﻿function deg2rad (angle) {
	return angle/180*Math.PI;
}

function getEarthRadiusAtLatitude(latitude){
	var equatorRadius=6378137;
	var polarRadius= 6356752.3142;
	var lat = deg2rad(latitude);
	return equatorRadius*Math.sqrt(Math.pow(polarRadius,4)/Math.pow(equatorRadius,4)*
        Math.pow((Math.sin(lat)),2)+Math.pow(Math.cos(lat),2))/
        Math.sqrt(1-(1-(polarRadius*polarRadius)/( equatorRadius*equatorRadius))*Math.pow(Math.sin(lat),2));
}

function latlong2xy (coord) {
	var vlat=coord.lati;
	var vlong=coord.longi;
	var xy=new Object();
	var rT=getEarthRadiusAtLatitude(vlat);
	var dLat=vlat-lati0;
	var dLong=vlong-longi0;
	var dy=deg2rad(dLat)*rT;
	var circAtLat=2*Math.PI*rT*Math.cos(deg2rad(vlat));
	var dx=circAtLat*dLong/360;
	xy.x=dx;
	xy.y=dy;
	return xy;
}

function nordEst2latLong (coordPt,coordRef) {
	// convertit en latitude longitude une coordonnée de type x (est) et y (nord), par rapport à une référence de lat et long connues
	let latRef=coordRef.lati;
	let longRef=coordRef.longi;
	let x=coordPt.x;
	let y=coordPt.y;
	let rT=getEarthRadiusAtLatitude(latRef);
	let circAtLat=2*Math.PI*rT*Math.cos(deg2rad(latRef));
	let circMeridien=20004000;
	let dLong=x*360/circAtLat;
	let dLat=y*360/circMeridien;
	let lati=latRef+dLat;
	let longi=longRef+dLong;
	return {lati:lati,longi:longi}
	
}

function xy2esp (coordxy) {
	var cesp=new Object ();
	cesp.x=coordxy.x;
	cesp.z=-coordxy.y;
	cesp.y=0;
	return cesp;
}


function sphcart (p)
{
	var qs={};

	qs.x=Math.sin(p.theta)*Math.cos(p.phi);
	qs.y=Math.sin(p.theta)*Math.sin(p.phi);
	qs.z=Math.cos(p.theta);

	return qs;
}

function cartsph (p)
{
	var q={};
	
	q.theta=Math.acos(p.z);
	//q.phi=Math.acos(p.x/Math.sin(q.theta));
	if (p.x==0) {
		if (p.y>0) {q.phi=Math.PI/2;} else {q.phi=-Math.PI/2;}
	}
	else {
		q.phi=Math.atan(p.y/p.x);
		if ((p.x<0)&&(p.y>0)) 
		{q.phi=Math.PI+q.phi;}
		else if ((p.x<0)&&(p.y<0)) 
		{q.phi=-Math.PI+q.phi;}
	}
	
	return q;
}

function calcsph (laticalc,longicalc)
{
	var q={};
	q.theta=(90-laticalc)*Math.PI/180;
	q.phi=longicalc/180*Math.PI;
	
	return q;
}

function rotateX (p,angle)
{
	var qs={};

	qs.x=p.x;
	qs.y=p.y*Math.cos(angle)-p.z*Math.sin(angle);
	qs.z=p.y*Math.sin(angle)+p.z*Math.cos(angle);

	return qs;	
}

function rotateY (p,angle)
{
	var qs={};

	qs.x=p.x*Math.cos(angle)+p.z*Math.sin(angle);
	qs.y=p.y;
	qs.z=-p.x*Math.sin(angle)+p.z*Math.cos(angle);

	return qs;	
}

function rotateZ (p,angle)
{
	var qs={};

	qs.x=p.x*Math.cos(angle)-p.y*Math.sin(angle);
	qs.y=p.x*Math.sin(angle)+p.y*Math.cos(angle);
	qs.z=p.z;

	return qs;	
}

