﻿
function detecteCible (mouse) {
	var raycaster = new THREE.Raycaster();
	raycaster.setFromCamera( mouse, camera );
	
	var intersects = raycaster.intersectObjects( scene.children );
	var obRetenu={};
	var cibleRetenue=false;
	if ( intersects.length > 0 ) {
		for ( var i = 0; i < intersects.length; i++ ) {
			var obClic=intersects[ i ].object;
			var ciblePossible=obClic.ciblePossible||false;
			if (ciblePossible) {
				cibleRetenue=true;
				obRetenu=obClic;
			}
		}
		if (cibleRetenue) {
				xCible=obRetenu.position.x;
				yCible=obRetenu.position.y;
				zCible=obRetenu.position.z;
				bougeCam();		
		}
	}
}

function infoCible (mouse) {
	var raycaster = new THREE.Raycaster();
	raycaster.setFromCamera( mouse, camera );
	
	var intersects = raycaster.intersectObjects( scene.children );
	var obRetenu={};
	var cibleRetenue=false;
	if ( intersects.length > 0 ) {
		for ( var i = 0; i < intersects.length; i++ ) {
			var obClic=intersects[ i ].object;
			var ciblePossible=obClic.ciblePossible||false;
			if (ciblePossible) {
				cibleRetenue=true;
				obRetenu=obClic;
			}
		}
		if (cibleRetenue) {
			var nom=obRetenu.nom||"sans nom";
			var posRel=obRetenu.posRel||false;
			if (posRel) {
				var x=Math.round(obRetenu.dx*1000)/1000;
				var y=Math.round(obRetenu.dy*1000)/1000;
				var alti=Math.round(obRetenu.alti);
				var texte="x="+x+"m, y="+y+"m";
			
			} else {
				var lati=Math.round(obRetenu.lati*1000)/1000;
				var longi=Math.round(obRetenu.longi*1000)/1000;
				var alti=Math.round(obRetenu.alti);
				var texte="Coordonnées = "+lati+"°N, "+longi+"°E";
			}
			texte+="\nAltitude = "+alti+"m";
			texte+="\n\nCentrer la vue sur cet objet ?";
			
			if (isNaN(alti)) {texte="";}
			
			swal({   title: nom,   text: texte,   type: "info",   showCancelButton: true,   confirmButtonColor: "#DD6B55",   confirmButtonText: "Oui, centrer",   closeOnConfirm: true }, 
			function(){
				xCible=obRetenu.position.x;
				yCible=obRetenu.position.y;
				zCible=obRetenu.position.z;
				bougeCam();		 
			});

		}
	}
}




function bougeCam() {
	var p1=calcsph(90,0);
	var p2=sphcart(p1);
	
	var p3=rotateX(p2,angleYCam);
	var p4=rotateY(p3,angleXCam);
	
	var x0=xCible;
	var y0=yCible;
	var z0=zCible;
	
	var x=p4.x*distCam+x0;
	var y=p4.y*distCam+y0;
	var z=p4.z*distCam+z0;
	
	y-=2500*echelleZ; // on descend la caméra de 2500m vers le bas pour mieux voir le fond
	
	surface.position.y=distCam/1000; // on place la surface un peu au dessus de l'altitude 0, plus on est loin plus on doit décaler
	
	//on décale la grille
	for (var i=0;i<grille.geometry.vertices.length;i++) {
		grille.geometry.vertices[i].y=surface.position.y-5;
	}
	grille.geometry.verticesNeedUpdate=true;

	scene.fog.near=distCam+(large+haut)*0.04;
	scene.fog.far=distCam+(large+haut)*0.5;
	
	camera.position.set(x,y,z);
	camera.lookAt(new THREE.Vector3(x0,y0,z0));
	camera.updateProjectionMatrix();
}