
import numpy as np
import pandas as pd
from matplotlib import colors
import matplotlib.pyplot as plt
import argparse

parser = argparse.ArgumentParser()
parser.add_argument("detections", type=str)
args = parser.parse_args()

df = pd.read_csv(args.detections)
df["date"] = pd.to_datetime(df.filename, format="%Y%m%d_%H%M%SUTC_V12.log.wav")
plt.figure(figsize=(40, 10))
plt.hist2d(
    (df.date - df.date.min()).dt.total_seconds(),
    df.prediction,
    bins=(1024, 10),
    norm=colors.LogNorm(),
)
plt.xticks(
    np.arange(0, (df.date.max() - df.date.min()).total_seconds(), 3600 * 3),
    pd.date_range(df.date.min(), df.date.max(), freq='3H').strftime("%m-%d %Hh"),
    rotation=90
)
plt.grid()
plt.tight_layout()
plt.savefig(args.detections[:-4]+"_hist2d.pdf")
plt.close()
