/*
 * Define.h
 *
 *  Created on: 1 juil. 2020
 *      Author: sebas
 */

#ifndef MACROS_DEFINE_H_
#define MACROS_DEFINE_H_

/*******************************************************************************
 * VERSIONS HYSTORY
 *
 *      -   WorkspaceTICCS10_3_0_QualilifeHighBlueV0.3_SPI_SD_OK
 *              + SD ok
 *              + SPI ok IMU sans mag
 *              + UART PIC32 TX ok
 *
 *      -   WorkspaceTICCS10_3_0_QualilifeHighBlueV0.4_SPI_SD_UART-TX_OK
 *              + SD ok
 *              + SPI ok IMU sans mag
 *              + UART PIC32 TX RX ok
 *
 *      -   WorkspaceTICCS10_3_0_QualilifeHighBlueV0.5_SPI_SD_UARTPIC32-TX-RX_OK
 *              + SD ok
 *              + SPI ok IMU sans mag
 *              + UART PIC32 TX RX ok
 *              + UART PIC24 TX ok
 *
 *      -   WorkspaceTICCS10_3_0_QualilifeHighBlueV0.6_EVERYTHING_VALIDATED_SAUF_MAGNETO
 *              + SD ok
 *              + SPI ok IMU avec mag
 *              + UART PIC32 TX RX ok
 *              + UART PIC24 TX RX ok
 *
 *      -   WorkspaceTICCS10_3_0_QualilifeHighBlueV0.6_TEST_SLEEP_MODE
 *              + SD ok
 *              + SPI ok IMU avec mag
 *              + UART PIC32 TX RX ok
 *              + UART PIC24 TX RX ok
 *              + sleep working (710 uA) but without IMU reads. This power consumption is due to the level shifter
 *
 *      -   WorkspaceTICCS10_3_0_QualilifeHighBlueV0.7
 *              + SD ok
 *              + SPI ok IMU avec mag
 *              + UART PIC32 TX RX ok
 *              + UART PIC24 TX RX ok
 *              + Sleep working (600 uA). This power consumption is due to the level shifter, INT pint was LOW so the level shifter consumes more as R low level is lower than R high level. For the next hardware version output enable must be switched to low power
 *
 *      -   WorkspaceTICCS10_3_0_QualilifeHighBlueV0.8
 *              + SD ok
 *              + SPI ok IMU avec mag
 *              + UART PIC32 TX RX ok
 *              + UART PIC24 TX RX ok
 *              + Sleep working (600 uA). This power consumption is due to the level shifter, INT pint was LOW so the level shifter consumes more as R low level is lower than R high level. For the next hardware version output enable must be switched to low power
 *                  . quand on lis le recording parameters de la SD et sont differents des parametres TEST_SLEEP_MODE il ne rentrait pas en veille avec la derniere version
 *                  . Donc pour cela il faut ajouter apres l'arret du timer virtuel (Clock_stop(Clock_handle(&TimerSendSupervisorState));) un delai de 5 ms
 *                      Task_sleep(5 * (1000 / Clock_tickPeriod)); //On attend 5ms APRES ARRETER LE TIMER VIRTUEL SINON IL NE RENTRE PAS EN SLEEP MODE !!!!!!!!!!!!!!
 *                  . La mise en veille des SPI sensor doit se faire avant le delai de 5 ms aussi parce qu'elle envoit de trames au PIC32 donc c'est le meme pb qu'avant
 *                  . TOUT CE QUI ENVOIE DE TRAMES AU PIC32 DOIT SE METTRE EN VEILLE AVANT LE DELAY DE 5 mS !!!!
 *              + File Clock to update RTCC OK
 *
 *       -   WorkspaceTICCS10_3_0_QualilifeHighBlueV0.9
 *              + SD ok
 *              + SPI ok IMU avec mag
 *              + UART PIC32 TX RX ok
 *              + UART PIC24 TX RX ok
 *              + Sleep working (600 uA). This power consumption is due to the level shifter, INT pint was LOW so the level shifter consumes more as R low level is lower than R high level. For the next hardware version output enable must be switched to low power
 *                  . quand on lis le recording parameters de la SD et sont differents des parametres TEST_SLEEP_MODE il ne rentrait pas en veille avec la derniere version
 *                  . Donc pour cela il faut ajouter apres l'arret du timer virtuel (Clock_stop(Clock_handle(&TimerSendSupervisorState));) un delai de 5 ms
 *                      Task_sleep(5 * (1000 / Clock_tickPeriod)); //On attend 5ms APRES ARRETER LE TIMER VIRTUEL SINON IL NE RENTRE PAS EN SLEEP MODE !!!!!!!!!!!!!!
 *                  . La mise en veille des SPI sensor doit se faire avant le delai de 5 ms aussi parce qu'elle envoit de trames au PIC32 donc c'est le meme pb qu'avant
 *                  . TOUT CE QUI ENVOIE DE TRAMES AU PIC32 DOIT SE METTRE EN VEILLE AVANT LE DELAY DE 5 mS !!!!
 *              + File Clock to update RTCC OK
 *              + Ajout du storage target pour selectionner le stockage sur carte SD ou HDD et sinon le mode device USB
 *              + Ajout des profiles BLE mais c'est pas encore fini
 *              + Ajout des trames de boutons
 *              + Ajout de gestion de autostart et pauses pour interval et continus
 *
 *       -   WorkspaceTICCS10_3_0_QualilifeHighBlueV0.9
 *              + SD ok
 *              + SPI ok IMU avec mag
 *              + UART PIC32 TX RX ok
 *              + UART PIC24 TX RX ok
 *              + Sleep working (600 uA). This power consumption is due to the level shifter, INT pint was LOW so the level shifter consumes more as R low level is lower than R high level. For the next hardware version output enable must be switched to low power
 *                  . quand on lis le recording parameters de la SD et sont differents des parametres TEST_SLEEP_MODE il ne rentrait pas en veille avec la derniere version
 *                  . Donc pour cela il faut ajouter apres l'arret du timer virtuel (Clock_stop(Clock_handle(&TimerSendSupervisorState));) un delai de 5 ms
 *                      Task_sleep(5 * (1000 / Clock_tickPeriod)); //On attend 5ms APRES ARRETER LE TIMER VIRTUEL SINON IL NE RENTRE PAS EN SLEEP MODE !!!!!!!!!!!!!!
 *                  . La mise en veille des SPI sensor doit se faire avant le delai de 5 ms aussi parce qu'elle envoit de trames au PIC32 donc c'est le meme pb qu'avant
 *                  . TOUT CE QUI ENVOIE DE TRAMES AU PIC32 DOIT SE METTRE EN VEILLE AVANT LE DELAY DE 5 mS !!!!
 *              + File Clock to update RTCC OK
 *              + Ajout du storage target pour selectionner le stockage sur carte SD ou HDD et sinon le mode device USB
 *              + Ajout des profiles BLE mais c'est pas encore fini
 *              + Ajout des trames de boutons
 *              + Ajout de gestion de autostart et pauses pour interval et continus
 *              + Ajout gestion multiplexeur UART
 *              + Correction d'un GROS BEUG quand on envoie deux trames succsesifs sur les ports UART il faut mettre isTransmitting true tout de suite sinon on bouffe un octet!
 *
 ******************************************************************************/



//#define M_PI 3.14159265358979323846f
#define M_2PI 6.28318530717958647692f

/*******************************************************************************
 * SYSTEM CONFIGURATION
 ******************************************************************************/
//Task SPI
#define USING_SPI                               1
#define USING_IMU                               1
#define USING_RTCC                              1

//Task UART PIC24
#define USING_UART_PIC24                        1
#define USING_OLD_VERSION_WITHOUT_PIC24         0

//Task UART PIC32
#define USING_UART_PIC32                        1

//Task SD
#define USING_SD                                1

//Test Sleep Mode
#define DOING_TEST_SLEEP_MODE                   0



/*******************************************************************************
 * CONSTANTS
 ******************************************************************************/

//Pour GIAS
//defined in task supervision
//bool USING_CNN_DETECTION = false                //1 // GIAS = 1; QHB =0
//Pour GIAS
//#define BUOY___USING_PIC24_ALWAYS_ON_FOR_UART   1 // GIAS = 1; QHB =0

//Debug PIC32 (on l'etend pas)
#define DOING_DEBUG_PIC32                       0 // GIAS = 1; QHB =1

/*******************************************************************************
 * PORT MAPPING Values
 ******************************************************************************/
#define INPUT 1
#define OUTPUT 0
#define ON 1
#define OFF 0
#define LOW 0
#define HIGH 1
//#define TRUE 1
//#define FALSE 0
#define CLEAR 0
#define RESET 0
#define UNUSED(expr) do { (void)(expr); } while (0)

/*******************************************************************************
 * FRAMES IDs
 ******************************************************************************/


#define TRAME_ACCEL_DATA 0xA0

/*******************************************************************************
 * FRAMES GLOBALS PARAMETERS
 ******************************************************************************/


//#define BUFFER_TX_UART_SIZE 128

/*******************************************************************************
 * MACROS
 ******************************************************************************/
#define CLRWDT()  asm(" clrwdt")
//#define BUILD_UINT16(hiByte, loByte) \
//          ((unsigned short int)(((loByte) & 0x00FF) + (((hiByte) & 0x00FF) << 8)))
#define BUILD_INT16(hiByte, loByte) \
          ((int)(((loByte) & 0x00FF) + (((hiByte) & 0x00FF) << 8)))
#define MSB_UINT16(a) (((a) >> 8) & 0xFF)
#define LSB_UINT16(a) ((a) & 0xFF)
#define BUILD_UINT32_Lib(Byte0, Byte1, Byte2, Byte3) \
          ((unsigned long)((unsigned long)((Byte0) & 0x00FF) \
          + ((unsigned long)((Byte1) & 0x00FF) << 8) \
          + ((unsigned long)((Byte2) & 0x00FF) << 16) \
          + ((unsigned long)((Byte3) & 0x00FF) << 24)))
#define BUILD_INT32(Byte0, Byte1, Byte2, Byte3) \
          ((long)((long)((Byte0) & 0x00FF) \
          + ((long)((Byte1) & 0x00FF) << 8) \
          + ((long)((Byte2) & 0x00FF) << 16) \
          + ((long)((Byte3) & 0x00FF) << 24)))
//#define BREAK_UINT32( var, ByteNum ) \
//          (unsigned char)((unsigned int)(((var) >>((ByteNum) * 8)) & 0x00FF))
#define MSB_LSB_INVERT(uShort) ((((uShort) & 0x00FF)<<8) + ((uShort) & 0xFF00)>>8)
#ifndef MIN
#define MIN(n,m)   (((n) < (m)) ? (n) : (m))
#endif
#ifndef MAX
#define MAX(n,m)   (((n) < (m)) ? (m) : (n))
#endif
#ifndef ABS
#define ABS(x) ((x>0) ? x : (-x))
#endif
#ifndef ABS_Q16
#define ABS_Q16(x) ((_itofQ16(x)>0) ? x : _Q16neg(x))
#endif
#ifndef CEILING
#define CEILING(x) ((int)x == (double)x) ? (int)x : ((int)x) + 1;
#endif
#ifndef DegreeToRadian
#define DegreeToRadian(value) ((double)value * M_PI / 180.0)
#endif







#endif /* MACROS_DEFINE_H_ */
