/*
 * Protocol.h
 *
 *  Created on: 1 juil. 2020
 *      Author: sebas
 */

#ifndef MACROS_PROTOCOL_H_
#define MACROS_PROTOCOL_H_

//#include <GlobalConfiguration/GlobalConfiguration.h>

#define SOF 0xFE
#define UTLN_FRAME_SIZE 6
#define UART_MSG_MAX_SIZE 512

//---------------------------------Trames envoyes au recorder High Speed---------------------------

//DEMANDE_DU_STATUT_DU_RECORDER
//ID = 0x0100 : demande du statut du recorder
#define DEMANDE_DU_STATUT_DU_RECORDER                       0x0100
//Pas de payload
#define DEMANDE_DU_STATUT_DU_RECORDER_DESCRIPTION_LENGHT    0
#define DEMANDE_DU_STATUT_DU_RECORDER_LENGHT                (DEMANDE_DU_STATUT_DU_RECORDER_DESCRIPTION_LENGHT)

//PRESTART_CONFIGURATION_DU_RECORDER_AUDIO;
//ID = 0x0101 : configuration du recorder audio Permet la cration du fichier en avance
#define PRESTART_CONFIGURATION_DU_RECORDER_AUDIO            0x0101
#define PRESTART_CONFIGURATION_DU_RECORDER_AUDIO_LENGHT     26

#define SUPERVISOR_STATE                                    0x0101

//ID = 0x0102 : SET_RTCC (Envois RTCC au recorder audio)
//6 octets : DateTime courant (1 octet = anne / 1 octet = mois / 1 octet = jour / 1 octet= heure / 1 octet = minute / 1 octet = seconde)
#define SET_RTCC_DU_RECORDER_AUDIO                          0x0102
#define SET_RTCC_DU_RECORDER_AUDIO_LENGHT                   6

//START_RECORDER_AUDIO
//ID = 0x0103 : start recorder
#define START_RECORDER_AUDIO                                0x0103
#define START_RECORDER_AUDIO_LENGHT                         0
//4 octets : sampling frequency en Hz
//1 octet : nb de canaux
//1 octet : rsolution
//1 octet : slection du filtre de lADC
//4 octets : taille max de fichier (pour splitter)
//1 octet : support de stockage (0 = SD / 1= HDD / 2 = device)
//6 octets : RTCC (1 octet = anne / 1 octet = mois / 1 octet = jour / 1 octet= heure / 1 octet = minute / 1 octet = seconde
//ID = 0x0103 : start recording
//Pas de payload
//ID = 0x0104 : stop recording
#define STOP_RECORDER_AUDIO                                 0x0104
#define STOP_RECORDER_AUDIO_LENGHT                          0
//Pas de payload


//ID = 0x0105 : TOA_EVENT_FRAME (Trame donnant la liste des TOA eventuelles)
//1 octets: Specie ( enum{ cachalot=0, rorqual } )//1 octets: TOA List Count//Packet : taille thorique : TDOA List Count*5//1 octets : Hydrophone ID//4 octets : timeStamp (s)
#define NumberOfTOAInATrame                                         10
#define SEND_TOA_EVENT_FRAME_TO_RECORDER_AUDIO                     0x0105
#define SEND_TOA_EVENT_FRAME_TO_RECORDER_AUDIO_LENGHT              (2 + 5*NumberOfTOAInATrame)

#define FILE_SIZE_TO_BE_FORWARDED                                  0x0106

//ID = 0x0A0A : HS_DATA_PACKET_FULL_TIMESTAMP
//Chaque chantillon a un timeStamp, la trame contient un paquet de donnes, sur un ou plusieurs canaux (par exemple 3 pour un accel), de taille variable (2 octets par exemple en 12 bits)
//1 octet : Type (0x01 accel, 0x02 gyro, 0x03 magneto, 0x04 temperature, 0x05 pressure, 0x06 light, 0x07 piezo )
//1 octet : ID (identifiant du sensor)
//1 octet : Nb Channels
//1 octet : Range
//1 octet : Rsolution (en bits)
//2 octet : Freq (en Hz)
//Packet :
//4 octets : timeStamp (ms)
//n octets : Data_Channel1 (n = rsolution/8 arrondi  lentier suprieur : Math.Ceiling(resolution/8.0)
//n octets : Data_Channel2
//n octets : ....
#define HS_DATA_PACKET_FULL_TIMESTAMP                             0x0A0A
#define HS_DATA_PACKET_FULL_TIMESTAMP_LENGHT                      9


//ID = 0x0A0B : HS_DATA_PACKET_ONE_TIMESTAMP
//Chaque trame contient un seul timestamp et un paquet de donnes, sur un ou plusieurs canaux (par exemple 3 pour un accel), de taille variable (2 octets par exemple en 12 bits)
//1 octet : Type (0x01 accel, 0x02 gyro, 0x03 magneto, 0x04 temperature, 0x05 pressure, 0x06 light, 0x07 piezo )
//1 octet : ID (identifiant du sensor)
//1 octet : Nb Channels
//1 octet : Range
//1 octet : Rsolution (en bits)
//2 octet : Freq (en Hz)
//4 octets : timeStamp (ms)
//Packet :
//n octets : Data_Channel1 (n = rsolution/8 arrondi  lentier suprieur : Math.Ceiling(resolution/8.0)
//n octets : Data_Channel2
//n octets : ....

//------------------------------Trames en provenance du USB-----------------------------
#define USB_MODE_DEVICE_START                          0x0C01
#define USB_MODE_FILE_CREATE                           0x0C02
#define USB_MODE_FILE_APPEND                           0x0C03
#define USB_MODE_FILE_GET_INFO                         0x0C04
#define USB_MODE_FILE_DELETE                           0x0C05
#define USB_MODE_SET_CLOCK_TIME                        0x0C06



//------------------------------Trames en provenance du recorder High Speed-----------------------------
// : statut du recorder high speed
#define RECORDER_HIGH_SPEED_STATUT                     0x0200
#define RECORDER_HIGH_SPEED_STATUT_PAYLOAD_LENGHT      1
#define RECORDER_HIGH_SPEED_STATUT_INIT                0x00
#define RECORDER_HIGH_SPEED_STATUT_WAIT_FOR_STORAGE    0x01
#define RECORDER_HIGH_SPEED_STATUT_READY_TO_START      0x02
#define RECORDER_HIGH_SPEED_STATUT_RECORDING           0x03
#define RECORDER_HIGH_SPEED_STATUT_FLUSHING_DDR_TO_FS  0x04
#define RECORDER_HIGH_SPEED_STATUT_ANALYSE_CNN         0x05
#define RECORDER_HIGH_SPEED_STATUT_READY_TO_TURN_OFF   0x06
#define RECORDER_HIGH_SPEED_STATUT_SEND_DATA_GSM       0x07
#define RECORDER_HIGH_SPEED_STATUT_ERROR               0xEE

// Demande de RTCC au CC2652
#define RECORDER_HIGH_SPEED_DEMANDE_RTCC               0x0202
#define GSM_OUVERTURE_NOUVEAU_FICHIER_CMD              0x0520
#define GSM_DATA_TO_FORWARD                            0x0521
#define GSM_FERMETURE_FICHIER                          0x0522
#define RESULTAT_ANALYSE_CNN                           0x0212

#define APPUIS_BOUTON                                  0x0203

#define RECORDER_HIGH_SPEED_DATA_GSM    0x0210// : data devant tre transmises au GSM. Le contenu de la trame renvoye au GSM nest pas modifi, ce qui permet de connatre sa source.
#define RECORDER_HIGH_SPEED_USB_PIC32   0x0211// : data en provenance de lUSB PIC32 devant tre forwarde au CC2652.
//Contenu  dfinir

//------------------------Trames envoyes au GSM-----------------------------------

#define DEMANDE_STATE_GSM                               0x0500
#define DEMANDE_GSM_CREATION_NOUVEAU_FICHIER            0x0510

//------------------------Trames envoyes  la boue-----------------------------------
//ID = 0x0300 : Demande de status
#define DEMANDE_STATE_BUOY                                 0x0300
#define DEMANDE_STATE_BUOY_LENGHT                          0

//ID = 0x0302 : tat de communication GSM dans le recording manager
//1 octet : (0: pas de communication, 1: communication en cours, 2: communication en prparation)
#define RECORDING_MANAGER_GSM_COMMUNICATION_STATUS         0x0302
#define RECORDING_MANAGER_GSM_COMMUNICATION_STATUS_LENGHT  1

//ID = 0x303 : Demande de management systme
//1 octet : (1: reboot alimentation)
#define DEMANDE_SYSTEM_REBOOT                              0x0303
#define DEMANDE_SYSTEM_REBOOT_LENGHT                       1

//ID = 0x0304: Rapport de synchronisation GPS
//1 octet : Etat de la synchronisation GPS(0: Synchronisation termine, 1: Erreur de synchronisation)
#define STATUS_SYNCHRO_GPS                                 0x0304
#define STATUS_SYNCHRO_GPS_LENGHT                          1

//ID = 0x310 : Donnes IMU
//4 octets Configuration Accel
//1 octet : ID Accel
//1 octet : Range Accel
//1 octet : Rsolution Accel
//1 octet : Freq Accel
//6 octets Data Accel
//4 octets Configuration Gyro
//1 octet : ID Gyro
//1 octet : Range Gyro
//1 octet : Rsolution Gyro
//1 octet : Freq Gyro
//6 octets Gyro
//4 octets Configuration Magneto
//1 octet : ID Magneto
//1 octet : Range Magneto
//1 octet : Rsolution Magneto
//1 octet : Freq Magneto
//6 octets Magneto
#define IMU_DATA                                           0x0310
#define IMU_DATA_LENGHT                                    30

//ID= 0x0320 : Ouverture dun nouveau fichier de commande
//4 octets:Longueur du fichier en octets
//32 octets ou moins: Nom du fichier de commande associ
#define DEMANDE_OPEN_NEW_FILE                              0x0320
#define DEMANDE_OPEN_NEW_FILE_LENGHT                       36

//ID= 0x0321: Transfert des donnes dun fichier de commande
//4 octets: Index de lecture du fichier
//256 octets: (ou moins) donnes
//4 octets: CRC-32 des donnes (Polynme: 0xEDB88320)
#define TX_DATA_FILE_CMD                                   0x0321
#define TX_DATA_FILE_CMD_LENGHT                            264

//ID= 0x0322: Fermeture de fichier
//1 octet: Cause de fermeture(0:Fin de fichier, 1: Abandon de procdure)
#define DEMANDE_CLOSE_FILE                                 0x0310
#define DEMANDE_CLOSE_FILE_LENGHT                          1


//---------------------Trames en provenance du multiplexeur PIC24-------------------------------------------
#define PING_PIC24_STATUT                                  0x0A00
#define UART_STATE_PIC24                                   0x0A01

//---------------------Trames en provenance de la boue-------------------------------------------
#define BUOY_STATUT                                        0x0400
#define BUOY_STATUT_CMD_LENGHT                             7
//ID = 0x0400 : Statut de la boue (envoi sur event boue ou sur requte externe)
//1 octet : Position (0: haut, 1: bas, 2: remonte, 3: descente)
//1 octet : External Noise (0: No noise, 1: Noise)
//1 octet : Etat Canal GSM (0: Non utilisable, 1:Utilis Boue, 2:Dispo Recording Manager, 3: Erreur Rseau)
//4 octets : Pression.


//---------------------Trames en provenance du GSM-------------------------------------------

//#define SD_DATA_PACKET_FULL_TIMESTAMP                       0x0500

//---------------------Trames envoyes  la SD du recording Manager-------------------------------------------

//SD_DATA_PACKET_FULL_TIMESTAMP
//Chaque chantillon a un timeStamp, la trame contient un paquet de donnes,
//sur un ou plusieurs canaux (par exemple 3 pour un accel),
//de taille variable (2 octets par exemple en 12 bits)
#define SD_DATA_PACKET_FULL_TIMESTAMP                       0x060A
#define SD_DATA_PACKET_FULL_TIMESTAMP_DESCRIPTION_LENGHT    7
#define SD_DATA_PACKET_FULL_TIMESTAMP_LENGHT                (SD_DATA_PACKET_FULL_TIMESTAMP_DESCRIPTION_LENGHT + PingPongBuffersSize*2)
//SD_DATA_PACKET_ONE_TIMESTAMP
//Chaque trame contient un seul timestamp et un paquet de donnes,
//sur un ou plusieurs canaux (par exemple 3 pour un accel),
//de taille variable (2 octets par exemple en 12 bits)
#define SD_DATA_PACKET_ONE_TIMESTAMP                        0x060B
#define SD_DATA_PACKET_ONE_TIMESTAMP_DESCRIPTION_LENGHT     13
#define SD_DATA_PACKET_ONE_TIMESTAMP_LENGHT                 (SD_DATA_PACKET_ONE_TIMESTAMP_DESCRIPTION_LENGHT + PingPongBuffersSize*2)


//---------------------Trames envoyes au multiplexeur Uart-------------------------------------------
//ID = 0x0501 : SET_LED Rglage valeur LED
//1 octet : ledValue (ON, OFF)
#define MLT_SET_LED                                         0x0901
#define MLT_SET_LED_LENGHT                                  1

#define MLT_SET_UART2                                       0x0902
#define MLT_SET_UART2_LENGHT                                1

//---------------------Trames envoyes au dtecteur ultra-low power-------------------------------------------
//ID = 0x0800 : Demande de status
#define DEMANDE_STATUS_ULP_DETECTOR                         0x0800
#define DEMANDE_STATUS_ULP_DETECTOR_LENGHT                  0

//ID = 0x0801 : Dtection du CNN correspondant  la dtection du ULP dtecteur
//1 octet : (1: true positive, 0: false positive)
#define DETECTION_CNN                                       0x0801
#define DETECTION_CNN_LENGHT                                1

//ID = 0x0802 : Demande de Time Of Arrival Information
//1 octet : (1: demande de TOA, 0: stop TOA)
#define DEMANDE_TOA                                         0x0802
#define DEMANDE_TOA_LENGHT                                  1

#define TYPE_PERIPHERAL_ACCEL         0x01
#define TYPE_PERIPHERAL_GYRO          0x02
#define TYPE_PERIPHERAL_MAGNETO       0x03
#define TYPE_PERIPHERAL_TEMPERATURE   0x04
#define TYPE_PERIPHERAL_PRESSURE      0x05
#define TYPE_PERIPHERAL_LIGHT         0x06
#define TYPE_PERIPHERAL_PIEZO         0x07
#define TYPE_PERIPHERAL_IMU           0x08

#endif /* MACROS_PROTOCOL_H_ */
