/*
 * recordingParametersService.c
 *
 *  Created on: 27 mai 2021
 *      Author: TP-EO-6
 */



/*********************************************************************
 * INCLUDES
 */
#include <string.h>

#include "bcomdef.h"
#include "OSAL.h"
#include "linkdb.h"
#include "linkdb_internal.h"
#include "att.h"
#include "gatt.h"
#include "gatt_uuid.h"
#include "gattservapp.h"
#include "gapbondmgr.h"

#include "recordingParametersService.h"
#include "Application/simple_peripheral.h"

/*********************************************************************
 * MACROS
 */

/*********************************************************************
 * CONSTANTS
 */

/*********************************************************************
 * TYPEDEFS
 */

/*********************************************************************
* GLOBAL VARIABLES
*/
// recordingParametersService Service UUID
CONST uint8_t recordingParametersServiceUUID[ATT_BT_UUID_SIZE] =
{
  LO_UINT16(RECORDINGPARAMETERSSERVICE_SERV_UUID), HI_UINT16(RECORDINGPARAMETERSSERVICE_SERV_UUID)
};

// ActualRecordingParameters UUID
CONST uint8_t recordingParametersService_ActualRecordingParametersUUID[ATT_UUID_SIZE] =
{
  TI_BASE_UUID_128(RECORDINGPARAMETERSSERVICE_ACTUALRECORDINGPARAMETERS_UUID)
};
// DesiredRecordingParameters UUID
CONST uint8_t recordingParametersService_DesiredRecordingParametersUUID[ATT_UUID_SIZE] =
{
  TI_BASE_UUID_128(RECORDINGPARAMETERSSERVICE_DESIREDRECORDINGPARAMETERS_UUID)
};

/*********************************************************************
 * LOCAL VARIABLES
 */

static recordingParametersServiceCBs_t *pAppCBs = NULL;

/*********************************************************************
* Profile Attributes - variables
*/

// Service declaration
static CONST gattAttrType_t recordingParametersServiceDecl = { ATT_BT_UUID_SIZE, recordingParametersServiceUUID };

// Characteristic "ActualRecordingParameters" Properties (for declaration)
static uint8_t recordingParametersService_ActualRecordingParametersProps = GATT_PROP_READ | GATT_PROP_NOTIFY;

// Characteristic "ActualRecordingParameters" Value variable
static uint8_t recordingParametersService_ActualRecordingParametersVal[RECORDINGPARAMETERSSERVICE_ACTUALRECORDINGPARAMETERS_LEN] = {0};

// Characteristic "ActualRecordingParameters" CCCD
static gattCharCfg_t *recordingParametersService_ActualRecordingParametersConfig;
// Characteristic "DesiredRecordingParameters" Properties (for declaration)
static uint8_t recordingParametersService_DesiredRecordingParametersProps = GATT_PROP_WRITE | GATT_PROP_NOTIFY;

// Characteristic "DesiredRecordingParameters" Value variable
static uint8_t recordingParametersService_DesiredRecordingParametersVal[RECORDINGPARAMETERSSERVICE_DESIREDRECORDINGPARAMETERS_LEN] = {0};

// Characteristic "DesiredRecordingParameters" CCCD
static gattCharCfg_t *recordingParametersService_DesiredRecordingParametersConfig;

/*********************************************************************
* Profile Attributes - Table
*/

static gattAttribute_t recordingParametersServiceAttrTbl[] =
{
  // recordingParametersService Service Declaration
  {
    { ATT_BT_UUID_SIZE, primaryServiceUUID },
    GATT_PERMIT_READ,
    0,
    (uint8_t *)&recordingParametersServiceDecl
  },
    // ActualRecordingParameters Characteristic Declaration
    {
      { ATT_BT_UUID_SIZE, characterUUID },
      GATT_PERMIT_READ,
      0,
      &recordingParametersService_ActualRecordingParametersProps
    },
      // ActualRecordingParameters Characteristic Value
      {
        { ATT_UUID_SIZE, recordingParametersService_ActualRecordingParametersUUID },
        0,
        0,
        recordingParametersService_ActualRecordingParametersVal
      },
      // ActualRecordingParameters CCCD
      {
        { ATT_BT_UUID_SIZE, clientCharCfgUUID },
        GATT_PERMIT_READ | GATT_PERMIT_WRITE,
        0,
        (uint8 *)&recordingParametersService_ActualRecordingParametersConfig
      },
    // DesiredRecordingParameters Characteristic Declaration
    {
      { ATT_BT_UUID_SIZE, characterUUID },
      GATT_PERMIT_READ,
      0,
      &recordingParametersService_DesiredRecordingParametersProps
    },
      // DesiredRecordingParameters Characteristic Value
      {
        { ATT_UUID_SIZE, recordingParametersService_DesiredRecordingParametersUUID },
        GATT_PERMIT_READ | GATT_PERMIT_WRITE,
        0,
        recordingParametersService_DesiredRecordingParametersVal
      },
      // DesiredRecordingParameters CCCD
      {
        { ATT_BT_UUID_SIZE, clientCharCfgUUID },
        GATT_PERMIT_READ | GATT_PERMIT_WRITE,
        0,
        (uint8 *)&recordingParametersService_DesiredRecordingParametersConfig
      },
};

/*********************************************************************
 * LOCAL FUNCTIONS
 */
static bStatus_t recordingParametersService_ReadAttrCB( uint16 connHandle, gattAttribute_t *pAttr,
                                           uint8 *pValue, uint16 *pLen, uint16 offset,
                                           uint16 maxLen, uint8 method );
static bStatus_t recordingParametersService_WriteAttrCB( uint16 connHandle, gattAttribute_t *pAttr,
                                            uint8 *pValue, uint16 len, uint16 offset,
                                            uint8 method );

/*********************************************************************
 * PROFILE CALLBACKS
 */
// Simple Profile Service Callbacks
CONST gattServiceCBs_t recordingParametersServiceCBs =
{
  recordingParametersService_ReadAttrCB,  // Read callback function pointer
  recordingParametersService_WriteAttrCB, // Write callback function pointer
  NULL                       // Authorization callback function pointer
};

/*********************************************************************
* PUBLIC FUNCTIONS
*/

/*
 * RecordingParametersService_AddService- Initializes the RecordingParametersService service by registering
 *          GATT attributes with the GATT server.
 *
 */
bStatus_t RecordingParametersService_AddService( void )
{
  uint8_t status;

  // Allocate Client Characteristic Configuration table
  recordingParametersService_ActualRecordingParametersConfig = (gattCharCfg_t *)ICall_malloc( sizeof(gattCharCfg_t) * linkDBNumConns );
  if ( recordingParametersService_ActualRecordingParametersConfig == NULL )
  {
    return ( bleMemAllocError );
  }

  // Initialize Client Characteristic Configuration attributes
  GATTServApp_InitCharCfg( INVALID_CONNHANDLE, recordingParametersService_ActualRecordingParametersConfig );
  // Allocate Client Characteristic Configuration table
  recordingParametersService_DesiredRecordingParametersConfig = (gattCharCfg_t *)ICall_malloc( sizeof(gattCharCfg_t) * linkDBNumConns );
  if ( recordingParametersService_DesiredRecordingParametersConfig == NULL )
  {
    return ( bleMemAllocError );
  }

  // Initialize Client Characteristic Configuration attributes
  GATTServApp_InitCharCfg( INVALID_CONNHANDLE, recordingParametersService_DesiredRecordingParametersConfig );
  // Register GATT attribute list and CBs with GATT Server App
  status = GATTServApp_RegisterService( recordingParametersServiceAttrTbl,
                                        GATT_NUM_ATTRS( recordingParametersServiceAttrTbl ),
                                        GATT_MAX_ENCRYPT_KEY_SIZE,
                                        &recordingParametersServiceCBs );

  return ( status );
}

/*
 * RecordingParametersService_RegisterAppCBs - Registers the application callback function.
 *                    Only call this function once.
 *
 *    appCallbacks - pointer to application callbacks.
 */
bStatus_t RecordingParametersService_RegisterAppCBs( recordingParametersServiceCBs_t *appCallbacks )
{
  if ( appCallbacks )
  {
    pAppCBs = appCallbacks;

    return ( SUCCESS );
  }
  else
  {
    return ( bleAlreadyInRequestedMode );
  }
}

/*
 * RecordingParametersService_SetParameter - Set a RecordingParametersService parameter.
 *
 *    param - Profile parameter ID
 *    len - length of data to right
 *    value - pointer to data to write.  This is dependent on
 *          the parameter ID and WILL be cast to the appropriate
 *          data type (example: data type of uint16 will be cast to
 *          uint16 pointer).
 */
bStatus_t RecordingParametersService_SetParameter( uint8 param, uint8 len, void *value )
{
  bStatus_t ret = SUCCESS;
  switch ( param )
  {
    case RECORDINGPARAMETERSSERVICE_ACTUALRECORDINGPARAMETERS:
      if ( len == RECORDINGPARAMETERSSERVICE_ACTUALRECORDINGPARAMETERS_LEN )
      {
        memcpy(recordingParametersService_ActualRecordingParametersVal, value, len);

        // Try to send notification.
        GATTServApp_ProcessCharCfg( recordingParametersService_ActualRecordingParametersConfig, (uint8_t *)&recordingParametersService_ActualRecordingParametersVal, FALSE,
                                    recordingParametersServiceAttrTbl, GATT_NUM_ATTRS( recordingParametersServiceAttrTbl ),
                                    INVALID_TASK_ID,  recordingParametersService_ReadAttrCB);
      }
      else
      {
        ret = bleInvalidRange;
      }
      break;

    case RECORDINGPARAMETERSSERVICE_DESIREDRECORDINGPARAMETERS:
      if ( len == RECORDINGPARAMETERSSERVICE_DESIREDRECORDINGPARAMETERS_LEN )
      {
        memcpy(recordingParametersService_DesiredRecordingParametersVal, value, len);

        // Try to send notification.
        GATTServApp_ProcessCharCfg( recordingParametersService_DesiredRecordingParametersConfig, (uint8_t *)&recordingParametersService_DesiredRecordingParametersVal, FALSE,
                                    recordingParametersServiceAttrTbl, GATT_NUM_ATTRS( recordingParametersServiceAttrTbl ),
                                    INVALID_TASK_ID,  recordingParametersService_ReadAttrCB);
      }
      else
      {
        ret = bleInvalidRange;
      }
      break;

    default:
      ret = INVALIDPARAMETER;
      break;
  }
  return ret;
}


/*
 * RecordingParametersService_GetParameter - Get a RecordingParametersService parameter.
 *
 *    param - Profile parameter ID
 *    value - pointer to data to write.  This is dependent on
 *          the parameter ID and WILL be cast to the appropriate
 *          data type (example: data type of uint16 will be cast to
 *          uint16 pointer).
 */
bStatus_t RecordingParametersService_GetParameter( uint8 param, void *value )
{
  bStatus_t ret = SUCCESS;
  switch ( param )
  {
    case RECORDINGPARAMETERSSERVICE_DESIREDRECORDINGPARAMETERS:
      memcpy(value, recordingParametersService_DesiredRecordingParametersVal, RECORDINGPARAMETERSSERVICE_DESIREDRECORDINGPARAMETERS_LEN);
      break;

    default:
      ret = INVALIDPARAMETER;
      break;
  }
  return ret;
}


/*********************************************************************
 * @fn          recordingParametersService_ReadAttrCB
 *
 * @brief       Read an attribute.
 *
 * @param       connHandle - connection message was received on
 * @param       pAttr - pointer to attribute
 * @param       pValue - pointer to data to be read
 * @param       pLen - length of data to be read
 * @param       offset - offset of the first octet to be read
 * @param       maxLen - maximum length of data to be read
 * @param       method - type of read message
 *
 * @return      SUCCESS, blePending or Failure
 */
static bStatus_t recordingParametersService_ReadAttrCB( uint16 connHandle, gattAttribute_t *pAttr,
                                       uint8 *pValue, uint16 *pLen, uint16 offset,
                                       uint16 maxLen, uint8 method )
{
  bStatus_t status = SUCCESS;

  // See if request is regarding the ActualRecordingParameters Characteristic Value
if ( ! memcmp(pAttr->type.uuid, recordingParametersService_ActualRecordingParametersUUID, pAttr->type.len) )
  {
    if ( offset > RECORDINGPARAMETERSSERVICE_ACTUALRECORDINGPARAMETERS_LEN )  // Prevent malicious ATT ReadBlob offsets.
    {
      status = ATT_ERR_INVALID_OFFSET;
    }
    else
    {
      *pLen = MIN(maxLen, RECORDINGPARAMETERSSERVICE_ACTUALRECORDINGPARAMETERS_LEN - offset);  // Transmit as much as possible
      memcpy(pValue, pAttr->pValue + offset, *pLen);
    }
  }
  // See if request is regarding the DesiredRecordingParameters Characteristic Value
else if ( ! memcmp(pAttr->type.uuid, recordingParametersService_DesiredRecordingParametersUUID, pAttr->type.len) )
  {
    if ( offset > RECORDINGPARAMETERSSERVICE_DESIREDRECORDINGPARAMETERS_LEN )  // Prevent malicious ATT ReadBlob offsets.
    {
      status = ATT_ERR_INVALID_OFFSET;
    }
    else
    {
      *pLen = MIN(maxLen, RECORDINGPARAMETERSSERVICE_DESIREDRECORDINGPARAMETERS_LEN - offset);  // Transmit as much as possible
      memcpy(pValue, pAttr->pValue + offset, *pLen);
    }
  }
  else
  {
    // If we get here, that means you've forgotten to add an if clause for a
    // characteristic value attribute in the attribute table that has READ permissions.
    *pLen = 0;
    status = ATT_ERR_ATTR_NOT_FOUND;
  }

  return status;
}


/*********************************************************************
 * @fn      recordingParametersService_WriteAttrCB
 *
 * @brief   Validate attribute data prior to a write operation
 *
 * @param   connHandle - connection message was received on
 * @param   pAttr - pointer to attribute
 * @param   pValue - pointer to data to be written
 * @param   len - length of data
 * @param   offset - offset of the first octet to be written
 * @param   method - type of write message
 *
 * @return  SUCCESS, blePending or Failure
 */
static bStatus_t recordingParametersService_WriteAttrCB( uint16 connHandle, gattAttribute_t *pAttr,
                                        uint8 *pValue, uint16 len, uint16 offset,
                                        uint8 method )
{
  bStatus_t status  = SUCCESS;
  uint8_t   paramID = 0xFF;

  // See if request is regarding a Client Characterisic Configuration
  if ( ! memcmp(pAttr->type.uuid, clientCharCfgUUID, pAttr->type.len) )
  {
    // Allow only notifications.
    status = GATTServApp_ProcessCCCWriteReq( connHandle, pAttr, pValue, len,
                                             offset, GATT_CLIENT_CFG_NOTIFY);
  }
  // See if request is regarding the DesiredRecordingParameters Characteristic Value
  else if ( ! memcmp(pAttr->type.uuid, recordingParametersService_DesiredRecordingParametersUUID, pAttr->type.len) )
  {
    if ( offset + len > RECORDINGPARAMETERSSERVICE_DESIREDRECORDINGPARAMETERS_LEN )
    {
      status = ATT_ERR_INVALID_OFFSET;
    }
    else
    {
      // Copy pValue into the variable we point to from the attribute table.
      memcpy(pAttr->pValue + offset, pValue, len);

      // Only notify application if entire expected value is written
      if ( offset + len == RECORDINGPARAMETERSSERVICE_DESIREDRECORDINGPARAMETERS_LEN)
        paramID = RECORDINGPARAMETERSSERVICE_DESIREDRECORDINGPARAMETERS;
    }
  }
  else
  {
    // If we get here, that means you've forgotten to add an if clause for a
    // characteristic value attribute in the attribute table that has WRITE permissions.
    status = ATT_ERR_ATTR_NOT_FOUND;
  }

  // Let the application know something changed (if it did) by using the
  // callback it registered earlier (if it did).
  if (paramID != 0xFF)
    if ( pAppCBs && pAppCBs->pfnChangeCb )
      pAppCBs->pfnChangeCb( paramID ); // Call app function from stack task context.

  return status;
}



