/*
 * recordingParametersService.h
 *
 *  Created on: 27 mai 2021
 *      Author: TP-EO-6
 */

#ifndef PROFILES_RECORDINGPARAMETERSSERVICE_H_
#define PROFILES_RECORDINGPARAMETERSSERVICE_H_


/*********************************************************************
 * INCLUDES
 */

/*********************************************************************
 * CONSTANTS
 */

/*********************************************************************
* CONSTANTS
*/
// Service UUID
#define RECORDINGPARAMETERSSERVICE_SERV_UUID 0xBABF
//0xFE
//0xCommand
//0xCommand
//0xLength
//0xLength
// 1 Byte for Sampling_Resolution (0x00 = 8 bits, 0x01 = 16 bits, 0x02 = 24 bits, 0x03 = 32 bits)
// 1 Byte for Sampling_Freq (0x00 = 128000 sps, 0x01 = 256000 sps, 0x02 = 512000 sps)
// 1 Byte for Filter_Selection
// 1 Byte for AutoStart
// 4 Bytes for FILE_Size_Limit
// 1 Byte for Record_Use_TimeInterval
// 2 Bytes for Shutdown_Duration
// 2 Bytes for Preparing_Duration
// 2 Bytes for Recording_Duration
// 2 Bytes for Stopping_Duration
// 1 Bytes for Channel_Count
// 1 Bytes for Storage_Target (0 SD/HDD, 2 USB)
//0xCHKSM

//  Characteristic defines
#define RECORDINGPARAMETERSSERVICE_ACTUALRECORDINGPARAMETERS      0
#define RECORDINGPARAMETERSSERVICE_ACTUALRECORDINGPARAMETERS_UUID 0xBE00
#define RECORDINGPARAMETERSSERVICE_ACTUALRECORDINGPARAMETERS_LEN  25

//  Characteristic defines
#define RECORDINGPARAMETERSSERVICE_DESIREDRECORDINGPARAMETERS      1
#define RECORDINGPARAMETERSSERVICE_DESIREDRECORDINGPARAMETERS_UUID 0xBE01
#define RECORDINGPARAMETERSSERVICE_DESIREDRECORDINGPARAMETERS_LEN  25

/*********************************************************************
 * TYPEDEFS
 */

/*********************************************************************
 * MACROS
 */
//     Invalid connection handle, used for no connection handle.
#define     INVALID_CONNHANDLE   0xFFFF


/*********************************************************************
 * Profile Callbacks
 */

// Callback when a characteristic value has changed
typedef void (*recordingParametersServiceChange_t)( uint8 paramID );

typedef struct
{
  recordingParametersServiceChange_t        pfnChangeCb;  // Called when characteristic value changes
} recordingParametersServiceCBs_t;



/*********************************************************************
 * API FUNCTIONS
 */


/*
 * RecordingParametersService_AddService- Initializes the RecordingParametersService service by registering
 *          GATT attributes with the GATT server.
 *
 */
extern bStatus_t RecordingParametersService_AddService( void );

/*
 * RecordingParametersService_RegisterAppCBs - Registers the application callback function.
 *                    Only call this function once.
 *
 *    appCallbacks - pointer to application callbacks.
 */
extern bStatus_t RecordingParametersService_RegisterAppCBs( recordingParametersServiceCBs_t *appCallbacks );

/*
 * RecordingParametersService_SetParameter - Set a RecordingParametersService parameter.
 *
 *    param - Profile parameter ID
 *    len - length of data to right
 *    value - pointer to data to write.  This is dependent on
 *          the parameter ID and WILL be cast to the appropriate
 *          data type (example: data type of uint16 will be cast to
 *          uint16 pointer).
 */
extern bStatus_t RecordingParametersService_SetParameter( uint8 param, uint8 len, void *value );

/*
 * RecordingParametersService_GetParameter - Get a RecordingParametersService parameter.
 *
 *    param - Profile parameter ID
 *    value - pointer to data to write.  This is dependent on
 *          the parameter ID and WILL be cast to the appropriate
 *          data type (example: data type of uint16 will be cast to
 *          uint16 pointer).
 */
extern bStatus_t RecordingParametersService_GetParameter( uint8 param, void *value );

/*********************************************************************
*********************************************************************/


#endif /* PROFILES_RECORDINGPARAMETERSSERVICE_H_ */
