/// \addtogroup module_scif_driver_setup
//@{
#include "scif.h"
#include "scif_framework.h"
#include <ti/devices/DeviceFamily.h>
#include DeviceFamily_constructPath(inc/hw_types.h)
#include DeviceFamily_constructPath(inc/hw_memmap.h)
#include DeviceFamily_constructPath(inc/hw_aon_event.h)
#include DeviceFamily_constructPath(inc/hw_aon_rtc.h)
#include DeviceFamily_constructPath(inc/hw_aon_pmctl.h)
#include DeviceFamily_constructPath(inc/hw_aux_sce.h)
#include DeviceFamily_constructPath(inc/hw_aux_smph.h)
#include DeviceFamily_constructPath(inc/hw_aux_spim.h)
#include DeviceFamily_constructPath(inc/hw_aux_evctl.h)
#include DeviceFamily_constructPath(inc/hw_aux_aiodio.h)
#include DeviceFamily_constructPath(inc/hw_aux_timer01.h)
#include DeviceFamily_constructPath(inc/hw_aux_sysif.h)
#include DeviceFamily_constructPath(inc/hw_event.h)
#include DeviceFamily_constructPath(inc/hw_ints.h)
#include DeviceFamily_constructPath(inc/hw_ioc.h)
#include <string.h>
#if defined(__IAR_SYSTEMS_ICC__)
    #include <intrinsics.h>
#endif


// OSAL function prototypes
uint32_t scifOsalEnterCriticalSection(void);
void scifOsalLeaveCriticalSection(uint32_t key);




/// Firmware image to be uploaded to the AUX RAM
static const uint16_t pAuxRamImage[] = {
    /*0x0000*/ 0x140E, 0x0417, 0x140E, 0x0438, 0x140E, 0x0442, 0x140E, 0x045F, 0x140E, 0x0468, 0x140E, 0x0471, 0x140E, 0x047A, 0x8953, 0x9954, 
    /*0x0020*/ 0x8D29, 0xBEFD, 0x4553, 0x2554, 0xAEFE, 0x445C, 0xADB7, 0x745B, 0x545B, 0x7000, 0x7CA3, 0x68AC, 0x00A0, 0x1431, 0x68AD, 0x00A1, 
    /*0x0040*/ 0x1431, 0x68AE, 0x00A2, 0x1431, 0x78A3, 0xF801, 0xFA01, 0xBEF2, 0x78AA, 0x68AC, 0xFD0E, 0x68AE, 0xED92, 0xFD06, 0x7CAA, 0x6440, 
    /*0x0060*/ 0x047F, 0x78A3, 0x8F1F, 0xED8F, 0xEC01, 0xBE01, 0xADB7, 0x8DB7, 0x755B, 0x555B, 0x78A8, 0x60BF, 0xEF27, 0xE240, 0xEF27, 0x7000, 
    /*0x0080*/ 0x7CA8, 0x047F, 0x6477, 0x0000, 0x18AA, 0x9D88, 0x9C01, 0xB60E, 0x109F, 0xAF19, 0xAA00, 0xB60A, 0xA8FF, 0xAF39, 0xBE07, 0x0CA3, 
    /*0x00A0*/ 0x8600, 0x88A1, 0x8F08, 0xFD47, 0x9DB7, 0x08A3, 0x8801, 0x8A01, 0xBEEB, 0x254F, 0xAEFE, 0x645B, 0x445B, 0x4477, 0x047F, 0x5656, 
    /*0x00C0*/ 0x655B, 0x455B, 0x0000, 0x0CA3, 0x0001, 0x0CA4, 0x14DF, 0x047F, 0x5657, 0x665B, 0x465B, 0x0000, 0x0CA3, 0x0002, 0x0CA4, 0x1416, 
    /*0x00E0*/ 0x047F, 0x5658, 0x675B, 0x475B, 0x0000, 0x0CA3, 0x0004, 0x0CA4, 0x1416, 0x047F, 0x765B, 0x565B, 0x86FF, 0x03FF, 0x0CA6, 0x645C, 
    /*0x0100*/ 0x78A5, 0x68A6, 0xED37, 0xB605, 0x0000, 0x0CA5, 0x7CAB, 0x6540, 0x0CA6, 0x1499, 0x78A6, 0x68A7, 0xFD0E, 0xF801, 0xE95A, 0xFD0E, 
    /*0x0120*/ 0xBE01, 0x6553, 0xBDB7, 0x700B, 0xFB96, 0x4453, 0x2454, 0xAEFE, 0xADB7, 0x6453, 0x2454, 0xA6FE, 0x7000, 0xFB96, 0xADB7, 0x0000, 
    /*0x0140*/ 0x00C2, 0x00DE, 0x00FF, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x02EE, 
    /*0x0160*/ 0x015E, 0x0001, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
    /*0x0180*/ 0x0000, 0x0000, 0x1493, 0x0004, 0x8B6A, 0x003F, 0x8B3C, 0xFDB1, 0x002F, 0x8B22, 0x0040, 0x8B2E, 0x8680, 0x0000, 0x8B1B, 0x0000, 
    /*0x01A0*/ 0x0CB8, 0x0001, 0x8B6A, 0x003F, 0x8B3C, 0xFDB1, 0x0006, 0x8B1A, 0x0031, 0x8B56, 0x655B, 0x7656, 0x455B, 0xADB7, 0xADB7, 0x1499, 
    /*0x01C0*/ 0x661F, 0x08C1, 0x8AFF, 0xBE06, 0x08C0, 0x8801, 0x0CC0, 0x0000, 0x0CC1, 0x04ED, 0x08C1, 0x8801, 0x0CC1, 0x08B8, 0x8801, 0x0CB8, 
    /*0x01E0*/ 0x08B8, 0x18B1, 0x8D29, 0xAE05, 0x0000, 0x0CB8, 0x6540, 0x0000, 0x0CA6, 0x0031, 0x8B56, 0x655B, 0x7656, 0x455B, 0xADB7, 0x1493, 
    /*0x0200*/ 0x5656, 0x655B, 0x455B, 0x0000, 0x8B1A, 0x671A, 0x741A, 0x641F, 0x661F, 0x0000, 0x8B6A, 0x003F, 0x8B3C, 0xFDB1, 0xADB7
};


/// Look-up table that converts from AUX I/O index to MCU IOCFG offset
static const uint8_t pAuxIoIndexToMcuIocfgOffsetLut[] = {
    0, 68, 64, 60, 56, 52, 48, 44, 40, 36, 32, 28, 24, 20, 16, 12, 8, 4, 0, 120, 116, 112, 108, 104, 100, 96, 92, 88, 84, 80, 76, 72
};


/** \brief Look-up table of data structure information for each task
  *
  * There is one entry per data structure (\c cfg, \c input, \c output and \c state) per task:
  * - [31:20] Data structure size (number of 16-bit words)
  * - [19:12] Buffer count (when 2+, first data structure is preceded by buffering control variables)
  * - [11:0] Address of the first data structure
  */
static const uint32_t pScifTaskDataStructInfoLut[] = {
//  cfg         input       output      state       
    0x0020115E, 0x00201162, 0x00F01166, 0x00000000  // TimestapIntGenerator
};




// No run-time logging task data structure signatures needed in this project




// No task-specific initialization functions




// No task-specific uninitialization functions




/** \brief Performs driver setup dependent hardware initialization
  *
  * This function is called by the internal driver initialization function, \ref scifInit().
  */
static void scifDriverSetupInit(void) {

    // Select SCE clock frequency in active mode
    HWREG(AON_PMCTL_BASE + AON_PMCTL_O_AUXSCECLK) = AON_PMCTL_AUXSCECLK_SRC_SCLK_HFDIV2;

    // Set the default power mode
    scifSetSceOpmode(AUX_SYSIF_OPMODEREQ_REQ_LP);

    // Initialize task resource dependencies
    // - None required

} // scifDriverSetupInit




/** \brief Performs driver setup dependent hardware uninitialization
  *
  * This function is called by the internal driver uninitialization function, \ref scifUninit().
  */
static void scifDriverSetupUninit(void) {

    // Uninitialize task resource dependencies
    // - None required

} // scifDriverSetupUninit




/** \brief Re-initializes I/O pins used by the specified tasks
  *
  * It is possible to stop a Sensor Controller task and let the System CPU borrow and operate its I/O
  * pins. For example, the Sensor Controller can operate an SPI interface in one application state while
  * the System CPU with SSI operates the SPI interface in another application state.
  *
  * This function must be called before \ref scifExecuteTasksOnceNbl() or \ref scifStartTasksNbl() if
  * I/O pins belonging to Sensor Controller tasks have been borrowed System CPU peripherals.
  *
  * \param[in]      bvTaskIds
  *     Bit-vector of task IDs for the task I/Os to be re-initialized
  */
void scifReinitTaskIo(uint32_t bvTaskIds) {
    if (bvTaskIds & (1 << SCIF_TIMESTAP_INT_GENERATOR_TASK_ID)) {
    }
} // scifReinitTaskIo




/// Driver setup data, to be used in the call to \ref scifInit()
const SCIF_DATA_T scifDriverSetup = {
    (volatile SCIF_INT_DATA_T*) 0x400E0146,
    (volatile SCIF_TASK_CTRL_T*) 0x400E0154,
    (volatile uint16_t*) 0x400E013E,
    0x0000,
    sizeof(pAuxRamImage),
    pAuxRamImage,
    pScifTaskDataStructInfoLut,
    pAuxIoIndexToMcuIocfgOffsetLut,
    0x0000,
    24,
    scifDriverSetupInit,
    scifDriverSetupUninit,
    (volatile uint16_t*) NULL,
    (volatile uint16_t*) NULL,
    NULL
};




// No task-specific API available


//@}


// Generated by PC-SEBASTIAN at 2021-05-18 12:38:26.758
