/** \mainpage Driver Overview
  *
  * \section section_drv_info Driver Information
  * This Sensor Controller Interface driver has been generated by the Texas Instruments Sensor Controller
  * Studio tool:
  * - <b>Project name</b>:     QualilifeHighBlueSensorController
  * - <b>Project file</b>:     C:/Github/TheseSebastian/SensorControllerQualilifeHighBlueV0.4/Analog Sensor for ULPSENSE.scp
  * - <b>Code prefix</b>:      -
  * - <b>Operating system</b>: TI-RTOS
  * - <b>Tool version</b>:     2.6.0.132
  * - <b>Tool patches</b>:     None
  * - <b>Target chip</b>:      CC2652R1F, package QFN48 7x7 RGZ, revision E (2.1)
  * - <b>Created</b>:          2021-05-18 12:38:26.758
  * - <b>Computer</b>:         PC-SEBASTIAN
  * - <b>User</b>:             TP-EO-6
  *
  * No user-provided resource definitions were used to generate this driver.
  *
  * No user-provided procedure definitions were used to generate this driver.
  *
  * Do not edit the generated source code files other than temporarily for debug purposes. Any
  * modifications will be overwritten by the Sensor Controller Studio when generating new output.
  *
  * \section section_drv_modules Driver Modules
  * The driver is divided into three modules:
  * - \ref module_scif_generic_interface, providing the API for:
  *     - Initializing and uninitializing the driver
  *     - Task control (for starting, stopping and executing Sensor Controller tasks)
  *     - Task data exchange (for producing input data to and consume output data from Sensor Controller
  *       tasks)
  * - \ref module_scif_driver_setup, containing:
  *     - The AUX RAM image (Sensor Controller code and data)
  *     - I/O mapping information
  *     - Task data structure information
  *     - Driver setup data, to be used in the driver initialization
  *     - Project-specific functionality
  * - \ref module_scif_osal, for flexible OS support:
  *     - Interfaces with the selected operating system
  *
  * It is possible to use output from multiple Sensor Controller Studio projects in one application. Only
  * one driver setup may be active at a time, but it is possible to switch between these setups. When
  * using this option, there is one instance of the \ref module_scif_generic_interface and
  * \ref module_scif_osal modules, and multiple instances of the \ref module_scif_driver_setup module.
  * This requires that:
  * - The outputs must be generated using the same version of Sensor Controller Studio
  * - The outputs must use the same operating system
  * - The outputs must use different source code prefixes (inserted into all globals of the
  *   \ref module_scif_driver_setup)
  *
  *
  * \section section_project_info Project Description
  * Demonstrates use of Timer 2 for startup sequencing, and ADC for sampling the analog light sensor on
  * ULP Sense BoosterPack (BOOSTXL-ULPSENSE).
  * 
  * The Sensor Controller samples the analog light sensor, finds whether the ADC value is above or below
  * configurable thresholds, and notifies the System CPU.
  * 
  * The default sampling frequency is ~10 Hz.
  * 
  * BOOSTXL-ULPSENSE SETUP:
  * - Mount ADC SEL jumper: LIGHT
  * - Mount SENSOR POWER jumper: LIGHT
  * - Remove all other jumpers
  * 
  * See the header in the application source file ("main_tirtos.c") for further details and instructions.
  * This file is located in the source code output directory.
  *
  *
  * \subsection section_io_mapping I/O Mapping
  * Task I/O functions are mapped to the following pins:
  * 
  *
  *
  * \section section_task_info Task Description(s)
  * This driver supports the following task(s):
  *
  *
  * \subsection section_task_desc_timestap_int_generator TimestapIntGenerator
  * - This task generates periodical interrupts fixed by input.sensorControllerPeriodIRQmS in
  * milliseconds
  * - This task also generates a 1 millisecond timestamp that can be read in the armM4
  *
  */




/** \addtogroup module_scif_driver_setup Driver Setup
  *
  * \section section_driver_setup_overview Overview
  *
  * This driver setup instance has been generated for:
  * - <b>Project name</b>:     QualilifeHighBlueSensorController
  * - <b>Code prefix</b>:      -
  *
  * The driver setup module contains the generated output from the Sensor Controller Studio project:
  * - Location of task control and scheduling data structures in AUX RAM
  * - The AUX RAM image, and the size the image
  * - Task data structure information (location, size and buffer count)
  * - I/O pin mapping translation table
  * - Task resource initialization and uninitialization functions
  * - Hooks for run-time logging
  *
  * @{
  */
#ifndef SCIF_H
#define SCIF_H

#include <stdint.h>
#include <stdbool.h>
#include "scif_framework.h"
#include "scif_osal_tirtos.h"


/// Target chip name
#define SCIF_TARGET_CHIP_NAME_CC2652R1F
/// Target chip package
#define SCIF_TARGET_CHIP_PACKAGE_QFN48_7X7_RGZ

/// Number of tasks implemented by this driver
#define SCIF_TASK_COUNT 1

/// TimestapIntGenerator: Task ID
#define SCIF_TIMESTAP_INT_GENERATOR_TASK_ID 0


/// TimestapIntGenerator: 
#define SCIF_TIMESTAP_INT_GENERATOR_COMMAND2VDAC 39596
/// TimestapIntGenerator: 
#define SCIF_TIMESTAP_INT_GENERATOR_MAX_SEA_NOISE_LEVEL_SCALED 3040
/// TimestapIntGenerator: 
#define SCIF_TIMESTAP_INT_GENERATOR_MIN_SEA_NOISE_LEVEL_SCALED 1560
/// TimestapIntGenerator: Minimum noise shift, ajouter au niveau mesuré
#define SCIF_TIMESTAP_INT_GENERATOR_MINIMUM_NOISE 5
/// TimestapIntGenerator: 
#define SCIF_TIMESTAP_INT_GENERATOR_REFERENCE1_65 1505
/// TimestapIntGenerator: 
#define SCIF_TIMESTAP_INT_GENERATOR_THRESHOLD_1_6V 1550
/// TimestapIntGenerator: 
#define SCIF_TIMESTAP_INT_GENERATOR_TOTO 0


// All shared data structures in AUX RAM need to be packed
#pragma pack(push, 2)


/// TimestapIntGenerator: Task configuration structure
typedef struct {
    uint16_t highThres; ///< ADC value high threshold
    uint16_t lowThres;  ///< ADC value low threshold
} SCIF_TIMESTAP_INT_GENERATOR_CFG_T;


/// TimestapIntGenerator: Task input data structure
typedef struct {
    uint16_t sensorControllerPeriodIRQSeconds; ///< 
    uint16_t timer2Cleared;                    ///< This flag is set by the CPU to indicate that the 1 second timer alarm was well cleared
} SCIF_TIMESTAP_INT_GENERATOR_INPUT_T;


/// TimestapIntGenerator: Task output data structure
typedef struct {
    uint16_t LPFLastOutput;      ///< 
    uint16_t adcValue;           ///< Last ADC value
    uint16_t dacValue;           ///< 
    uint16_t isAboveHighThres;   ///< 1 if the ADC value is above cfg.highThres, otherwise 0
    uint16_t isBelowLowThres;    ///< 1 if the ADC value is below cfg.lowThres, otherwise 0
    uint16_t secondsCounter;     ///< 
    uint16_t test;               ///< 
    uint16_t test2;              ///< 
    uint16_t test3;              ///< 
    uint16_t timeStamp64LSBHigh; ///< 
    uint16_t timeStamp64LSBLow;  ///< 
    uint16_t timeStamp64MSBHigh; ///< 
    uint16_t timeStamp64MSBLow;  ///< 
    uint16_t timeStampSCHigh;    ///< 
    uint16_t timeStampSCLow;     ///< 
} SCIF_TIMESTAP_INT_GENERATOR_OUTPUT_T;


/// Sensor Controller task data (configuration, input buffer(s), output buffer(s) and internal state)
typedef struct {
    struct {
        SCIF_TIMESTAP_INT_GENERATOR_CFG_T cfg;
        SCIF_TIMESTAP_INT_GENERATOR_INPUT_T input;
        SCIF_TIMESTAP_INT_GENERATOR_OUTPUT_T output;
    } timestapIntGenerator;
} SCIF_TASK_DATA_T;

/// Sensor Controller task generic control (located in AUX RAM)
#define scifTaskData    (*((volatile SCIF_TASK_DATA_T*) 0x400E015E))


// Initialized internal driver data, to be used in the call to \ref scifInit()
extern const SCIF_DATA_T scifDriverSetup;


// Restore previous struct packing setting
#pragma pack(pop)


// AUX I/O re-initialization functions
void scifReinitTaskIo(uint32_t bvTaskIds);


// No task-specific API available


#endif
//@}


// Generated by PC-SEBASTIAN at 2021-05-18 12:38:26.758
