/*
 * SD_Driver.c
 *
 *  Created on: 7 mai 2021
 *      Author: sebas
 */

#include <string.h>
#include <math.h>
#include <stdbool.h>
#include <time.h>
#include <stdlib.h>
#include <stdint.h>
#include <stddef.h>
#include <file.h>
#include <stdio.h>
#include "Macros/Protocol.h"
#include <ti/drivers/SDFatFS.h>
#include <ti/drivers/SD.h>
#include <ti/drivers/PIN.h>
#include <third_party/fatfs/ff.h>
#include <third_party/fatfs/diskio.h>
#include <third_party/fatfs/ffcio.h>
#include <ti/drivers/SPI.h>
#include <ti/drivers/GPIO.h>
#include "Macros/Define.h"
#include <Task_UART_PIC32/MsgProcessor_PIC32.h>
#include <Task_SD/SD_Driver.h>

#include <Task_SPI/MCP79522/UTLN_MCP79522.h>
#include <Task_Supervisor/Task_Supervisor.h>
/* Driver configuration */
#include "ti_drivers_config.h"
#include "hal_types.h"
#include "hal_defs.h"
char fatfsPrefix[] = "fat";

#define DRIVE_NUM       0

SDFatFS_Object sdfatfsObjects[1];

//const SDFatFS_Config SDFatFS_config[1] = { { .object = &sdfatfsObjects[0] } };
//
//const uint_least8_t SDFatFS_count = 1;
extern bool USING_CNN_DETECTION;                //1 // GIAS = 1; QHB =0
extern SupervisorState supervisorState;
RtccDateTime    FlashRtccDateTime;
extern uint8_t SDTrameToProcess[512];
extern uint16_t SDTrameToProcessSize;
FIL src;
bool SDWriteFinished = true;

int32_t fatfs_getFatTime(void)
{
    time_t seconds;
    uint32_t fatTime;
    struct tm *pTime;

    seconds = time(NULL);

    pTime = localtime(&seconds);

    fatTime = ((uint32_t) (pTime->tm_year - 80) << 25)
            | ((uint32_t) (pTime->tm_mon) << 21)
            | ((uint32_t) (pTime->tm_mday) << 16)
            | ((uint32_t) (pTime->tm_hour) << 11)
            | ((uint32_t) (pTime->tm_min) << 5)
            | ((uint32_t) (pTime->tm_sec) >> 1);

    return ((int32_t) fatTime);
}

/* Set this to the current UNIX time in seconds */
const struct timespec ts = {
    .tv_sec = 1469647026,
    .tv_nsec = 0
};
/*
 *  ======== printDrive ========
 *  Function to print drive information such as the total disk space
 *  This function was created by referencing FatFs's API documentation
 *  http://elm-chan.org/fsw/ff/en/getfree.html
 *
 *  This function call may take a while to process, depending on the size of
 *  SD Card used.
 */
void printDrive(const char *driveNumber, FATFS **fatfs)
{
    FRESULT fresult;
    DWORD   freeClusterCount;
    DWORD   totalSectorCount;
    DWORD   freeSectorCount;

    //Display_printf(display, 0, 0, "Reading disk information...");

    fresult = f_getfree(driveNumber, &freeClusterCount, fatfs);
    if (fresult) {
//        Display_printf(display, 0, 0,
//            "Error getting the free cluster count from the FatFs object");
//        while (1);
        ;
    }
    else {
//        Display_printf(display, 0, 0, "done\n");

        /* Get total sectors and free sectors */
        totalSectorCount = ((*fatfs)->n_fatent - 2) * (*fatfs)->csize;
        freeSectorCount  = freeClusterCount * (*fatfs)->csize;

        /* Print the free space (assuming 512 bytes/sector) */
//        Display_printf(display, 0, 0,
//            "Total Disk size: %10lu KiB\n Free Disk space: %10lu KiB\n",
//            totalSectorCount / 2, freeSectorCount  / 2);
    }
}
int fsize(FILE *fp)
{
    int prev = ftell(fp);
    fseek(fp, 0L, SEEK_END);
    int sz = ftell(fp);
    fseek(fp, prev, SEEK_SET); //go back to where we were
    return sz;
}

uint8_t Init_SD(void)
{

    //par defaut c'est USB
    supervisorState.recordParameters.storageTarget = 2;
    supervisorState.recordParameters.resolution = (int) DEFAULT_RESOLUTION;
    supervisorState.recordParameters.samplingFrequency = DEFAULT_FREQ;
    supervisorState.recordParameters.filterSelection = DEFAULT_FILTER_SEL;
    supervisorState.recordParameters.useAutoStart = false;
    supervisorState.recordParameters.fileSize = USTV_DEFAULT_FILESIZE_LIMITATION;
    supervisorState.recordParameters.recordUseTimeInterval = false;
    supervisorState.recordParameters.recordingDuration = DEFAULT_RECORDING_DURATION;
    supervisorState.recordParameters.shutdownDuration = DEFAULT_SHUTDOWN_DURATION;
    supervisorState.recordParameters.nbChannelsUsed = DEFAULT_CHANNEL_COUNT;
    supervisorState.recordParameters.preparingDuration = DEFAULT_PREPARING_DURATION;
    supervisorState.recordParameters.stoppingDuration = DEFAULT_STOPPING_DURATION;
    supervisorState.recordParameters.DetectionCNNDurationTimeout = 1;
    supervisorState.recordParameters.DataSendDurationTimeout = 1;
    supervisorState.recordParameters.nbRemontesParJour = 1;
    supervisorState.recordParameters.TimeOutRemontee = 1;


    //GPIO_init();
    SDFatFS_init();

    add_device(fatfsPrefix, _MSA, ffcio_open, ffcio_close, ffcio_read,
               ffcio_write, ffcio_lseek, ffcio_unlink, ffcio_rename);

    //Vrifier si la carte SD y est dj
    //uint_fast8_t SDDetected = GPIO_read(SD_CARD_DETECT);

    //if (SDDetected == 1)
    //{
        //SD_CARD_DETECT_CallbackFxn(1);
    //    return 1;
    //}

    return 0;
}
//Dossier
//char ConfigurationFile[] = "fat:/Config/JConfig.cfg";
//Sans Dossier
char ConfigurationFile[] = "fat:0:JConfig.cfg";

bool USTV_LoadConfigurationFile(void)
{

    SDFatFS_Handle sdfatfsHandle;
    FILE *src;

    sdfatfsHandle = SDFatFS_open(CONFIG_SDFatFS_0, DRIVE_NUM);

    if (sdfatfsHandle != NULL)
    {
        src = fopen(ConfigurationFile, "r"); //r Opens a file for reading. The file must exist.
        if (src != NULL)
        {
            //GPIO_write(SPI_SS_EXT1, CONFIG_GPIO_LED_ON);

            int fileSize = fsize(src);
            if (fileSize < 1500)
            {
                unsigned char stringBuffer[fileSize + 1]; //+1 avec le char de fin de chaine
                //stringBuffer[fileSize]=0;       //Ajout du charactere de fin de chaine
                //rewind(src);
                fread(stringBuffer, 1, fileSize, src);

                int i;
                for (i = 0; i < USTV_PARAMETER_COUNT; i++)
                {
                    char* match = 0;
                    char* debutData = 0;
                    char* finData = 0;
                    char* espace = 0;
                    switch (i)
                    {
                    case USTV_SAMPLING_RES_IDX:
                    {
                        //La lecture est bonne, on process la chaine
                        match = strstr(stringBuffer, "Sampling_Resolution=");
                        if (match != NULL)
                        {
                            debutData = match + strlen("Sampling_Resolution=");
                            finData = strchr(debutData, ';');
                            espace = strchr(debutData, ' ');
                            if (espace != NULL && espace < debutData)
                            {
                                debutData = espace;
                            }
                            char tmp[20] = { 0 };
                            strncpy(tmp, debutData, finData - debutData);
                            long res = atol(tmp);
                            if (res != 0)
                            {
                                if (res > BLUEEAR_MAX_RESOLUTION)
                                    supervisorState.recordParameters.resolution =
                                            (int) BLUEEAR_MAX_RESOLUTION;
                                else
                                    supervisorState.recordParameters.resolution =
                                            (int) res;
                            }
                        }
                        else
                        {
                            supervisorState.recordParameters.resolution =
                                    (int) DEFAULT_RESOLUTION;
                        }
                    }
                        break;
                    case USTV_SAMPLING_FREQ_IDX:
                    {
                        match = strstr(stringBuffer, "Sampling_Freq=");
                        if (match)
                        {
                            debutData = match + strlen("Sampling_Freq=");
                            finData = strchr(debutData, ';');
                            espace = strchr(debutData, ' ');
                            if (espace != NULL && espace < debutData)
                            {
                                debutData = espace;
                            }
                            char tmp[30] = { 0 };
                            strncpy(tmp, debutData, finData - debutData);
                            int freq = atoi(tmp);
                            if (freq != 0)
                                supervisorState.recordParameters.samplingFrequency =
                                        freq;
                        }
                        else
                        {
                            supervisorState.recordParameters.samplingFrequency =
                                    DEFAULT_FREQ;
                        }
                    }
                        break;
                    case USTV_FILTERS_SEL_IDX:
                    {
                        match = strstr(stringBuffer, "Filter_Selection=");
                        if (match != NULL)
                        {
                            debutData = match + strlen("Filter_Selection=");
                            finData = strchr(debutData, ';');
                            espace = strchr(debutData, ' ');
                            if (espace != NULL && espace < debutData)
                            {
                                debutData = espace;
                            }
                            char tmp[4] = { 0 };
                            strncpy(tmp, debutData, finData - debutData);

                            int sel = atoi(tmp);

                            if (sel <= 2)
                            {
                                supervisorState.recordParameters.filterSelection =
                                        sel;
                            }
                            else
                            {
                                supervisorState.recordParameters.filterSelection =
                                        DEFAULT_FILTER_SEL;
                            }
                        }
                        else
                        {
                            supervisorState.recordParameters.filterSelection =
                                    DEFAULT_FILTER_SEL;
                        }
                    }
                        break;
                    case USTV_USE_AUTO_START_IDX:
                    {
                        match = strstr(stringBuffer, "AutoStart=");
                        if (match != NULL)
                        {
                            debutData = match + strlen("AutoStart=");
                            finData = strchr(debutData, ';');
                            espace = strchr(debutData, ' ');
                            if (espace != NULL && espace < debutData)
                            {
                                debutData = espace;
                            }
                            char tmp[15] = { 0 };
                            strncpy(tmp, debutData, finData - debutData);
                            if (strstr(tmp, "true") != NULL)
                            {
                                supervisorState.recordParameters.useAutoStart =
                                        true;
                            }
                            else
                            {
                                supervisorState.recordParameters.useAutoStart =
                                        false;
                            }
                        }
                        else
                        {
                            supervisorState.recordParameters.useAutoStart =
                                    false;
                        }
                    }
                        break;

                    case USTV_FS_FLIMIT_IDX:
                    {
                        char* match = strstr(stringBuffer, "FILE_Size_Limit=");
                        if (match != NULL)
                        {
                            debutData = match + strlen("FILE_Size_Limit=");
                            finData = strchr(debutData, ';');
                            espace = strchr(debutData, ' ');
                            if (espace != NULL && espace < debutData)
                            {
                                debutData = espace;
                            }
                            char tmp[20] = { 0 };
                            strncpy(tmp, debutData, finData - debutData);
                            long fsLim = atol(tmp);
                            supervisorState.recordParameters.fileSize = fsLim;
                        }
                        else
                        {
                            supervisorState.recordParameters.fileSize =
                            USTV_DEFAULT_FILESIZE_LIMITATION;
                        }
                    }
                        break;

                    case USTV_RECORD_USE_TIM_INT_IDX:
                    {
                        match = strstr(stringBuffer,
                                       "Record_Use_TimeInterval=");
                        if (match != NULL)
                        {
                            debutData = match
                                    + strlen("Record_Use_TimeInterval=");
                            finData = strchr(debutData, ';');
                            espace = strchr(debutData, ' ');
                            if (espace != NULL && espace < debutData)
                            {
                                debutData = espace;
                            }
                            char tmp[20] = { 0 };
                            strncpy(tmp, debutData, finData - debutData);
                            if (strstr(tmp, "true") != NULL)
                            {
                                supervisorState.recordParameters.recordUseTimeInterval =
                                        true;
                            }
                            else
                            {
                                supervisorState.recordParameters.recordUseTimeInterval =
                                        false;
                            }
                        }
                        else
                        {
                            supervisorState.recordParameters.recordUseTimeInterval =
                                    false;
                            //                        char buff[250]={0};
                            //                        sprintf(buff,"#Error while reading useRecordInterval parameter.\nSetting parameter to default:%s \n",(0)?"true":"false");
                            //                        USTV_LogSysError(buff, strlen(buff));
                        }
                    }
                        break;
                    case USTV_RECORD_TIME_IDX:
                    {
                        match = strstr(stringBuffer, "Recording_Duration=");
                        if (match != NULL)
                        {
                            debutData = match + strlen("Recording_Duration=");
                            finData = strchr(debutData, ';');
                            espace = strchr(debutData, ' ');
                            if (espace != NULL && espace < debutData)
                            {
                                debutData = espace;
                            }
                            char tmp[20] = { 0 };
                            strncpy(tmp, debutData, finData - debutData);
                            int recording_Duration = atoi(tmp);
#if !debugMode
                            if (recording_Duration > 0)
                                supervisorState.recordParameters.recordingDuration =
                                        recording_Duration;
#endif
                        }
                        else
                        {
#if !debugMode
                            supervisorState.recordParameters.recordingDuration =
                                    DEFAULT_RECORDING_DURATION;
#endif
                            //                        char buff[250]={0};
                            //                        sprintf(buff,"#Error while reading recordingTime parameter.\nSetting parameter to default:%d \n",DEFAULT_RECORD_TIME);
                            //                        USTV_LogSysError(buff, strlen(buff));
                        }
                    }
                        break;
                    case SHUTDOWN_DURATION_IDX:
                    {
                        match = strstr(stringBuffer, "Shutdown_Duration=");
                        if (match != NULL)
                        {
                            debutData = match + strlen("Shutdown_Duration=");
                            finData = strchr(debutData, ';');
                            espace = strchr(debutData, ' ');
                            if (espace != NULL && espace < debutData)
                            {
                                debutData = espace;
                            }
                            char tmp[20] = { 0 };
                            strncpy(tmp, debutData, finData - debutData);
                            int Shutdown_Duration = atoi(tmp);

#if !debugMode
                            if (Shutdown_Duration > 0)
                                supervisorState.recordParameters.shutdownDuration =
                                        Shutdown_Duration;
                            else
                                supervisorState.recordParameters.shutdownDuration =
                                        DEFAULT_SHUTDOWN_DURATION;
#endif
                        }
                        else
                        {
#if !debugMode
                            supervisorState.recordParameters.shutdownDuration =
                                    DEFAULT_SHUTDOWN_DURATION;
#endif
                            //                        char buff[250]={0};
                            //                        sprintf(buff,"#Error while reading recordingInterval parameter.\nSetting parameter to default:%d \n",DEFAULT_INTERVAL);
                            //                        USTV_LogSysError(buff, strlen(buff));
                        }
                    }
                        break;
                    case USTV_CHANNEL_COUNT_IDX:
                    {
                        match = strstr(stringBuffer, "Channel_Count=");
                        if (match != NULL)
                        {
                            debutData = match + strlen("Channel_Count=");
                            finData = strchr(debutData, ';');
                            espace = strchr(debutData, ' ');
                            if (espace != NULL && espace < debutData)
                            {
                                debutData = espace;
                            }
                            char tmp[20] = { 0 };
                            strncpy(tmp, debutData, finData - debutData);
                            int channel_count = atoi(tmp);

                            if (channel_count != 0)
                                supervisorState.recordParameters.nbChannelsUsed =
                                        channel_count;
                            else
                                supervisorState.recordParameters.nbChannelsUsed =
                                        DEFAULT_CHANNEL_COUNT;
                        }
                        else
                        {
                            supervisorState.recordParameters.nbChannelsUsed =
                                    DEFAULT_CHANNEL_COUNT;
                            //                        char buff[250]={0};
                            //                        sprintf(buff,"#Error while reading recordingInterval parameter.\nSetting parameter to default:%d \n",DEFAULT_INTERVAL);
                            //                        USTV_LogSysError(buff, strlen(buff));
                        }
                    }
                        break;
                    case USTV_PREPARING_DURATION_PIC32_IDX:
                    {
                        match = strstr(stringBuffer, "Preparing_Duration=");
                        if (match != NULL)
                        {
                            debutData = match + strlen("Preparing_Duration=");
                            finData = strchr(debutData, ';');
                            espace = strchr(debutData, ' ');
                            if (espace != NULL && espace < debutData)
                            {
                                debutData = espace;
                            }
                            char tmp[20] = { 0 };
                            strncpy(tmp, debutData, finData - debutData);
                            int Preparing_Duration = atoi(tmp);

#if !debugMode
                            if (Preparing_Duration
                                    >= DEFAULT_PREPARING_DURATION)
                                supervisorState.recordParameters.preparingDuration =
                                        Preparing_Duration;
                            else
                                supervisorState.recordParameters.preparingDuration =
                                        DEFAULT_PREPARING_DURATION;
#endif
                        }
                        else
                        {
#if !debugMode
                            supervisorState.recordParameters.preparingDuration =
                                    DEFAULT_PREPARING_DURATION;
#endif
                            //                        char buff[250]={0};
                            //                        sprintf(buff,"#Error while reading recordingInterval parameter.\nSetting parameter to default:%d \n",DEFAULT_INTERVAL);
                            //                        USTV_LogSysError(buff, strlen(buff));
                        }
                    }
                        break;
                    case USTV_STOPPING_DURATION_PIC32_IDX:
                    {
                        match = strstr(stringBuffer, "Stopping_Duration=");
                        if (match != NULL)
                        {
                            debutData = match + strlen("Stopping_Duration=");
                            finData = strchr(debutData, ';');
                            espace = strchr(debutData, ' ');
                            if (espace != NULL && espace < debutData)
                            {
                                debutData = espace;
                            }
                            char tmp[20] = { 0 };
                            strncpy(tmp, debutData, finData - debutData);
                            int Stopping_Duration = atoi(tmp);

#if !debugMode
                            if (Stopping_Duration
                                    >= DEFAULT_STOPPING_DURATION)
                                supervisorState.recordParameters.stoppingDuration =
                                        Stopping_Duration;
                            else
                                supervisorState.recordParameters.stoppingDuration =
                                        DEFAULT_STOPPING_DURATION;
#endif
                        }
                        else
                        {
#if !debugMode
                            supervisorState.recordParameters.stoppingDuration =
                                    DEFAULT_STOPPING_DURATION;
#endif
                            //                        char buff[250]={0};
                            //                        sprintf(buff,"#Error while reading recordingInterval parameter.\nSetting parameter to default:%d \n",DEFAULT_INTERVAL);
                            //                        USTV_LogSysError(buff, strlen(buff));
                        }
                    }
                        break;
                    case USTV_STORAGE_TARGET_IDX:
                    {
                        match = strstr(stringBuffer, "Storage_Target=");
                        if (match != NULL)
                        {
                            debutData = match + strlen("Storage_Target=");
                            finData = strchr(debutData, ';');
                            espace = strchr(debutData, ' ');
                            if (espace != NULL && espace < debutData)
                            {
                                debutData = espace;
                            }
                            char tmp[20] = { 0 };
                            strncpy(tmp, debutData, finData - debutData);
                            if (strstr(tmp, "USB") != NULL)
                            {
                                supervisorState.recordParameters.storageTarget = 2;
                            }
                            else if (strstr(tmp, "SD") != NULL)
                            {
                                supervisorState.recordParameters.storageTarget = 0;
                            }
                            else
                            {
                                supervisorState.recordParameters.storageTarget = 0;
                            }
                        }
                        else
                        {
                            supervisorState.recordParameters.storageTarget = 2;
                        }
                    }
                        break;

                    case GIAS_CNN_DETECTION_TIMEOUT_DURATION_IDX:
                    {
                        match = strstr(stringBuffer, "CNN_Detection_Timeout_Duration=");

                        if (match != NULL)
                        {
                            debutData = match + strlen("CNN_Detection_Timeout_Duration=");
                            finData = strchr(debutData, ';');
                            espace = strchr(debutData, ' ');
                            if (espace != NULL && espace < debutData)
                            {
                                debutData = espace;
                            }
                            char tmp[20] = { 0 };
                            strncpy(tmp, debutData, finData - debutData);
                            int CNN_Detection_TimeoutDuration = atoi(tmp);

                            //Si on ne le trouve on fait le GIAS
                            USING_CNN_DETECTION = true;

                            if (CNN_Detection_TimeoutDuration >= DEFAULT_CNN_DETECTION_TIMEOUT_DURATION)
                                supervisorState.recordParameters.DetectionCNNDurationTimeout =
                                        CNN_Detection_TimeoutDuration;
                            else
                                supervisorState.recordParameters.DetectionCNNDurationTimeout =
                                        DEFAULT_CNN_DETECTION_TIMEOUT_DURATION;
                        }
                        else
                        {
                            supervisorState.recordParameters.DetectionCNNDurationTimeout =
                                    DEFAULT_CNN_DETECTION_TIMEOUT_DURATION;
                            //Si on ne l'a pas trouv on fait le projet QHB et ne pas le GIAS
                            USING_CNN_DETECTION = false;
                        }
                    }
                        break;

                    case GIAS_TIMEOUT_REMONTE_IDX:
                    {
                        match = strstr(stringBuffer, "Remontee_Timeout_Duration=");

                        if (match != NULL)
                        {
                            debutData = match + strlen("Remontee_Timeout_Duration=");
                            finData = strchr(debutData, ';');
                            espace = strchr(debutData, ' ');
                            if (espace != NULL && espace < debutData)
                            {
                                debutData = espace;
                            }
                            char tmp[20] = { 0 };
                            strncpy(tmp, debutData, finData - debutData);
                            uint32_t Remontee_TimeoutDuration = atoi(tmp);

                            //Si on le trouve on fait le GIAS
                            USING_CNN_DETECTION = true;

                            if (Remontee_TimeoutDuration >= DEFAULT_REMONTEE_TIMEOUT_DURATION)
                                supervisorState.recordParameters.TimeOutRemontee =
                                        Remontee_TimeoutDuration;
                            else
                                supervisorState.recordParameters.TimeOutRemontee =
                                        DEFAULT_REMONTEE_TIMEOUT_DURATION;

                        }
                        else
                        {
                            supervisorState.recordParameters.TimeOutRemontee =
                                    DEFAULT_REMONTEE_TIMEOUT_DURATION;

                            //Si on ne l'a pas trouv on fait le projet QHB et ne pas le GIAS
                            USING_CNN_DETECTION = false;
                        }
                    }
                        break;

                    case GIAS_GSM_DATA_SEND_TIMEOUT_DURATION_IDX:
                    {
                        match = strstr(stringBuffer, "GSM_Data_Send_Timeout_Duration=");

                        if (match != NULL)
                        {
                            debutData = match + strlen("GSM_Data_Send_Timeout_Duration=");
                            finData = strchr(debutData, ';');
                            espace = strchr(debutData, ' ');
                            if (espace != NULL && espace < debutData)
                            {
                                debutData = espace;
                            }
                            char tmp[20] = { 0 };
                            strncpy(tmp, debutData, finData - debutData);
                            int GSM_Data_Send_TimeoutDuration = atoi(tmp);

                            //Si on ne le trouve on fait le GIAS
                            USING_CNN_DETECTION = true;

                            if (GSM_Data_Send_TimeoutDuration >= DEFAULT_GSM_DATA_SEND_TIMEOUT_DURATION)
                                supervisorState.recordParameters.DataSendDurationTimeout =
                                        GSM_Data_Send_TimeoutDuration;
                            else
                                supervisorState.recordParameters.DataSendDurationTimeout =
                                        DEFAULT_GSM_DATA_SEND_TIMEOUT_DURATION;

                        }
                        else
                        {
                            supervisorState.recordParameters.DataSendDurationTimeout =
                                    DEFAULT_GSM_DATA_SEND_TIMEOUT_DURATION;

                            //Si on ne l'a pas trouv on fait le projet QHB et ne pas le GIAS
                            USING_CNN_DETECTION = false;
                        }
                    }
                        break;

                    case GIAS_NB_REMONTES_PAR_JOUR_IDX:
                    {
                        match = strstr(stringBuffer, "Nb_Remontes_Par_Jour=");

                        if (match != NULL)
                        {
                            debutData = match + strlen("Nb_Remontes_Par_Jour=");
                            finData = strchr(debutData, ';');
                            espace = strchr(debutData, ' ');
                            if (espace != NULL && espace < debutData)
                            {
                                debutData = espace;
                            }
                            char tmp[20] = { 0 };
                            strncpy(tmp, debutData, finData - debutData);
                            int NB_REMONTES_PAR_JOUR = atoi(tmp);

                            //Si on ne le trouve on fait le GIAS
                            USING_CNN_DETECTION = true;

                            if (NB_REMONTES_PAR_JOUR >= DEFAULT_NB_REMONTES_PAR_JOUR)
                                supervisorState.recordParameters.nbRemontesParJour =
                                        NB_REMONTES_PAR_JOUR;
                            else
                                supervisorState.recordParameters.nbRemontesParJour =
                                        DEFAULT_NB_REMONTES_PAR_JOUR;
                        }
                        else
                        {
                            supervisorState.recordParameters.nbRemontesParJour =
                                    DEFAULT_NB_REMONTES_PAR_JOUR;

                            //Si on ne l'a pas trouv on fait le projet QHB et ne pas le GIAS
                            USING_CNN_DETECTION = false;
                        }
                    }
                        break;



                    default:        //On a une erreur si on passe par ici
                        break;
                    }
                }
            }
            else
            {
                fclose(src);
                // Release SPI0!
                SDFatFS_close(sdfatfsHandle);
                return false;
            }

            fclose(src);
            //GPIO_write(SPI_SS_EXT1, CONFIG_GPIO_LED_OFF);
        }
        else
        {
//           GPIO_write(LED_Bleue, CONFIG_GPIO_LED_ON);
//           GPIO_write(LED_Blanche, CONFIG_GPIO_LED_OFF);
//           /* SD_open() failed */
//           while (1);
//            fclose(src);
            // Release SPI0!
//            SDFatFS_close(sdfatfsHandle);
            // Release SPI0!
            SDFatFS_close(sdfatfsHandle);
            return false;
        }

        // Release SPI0!
        SDFatFS_close(sdfatfsHandle);
    }
    else
    {
//       GPIO_write(LED_Bleue, CONFIG_GPIO_LED_ON);
//       GPIO_write(LED_Blanche, CONFIG_GPIO_LED_ON);
//       /* SD_open() failed */
//       while (1);

        // Release SPI0!
//        SDFatFS_close(sdfatfsHandle);
        return false;
    }

    return true;
}

/* String conversion macro */
//#define STR_(n)             #n
//#define STR(n)              STR_(n)
//
//const char ConfigurationFile[] = STR(DRIVE_NUM)":/Config/JConfig.cfg";
//bool USTV_LoadConfigurationFile(void)
//{
//    FRESULT fresult;
//    SDFatFS_init();
//    //char ConfigurationFile[] = "fat:/Config/JConfig.cfg";
//    SDFatFS_Handle sdfatfsHandle;
//    /* Mount and register the SD Card */
//    sdfatfsHandle = SDFatFS_open(CONFIG_SDFatFS_0, DRIVE_NUM);
//
//    //printDrive(STR(DRIVE_NUM), &(src.obj.fs));
//
//    if (sdfatfsHandle != NULL)
//    {
//        /* Try to open the source file */
//        fresult = f_open(&src, ConfigurationFile, FA_READ);
//        //src = fopen(ConfigurationFile, "r"); //r Opens a file for reading. The file must exist.
////        if (src != NULL)
////        {
//        if (fresult == FR_OK)
//        {
//            GPIO_write(SPI_SS_EXT1, CONFIG_GPIO_LED_ON);
//
//            //int fileSize = fsize(src);
//            /* Get the filesize of the source file */
////            UINT fileSize = f_size(&src);
//            unsigned int fileSize = f_size(&src);
//
//            if (fileSize < 1500)
//            {
//                unsigned char stringBuffer[fileSize + 1]; //+1 avec le char de fin de chaine
//
////                unsigned int numberOfReads = fileSize / 512;
////                unsigned int numberOfReadsReast = fileSize % 512;
////
////                unsigned int bytesRead = 0;
////                for(int ijk = 0; ijk < numberOfReads; ijk++){
////                    unsigned char stringThisRead[512+1];
////                    fresult = f_read(&src, stringThisRead, 512, &bytesRead);
////                    if(ijk==0)
////                        strcpy(stringBuffer, stringThisRead);
////                    else
////                        strcat(stringBuffer, stringThisRead);
////                }
////
////                unsigned char stringLastRead[numberOfReadsReast+1];
////                fresult = f_read(&src, stringLastRead, stringLastRead, &bytesRead);
////                strcat(stringBuffer, stringLastRead);
//
//
//                //stringBuffer[fileSize]=0;       //Ajout du charactere de fin de chaine
//                //rewind(src);
//                //fread(stringBuffer, 1, fileSize, src);
////                UINT bytesRead = 0;
//                unsigned int bytesRead = 0;
//                fileSize = 512;
//                /* Read from output file */
//                fresult = f_read(&src, stringBuffer, fileSize, &bytesRead);
//
//                if (fresult || bytesRead == 0) {
//                    return false; /* Error or EOF */
//                }
//#if 1
//                int i;
//                for (i = 0; i < USTV_PARAMETER_COUNT; i++)
//                {
//                    char* match = 0;
//                    char* debutData = 0;
//                    char* finData = 0;
//                    char* espace = 0;
//                    switch (i)
//                    {
//                    case USTV_SAMPLING_RES_IDX:
//                    {
//                        //La lecture est bonne, on process la chaine
//                        match = strstr(stringBuffer, "Sampling_Resolution=");
//                        if (match != NULL)
//                        {
//                            debutData = match + strlen("Sampling_Resolution=");
//                            finData = strchr(debutData, ';');
//                            espace = strchr(debutData, ' ');
//                            if (espace != NULL && espace < debutData)
//                            {
//                                debutData = espace;
//                            }
//                            char tmp[20] = { 0 };
//                            strncpy(tmp, debutData, finData - debutData);
//                            long res = atol(tmp);
//                            if (res != 0)
//                            {
//                                if (res > BLUEEAR_MAX_RESOLUTION)
//                                    supervisorState.recordParameters.resolution =
//                                            (int) BLUEEAR_MAX_RESOLUTION;
//                                else
//                                    supervisorState.recordParameters.resolution =
//                                            (int) res;
//                            }
//                        }
//                        else
//                        {
//                            supervisorState.recordParameters.resolution =
//                                    (int) DEFAULT_RESOLUTION;
//                        }
//                    }
//                        break;
//                    case USTV_SAMPLING_FREQ_IDX:
//                    {
//                        match = strstr(stringBuffer, "Sampling_Freq=");
//                        if (match)
//                        {
//                            debutData = match + strlen("Sampling_Freq=");
//                            finData = strchr(debutData, ';');
//                            espace = strchr(debutData, ' ');
//                            if (espace != NULL && espace < debutData)
//                            {
//                                debutData = espace;
//                            }
//                            char tmp[30] = { 0 };
//                            strncpy(tmp, debutData, finData - debutData);
//                            int freq = atoi(tmp);
//                            if (freq != 0)
//                                supervisorState.recordParameters.samplingFrequency =
//                                        freq;
//                        }
//                        else
//                        {
//                            supervisorState.recordParameters.samplingFrequency =
//                                    DEFAULT_FREQ;
//                        }
//                    }
//                        break;
//                    case USTV_FILTERS_SEL_IDX:
//                    {
//                        match = strstr(stringBuffer, "Filter_Selection=");
//                        if (match != NULL)
//                        {
//                            debutData = match + strlen("Filter_Selection=");
//                            finData = strchr(debutData, ';');
//                            espace = strchr(debutData, ' ');
//                            if (espace != NULL && espace < debutData)
//                            {
//                                debutData = espace;
//                            }
//                            char tmp[4] = { 0 };
//                            strncpy(tmp, debutData, finData - debutData);
//
//                            int sel = atoi(tmp);
//
//                            if (sel <= 2)
//                            {
//                                supervisorState.recordParameters.filterSelection =
//                                        sel;
//                            }
//                            else
//                            {
//                                supervisorState.recordParameters.filterSelection =
//                                        DEFAULT_FILTER_SEL;
//                            }
//                        }
//                        else
//                        {
//                            supervisorState.recordParameters.filterSelection =
//                                    DEFAULT_FILTER_SEL;
//                        }
//                    }
//                        break;
//                    case USTV_USE_AUTO_START_IDX:
//                    {
//                        match = strstr(stringBuffer, "AutoStart=");
//                        if (match != NULL)
//                        {
//                            debutData = match + strlen("AutoStart=");
//                            finData = strchr(debutData, ';');
//                            espace = strchr(debutData, ' ');
//                            if (espace != NULL && espace < debutData)
//                            {
//                                debutData = espace;
//                            }
//                            char tmp[15] = { 0 };
//                            strncpy(tmp, debutData, finData - debutData);
//                            if (strstr(tmp, "true") != NULL)
//                            {
//                                supervisorState.recordParameters.useAutoStart =
//                                        true;
//                            }
//                            else
//                            {
//                                supervisorState.recordParameters.useAutoStart =
//                                        false;
//                            }
//                        }
//                        else
//                        {
//                            supervisorState.recordParameters.useAutoStart =
//                                    false;
//                        }
//                    }
//                        break;
//
//                    case USTV_FS_FLIMIT_IDX:
//                    {
//                        char* match = strstr(stringBuffer, "FILE_Size_Limit=");
//                        if (match != NULL)
//                        {
//                            debutData = match + strlen("FILE_Size_Limit=");
//                            finData = strchr(debutData, ';');
//                            espace = strchr(debutData, ' ');
//                            if (espace != NULL && espace < debutData)
//                            {
//                                debutData = espace;
//                            }
//                            char tmp[20] = { 0 };
//                            strncpy(tmp, debutData, finData - debutData);
//                            long fsLim = atol(tmp);
//                            supervisorState.recordParameters.fileSize = fsLim;
//                        }
//                        else
//                        {
//                            supervisorState.recordParameters.fileSize =
//                            USTV_DEFAULT_FILESIZE_LIMITATION;
//                        }
//                    }
//                        break;
//
//                    case USTV_RECORD_USE_TIM_INT_IDX:
//                    {
//                        match = strstr(stringBuffer,
//                                       "Record_Use_TimeInterval=");
//                        if (match != NULL)
//                        {
//                            debutData = match
//                                    + strlen("Record_Use_TimeInterval=");
//                            finData = strchr(debutData, ';');
//                            espace = strchr(debutData, ' ');
//                            if (espace != NULL && espace < debutData)
//                            {
//                                debutData = espace;
//                            }
//                            char tmp[20] = { 0 };
//                            strncpy(tmp, debutData, finData - debutData);
//                            if (strstr(tmp, "true") != NULL)
//                            {
//                                supervisorState.recordParameters.recordUseTimeInterval =
//                                        true;
//                            }
//                            else
//                            {
//                                supervisorState.recordParameters.recordUseTimeInterval =
//                                        false;
//                            }
//                        }
//                        else
//                        {
//                            supervisorState.recordParameters.recordUseTimeInterval =
//                                    false;
//                            //                        char buff[250]={0};
//                            //                        sprintf(buff,"#Error while reading useRecordInterval parameter.\nSetting parameter to default:%s \n",(0)?"true":"false");
//                            //                        USTV_LogSysError(buff, strlen(buff));
//                        }
//                    }
//                        break;
//                    case USTV_RECORD_TIME_IDX:
//                    {
//                        match = strstr(stringBuffer, "Recording_Duration=");
//                        if (match != NULL)
//                        {
//                            debutData = match + strlen("Recording_Duration=");
//                            finData = strchr(debutData, ';');
//                            espace = strchr(debutData, ' ');
//                            if (espace != NULL && espace < debutData)
//                            {
//                                debutData = espace;
//                            }
//                            char tmp[20] = { 0 };
//                            strncpy(tmp, debutData, finData - debutData);
//                            int recording_Duration = atoi(tmp);
//#if !debugMode
//                            if (recording_Duration > 0)
//                                supervisorState.recordParameters.recordingDuration =
//                                        recording_Duration;
//#endif
//                        }
//                        else
//                        {
//#if !debugMode
//                            supervisorState.recordParameters.recordingDuration =
//                                    DEFAULT_RECORDING_DURATION;
//#endif
//                            //                        char buff[250]={0};
//                            //                        sprintf(buff,"#Error while reading recordingTime parameter.\nSetting parameter to default:%d \n",DEFAULT_RECORD_TIME);
//                            //                        USTV_LogSysError(buff, strlen(buff));
//                        }
//                    }
//                        break;
//                    case SHUTDOWN_DURATION_IDX:
//                    {
//                        match = strstr(stringBuffer, "Shutdown_Duration=");
//                        if (match != NULL)
//                        {
//                            debutData = match + strlen("Shutdown_Duration=");
//                            finData = strchr(debutData, ';');
//                            espace = strchr(debutData, ' ');
//                            if (espace != NULL && espace < debutData)
//                            {
//                                debutData = espace;
//                            }
//                            char tmp[20] = { 0 };
//                            strncpy(tmp, debutData, finData - debutData);
//                            int Shutdown_Duration = atoi(tmp);
//
//#if !debugMode
//                            if (Shutdown_Duration > 0)
//                                supervisorState.recordParameters.shutdownDuration =
//                                        Shutdown_Duration;
//                            else
//                                supervisorState.recordParameters.shutdownDuration =
//                                        DEFAULT_SHUTDOWN_DURATION;
//#endif
//                        }
//                        else
//                        {
//#if !debugMode
//                            supervisorState.recordParameters.shutdownDuration =
//                                    DEFAULT_SHUTDOWN_DURATION;
//#endif
//                            //                        char buff[250]={0};
//                            //                        sprintf(buff,"#Error while reading recordingInterval parameter.\nSetting parameter to default:%d \n",DEFAULT_INTERVAL);
//                            //                        USTV_LogSysError(buff, strlen(buff));
//                        }
//                    }
//                        break;
//                    case USTV_CHANNEL_COUNT_IDX:
//                    {
//                        match = strstr(stringBuffer, "Channel_Count=");
//                        if (match != NULL)
//                        {
//                            debutData = match + strlen("Channel_Count=");
//                            finData = strchr(debutData, ';');
//                            espace = strchr(debutData, ' ');
//                            if (espace != NULL && espace < debutData)
//                            {
//                                debutData = espace;
//                            }
//                            char tmp[20] = { 0 };
//                            strncpy(tmp, debutData, finData - debutData);
//                            int channel_count = atoi(tmp);
//
//                            if (channel_count != 0)
//                                supervisorState.recordParameters.nbChannelsUsed =
//                                        channel_count;
//                            else
//                                supervisorState.recordParameters.nbChannelsUsed =
//                                        DEFAULT_CHANNEL_COUNT;
//                        }
//                        else
//                        {
//                            supervisorState.recordParameters.nbChannelsUsed =
//                                    DEFAULT_CHANNEL_COUNT;
//                            //                        char buff[250]={0};
//                            //                        sprintf(buff,"#Error while reading recordingInterval parameter.\nSetting parameter to default:%d \n",DEFAULT_INTERVAL);
//                            //                        USTV_LogSysError(buff, strlen(buff));
//                        }
//                    }
//                        break;
//                    case USTV_PREPARING_DURATION_PIC32_IDX:
//                    {
//                        match = strstr(stringBuffer, "Preparing_Duration=");
//                        if (match != NULL)
//                        {
//                            debutData = match + strlen("Preparing_Duration=");
//                            finData = strchr(debutData, ';');
//                            espace = strchr(debutData, ' ');
//                            if (espace != NULL && espace < debutData)
//                            {
//                                debutData = espace;
//                            }
//                            char tmp[20] = { 0 };
//                            strncpy(tmp, debutData, finData - debutData);
//                            int Preparing_Duration = atoi(tmp);
//
//#if !debugMode
//                            if (Preparing_Duration
//                                    >= DEFAULT_PREPARING_DURATION)
//                                supervisorState.recordParameters.preparingDuration =
//                                        Preparing_Duration;
//                            else
//                                supervisorState.recordParameters.preparingDuration =
//                                        DEFAULT_PREPARING_DURATION;
//#endif
//                        }
//                        else
//                        {
//#if !debugMode
//                            supervisorState.recordParameters.preparingDuration =
//                                    DEFAULT_PREPARING_DURATION;
//#endif
//                            //                        char buff[250]={0};
//                            //                        sprintf(buff,"#Error while reading recordingInterval parameter.\nSetting parameter to default:%d \n",DEFAULT_INTERVAL);
//                            //                        USTV_LogSysError(buff, strlen(buff));
//                        }
//                    }
//                        break;
//                    case USTV_STOPPING_DURATION_PIC32_IDX:
//                    {
//                        match = strstr(stringBuffer, "Stopping_Duration=");
//                        if (match != NULL)
//                        {
//                            debutData = match + strlen("Stopping_Duration=");
//                            finData = strchr(debutData, ';');
//                            espace = strchr(debutData, ' ');
//                            if (espace != NULL && espace < debutData)
//                            {
//                                debutData = espace;
//                            }
//                            char tmp[20] = { 0 };
//                            strncpy(tmp, debutData, finData - debutData);
//                            int Stopping_Duration = atoi(tmp);
//
//#if !debugMode
//                            if (Stopping_Duration
//                                    >= DEFAULT_STOPPING_DURATION)
//                                supervisorState.recordParameters.stoppingDuration =
//                                        Stopping_Duration;
//                            else
//                                supervisorState.recordParameters.stoppingDuration =
//                                        DEFAULT_STOPPING_DURATION;
//#endif
//                        }
//                        else
//                        {
//#if !debugMode
//                            supervisorState.recordParameters.stoppingDuration =
//                                    DEFAULT_STOPPING_DURATION;
//#endif
//                            //                        char buff[250]={0};
//                            //                        sprintf(buff,"#Error while reading recordingInterval parameter.\nSetting parameter to default:%d \n",DEFAULT_INTERVAL);
//                            //                        USTV_LogSysError(buff, strlen(buff));
//                        }
//                    }
//                        break;
//                    default:        //On a une erreur si on passe par ici
//                        break;
//                    }
//                }
//#endif
//            }
//            else
//            {
//                f_close(&src);
//                // Release SPI0!
//                SDFatFS_close(sdfatfsHandle);
//                return false;
//            }
//
//            f_close(&src);
//            GPIO_write(SPI_SS_EXT1, CONFIG_GPIO_LED_OFF);
//        }
//        else
//        {
////           GPIO_write(LED_Bleue, CONFIG_GPIO_LED_ON);
////           GPIO_write(LED_Blanche, CONFIG_GPIO_LED_OFF);
////           /* SD_open() failed */
////           while (1);
//            //fclose(src);
//            // Release SPI0!
//            SDFatFS_close(sdfatfsHandle);
//            return false;
//        }
//
//        // Release SPI0!
//        SDFatFS_close(sdfatfsHandle);
//    }
//    else
//    {
//        return false;
//    }
//
//    return true;
//}


bool USTV_LoadClockConfigurationFile(void)
{
    char* match=0;
    char* debutData=0;
    char* finData=0;
    char* espace=0;
    //char ConfigurationClockFile[] = "fat:/Config/CLOCK.cfg";
    char ConfigurationClockFile[] = "fat:0:CLOCK.cfg";
    SDFatFS_Handle sdfatfsHandle;
    FILE *src;
    sdfatfsHandle = SDFatFS_open(0, DRIVE_NUM);

    if (sdfatfsHandle != NULL) {
        src = fopen(ConfigurationClockFile, "r");//r Opens a file for reading. The file must exist.
        if(src != NULL){
            int fileSize=fsize(src);
            if(fileSize < 1500){
                unsigned char stringBuffer[fileSize+1]; //+1 avec le char de fin de chaine
                fread(stringBuffer, 1, fileSize, src);

//    supervisorState.fileHandle=SYS_FS_HANDLE_INVALID;
//    supervisorState.fileHandle = SYS_FS_FileOpen("/mnt/myDrive1/CLOCK.CFG",(SYS_FS_FILE_OPEN_READ));
//    if(supervisorState.fileHandle == SYS_FS_HANDLE_INVALID)
//    {
//        /* Could not open the file. Error out*/
//        return false;
//    }
//    else
//    {
        //....................................................................//
//        SYS_FS_RESULT res;
//        fileSize=SYS_FS_FileSize(supervisorState.fileHandle);
        //char stringBuffer[fileSize+1]; //+1 avec le char de fin de chaine
//        stringBuffer[fileSize]=0;       //Ajout du charactere de fin de chaine
//        if(SYS_FS_FileRead(supervisorState.fileHandle,stringBuffer, fileSize ) == -1)
//        {
            /* There was an error while reading the file.
            * Close the file and error out. */
//            SYS_FS_FileClose(supervisorState.fileHandle);
//            return false;
//        }
//        else
//        {
            match=strstr(stringBuffer,"CLOCKTIME=");
            if(match!=NULL)
            {
                    debutData=match+strlen("CLOCKTIME=");
                    finData=strchr(debutData, ';');
                    espace=strchr(debutData, ' ');
                    espace=espace+1;
                    if(espace!=NULL && espace>debutData)
                    {
                        debutData=espace;
                    }

                    char dayStr[2];
                    strncpy(dayStr, debutData, 2);
                    debutData+=3;
                    int day=atoi(dayStr);
                    char monthStr[2];
                    strncpy(monthStr, debutData, 2);
                    debutData+=3;
                    int month=atoi(monthStr);
                    char yearStr[4];
                    strncpy(yearStr, debutData, 4);
                    debutData+=5;
                    volatile unsigned int year=atoi(yearStr);
                    if(year>=2000)
                        year-=2000;

                    char hourStr[2];
                    strncpy(hourStr, debutData, 2);
                    debutData+=3;
                    int hour=atoi(hourStr);
                    char minStr[2];
                    strncpy(minStr, debutData, 2);
                    debutData+=3;
                    int min=atoi(minStr);
                    char secStr[2];
                    strncpy(secStr, debutData, 2);
                    int sec=atoi(secStr);

                    //Save date to flash rtcc
                    FlashRtccDateTime.day = (unsigned char) day;
                    FlashRtccDateTime.hour = (unsigned char) hour;
                    FlashRtccDateTime.minute = (unsigned char) min;
                    FlashRtccDateTime.month = (unsigned char) month;
                    FlashRtccDateTime.second = (unsigned char) sec;
                    FlashRtccDateTime.year = (unsigned char) year;
                    FlashRtccDateTime.weekDay = (unsigned char) 1;

                    supervisorState.localTime.year=(unsigned char) year;
                    supervisorState.localTime.month=(unsigned char) month;
                    supervisorState.localTime.day=(unsigned char) day;
                    supervisorState.localTime.hour=(unsigned char) hour;
                    supervisorState.localTime.minute=(unsigned char) min;
                    supervisorState.localTime.second=(unsigned char) sec;
                }
                else
                {
                    fclose(src);
                    remove(ConfigurationClockFile);
                    SDFatFS_close(sdfatfsHandle);
                    return false;
                }
                fclose(src);
                remove(ConfigurationClockFile);
                SDFatFS_close(sdfatfsHandle);

            }
            else
            {
                fclose(src);
                remove(ConfigurationClockFile);
                SDFatFS_close(sdfatfsHandle);
                return false;
            }
        }
        else
        {
            SDFatFS_close(sdfatfsHandle);
            return false;
        }
        SDFatFS_close(sdfatfsHandle);
    }
    else
    {
        SDFatFS_close(sdfatfsHandle);
        return false;
    }


    return true;
}

void SD_FileCreate(void){

    //GPIO_write(CMD_ALIM_SD_CARD, CONFIG_GPIO_LED_ON);

     SDFatFS_Handle sdfatfsHandle;
     FILE *src;
     sdfatfsHandle = SDFatFS_open(0, DRIVE_NUM);

     uint8_t TailleDuNomDeFichier = SDTrameToProcess[0];

     char outputInitFileTest[20]={0};
     int cx;
     char NomDeFichier[TailleDuNomDeFichier+1];

     for(uint8_t i = 0; i < TailleDuNomDeFichier;i++){
         NomDeFichier[i] = 0;
     }
     for(uint8_t i = 0; i < TailleDuNomDeFichier;i++){
         NomDeFichier[i] = SDTrameToProcess[i+1];
     }

     NomDeFichier[TailleDuNomDeFichier] = 0;
//     char NomDeFichier[] = "testInit.txt";

     //extern uint8_t SDTrameToProcess[512];
     //extern uint16_t SDTrameToProcessSize;
     //char outputInitFileTest[] = "fat:0:testInit.txt";
     cx = snprintf(outputInitFileTest, 20, "fat:0:%s", NomDeFichier);


     if (sdfatfsHandle != NULL) {
         src = fopen(outputInitFileTest, "w");
         if(src != NULL){
             //char *str="SD Init OK...\nHippy Logger\n....\tSMIOT- UNIVERSITE DE TOULON\t....";
             //fwrite(str, 1, strlen(str), src);
             fwrite(SDTrameToProcess+TailleDuNomDeFichier+1, 1, SDTrameToProcessSize-(TailleDuNomDeFichier+1), src);
             fflush(src);
             fclose(src);
         }
//         else{
////             GPIO_write(LED_Bleue, CONFIG_GPIO_LED_ON);
//
//             /* SD_open() failed */
//             while (1);
//         }
     }
//     else{
//
////         GPIO_write(LED_Bleue, CONFIG_GPIO_LED_ON);
//
//         /* SD_open() failed */
//         while (1);
//     }
     // Release SPI0!
     SDFatFS_close(sdfatfsHandle);
     SDWriteFinished = true;
     //GPIO_write(CMD_ALIM_SD_CARD, CONFIG_GPIO_LED_OFF);
 }

void SD_FileAppend(void){
    SDFatFS_Handle sdfatfsHandle;
    FILE *src;
    sdfatfsHandle = SDFatFS_open(0, DRIVE_NUM);

    uint8_t TailleDuNomDeFichier = SDTrameToProcess[0];

    char outputInitFileTest[20]={0};
    int cx;
    char NomDeFichier[TailleDuNomDeFichier+1];

    for(uint8_t i = 0; i < TailleDuNomDeFichier;i++){
        NomDeFichier[i] = 0;
    }
    for(uint8_t i = 0; i < TailleDuNomDeFichier;i++){
        NomDeFichier[i] = SDTrameToProcess[i+1];
    }

    NomDeFichier[TailleDuNomDeFichier] = 0;
//     char NomDeFichier[] = "testInit.txt";

    //extern uint8_t SDTrameToProcess[512];
    //extern uint16_t SDTrameToProcessSize;
    //char outputInitFileTest[] = "fat:0:testInit.txt";
    cx = snprintf(outputInitFileTest, 20, "fat:0:%s", NomDeFichier);


    if (sdfatfsHandle != NULL) {
        src = fopen(outputInitFileTest, "a");
        if(src != NULL){
            //char *str="SD Init OK...\nHippy Logger\n....\tSMIOT- UNIVERSITE DE TOULON\t....";
            //fwrite(str, 1, strlen(str), src);
            fwrite(SDTrameToProcess+TailleDuNomDeFichier+1, 1, SDTrameToProcessSize-(TailleDuNomDeFichier+1), src);
            fflush(src);
            fclose(src);
        }
//        else{
////             GPIO_write(LED_Bleue, CONFIG_GPIO_LED_ON);
//
//            /* SD_open() failed */
//            while (1);
//        }
    }
//    else{
//
////         GPIO_write(LED_Bleue, CONFIG_GPIO_LED_ON);
//
//        /* SD_open() failed */
//        while (1);
//    }
    // Release SPI0!
    SDFatFS_close(sdfatfsHandle);
    SDWriteFinished = true;
 }

void SD_FileGetInfo(void){

    uint32_t res;

    SDFatFS_Handle sdfatfsHandle;
    FILE *src;
    sdfatfsHandle = SDFatFS_open(0, DRIVE_NUM);

    uint8_t TailleDuNomDeFichier = SDTrameToProcess[0];

    char outputInitFileTest[20]={0};
    int cx;
    char NomDeFichier[TailleDuNomDeFichier+1];

    for(uint8_t i = 0; i < TailleDuNomDeFichier;i++){
        NomDeFichier[i] = 0;
    }
    for(uint8_t i = 0; i < TailleDuNomDeFichier;i++){
        NomDeFichier[i] = SDTrameToProcess[i+1];
    }

    NomDeFichier[TailleDuNomDeFichier] = 0;
//     char NomDeFichier[] = "testInit.txt";

    //extern uint8_t SDTrameToProcess[512];
    //extern uint16_t SDTrameToProcessSize;
    //char outputInitFileTest[] = "fat:0:testInit.txt";
    cx = snprintf(outputInitFileTest, 20, "fat:0:%s", NomDeFichier);


    if (sdfatfsHandle != NULL) {
        src = fopen(outputInitFileTest, "r");
        if(src != NULL){

            fseek(src, 0L, SEEK_END);

            // calculating the size of the file
             res = ftell(src);
            fclose(src);
        }
//        else{
////             GPIO_write(LED_Bleue, CONFIG_GPIO_LED_ON);
//
//            /* SD_open() failed */
//            while (1);
//        }
    }
    // Release SPI0!
    SDFatFS_close(sdfatfsHandle);
    SDWriteFinished = true;

    uint16_t commandSDFileSize = FILE_SIZE_TO_BE_FORWARDED;

    uint8_t payloadSDFileSize[TailleDuNomDeFichier+4+1];
    payloadSDFileSize[0] = TailleDuNomDeFichier;
    for(uint8_t i=0;i<TailleDuNomDeFichier;i++){
        payloadSDFileSize[i+1] = NomDeFichier[i];
    }
    payloadSDFileSize[TailleDuNomDeFichier+1] = BREAK_UINT32(res,0);
    payloadSDFileSize[TailleDuNomDeFichier+2] = BREAK_UINT32(res,1);
    payloadSDFileSize[TailleDuNomDeFichier+3] = BREAK_UINT32(res,2);
    payloadSDFileSize[TailleDuNomDeFichier+4] = BREAK_UINT32(res,3);

    MakeAndSendMessageWithUTLNProtocol(commandSDFileSize,TailleDuNomDeFichier+4+1,payloadSDFileSize);

 }

void SD_FileDelete(void){

    SDFatFS_Handle sdfatfsHandle;
    FILE *src;
    sdfatfsHandle = SDFatFS_open(0, DRIVE_NUM);

    uint8_t TailleDuNomDeFichier = SDTrameToProcess[0];

    char outputInitFileTest[20]={0};
    int cx;
    char NomDeFichier[TailleDuNomDeFichier+1];

    for(uint8_t i = 0; i < TailleDuNomDeFichier;i++){
        NomDeFichier[i] = 0;
    }
    for(uint8_t i = 0; i < TailleDuNomDeFichier;i++){
        NomDeFichier[i] = SDTrameToProcess[i+1];
    }

    NomDeFichier[TailleDuNomDeFichier] = 0;

    cx = snprintf(outputInitFileTest, 20, "fat:0:%s", NomDeFichier);


    if (sdfatfsHandle != NULL) {
        int fileDeleted = remove(outputInitFileTest);
    }

    SDFatFS_close(sdfatfsHandle);
    SDWriteFinished = true;
 }

