/*
 * SD_Driver.h
 *
 *  Created on: 7 mai 2021
 *      Author: sebas
 */

#ifndef TASK_SD_SD_DRIVER_H_
#define TASK_SD_SD_DRIVER_H_


uint8_t Init_SD(void);
bool USTV_LoadConfigurationFile(void);
bool USTV_LoadClockConfigurationFile(void);
void SD_FileCreate(void);
void SD_FileAppend(void);
void SD_FileGetInfo(void);
void SD_FileDelete(void);

#define USTV_PARAMETER_COUNT                    15 //GIAS 12=QHB
#define BLUEEAR_MAX_RESOLUTION                  24
#define DEFAULT_RESOLUTION                      16
#define DEFAULT_FREQ                            48000
#define DEFAULT_FILTER_SEL                      0
#define USTV_DEFAULT_FILESIZE_LIMITATION        100000
#define DEFAULT_CHANNEL_COUNT                   2
#define DEFAULT_PREPARING_DURATION              1
#define DEFAULT_RECORDING_DURATION              1
#define DEFAULT_STOPPING_DURATION               1
#define DEFAULT_SHUTDOWN_DURATION               1
#define DEFAULT_CNN_DETECTION_TIMEOUT_DURATION  1
#define DEFAULT_GSM_DATA_SEND_TIMEOUT_DURATION  1
#define DEFAULT_NB_REMONTES_PAR_JOUR            1
#define DEFAULT_REMONTEE_TIMEOUT_DURATION       1

#define USTV_SAMPLING_RES_IDX                   0
#define USTV_SAMPLING_FREQ_IDX                  1
#define USTV_FILTERS_SEL_IDX                    2
#define USTV_USE_AUTO_START_IDX                 3
#define USTV_FS_FLIMIT_IDX                      4
#define USTV_RECORD_USE_TIM_INT_IDX             5
#define USTV_RECORD_TIME_IDX                    6
#define SHUTDOWN_DURATION_IDX                   7
#define USTV_CHANNEL_COUNT_IDX                  8
#define USTV_PREPARING_DURATION_PIC32_IDX       9
#define USTV_STOPPING_DURATION_PIC32_IDX        10
#define USTV_STORAGE_TARGET_IDX                 11
#define GIAS_CNN_DETECTION_TIMEOUT_DURATION_IDX 12
#define GIAS_GSM_DATA_SEND_TIMEOUT_DURATION_IDX 13
#define GIAS_NB_REMONTES_PAR_JOUR_IDX           14
#define GIAS_TIMEOUT_REMONTE_IDX                15

#endif /* TASK_SD_SD_DRIVER_H_ */
