/*
 * Task_SD.c
 *
 *  Created on: 7 mai 2021
 *      Author: sebas
 */

#include <string.h>
#include <math.h>
#include <stdbool.h>
#include <time.h>
#include <stdlib.h>
#include <stdint.h>
#include <stddef.h>
#include <file.h>
#include <stdio.h>

#include <ti/sysbios/knl/Task.h>
#include <ti/sysbios/knl/Clock.h>
#include <ti/sysbios/knl/Event.h>
#include <ti/sysbios/knl/Queue.h>
#include <ti/sysbios/knl/Semaphore.h>
#include <ti/sysbios/BIOS.h>
#include <ti/drivers/GPIO.h>

#include <ti/drivers/SDFatFS.h>
#include <ti/drivers/SD.h>

#include <third_party/fatfs/ff.h>
#include <third_party/fatfs/diskio.h>
#include <third_party/fatfs/ffcio.h>
#include <ti/drivers/SPI.h>

#include <Macros/Define.h>

#include <Task_SD/Task_SD.h>
#include <Task_SD/SD_Driver.h>

#include "ti_drivers_config.h"

// Task configuration
#define SD_TASK_PRIORITY                     2

#ifndef SD_TASK_STACK_SIZE
#define SD_TASK_STACK_SIZE                   4096
//#define SD_TASK_STACK_SIZE                   5120
#endif

// Task configuration
Task_Struct SDTask;

Semaphore_Struct semTaskSDStruct;
Semaphore_Handle semTaskSDHandle;

uint8_t SDTaskStack[SD_TASK_STACK_SIZE];

StateTaskSD stateTaskSD = SD_CARD_NOT_DETECTED;

bool SdFileSystemInitDone = false;
bool SdCardParametersRead = false;
bool CLOCKFILEREAD = false;
bool SdCard_FILE_CREATE_Requested = false;
bool SdCard_FILE_APPEND_Requested = false;
bool SdCard_FILE_GET_INFO_Requested = false;
bool SdCard_FILE_DELETE_Requested = false;

uint8_t SDTrameToProcess[512];
uint16_t SDTrameToProcessSize;

void SD_CreateTask(void)
{

    Task_Params taskParams;
    Semaphore_Params semParams;

    // Configure task
    Task_Params_init(&taskParams);
    taskParams.stack = SDTaskStack;
    taskParams.stackSize = SD_TASK_STACK_SIZE;
    taskParams.priority = SD_TASK_PRIORITY;

    Task_construct(&SDTask, SD_taskFxn, &taskParams, NULL);

    /* Construct a Semaphore object to be used as a resource lock, inital count 0 */
    Semaphore_Params_init(&semParams);
    Semaphore_construct(&semTaskSDStruct, 0, &semParams);

    /* Obtain instance handle */
    semTaskSDHandle = Semaphore_handle(&semTaskSDStruct);
}

static void SD_taskFxn(UArg a0, UArg a1)
{
    Init_SD();

//    GPIO_write(CMD_ALIM_SD_CARD, CONFIG_GPIO_LED_ON); //On alimente la SD
//
//    Task_sleep(5 * (1000 / Clock_tickPeriod)); //On attends 5ms
//
//    SD_FileCreate();

    Semaphore_post(semTaskSDHandle);

    // Application main loop
    while (1)
    {
            Semaphore_pend(semTaskSDHandle,
                           //25 * (1000 / Clock_tickPeriod));
                           BIOS_WAIT_FOREVER); //Attente d'une demande de lecture du superviseur

            GPIO_write(CMD_ALIM_SD_CARD, CONFIG_GPIO_LED_ON); //On alimente la SD

            Task_sleep(5 * (1000 / Clock_tickPeriod)); //On attends 5ms
            uint_fast8_t SDDetected = GPIO_read(SD_CARD_DETECT); //On teste que la carte est bien dtecte
            if (SDDetected)
            {
                if (SdCard_FILE_CREATE_Requested)
                {
                    SdCard_FILE_CREATE_Requested = false;
                    SD_FileCreate();
                }
                else if (SdCard_FILE_APPEND_Requested)
                {
                    SdCard_FILE_APPEND_Requested = false;
                    SD_FileAppend();
                }
                else if (SdCard_FILE_GET_INFO_Requested)
                {
                    SdCard_FILE_GET_INFO_Requested = false;
                    SD_FileGetInfo();
                }
                else if (SdCard_FILE_DELETE_Requested)
                {
                    SdCard_FILE_DELETE_Requested = false;
                    SD_FileDelete();
                }

                else if(!SdCardParametersRead){
                    CLOCKFILEREAD = USTV_LoadClockConfigurationFile();
                    USTV_LoadConfigurationFile();//On rcupre les paramtres
                    //if(USTV_LoadConfigurationFile()) //ON rcupre les paramtres
                    //    stateTaskSD = SD_CARD_DETECTED;
                    //else
                    //    stateTaskSD = SD_CARD_NOT_DETECTED;
                    SdCardParametersRead = true;
                    stateTaskSD = SD_CARD_DETECTED;
                    SdFileSystemInitDone = true;
                }

            }
            else
            {
                SdCardParametersRead = false;
                stateTaskSD = SD_CARD_NOT_DETECTED;
                SdFileSystemInitDone = true;
                Task_sleep(3000 * (1000 / Clock_tickPeriod)); //On attends 3s
                //if(!SdFileSystemInitDone)
                Semaphore_post(semTaskSDHandle);
            }
            GPIO_write(CMD_ALIM_SD_CARD, CONFIG_GPIO_LED_OFF); //On coupe l'alim de la SD
    }
}

void RequestSdOperation(void){
    Semaphore_post(semTaskSDHandle);
}

void CopyTrameSD(uint16_t length, uint8_t payload[]){

    SDTrameToProcessSize = length;
    for(uint16_t i = 0; i < length; i++){
        SDTrameToProcess[i] = payload[i];
    }
}
