/* ************************************************************************** */
/** Descriptive File Name

  @Company
    Company Name

  @File Name
    filename.c

  @Summary
    Brief description of the file.

  @Description
    Describe the purpose of this file.
 */
/* ************************************************************************** */

/* ************************************************************************** */
/* ************************************************************************** */
/* Section: Included Files                                                    */
/* ************************************************************************** */
/* ************************************************************************** */
#include "UTLN_MCP79522_REG.h"
#include "UTLN_MCP79522.h"
#include "ti_drivers_config.h"
#include <ti/drivers/GPIO.h>
MCP79522USER_SPI_Func spiFuncMCP79522;
//SPI Related Functions
void MCP79522RegisterUserSPIFunc(MCP79522USER_SPI_Func func)
{
    if(func != NULL)
        spiFuncMCP79522 = func;
}
void MCP79522SPIWriteSingleMultipleRead(unsigned char command, unsigned char results[], int nbRead, unsigned char csID)
{
    unsigned char comm[1];
    comm[0]=command;
    if(spiFuncMCP79522!=NULL)
        (*spiFuncMCP79522)(comm,1,results,nbRead, csID);
}
void MCP79522SPIWriteMultipleMultipleRead(unsigned char command[],int nbWrite, unsigned char results[], int nbRead, unsigned char csID)
{
    if(spiFuncMCP79522!=NULL)
        (*spiFuncMCP79522)(command,nbWrite,results,nbRead,csID);
}




//MCP79522 Functions
void MCP79522WriteRTCCRegister(unsigned char regAddress,unsigned char value, unsigned char csID)
{
    unsigned char comm[3],result[1];
    comm[0]=WRITE;              //OP-Code Write
    comm[1]=regAddress;
    comm[2]=value;
    MCP79522SPIWriteMultipleMultipleRead(comm,3,result,0, csID);
}

void MCP79522WriteMultipleRTCCRegister(unsigned char regAddress,unsigned char value[],unsigned char writeCount, unsigned char csID)
{
    unsigned char comm[2+writeCount],result[1],i;
    comm[0]=WRITE;              //OP-Code Write
    comm[1]=regAddress;
    for(i=0;i<writeCount;i++)
        comm[2+i]=value[i];
    MCP79522SPIWriteMultipleMultipleRead(comm,2+writeCount,result,0, csID);
}

unsigned char MCP79522ReadRTCCRegister(unsigned char regAddress, unsigned char csID)
{
    unsigned char comm[3],result[1];
    comm[0]=READ;
    comm[1]=regAddress;
    MCP79522SPIWriteMultipleMultipleRead(comm,2,result,1, csID);
    return result[0];
}

void MCP79522ReadMultipleRTCCRegister(unsigned char regAddress,unsigned char readVal[],unsigned char readCount, unsigned char csID)
{
    unsigned char comm[2];
    comm[0]=READ;
    comm[1]=regAddress;
    MCP79522SPIWriteMultipleMultipleRead(comm,2,readVal,readCount, csID);
}


void MCP79522ClearSRAM(unsigned char csID)
{
    unsigned char comm[2],result[1];
    comm[0]=CLRRAM;              //OP-Code Write
    comm[1]=0;
    MCP79522SPIWriteMultipleMultipleRead(comm,2,result,0, csID);
}

void MCP79522WriteStatus(unsigned char status, unsigned char csID)
{
    unsigned char comm[2],result[1];
    comm[0]=SRWRITE;              //OP-Code Write
    comm[1]=status;
    MCP79522SPIWriteMultipleMultipleRead(comm,2,result,0, csID);
}

unsigned char MCP79522ReadStatus( unsigned char csID)
{
    unsigned char comm[1],result[1];
    comm[0]=SRREAD;
    MCP79522SPIWriteMultipleMultipleRead(comm,1,result,1, csID);
    return result[0];
}

//EEPROM WRITE Enable/Disable Sequence
void MCP79522EEPROMWriteEnable(unsigned char csID)
{
    unsigned char comm[2],result[1];
    comm[0]=EEWREN;              //OP-Code Write Enable
    MCP79522SPIWriteMultipleMultipleRead(comm,1,result,0, csID);
}

void MCP79522EEPROMWriteDisable(unsigned char csID)
{
    unsigned char comm[2],result[1];
    comm[0]=EEWRDI;              //OP-Code Write Disable
    MCP79522SPIWriteMultipleMultipleRead(comm,1,result,0, csID);
}

//EEPROM Write/Read Sequence
void MCP79522EEPROMWrite(unsigned char addressByte,unsigned char data[], unsigned char dataCount,unsigned char csID)
{
    unsigned char comm[2+dataCount],result[1],i;
    comm[0]=EEWRITE;              //OP-Code Write
    comm[1]=addressByte;
    for(i=0;i<dataCount;i++)
        comm[2+i]=data[i];
    MCP79522SPIWriteMultipleMultipleRead(comm,2+dataCount,result,0, csID);
}

void MCP79522EEPROMRead(unsigned char addressByte,unsigned char dataRead[], unsigned char dataReadCount,unsigned char csID)
{
    unsigned char comm[2];
    comm[0]=EEREAD;              //OP-Code Read
    comm[1]=addressByte;
    MCP79522SPIWriteMultipleMultipleRead(comm,2,dataRead,dataReadCount, csID);
}

//Protected EEPROM WRITE/READ Sequences
void MCP79522ProtectedEEPROMWrite(unsigned char addressByte,unsigned char data[], unsigned char dataCount,unsigned char csID)
{
    unsigned char comm[2+dataCount],result[1],i;
    //Unlock step 1
    comm[0]=UNLOCK;              //OP-Code Write
    comm[1]=0x55;
    MCP79522SPIWriteMultipleMultipleRead(comm,2,result,0, csID);
    //Unlock step 2
    comm[0]=UNLOCK;
    comm[1]=0xAA;
    MCP79522SPIWriteMultipleMultipleRead(comm,2,result,0, csID);
    //IDWrite
    comm[0]=IDWRITE;
    comm[1]=addressByte&0x0F;
    for(i=0;i<dataCount;i++)
        comm[2+i]=data[i];
    MCP79522SPIWriteMultipleMultipleRead(comm,2+dataCount,result,0, csID);
}

void MCP79522ProtectedEEPROMRead(unsigned char addressByte,unsigned char dataRead[], unsigned char dataReadCount,unsigned char csID)
{
    unsigned char comm[2];
    comm[0]=IDREAD;              //OP-Code ID Read
    comm[1]=addressByte&0x0F;
    MCP79522SPIWriteMultipleMultipleRead(comm,2,dataRead,dataReadCount, csID);
}

//USER Function (High Level)

void MCP79522Init(unsigned char csID)
{
    RTCsecBits rtcsec;
    RTCwkdayBits rtcWkday;
    RTChourBits rtcHour;
    rtcHour.ALL=0;
    rtcWkday.ALL=0;
    rtcsec.ALL=0;
    CONTROLbits ctrl;
    ctrl.ALL=MCP79522ReadRTCCRegister(MCP79522_CONTROL_reg,csID);
    ctrl.CRSTRIM=0;
    ctrl.SQWEN=0;
    ctrl.SQWFS=0;
    ctrl.ALM0EN=0;              //Disable Alarm 0
    ctrl.ALM1EN=0;              //Disable Alarm 1
    MCP79522WriteRTCCRegister(MCP79522_CONTROL_reg,ctrl.ALL, csID);
    MCP79522ClearAlarmFlag(0,csID);     //Clear Alarm 0 Flag
    MCP79522ClearAlarmFlag(1,csID);     //Clear Alarm 1 Flag
//    ctrl.EXTOSC=1;
    rtcHour.ALL=MCP79522ReadRTCCRegister(MCP79522_RTCHOUR_reg,csID);
    rtcHour.f12_24=0;
    rtcWkday.ALL=MCP79522ReadRTCCRegister(MCP79522_RTCWKDAY_reg,csID);
    rtcWkday.VBATEN=1;                                                          //Enable Vbat backup
    if(rtcWkday.WKDAY==0)
        rtcWkday.WKDAY=1;
    rtcsec.ALL=MCP79522ReadRTCCRegister(MCP79522_RTCSEC_reg,csID);
    rtcsec.ST=1;                                                                //Oscillator enabled
    MCP79522WriteRTCCRegister(MCP79522_RTCHOUR_reg,rtcHour.ALL, csID);
    MCP79522WriteRTCCRegister(MCP79522_RTCSEC_reg,rtcsec.ALL, csID);
    MCP79522WriteRTCCRegister(MCP79522_RTCWKDAY_reg,rtcWkday.ALL, csID);
    
}
void MCP79522ReadID( unsigned char ID64[], unsigned char csID)
{
    MCP79522ProtectedEEPROMRead(0,ID64, 8,csID);
}


/* Function to read the time and date registers*/
void MCP79522RtccRead(RtccDateTimeBCD * rtBCD, unsigned char csID)
{
    RTCsecBits rtcsec;
    RTCminBits rtcMin;
    RTChourBits rtcHour;
    RTCwkdayBits rtcWkday;
    RTCdateBits rtcDate;
    RTCmthBits rtcMonth;
    RTCyearBits rtcYear;
    unsigned char readBuffer[7];
    
    //Read all RTCC Reg in one sequence to avoid rollover
    MCP79522ReadMultipleRTCCRegister(MCP79522_RTCSEC_reg,readBuffer,7,csID);

    rtcsec.ALL=readBuffer[0];
    rtcMin.ALL=readBuffer[1];
    rtcHour.ALL=readBuffer[2];
    rtcWkday.ALL=readBuffer[3];
    rtcDate.ALL = readBuffer[4];
    rtcMonth.ALL= readBuffer[5];
    rtcYear.ALL= readBuffer[6];
    
    
//    rtcYear.ALL=MCP79522ReadRTCCRegister(MCP79522_RTCYEAR_reg,csID);
//    rtcMonth.ALL=MCP79522ReadRTCCRegister(MCP79522_RTCMTH_reg,csID);
//    rtcDate.ALL=MCP79522ReadRTCCRegister(MCP79522_RTCDATE_reg,csID);
//    rtcWkday.ALL=MCP79522ReadRTCCRegister(MCP79522_RTCWKDAY_reg,csID);
//    rtcHour.ALL=MCP79522ReadRTCCRegister(MCP79522_RTCHOUR_reg,csID);
//    rtcMin.ALL=MCP79522ReadRTCCRegister(MCP79522_RTCMIN_reg,csID);
//    rtcsec.ALL=MCP79522ReadRTCCRegister(MCP79522_RTCSEC_reg,csID);
    
    
	rtBCD->yearTen = rtcYear.YRTEN;	
	rtBCD->yearUnit = rtcYear.YRONE;
	
	rtBCD->monthTen = rtcMonth.MTHTEN;	
	rtBCD->monthUnit = rtcMonth.MTHONE;
	rtBCD->dayTen = rtcDate.DATETEN;	
	rtBCD->dayUnit = rtcDate.DATEONE;

	rtBCD->weekDay = rtcWkday.WKDAY;
	rtBCD->hourTen = rtcHour.HRTEN;	
	rtBCD->hourUnit = rtcHour.HRONE;
	
	rtBCD->minuteTen = rtcMin.MINTEN;	
	rtBCD->minuteUnit = rtcMin.MINONE;
	rtBCD->secondTen = rtcsec.SECTEN;	
	rtBCD->secondUnit = rtcsec.SECONE;

}

void ConvertDateToBCD(const RtccDateTime * rt, RtccDateTimeBCD * rtBCD)
{	
	rtBCD->yearTen = (rt->year)/10;	
	rtBCD->yearUnit = rt->year - (rtBCD->yearTen*10);
	
	rtBCD->monthTen = rt->month/10;	
	rtBCD->monthUnit = rt->month - rtBCD->monthTen*10;
	
	rtBCD->dayTen = rt->day/10;	
	rtBCD->dayUnit = rt->day - rtBCD->dayTen*10;
	
	rtBCD->hourTen = rt->hour/10;	
	rtBCD->hourUnit = rt->hour - rtBCD->hourTen*10;
	
	rtBCD->minuteTen = rt->minute/10;	
	rtBCD->minuteUnit = rt->minute - rtBCD->minuteTen*10;
	
	rtBCD->secondTen = rt->second/10;	
	rtBCD->secondUnit = rt->second - rtBCD->secondTen*10;
	
	rtBCD->weekDay = MIN(rt->weekDay,6);	
}

void ConvertDateFromBCD( RtccDateTimeBCD * rtBCD, RtccDateTime * rt)
{
	rt->year = rtBCD->yearTen*10 + rtBCD->yearUnit;
	rt->month = rtBCD->monthTen*10 + rtBCD->monthUnit;
	rt->day = rtBCD->dayTen*10 + rtBCD->dayUnit;
	rt->hour = rtBCD->hourTen*10 + rtBCD->hourUnit;
	rt->minute = rtBCD->minuteTen*10 + rtBCD->minuteUnit;
	rt->second = rtBCD->secondTen*10 + rtBCD->secondUnit;
	rt->weekDay = rtBCD->weekDay;
}
void MCP79522TimeGet(RtccDateTime * value, unsigned char csID)
{
    RtccDateTimeBCD rtBCD;

    MCP79522RtccRead(&rtBCD,csID);
    ConvertDateFromBCD(&rtBCD, value);
}

void MCP79522RtccSetClock(const RtccDateTimeBCD * dtBCD, unsigned char csID)
{
    
    RTCsecBits rtcsec;
    RTCminBits rtcMin;
    RTChourBits rtcHour;
    RTCwkdayBits rtcWkday;
    RTCdateBits rtcDate;
    RTCmthBits rtcMonth;
    RTCyearBits rtcYear;
    unsigned char readBuffer[7];
    
    //Read all RTCC Reg in one sequence to avoid rollover
    MCP79522ReadMultipleRTCCRegister(MCP79522_RTCSEC_reg,readBuffer,7,csID);
    rtcsec.ALL=readBuffer[0];       //Read Back because contain ST bit
    rtcMin.ALL=readBuffer[1];
    rtcHour.ALL=readBuffer[2];      //Read Back because contain TRIMSIGN, and 12/24 bit
    rtcWkday.ALL=readBuffer[3];     //Read Back because contain OSCRUN, VBATEN, PWRFAIL bits
    rtcDate.ALL = readBuffer[4];
    rtcMonth.ALL= readBuffer[5];    //Read Back because contain LPYR bit
    rtcYear.ALL= readBuffer[6];
    
//    RTCsecBits rtcsec;
//    rtcsec.ALL=MCP79522ReadRTCCRegister(MCP79522_RTCSEC_reg,csID);      //Read Back because contain ST bit
//    RTCminBits rtcMin;
//    RTChourBits rtcHour;
//    rtcHour.ALL=MCP79522ReadRTCCRegister(MCP79522_RTCHOUR_reg,csID);    //Read Back because contain TRIMSIGN, and 12/24 bit
//    RTCwkdayBits rtcWkday;
//    rtcWkday.ALL=MCP79522ReadRTCCRegister(MCP79522_RTCWKDAY_reg,csID);    //Read Back because contain OSCRUN, VBATEN, PWRFAIL bits
//    RTCdateBits rtcDate;
//    RTCmthBits rtcMonth;
//    rtcMonth.ALL=MCP79522ReadRTCCRegister(MCP79522_RTCWKDAY_reg,csID);    //Read Back because contain LPYR bit
//    RTCyearBits rtcYear;
    
    //Modify ONLY Time relative values
    rtcYear.YRTEN=dtBCD->yearTen;
    rtcYear.YRONE=dtBCD->yearUnit;
    rtcMonth.MTHTEN=dtBCD->monthTen;
    rtcMonth.MTHONE=dtBCD->monthUnit; 
    rtcWkday.WKDAY=dtBCD->weekDay;
    rtcDate.DATETEN=dtBCD->dayTen;
    rtcDate.DATEONE=dtBCD->dayUnit;
    rtcsec.SECONE=dtBCD->secondUnit;
    rtcsec.SECTEN=dtBCD->secondTen;
	rtcMin.MINTEN=dtBCD->minuteTen;
	rtcMin.MINONE=dtBCD->minuteUnit;
    rtcHour.HRONE=dtBCD->hourUnit;
    rtcHour.HRTEN=dtBCD->hourTen;
    
    unsigned char valueToSend[7];
    valueToSend[0]=rtcsec.ALL;
    valueToSend[1]=rtcMin.ALL;
    valueToSend[2]=rtcHour.ALL;
    valueToSend[3]=rtcWkday.ALL;
    valueToSend[4]=rtcDate.ALL;
    valueToSend[5]=rtcMonth.ALL;
    valueToSend[6]=rtcYear.ALL;
    MCP79522WriteMultipleRTCCRegister(MCP79522_RTCSEC_reg,valueToSend,7,csID);
}		

void MCP79522RtccSetAlarm(const RtccDateTimeBCD * dtBCD,unsigned char almNum, unsigned char mask, unsigned char csID)
{	
    RTCsecBits almSec;
    RTCminBits almMin;
    RTChourBits almHour;
    ALMwkdayBits almWkday;
    RTCdateBits almDate;
    RTCmthBits almMonth;
    
	almMonth.MTHTEN=dtBCD->monthTen;
    almMonth.MTHONE=dtBCD->monthUnit;
    almDate.DATETEN=dtBCD->dayTen;
    almDate.DATEONE=dtBCD->dayUnit;
	almWkday.WKDAY=dtBCD->weekDay;
    almWkday.ALMxMSK=mask;
    almWkday.ALMxIF=0;
    almHour.HRTEN=dtBCD->hourTen;
    almHour.HRONE=dtBCD->hourUnit;	
	almMin.MINTEN=dtBCD->minuteTen;
    almMin.MINONE=dtBCD->minuteUnit;
    almSec.SECTEN=dtBCD->secondTen;
    almSec.SECONE=dtBCD->secondUnit;	//load minute second
    unsigned char valuesToSend[6];
    valuesToSend[0]=almSec.ALL;
    valuesToSend[1]=almMin.ALL;
    valuesToSend[2]=almHour.ALL;
    valuesToSend[3]=almWkday.ALL;
    valuesToSend[4]=almDate.ALL;
    valuesToSend[5]=almMonth.ALL;
    if(almNum)
    {
        MCP79522WriteMultipleRTCCRegister(MCP79522_ALM1SEC_reg,valuesToSend,6,csID);
    }
    else
    {
        MCP79522WriteMultipleRTCCRegister(MCP79522_ALM0SEC_reg,valuesToSend,6,csID);
    }
}

void MCP79522RtccReadAlarm(RtccDateTime * rt,unsigned char almNum,unsigned char csID)
{
    RtccDateTimeBCD * rtBCD;
            
            
    RTCsecBits rtcsec;
    RTCminBits rtcMin;
    RTChourBits rtcHour;
    ALMwkdayBits almWkday;
    RTCdateBits rtcDate;
    RTCmthBits rtcMonth;
    unsigned char readBuffer[6];
    
    //Read all RTCC Reg in one sequence to avoid rollover
    if(almNum)
    {
        MCP79522ReadMultipleRTCCRegister(MCP79522_ALM1SEC_reg,readBuffer,6,csID);
    }
    else
    {
        MCP79522ReadMultipleRTCCRegister(MCP79522_ALM0SEC_reg,readBuffer,6,csID);
    }
    rtcsec.ALL=readBuffer[0];
    rtcMin.ALL=readBuffer[1];
    rtcHour.ALL=readBuffer[2];
    almWkday.ALL=readBuffer[3];
    rtcDate.ALL = readBuffer[4];
    rtcMonth.ALL= readBuffer[5];
    
	rtBCD->monthTen = rtcMonth.MTHTEN;	
	rtBCD->monthUnit = rtcMonth.MTHONE;
	rtBCD->dayTen = rtcDate.DATETEN;	
	rtBCD->dayUnit = rtcDate.DATEONE;

	rtBCD->weekDay = almWkday.WKDAY;
	rtBCD->hourTen = rtcHour.HRTEN;	
	rtBCD->hourUnit = rtcHour.HRONE;
	
	rtBCD->minuteTen = rtcMin.MINTEN;	
	rtBCD->minuteUnit = rtcMin.MINONE;
	rtBCD->secondTen = rtcsec.SECTEN;	
	rtBCD->secondUnit = rtcsec.SECONE;	
	ConvertDateFromBCD(rtBCD, rt);
}

void MCP79522EnableAlarm(unsigned char almNum, unsigned char csID)
{
    CONTROLbits ctrl;
    ctrl.ALL=MCP79522ReadRTCCRegister(MCP79522_CONTROL_reg,csID);
    if(almNum)
    {
        ctrl.ALM1EN=1;
    }
    else
    {
        ctrl.ALM0EN=1;
    }
    MCP79522WriteRTCCRegister(MCP79522_CONTROL_reg,ctrl.ALL, csID);
}

void MCP79522DisableAlarm(unsigned char almNum, unsigned char csID)
{
    CONTROLbits ctrl;
    ctrl.ALL=MCP79522ReadRTCCRegister(MCP79522_CONTROL_reg,csID);
    if(almNum)
    {
        ctrl.ALM1EN=0;
    }
    else
    {
        ctrl.ALM0EN=0;
    }
    MCP79522WriteRTCCRegister(MCP79522_CONTROL_reg,ctrl.ALL, csID);
}

void MCP79522ClearAlarmFlag(unsigned char almNum, unsigned char csID)
{
    ALMwkdayBits almWkday;
    
    if(almNum)
    {
        almWkday.ALL=MCP79522ReadRTCCRegister(MCP79522_ALM1WKDAY_reg,csID);
        almWkday.ALMxIF=0;
        MCP79522WriteRTCCRegister(MCP79522_ALM1WKDAY_reg,almWkday.ALL, csID);
    }
    else
    {
        almWkday.ALL=MCP79522ReadRTCCRegister(MCP79522_ALM0WKDAY_reg,csID);
        almWkday.ALMxIF=0;
        MCP79522WriteRTCCRegister(MCP79522_ALM0WKDAY_reg,almWkday.ALL, csID);
    }
    
}

RtccDateTime MCP79522DateAddInterval(RtccDateTime * dateTime , uint32_t interval)
{
    RtccDateTime date;
    //On Calcule une date depuis l'interval
    int day=0,month=0,year=0;
    int hour=interval/3600;
    int min=(interval -(3600*hour)) /60;
    int sec=(interval -(3600*hour) - (60*min));
    
    if(dateTime->second+sec>59)
        min++;
    date.second=(dateTime->second+sec)%60;

    if(dateTime->minute+min>59)
        hour++;
    date.minute=(dateTime->minute+min)%60;

    if(dateTime->hour+hour>23)
    {
        day++;
    }
    date.hour=(dateTime->hour+hour)%24;
    
    int nbDayInMonth=31;
    int currentYear=dateTime->year + 2000;
    switch(dateTime->month)
    {
        case 1: nbDayInMonth=31; break;
        case 2: if( (currentYear%4) == 0 && ( (currentYear % 100) !=0 || (currentYear % 400)==0) )
                    nbDayInMonth=29;        // Leap year
                else
                    nbDayInMonth=28;        // Not Leap year
        case 3: nbDayInMonth=31; break;
        case 4: nbDayInMonth=30; break;
        case 5: nbDayInMonth=31; break;
        case 6: nbDayInMonth=30; break;
        case 7: nbDayInMonth=31; break;
        case 8: nbDayInMonth=31; break;
        case 9: nbDayInMonth=30; break;
        case 10: nbDayInMonth=31; break;
        case 11: nbDayInMonth=30; break;
        case 12: nbDayInMonth=31; break;
        default: nbDayInMonth=31; break;
    }
    if(dateTime->day+day >nbDayInMonth)
    {
        month++;
        date.day = ((dateTime->day+day)%nbDayInMonth);
    }
    else
    {
        date.day = (dateTime->day+day);
    }
    
    if(dateTime->weekDay+day >7)
    {
        date.weekDay = ((dateTime->weekDay+day)%7);
    }
    else
    {
        date.weekDay = (dateTime->weekDay+day);
    }
    
    if(dateTime->month+month >12)
    {
        year++;
        date.month = (dateTime->month+month)%12;
    }
    else
    {
        date.month = (dateTime->month+month);
    }
    date.year = dateTime->year+year;
    return date;
}

bool MCP79522IsDatePassed(RtccDateTime* aimedDate, unsigned char csID)
{
    RtccDateTimeBCD rtBcd;
    RtccDateTime rt;
    MCP79522RtccRead(&rtBcd, csID);
    ConvertDateFromBCD(&rtBcd,&rt);
    if(rt.year>aimedDate->year)
    {
        return true;
    }
    else if(rt.year<aimedDate->year)
    {
        return false;
    }
    
    if(rt.year==aimedDate->year)
    {
        if(rt.month>aimedDate->month)
        {
            return true;
        }
        else if(rt.month<aimedDate->month)
        {
            return false;
        }
        
        if(rt.month==aimedDate->month)
        {
            if(rt.day>aimedDate->day)
            {
                return true;
            }
            else if(rt.day<aimedDate->day)
            {
                return false;
            }
            
            if(rt.day==aimedDate->day)
            {
                if(rt.hour>aimedDate->hour)
                {
                    return true;
                }
                else if(rt.hour<aimedDate->hour)
                {
                    return false;
                }
                
                if(rt.hour==aimedDate->hour)
                {
                    if(rt.minute>aimedDate->minute)
                    {
                        return true;
                    }
                    else if(rt.minute<aimedDate->minute)
                    {
                        return false;
                    }
                    
                    if(rt.minute == aimedDate->minute)
                    {
                        if(rt.second>=aimedDate->second)
                        {
                            return true;
                        }
                        else
                        {
                            return false;
                        }
                    }
                }
            }
        }
    }
    return false;
}


bool MCP79522IsDatePassed2(RtccDateTime* aimedDate, RtccDateTime* rt)
{
    if(rt->year>aimedDate->year)
    {
        return true;
    }
    else if(rt->year<aimedDate->year)
    {
        return false;
    }

    if(rt->year==aimedDate->year)
    {
        if(rt->month>aimedDate->month)
        {
            return true;
        }
        else if(rt->month<aimedDate->month)
        {
            return false;
        }

        if(rt->month==aimedDate->month)
        {
            if(rt->day>aimedDate->day)
            {
                return true;
            }
            else if(rt->day<aimedDate->day)
            {
                return false;
            }

            if(rt->day==aimedDate->day)
            {
                if(rt->hour>aimedDate->hour)
                {
                    return true;
                }
                else if(rt->hour<aimedDate->hour)
                {
                    return false;
                }

                if(rt->hour==aimedDate->hour)
                {
                    if(rt->minute>aimedDate->minute)
                    {
                        return true;
                    }
                    else if(rt->minute<aimedDate->minute)
                    {
                        return false;
                    }

                    if(rt->minute == aimedDate->minute)
                    {
                        if(rt->second>=aimedDate->second)
                        {
                            return true;
                        }
                        else
                        {
                            return false;
                        }
                    }
                }
            }
        }
    }
    return false;
}

/* *****************************************************************************
 End of File
 */
