/* ************************************************************************** */
/** Descriptive File Name

  @Company
    Company Name

  @File Name
    filename.h

  @Summary
    Brief description of the file.

  @Description
    Describe the purpose of this file.
 */
/* ************************************************************************** */

#ifndef _UTLN_MCP79522_H    /* Guard against multiple inclusion */
#define _UTLN_MCP79522_H

/* ************************************************************************** */
/* ************************************************************************** */
/* Section: Included Files                                                    */
/* ************************************************************************** */
/* ************************************************************************** */
#include <stdint.h>
#include <stdbool.h>
#ifndef MAX
    #define MAX(a,b) ((a<b) ? b : a)
#endif
#ifndef MIN
    #define MIN(a,b) ((b<a) ? b : a)
#endif
#ifndef bool
#define bool unsigned char
#define true (1)
#define false (0)
#endif
//Alarm MASK
#define MCP79522_ALM_MSK_SEC 0
#define MCP79522_ALM_MSK_MIN 1
#define MCP79522_ALM_MSK_HOUR 2
#define MCP79522_ALM_MSK_DWK 3
#define MCP79522_ALM_MSK_DATE 4
#define MCP79522_ALM_MSK_ALL 7

typedef void (*MCP79522USER_SPI_Func)(unsigned char command[],int nbWrite, unsigned char results[], int nbResults, unsigned char ChipSelectID);


typedef struct RtccDateTime_struct {
	unsigned char year;
	unsigned char month;
	unsigned char day;
	unsigned char weekDay;
	unsigned char hour;
	unsigned char minute;
	unsigned char second;
	uint8_t ID[8];
} RtccDateTime;

typedef struct RtccDateTimeBCD_struct {
	unsigned char yearTen;
	unsigned char yearUnit;
	unsigned char monthTen;
	unsigned char monthUnit;
	unsigned char dayTen;
	unsigned char dayUnit;
	unsigned char weekDay;
	unsigned char hourTen;
	unsigned char hourUnit;
	unsigned char minuteTen;
	unsigned char minuteUnit;
	unsigned char secondTen;
	unsigned char secondUnit;
} RtccDateTimeBCD;


void MCP79522RegisterUserSPIFunc(MCP79522USER_SPI_Func func);
void MCP79522SPIWriteSingleMultipleRead(unsigned char command, unsigned char results[], int nbRead, unsigned char csID);
void MCP79522SPIWriteMultipleMultipleRead(unsigned char command[],int nbWrite, unsigned char results[], int nbRead, unsigned char csID);
//MCP79522 Functions
void MCP79522WriteRTCCRegister(unsigned char regAddress,unsigned char value, unsigned char csID);
void MCP79522WriteMultipleRTCCRegister(unsigned char regAddress,unsigned char value[],unsigned char writeCount, unsigned char csID);
unsigned char MCP79522ReadRTCCRegister(unsigned char regAddress, unsigned char csID);
void MCP79522ReadMultipleRTCCRegister(unsigned char regAddress,unsigned char readVal[],unsigned char readCount, unsigned char csID);
void MCP79522ClearSRAM(unsigned char csID);
void MCP79522WriteStatus(unsigned char status, unsigned char csID);
unsigned char MCP79522ReadStatus( unsigned char csID);
//EEPROM WRITE Enable/Disable Sequence
void MCP79522EEPROMWriteEnable(unsigned char csID);
void MCP79522EEPROMWriteDisable(unsigned char csID);
//EEPROM Write/Read Sequence
void MCP79522EEPROMWrite(unsigned char addressByte,unsigned char data[], unsigned char dataCount,unsigned char csID);
void MCP79522EEPROMRead(unsigned char addressByte,unsigned char dataRead[], unsigned char dataReadCount,unsigned char csID);
//Protected EEPROM WRITE/READ Sequences
void MCP79522ProtectedEEPROMWrite(unsigned char addressByte,unsigned char data[], unsigned char dataCount,unsigned char csID);
void MCP79522ProtectedEEPROMRead(unsigned char addressByte,unsigned char dataRead[], unsigned char dataReadCount,unsigned char csID);
//USER Function (High Level)

void MCP79522Init(unsigned char csID);
void MCP79522ReadID( unsigned char ID64[], unsigned char csID);
/* Function to read the time and date registers*/
void MCP79522RtccRead(RtccDateTimeBCD * rtBCD, unsigned char csID);
void ConvertDateToBCD(const RtccDateTime * rt, RtccDateTimeBCD * rtBCD);
void ConvertDateFromBCD( RtccDateTimeBCD * rtBCD, RtccDateTime * rt);
void MCP79522TimeGet(RtccDateTime * value, unsigned char csID);
void MCP79522RtccSetClock(const RtccDateTimeBCD * dtBCD, unsigned char csID);
void MCP79522RtccSetAlarm(const RtccDateTimeBCD * dtBCD,unsigned char almNum, unsigned char mask, unsigned char csID);
void MCP79522EnableAlarm(unsigned char almNum, unsigned char csID);
void MCP79522DisableAlarm(unsigned char almNum, unsigned char csID);
void MCP79522ClearAlarmFlag(unsigned char almNum, unsigned char csID);
RtccDateTime MCP79522DateAddInterval(RtccDateTime * dateTime , uint32_t interval);
bool MCP79522IsDatePassed(RtccDateTime* aimedDate, unsigned char csID);
bool MCP79522IsDatePassed2(RtccDateTime* aimedDate, RtccDateTime* rt);
#endif /* _UTLN_MCP79522_H */

/* *****************************************************************************
 End of File
 */
