/* ************************************************************************** */
/** Descriptive File Name

  @Company
    SMIOT

  @File Name
    filename.h

  @Summary
    Brief description of the file.

  @Description
    Describe the purpose of this file.
 */
/* ************************************************************************** */

#ifndef _UTLN_MCP79522_REG_H    /* Guard against multiple inclusion */
#define _UTLN_MCP79522_REG_H
//#include <xc.h> // include processor files - each processor file is guarded.

#ifndef NULL
    #define NULL 0
#endif

// Device OP-Code for SRAM/RTCC/EEPROM/STATUS Access
#define EEREAD 0x03
#define EEWRITE 0x02
#define EEWRDI 0x04
#define EEWREN 0x06
#define SRREAD 0x05
#define SRWRITE 0x01
#define READ 0x13
#define WRITE 0x12
#define UNLOCK 0x14
#define IDWRITE 0x32
#define IDREAD 0x33
#define CLRRAM 0x54




#define MSB_UINT16(a) (((a) >> 8) & 0xFF)
#define LSB_UINT16(a) ((a) & 0xFF)

//Registers for Timekeepintg
#define MCP79522_RTCHSEC_reg 0x00
#define MCP79522_RTCSEC_reg 0x01
#define MCP79522_RTCMIN_reg 0x02
#define MCP79522_RTCHOUR_reg 0x03
#define MCP79522_RTCWKDAY_reg 0x04
#define MCP79522_RTCDATE_reg 0x05
#define MCP79522_RTCMTH_reg 0x06
#define MCP79522_RTCYEAR_reg 0x07
#define MCP79522_CONTROL_reg 0x08
#define MCP79522_OSCTRIM_reg 0x09

//Registers for Alarm 0
#define MCP79522_ALM0SEC_reg 0x0C
#define MCP79522_ALM0MIN_reg 0x0D
#define MCP79522_ALM0HOUR_reg 0x0E
#define MCP79522_ALM0WKDAY_reg 0x0F
#define MCP79522_ALM0DATE_reg 0x10
#define MCP79522_ALM0MTH_reg 0x11

//Registers for Alarm 1
#define MCP79522_ALM1SEC_reg 0x12
#define MCP79522_ALM1MIN_reg 0x13
#define MCP79522_ALM1HOUR_reg 0x14
#define MCP79522_ALM1WKDAY_reg 0x15
#define MCP79522_ALM1DATE_reg 0x16
#define MCP79522_ALM1MTH_reg 0x17

//Registers for Power-Fail Timestamp
// Power-Down Timestamp
#define MCP79522_PWRDNMIN_reg 0x18
#define MCP79522_PWRDNHOUR_reg 0x19
#define MCP79522_PWRDNDATE_reg 0x1A
#define MCP79522_PWRDNMTH_reg 0x1B

// Power-Up Timestamp
#define MCP79522_PWRUPMIN_reg 0x1C
#define MCP79522_PWRUPHOUR_reg 0x1D
#define MCP79522_PWRUPDATE_reg 0x1E
#define MCP79522_PWRUPMTH_reg 0x1F




__extension__ typedef struct RTCSECBITS{
union {
struct{
  unsigned ALL:8;
   };

struct {
  unsigned SECONE:4;
  unsigned SECTEN:3; 
  unsigned ST:1;
  };
};
}RTCsecBits;


__extension__ typedef struct RTCMINBITS{
union {
struct{
  unsigned ALL:8;
   };

struct {
  unsigned MINONE:4;
  unsigned MINTEN:3;
  unsigned :0;
  };
};
}RTCminBits;

__extension__ typedef struct RTCHOURBITS{
union {
struct{
  unsigned ALL:8;
   };

struct {
  unsigned HRONE:4;
  unsigned HRTEN:2;
  unsigned f12_24:1;
  unsigned TRIMSIGN:1;
  };
};
}RTChourBits;

__extension__ typedef struct RTCWKDAYBITS{
union {
struct{
  unsigned ALL:8;
   };

struct {
  unsigned WKDAY:3;
  unsigned VBATEN:1;
  unsigned PWRFAIL:1;
  unsigned OSCRUN:1;
  unsigned :2;
  };
};
}RTCwkdayBits;

__extension__ typedef struct RTCDATEBITS{
union {
struct{
  unsigned ALL:8;
   };

struct {
  unsigned DATEONE:4;
  unsigned DATETEN:2;
  unsigned :2;
  };
};
}RTCdateBits;

__extension__ typedef struct RTCMTHBITS{
union {
struct{
  unsigned ALL:8;
   };

struct {
  unsigned MTHONE:4;
  unsigned MTHTEN:1;
  unsigned LPYR:1;
  unsigned :2;
  };
};
}RTCmthBits;

__extension__ typedef struct RTCYEARBITS{
union {
struct{
  unsigned ALL:8;
   };

struct {
  unsigned YRONE:4;
  unsigned YRTEN:4;
  };
};
}RTCyearBits;

__extension__ typedef struct ALMWKDAYBITS{
union {
struct{
  unsigned ALL:8;
   };

struct {
  unsigned WKDAY:3;
  unsigned ALMxIF:1;
  unsigned ALMxMSK:3;
  unsigned :2;
  };
};
}ALMwkdayBits;

__extension__ typedef struct CONTROLBITS{
union {
struct{
  unsigned ALL:8;
   };

struct {
  unsigned SQWFS:2;
  unsigned CRSTRIM:1;
  unsigned EXTOSC:1;
  unsigned ALM0EN:1;
  unsigned ALM1EN:1;
  unsigned SQWEN:1;
  unsigned :1;
  };
};
}CONTROLbits;

#endif /* _UTLN_MCP79522_REG_H */

/* *****************************************************************************
 End of File
 */
