/*
 * SPI_Driver.c
 *
 *  Created on: 7 mai 2021
 *      Author: sebas
 */
#include <string.h>
#include <math.h>
#include <stdbool.h>
#include <time.h>
#include <stdlib.h>
#include <stdint.h>
#include <stddef.h>
#include <file.h>
#include <stdio.h>
#include <ti/sysbios/knl/Clock.h>
#include <ti/sysbios/knl/Task.h>
#include <ti/sysbios/hal/Hwi.h>
#include <ti/drivers/PIN.h>
#include <ti/drivers/SPI.h>
#include <ti/drivers/GPIO.h>

#include <Macros/Define.h>

#include <Task_Supervisor/Task_Supervisor.h>
#include <Task_SPI/Task_SPI.h>
#include <Task_SPI/SPI_Driver.h>
#include <Task_SPI/ICM20948/UTLN_ICM20948.h>
#include <Task_SPI/MCP79522/UTLN_MCP79522.h>
#include <Task_SD/SD_Driver.h>
#include <Task_SD/Task_SD.h>

/* Driver configuration */
#include "ti_drivers_config.h"

#define SPI_MSG_LENGTH_MAX      128

SPI_Handle      masterSpi;
SPI_Params      spiParams;
bool            transferOK;

extern bool CLOCKFILEREAD;
extern SupervisorState supervisorState;
extern RtccDateTime    FlashRtccDateTime;
RtccDateTimeBCD FlashRtccDateTimeBCD;
ICM20948_SubAccel   ICM20948_subAccel;
ICM20948_SubGyro    ICM20948_subGyro;
ICM20948_SubMag     ICM20948_subMag;
unsigned char UUID64[8]={0};

unsigned char masterRxBuffer[SPI_MSG_LENGTH_MAX];
unsigned char masterTxBuffer[SPI_MSG_LENGTH_MAX];

void InitDevicesSPI(void){
    GPIO_setConfig(SPI_SS_IMU, GPIO_CFG_OUTPUT);
    GPIO_write(SPI_SS_IMU, CONFIG_GPIO_LED_ON);
    GPIO_write(SS_RTCC, CONFIG_GPIO_LED_ON);

    //On associe la fonction de lecture/ecriture SPI aux libs
    ICM20948RegisterUserSPIFunc(SPI_Communication);
    MCP79522RegisterUserSPIFunc(SPI_Communication);


#if USING_RTCC
    MCP79522Init(Board_MCP79522_ID);


    MCP79522ReadID(UUID64, Board_MCP79522_ID);
    for(int i=0; i<8;i++)
        supervisorState.localTime.ID[i] = UUID64[i];
#endif
    //Write board info TODO
    //WriteSDBoardInfoUUIDRTCC(UUID64);
    //WriteSD(UUID64, 1);

//    FlashRtccDateTime.day = 7;
//    FlashRtccDateTime.hour = 13;
//    FlashRtccDateTime.minute = 12;
//    FlashRtccDateTime.month = 9;
//    FlashRtccDateTime.second = 0;
//    FlashRtccDateTime.weekDay = 1;
//    FlashRtccDateTime.year = 20;

    //Write RTCC data info TODO
//    appData.localTime.day = FlashRtccDateTime.day;
//    appData.localTime.month = FlashRtccDateTime.month;
//    appData.localTime.year = FlashRtccDateTime.year;
//    appData.localTime.hour = FlashRtccDateTime.hour;
//    appData.localTime.minute = FlashRtccDateTime.minute;
//    appData.localTime.second = FlashRtccDateTime.second;
//
    if(CLOCKFILEREAD){
        ConvertDateToBCD(&FlashRtccDateTime, &FlashRtccDateTimeBCD);
        MCP79522RtccSetClock(&FlashRtccDateTimeBCD, Board_MCP79522_ID);
        CLOCKFILEREAD = false;
    }

    ReadRTCCData();

#if USING_IMU
    //On test 10 fois l'init de l'IMU
    uint8_t NumberOfIMUInitsTests = 0;
    ICM20948Reset(Board_ICM20948_ID);
    Task_sleep(10 * (1000/Clock_tickPeriod));
    //unsigned char initOkIMU =ICM20948Init_default(Board_ICM20948_ID); //Inits IMU sans magneto
    unsigned char initOkIMU = ICM20948Init_defaultV2MAG(Board_ICM20948_ID); //Inits IMU avec magneto
    if(initOkIMU == 0){
            while (initOkIMU == 0 && NumberOfIMUInitsTests < 10){
                ICM20948Reset(Board_ICM20948_ID);
                Task_sleep(100);
                initOkIMU = ICM20948Init_defaultV2MAG(Board_ICM20948_ID); //Inits IMU avec magneto
                NumberOfIMUInitsTests++;
                //initOkIMU =ICM20948Init_default(Board_ICM20948_ID); //Inits IMU sans magneto
            }//ID Error
         }
    //ICM20948EnterLowPowerMode(false, false, false, Board_ICM20948_ID);
    //ICM20648EnableSleepmode(true, Board_ICM20948_ID);

#endif

    //Interrupts are not used because the sensor are read doing pooling

    /* install callbacks */
    //GPIO_setCallback(IRQ_IMU,IRQ_IMU_CallbackFxn);
    //GPIO_setCallback(IRQ_RTCC,IRQ_RTCC_CallbackFxn);

    /* Enable interrupts */
    //GPIO_enableInt(IRQ_IMU);
    //GPIO_enableInt(IRQ_RTCC);
}

void SleepSPISensors(void){
    #if USING_IMU
    //ICM20948Reset(Board_ICM20948_ID);
    //Task_sleep(10 * (1000/Clock_tickPeriod));
    //ICM20948PreSleep(Board_ICM20948_ID);
    //ICM20948Init_defaultV2MAG(Board_ICM20948_ID); //Inits IMU avec magneto
    //Task_sleep(10 * (1000/Clock_tickPeriod));
    //ICM20948SleepMagneto(Board_ICM20948_ID);
    //ICM20948Reset(Board_ICM20948_ID);
    //Task_sleep(100 * (1000/Clock_tickPeriod));
    //ICM20948EnterLowPowerMode(false, false, false, Board_ICM20948_ID);
    ICM20648EnableSleepmode(true, Board_ICM20948_ID);
    #endif
    //GPIO_write(SPI_SS_IMU, CONFIG_GPIO_LED_OFF);
    //GPIO_write(SS_RTCC, CONFIG_GPIO_LED_OFF);
}

void SleepSPISensorsAvecMag(void){
    #if USING_IMU
    ICM20948Reset(Board_ICM20948_ID);
    Task_sleep(10 * (1000/Clock_tickPeriod));
    ICM20948PreSleep(Board_ICM20948_ID);
    ICM20948Init_defaultV2MAG(Board_ICM20948_ID); //Inits IMU avec magneto
    Task_sleep(10 * (1000/Clock_tickPeriod));
    ICM20948SleepMagneto(Board_ICM20948_ID);
    ICM20948Reset(Board_ICM20948_ID);
    Task_sleep(100 * (1000/Clock_tickPeriod));
    ICM20948EnterLowPowerMode(false, false, false, Board_ICM20948_ID);
    ICM20648EnableSleepmode(true, Board_ICM20948_ID);
    #endif
    //GPIO_write(SPI_SS_IMU, CONFIG_GPIO_LED_OFF);
    //GPIO_write(SS_RTCC, CONFIG_GPIO_LED_OFF);
}

void WakeUpSPISensors(void){
    //GPIO_write(SPI_SS_IMU, CONFIG_GPIO_LED_ON);
    #if USING_IMU
    ICM20948Reset(Board_ICM20948_ID);
    Task_sleep(10 * (1000/Clock_tickPeriod));
    //unsigned char initOkIMU =ICM20948Init_default(Board_ICM20948_ID); //Inits IMU sans magneto
    unsigned char initOkIMU = ICM20948Init_defaultV2MAG(Board_ICM20948_ID); //Inits IMU avec magneto
    if(initOkIMU == 0){
                ICM20948Reset(Board_ICM20948_ID);
                Task_sleep(10 * (1000/Clock_tickPeriod));
                initOkIMU = ICM20948Init_defaultV2MAG(Board_ICM20948_ID);
     //       }//ID Error
         }
#endif
}

void WakeUpSPISensorsAvecMag(void){
    //GPIO_write(SPI_SS_IMU, CONFIG_GPIO_LED_ON);
    #if USING_IMU
    ICM20948Reset(Board_ICM20948_ID);
    Task_sleep(10 * (1000/Clock_tickPeriod));
    ICM20948WakeUpMagVersion121(Board_ICM20948_ID);
    Task_sleep(10 * (1000/Clock_tickPeriod));
    ICM20948Reset(Board_ICM20948_ID);
    Task_sleep(10 * (1000/Clock_tickPeriod));
    //unsigned char initOkIMU =ICM20948Init_default(Board_ICM20948_ID); //Inits IMU sans magneto
    unsigned char initOkIMU = ICM20948Init_defaultV2MAG(Board_ICM20948_ID); //Inits IMU avec magneto
    if(initOkIMU == 0){
                ICM20948Reset(Board_ICM20948_ID);
                Task_sleep(10 * (1000/Clock_tickPeriod));
                initOkIMU = ICM20948Init_defaultV2MAG(Board_ICM20948_ID);
     //       }//ID Error
         }
#endif

//    uint8_t NumberOfIMUInitsTests = 0;
//    ICM20948Reset(Board_ICM20948_ID);
//    Task_sleep(10 * (1000/Clock_tickPeriod));
//    //unsigned char initOkIMU =ICM20948Init_default(Board_ICM20948_ID); //Inits IMU sans magneto
//    unsigned char initOkIMU = ICM20948Init_defaultV2MAG(Board_ICM20948_ID); //Inits IMU avec magneto
//    if(initOkIMU == 0){
//            while (initOkIMU == 0 && NumberOfIMUInitsTests < 10){
//                ICM20948Reset(Board_ICM20948_ID);
//                Task_sleep(100);
//                initOkIMU = ICM20948Init_defaultV2MAG(Board_ICM20948_ID); //Inits IMU avec magneto
//                NumberOfIMUInitsTests++;
//                //initOkIMU =ICM20948Init_default(Board_ICM20948_ID); //Inits IMU sans magneto
//            }//ID Error
//         }

}

void Init_SPI(void)
{
    //SPI_init();
    /* Open SPI as master (default) */
    SPI_Params_init (&spiParams);
    spiParams.frameFormat = SPI_POL0_PHA0;
    spiParams.bitRate = 7000000; //4 MHz
    spiParams.dataSize = 8; //16;

    masterSpi = SPI_open(CONFIG_SPI_1, &spiParams);
    if (masterSpi == NULL)
    {
        while (1)
        {
            //if it doesnt init it waits here
            //            Task_sleep(1000);
            ;
        }
    }

    InitDevicesSPI();
}

void ReadRTCCData(void){
    MCP79522TimeGet(&supervisorState.localTime, Board_MCP79522_ID);
}
unsigned char dataReadAccGyrMag[25];
void ReadIMUData(void){

    #if USING_IMU
    ICM20948WriteRegister(0x7F,0,Board_ICM20948_ID);
    //Read Acelerometer, Gyroscope and Magneto data
    ICM20948GetAGTMValues(dataReadAccGyrMag, Board_ICM20948_ID);

    //read Accelerometer data from IMU
    //ICM20948GetAccelValues_(dataRead,Board_ICM20948_ID);

    ICM20948_subAccel.Accel_X_High  = dataReadAccGyrMag[0];//dataRead[0];
    ICM20948_subAccel.Accel_X_Low   = dataReadAccGyrMag[1];//dataRead[1];
    ICM20948_subAccel.Accel_Y_High  = dataReadAccGyrMag[2];//dataRead[2];
    ICM20948_subAccel.Accel_Y_Low   = dataReadAccGyrMag[3];//dataRead[3];
    ICM20948_subAccel.Accel_Z_High  = dataReadAccGyrMag[4];//dataRead[4];
    ICM20948_subAccel.Accel_Z_Low   = dataReadAccGyrMag[5];//dataRead[5];

    //read Gyro data from IMU
    //ICM20948GetGyroValues_(dataRead2,Board_ICM20948_ID);

    ICM20948_subGyro.Gyro_X_High    = dataReadAccGyrMag[6];//dataRead2[0];
    ICM20948_subGyro.Gyro_X_Low     = dataReadAccGyrMag[7];//dataRead2[1];
    ICM20948_subGyro.Gyro_Y_High    = dataReadAccGyrMag[8];//dataRead2[2];
    ICM20948_subGyro.Gyro_Y_Low     = dataReadAccGyrMag[9];//dataRead2[3];
    ICM20948_subGyro.Gyro_Z_High    = dataReadAccGyrMag[10];//;dataRead2[4];
    ICM20948_subGyro.Gyro_Z_Low     = dataReadAccGyrMag[11];//dataRead2[5];

    //Temeprature
    //dataReadAccGyrMag[12]
    //dataReadAccGyrMag[13]

    ICM20948_subMag.Mag_X_High = dataReadAccGyrMag[16];//1;
    ICM20948_subMag.Mag_X_Low = dataReadAccGyrMag[15];//2;
    ICM20948_subMag.Mag_Y_High = dataReadAccGyrMag[18];//3;
    ICM20948_subMag.Mag_Y_Low = dataReadAccGyrMag[17];//4;
    ICM20948_subMag.Mag_Z_High = dataReadAccGyrMag[20];//5;
    ICM20948_subMag.Mag_Z_Low = dataReadAccGyrMag[19];//6;
    #endif
}

void SPI_Communication(unsigned char command[],int nbWrite, unsigned char results[], int nbRead, unsigned char csID){

    SPI_Transaction transaction;

    //NE PAS DECLARER LES BUFFERS TX ET RX EN LOCAL JAMAIS EXPLOSION DE LA MEMOIRE!!!

    for(int i=0;i<nbWrite;i++)
        masterTxBuffer[i] = command[i];

    switch(csID){
        case Board_ICM20948_ID :
            GPIO_write(SPI_SS_IMU, CONFIG_GPIO_LED_OFF);
            break;
        case Board_MCP79522_ID :
            GPIO_write(SS_RTCC, CONFIG_GPIO_LED_OFF);
            break;
        default :
        break;
    }

    //CELA NE SERT A RIEN MAIS IL EST FAIT DANS L'EXAMPLE PARCE QU'ILS ENVOIENT UNE CHAINE DE CHARACTERS
    /* Copy message to transmit buffer */
    //strncpy((unsigned char *) masterTxBuffer, command, nbWrite + nbRead);
    //CELA NE SERT A RIEN MAIS IL EST FAIT DANS L'EXAMPLE PARCE QU'ILS ENVOIENT UNE CHAINE DE CHARACTERS
    /* Initialize master SPI transaction structure */
    //memset((void *) masterRxBuffer, 0, nbWrite + nbRead);
    transaction.count = nbWrite + nbRead;
    transaction.txBuf = (void *) masterTxBuffer;
    transaction.rxBuf = (void *) masterRxBuffer;

    /* Perform SPI transfer */
    transferOK = SPI_transfer(masterSpi, &transaction);

    //UTILISER QUE SI ON A BESOIN DE CONNAITRE LE RESULTAT DE LA TRANSFERT
    //if (!transferOK)
    //  GPIO_toggle(SPI_SS_EXT2);

    for(int i = nbWrite; i < nbWrite+nbRead; i++)
        results[i-nbWrite] = masterRxBuffer[i];

    switch(csID){
        case Board_ICM20948_ID :
            GPIO_write(SPI_SS_IMU, CONFIG_GPIO_LED_ON);
            break;
        case Board_MCP79522_ID :
            GPIO_write(SS_RTCC, CONFIG_GPIO_LED_ON);
            break;
        default :
        break;
    }
}
