/*
 * Task_SPI.c
 *
 *  Created on: 7 mai 2021
 *      Author: sebas
 */

#include <string.h>
#include <math.h>
#include <stdbool.h>
#include <time.h>
#include <stdlib.h>
#include <stdint.h>
#include <stddef.h>
#include <file.h>
#include <stdio.h>

#include <xdc/runtime/Error.h>
#include <xdc/runtime/System.h>

#include <ti/sysbios/knl/Task.h>
#include <ti/sysbios/hal/Hwi.h>
#include <ti/sysbios/knl/Clock.h>
#include <ti/sysbios/knl/Event.h>
#include <ti/sysbios/knl/Queue.h>
#include <ti/sysbios/knl/Semaphore.h>
#include <ti/sysbios/BIOS.h>
#include <ti/drivers/GPIO.h>
#include <ti/drivers/SPI.h>
#include <ti/drivers/Timer.h>

#include "Macros/Protocol.h"
#include "Macros/Define.h"

#include <Task_SPI/ICM20948/UTLN_ICM20948.h>
#include <Task_Supervisor/Task_Supervisor.h>
#include <Task_UART_PIC32/MsgProcessor_PIC32.h>
#include <Task_Supervisor/Task_Supervisor.h>
#include <Task_SPI/Task_SPI.h>
#include <Task_SPI/SPI_Driver.h>
#include <Task_SD/Task_SD.h>
#include <Task_SD/SD_Driver.h>

#include "ti_drivers_config.h"
#include "hal_types.h"
#include "hal_defs.h"
// Task configuration
#define SPI_TASK_PRIORITY                     4

#ifndef SPI_TASK_STACK_SIZE
#define SPI_TASK_STACK_SIZE                   4096
#endif

// Task configuration
Task_Struct SPITask;

Event_Handle TaskSPIEvent;

uint8_t SPITaskStack[SPI_TASK_STACK_SIZE];

Clock_Struct TimerReadIMU;
extern bool SdFileSystemInitDone;
extern bool CLOCKFILEREAD;
extern RtccDateTime    FlashRtccDateTime;
extern RtccDateTimeBCD FlashRtccDateTimeBCD;
extern PIC32_RecorderState RecorderStatePIC32;
bool SPIInitOk = false;
bool IMUisSleep = false;
extern ICM20948_SubAccel   ICM20948_subAccel;
extern ICM20948_SubGyro    ICM20948_subGyro;
extern ICM20948_SubMag     ICM20948_subMag;
extern SupervisorState supervisorState;
Timer_Handle    handleTimer_IMUReadRequest;
Timer_Params    paramsTimer_IMUReadRequest;

#define payloadSPISentUARTLengthMAX  256
uint8_t payloadSPISentUART[payloadSPISentUARTLengthMAX];

void TimerReadIMUFxn(uintptr_t arg0){
    Event_post(TaskSPIEvent,IMU_Read_Event);
}

void RequestRTCCRead(void){
    Event_post(TaskSPIEvent,RTCC_Read_Event);
}

void RequestSleepTaskSPISensors(void){
    Event_post(TaskSPIEvent,SPI_Sleep_Event);
}

void RequestWakeUpTaskSPISensors(void){
    Event_post(TaskSPIEvent,SPI_WakeUp_Event);
}

void Timer_IMUReadRequestCallback(Timer_Handle myHandle){
    Event_post(TaskSPIEvent,IMU_Read_Event);
}
uint16_t commandSPISentUART;
uint16_t indexpayloadSPISentUART;
void TaskSPITrameSender(uint16_t trameID){

    switch(trameID){
        case HS_DATA_PACKET_FULL_TIMESTAMP:
        {
            commandSPISentUART = HS_DATA_PACKET_FULL_TIMESTAMP;
            indexpayloadSPISentUART = 0;
//            uint16_t payloadLength = SET_RTCC_DU_RECORDER_AUDIO_LENGHT;
//            uint8_t payload[payloadLength];
            uint32_t timstampNow = GetFullTimestamp();
            payloadSPISentUART[indexpayloadSPISentUART++] = 0x08;//Type IMU
            payloadSPISentUART[indexpayloadSPISentUART++] = 0x01;//Sensor ID
            payloadSPISentUART[indexpayloadSPISentUART++] = 9;//Sensor ID
            payloadSPISentUART[indexpayloadSPISentUART++] = 4;//Range 4G
            payloadSPISentUART[indexpayloadSPISentUART++] = 16;//16 bits resolution
            payloadSPISentUART[indexpayloadSPISentUART++] = 0;//Sampling freq 100 Hz
            payloadSPISentUART[indexpayloadSPISentUART++] = 100;//Sampling freq 100 Hz
            payloadSPISentUART[indexpayloadSPISentUART++] = 0;//Nb samples
            payloadSPISentUART[indexpayloadSPISentUART++] = 1;//Nb samples
            payloadSPISentUART[indexpayloadSPISentUART++] = BREAK_UINT32(timstampNow, 3);//supervisorState.localTime.year;
            payloadSPISentUART[indexpayloadSPISentUART++] = BREAK_UINT32(timstampNow, 2);//supervisorState.localTime.month;
            payloadSPISentUART[indexpayloadSPISentUART++] = BREAK_UINT32(timstampNow, 1);//supervisorState.localTime.day;
            payloadSPISentUART[indexpayloadSPISentUART++] = BREAK_UINT32(timstampNow, 0);//supervisorState.localTime.hour;
            payloadSPISentUART[indexpayloadSPISentUART++] = ICM20948_subAccel.Accel_X_High;
            payloadSPISentUART[indexpayloadSPISentUART++] = ICM20948_subAccel.Accel_X_Low;
            payloadSPISentUART[indexpayloadSPISentUART++] = ICM20948_subAccel.Accel_Y_High;
            payloadSPISentUART[indexpayloadSPISentUART++] = ICM20948_subAccel.Accel_Y_Low;
            payloadSPISentUART[indexpayloadSPISentUART++] = ICM20948_subAccel.Accel_Z_High;
            payloadSPISentUART[indexpayloadSPISentUART++] = ICM20948_subAccel.Accel_Z_Low;
            payloadSPISentUART[indexpayloadSPISentUART++] = ICM20948_subGyro.Gyro_X_High;
            payloadSPISentUART[indexpayloadSPISentUART++] = ICM20948_subGyro.Gyro_X_Low;
            payloadSPISentUART[indexpayloadSPISentUART++] = ICM20948_subGyro.Gyro_Y_High;
            payloadSPISentUART[indexpayloadSPISentUART++] = ICM20948_subGyro.Gyro_Y_Low;
            payloadSPISentUART[indexpayloadSPISentUART++] = ICM20948_subGyro.Gyro_Z_High;
            payloadSPISentUART[indexpayloadSPISentUART++] = ICM20948_subGyro.Gyro_Z_Low;
            payloadSPISentUART[indexpayloadSPISentUART++] = ICM20948_subMag.Mag_X_High;
            payloadSPISentUART[indexpayloadSPISentUART++] = ICM20948_subMag.Mag_X_Low;
            payloadSPISentUART[indexpayloadSPISentUART++] = ICM20948_subMag.Mag_Y_High;
            payloadSPISentUART[indexpayloadSPISentUART++] = ICM20948_subMag.Mag_Y_Low;
            payloadSPISentUART[indexpayloadSPISentUART++] = ICM20948_subMag.Mag_Z_High;
            payloadSPISentUART[indexpayloadSPISentUART++] = ICM20948_subMag.Mag_Z_Low;
            #if USING_UART_PIC32
            MakeAndSendMessageWithUTLNProtocol(commandSPISentUART, indexpayloadSPISentUART, payloadSPISentUART);
            #endif
            break;
        }
    }
}

void InitTimer_IMURequest(void){

    Timer_init();

    Timer_Params_init(&paramsTimer_IMUReadRequest);

    paramsTimer_IMUReadRequest.periodUnits = Timer_PERIOD_HZ;
    paramsTimer_IMUReadRequest.period = 100;
    //paramsTIMER_TimeStamp.timerMode  = Timer_FREE_RUNNING;
    paramsTimer_IMUReadRequest.timerMode  = Timer_CONTINUOUS_CALLBACK;
    paramsTimer_IMUReadRequest.timerCallback = Timer_IMUReadRequestCallback;

    handleTimer_IMUReadRequest = Timer_open(Timer_IMUReadRequest, &paramsTimer_IMUReadRequest);
    if (handleTimer_IMUReadRequest == NULL) {
        // Timer_open() failed
        while (1);
    }

    int32_t status = Timer_start(handleTimer_IMUReadRequest);
    if (status == Timer_STATUS_ERROR) {
        //Timer_start() failed
        while (1);
    }

}


void SPI_CreateTask(void){

    Error_Block eb;

    Task_Params taskParams;

    // Configure task
    Task_Params_init(&taskParams);
    taskParams.stack = SPITaskStack;
    taskParams.stackSize = SPI_TASK_STACK_SIZE;
    taskParams.priority = SPI_TASK_PRIORITY;

    Task_construct(&SPITask, SPI_taskFxn, &taskParams, NULL);

    /*Create an Event object. All events are binary*/
    Error_init(&eb);
    TaskSPIEvent = Event_create(NULL, &eb);
    if(TaskSPIEvent == NULL){
        System_abort("Event create failed");
        while(1);
    }

    Clock_Params clockParamsTimerReadIMU;
    Clock_Params_init(&clockParamsTimerReadIMU);
    clockParamsTimerReadIMU.period = 10* (1000/Clock_tickPeriod), //10 milliseconds
    Clock_construct(&TimerReadIMU, TimerReadIMUFxn,
                    10
                    * (1000/Clock_tickPeriod), // Initial delay before first timeout
                    &clockParamsTimerReadIMU);
}

static void SPI_taskFxn(UArg a0, UArg a1)
{
#if USING_SD
    //On attend l'initialisation du systeme de fichiers
    while(!SdFileSystemInitDone){
        Task_sleep(1000 * (1000 / Clock_tickPeriod)); //On attend 100ms
    }
#endif

    Init_SPI();
    //Hardware timer
    //InitTimer_IMURequest(); // only use virtual or hardware timer
    //Virtual timer
    Clock_start(Clock_handle(&TimerReadIMU)); // only use virtual or hardware timer

    //Read one time to have the actual time
    RequestRTCCRead();
    SPIInitOk = true;

    UInt events;
    // Application main loop
    while (1)
    {
        events = Event_pend(TaskSPIEvent, Event_Id_NONE, RTCC_Read_Event +
                            IMU_Read_Event + SPI_Sleep_Event + SPI_WakeUp_Event,
                            BIOS_WAIT_FOREVER);
                            //5 * (1000 / Clock_tickPeriod));

        if (events & IMU_Read_Event)
        {
            if(!IMUisSleep)
                ReadIMUData();

            #if USING_SD
            if(supervisorState.recordingState == RECORDING_En_Cours)
                TaskSPITrameSender(HS_DATA_PACKET_FULL_TIMESTAMP);
            #endif
        }

        if (events & RTCC_Read_Event)
        {
            if(CLOCKFILEREAD){
                ConvertDateToBCD(&FlashRtccDateTime, &FlashRtccDateTimeBCD);
                MCP79522RtccSetClock(&FlashRtccDateTimeBCD, Board_MCP79522_ID);
                CLOCKFILEREAD = false;
            }

            ReadRTCCData();
        }

        if (events & SPI_Sleep_Event)
        {
            IMUisSleep = true;
            //Timer_stop(handleTimer_IMUReadRequest); // Hardware timer
            Clock_stop(Clock_handle(&TimerReadIMU)); // Virtual timer
            SleepSPISensors();
            //SleepSPISensorsAvecMag();
        }

        if (events & SPI_WakeUp_Event)
        {
            WakeUpSPISensors();
            //WakeUpSPISensorsAvecMag();
            //Timer_start(handleTimer_IMUReadRequest); // Hardware timer
            Clock_start(Clock_handle(&TimerReadIMU)); //Virtual timer
            IMUisSleep = false;
        }
    }
}
