/*
 * Task_Supervisor.c
 *
 *  Created on: 7 mai 2021
 *      Author: sebas
 */


#include <string.h>
#include <math.h>
#include <stdbool.h>
#include <time.h>
#include <stdlib.h>
#include <stdint.h>
#include <stddef.h>
#include <file.h>
#include <stdio.h>

#include <ti/sysbios/knl/Event.h>
#include <ti/sysbios/hal/Hwi.h>
#include <ti/sysbios/knl/Task.h>
#include <ti/sysbios/knl/Clock.h>
#include <ti/sysbios/knl/Queue.h>
#include <ti/sysbios/knl/Semaphore.h>
#include <ti/sysbios/BIOS.h>
#include <ti/drivers/GPIO.h>
#include <ti/drivers/UART.h>
#include <ti/drivers/Timer.h>
#include <ti/drivers/Watchdog.h>

#include <xdc/runtime/Error.h>
#include <xdc/runtime/System.h>

#include "Macros/Protocol.h"
#include "Macros/Define.h"

#include <Task_UART_PIC24/Task_UART_PIC24.h>
#include <Task_UART_PIC24/UART_Driver_PIC24.h>
#include <Task_UART_PIC24/MsgProcessor_PIC24.h>
#include <Task_UART_PIC32/Task_UART_PIC32.h>
#include <Task_UART_PIC32/MsgProcessor_PIC32.h>
#include <Task_SD/Task_SD.h>
#include <Task_Supervisor/Task_Supervisor.h>
#include <Task_SPI/Task_SPI.h>
#include <SensorController/scif.h>

/* Driver configuration */
#include "ti_drivers_config.h"
#include "hal_types.h"
#include "hal_defs.h"

// Task configuration
#define SUPERVISOR_TASK_PRIORITY                     3

#ifndef SUPERVISOR_TASK_STACK_SIZE
#define SUPERVISOR_TASK_STACK_SIZE                   4096
#endif

// Task configuration
Task_Struct SupervisorTask;

Event_Handle TaskSupervisorEvent;

Timer_Handle    handleTimer_TimestampMs;
Timer_Params    paramsTimer_TimestampMs;

uint8_t SupervisorTaskStack[SUPERVISOR_TASK_STACK_SIZE];

/******************************* Global Variables **************************************************************/
#define Debug   1
#define payloadSupervisorSentUARTLengthMAX  256
uint32_t timestampSecond =0;
uint16_t timestampMillisecond =0;
SupervisorState supervisorState;
MULTIPLEXEUR_PIC24_State    multiplexeur_PIC24_State_Requested;
RtccDateTime TimeToStartRegistering;
uint8_t payloadSupervisorSentUART[payloadSupervisorSentUARTLengthMAX];
uint8_t payloadSupervisorSentUARTPIC24[payloadSupervisorSentUARTLengthMAX];

///////////////////BUOY & CNN VARIABLES//////////////////////////////
BuoyState buoyState;
bool NewCNNDetectionResult = false;
bool CNNDetectionResult = false;
bool NewDataToSendGSM = false;
uint8_t buoyMovement = 0;
bool FinalTrameToGSMForwarded = false;
RtccDateTime HeureDeDemmarrage;
RtccDateTime HeureDeControl;
bool firstHourControl_HeureDeDemmarrage = false;
bool RapportSentOkGSM = false;
extern uint32_t OctetsTransferred;
extern uint32_t OctetsToTransfer;
/////////////////////////////////////////////////////////////////////

//This variable defines the project : when it is false the project is QHB and when it is true the project is GIAS
bool USING_CNN_DETECTION = false;                //1 // GIAS = 1; QHB =0

//PIC32 recoder state
PIC32_RecorderState RecorderStatePIC32 = Init;
extern bool UARTPIC24isOpen;
extern bool UARTisOpen;
extern StateTaskSD stateTaskSD;
extern bool SdFileSystemInitDone;
extern bool SPIInitOk;
bool RecordingManagerExternalStop = false;

Clock_Struct TimerDebug;
Clock_Struct TimerSendQHBStateToBuoy;
Clock_Struct TimerSendSupervisorState;

#if WATCHDOG
Watchdog_Params params;
Watchdog_Handle watchdogHandle;
#endif

/******************************* Sleep mode functions ***************************************************/
void SetNormalModeConfig(void){

}
void SetSleepModeConfig(void){

}

/******************************* Sensor Controller functions ***************************************************/
// SCIF driver callback: Task control interface ready (non-blocking task control operation completed)
void scCtrlReadyCallback(void) {

}

// SCIF driver callback: Sensor Controller task code has generated an alert interrupt
void scTaskAlertCallback(void) {
    // Wake up the OS task
    // Clear the ALERT interrupt source
    scifClearAlertIntSource();
    Event_post(TaskSupervisorEvent, Sensor_Controller_Event);
    // Acknowledge the ALERT event
    scifAckAlertEvents();
}

/******************************* Timers functions *********************************************************/
uint16_t timestampMilliseconds = 0;
void Timer_TimestampMsCallback(Timer_Handle handle, int_fast16_t status){//(Timer_Handle myHandle){
    timestampMilliseconds++;
}

void InitTimer_TimestampMs(void){

    Timer_init();

    Timer_Params_init(&paramsTimer_TimestampMs);

    paramsTimer_TimestampMs.periodUnits = Timer_PERIOD_HZ;
    paramsTimer_TimestampMs.period = 1000;
    //paramsTIMER_TimeStamp.timerMode  = Timer_FREE_RUNNING;
    paramsTimer_TimestampMs.timerMode  = Timer_CONTINUOUS_CALLBACK;
    paramsTimer_TimestampMs.timerCallback = Timer_TimestampMsCallback;

    handleTimer_TimestampMs = Timer_open(Timer_TimestampMs, &paramsTimer_TimestampMs);
    if (handleTimer_TimestampMs == NULL) {
        // Timer_open() failed
        while (1);
    }

    int32_t status = Timer_start(handleTimer_TimestampMs);
    if (status == Timer_STATUS_ERROR) {
        //Timer_start() failed
        while (1);
    }

}

#if Debug
void TimerDebugFxn(uintptr_t arg0){
    GPIO_toggle(LED_Bleue);
}
void TimerSendQHBStateToBuoyFxn(uintptr_t arg0){
#if USING_UART_PIC24
    TaskSupervisorTrameSenderPIC24(DEMANDE_STATE_BUOY,buoyMovement);
    //TaskSupervisorTrameSenderPIC24(DEMANDE_STATE_GSM,buoyMovement);
#endif
}


#endif

void TimerSendSupervisorStateFxn(uintptr_t arg0){
#if USING_UART_PIC32
    TaskSupervisorTrameSender(SUPERVISOR_STATE);
#endif
}



/******************************* Timestamp functions *******************************************************/

void ResetTimestampMillisecond(void){
    timestampMilliseconds = 0;//timestampMillisecond = 0;
}

uint32_t GetFullTimestamp(void){
//    uint32_t timestampSecond = (((uint32)scifTaskData.timestapIntGenerator.output.timeStampSCHigh & 0x0000FFFF) <<16) +
//                            (((uint32) scifTaskData.timestapIntGenerator.output.timeStampSCLow) & 0x0000FFFF);
    return timestampMilliseconds + 1000*timestampSecond;//timestampMillisecond + 1000*timestampSecond;
}

/******************************* Trame sender functions ***************************************************/


void TaskSupervisorTrameSender(uint16_t trameID){

        switch(trameID){
            case SUPERVISOR_STATE:
            {
                uint16_t command = SUPERVISOR_STATE;
                uint16_t indexpayloadSupervisorSentUART = 0;

                payloadSupervisorSentUART[indexpayloadSupervisorSentUART++] = BREAK_UINT32(supervisorState.recordParameters.samplingFrequency,0);
                payloadSupervisorSentUART[indexpayloadSupervisorSentUART++] = BREAK_UINT32(supervisorState.recordParameters.samplingFrequency,1);
                payloadSupervisorSentUART[indexpayloadSupervisorSentUART++] = BREAK_UINT32(supervisorState.recordParameters.samplingFrequency,2);
                payloadSupervisorSentUART[indexpayloadSupervisorSentUART++] = BREAK_UINT32(supervisorState.recordParameters.samplingFrequency,3);
                payloadSupervisorSentUART[indexpayloadSupervisorSentUART++] = supervisorState.recordParameters.nbChannelsUsed;
                payloadSupervisorSentUART[indexpayloadSupervisorSentUART++] = supervisorState.recordParameters.resolution;
                payloadSupervisorSentUART[indexpayloadSupervisorSentUART++] = supervisorState.recordParameters.filterSelection;
                payloadSupervisorSentUART[indexpayloadSupervisorSentUART++] = BREAK_UINT32(supervisorState.recordParameters.fileSize,0);
                payloadSupervisorSentUART[indexpayloadSupervisorSentUART++] = BREAK_UINT32(supervisorState.recordParameters.fileSize,1);
                payloadSupervisorSentUART[indexpayloadSupervisorSentUART++] = BREAK_UINT32(supervisorState.recordParameters.fileSize,2);
                payloadSupervisorSentUART[indexpayloadSupervisorSentUART++] = BREAK_UINT32(supervisorState.recordParameters.fileSize,3);
                payloadSupervisorSentUART[indexpayloadSupervisorSentUART++] = supervisorState.recordParameters.storageTarget;
                payloadSupervisorSentUART[indexpayloadSupervisorSentUART++] = supervisorState.localTime.year;
                payloadSupervisorSentUART[indexpayloadSupervisorSentUART++] = supervisorState.localTime.month;
                payloadSupervisorSentUART[indexpayloadSupervisorSentUART++] = supervisorState.localTime.day;
                payloadSupervisorSentUART[indexpayloadSupervisorSentUART++] = supervisorState.localTime.hour;
                payloadSupervisorSentUART[indexpayloadSupervisorSentUART++] = supervisorState.localTime.minute;
                payloadSupervisorSentUART[indexpayloadSupervisorSentUART++] = supervisorState.localTime.second ;
                payloadSupervisorSentUART[indexpayloadSupervisorSentUART++] = TimeToStartRegistering.year;
                payloadSupervisorSentUART[indexpayloadSupervisorSentUART++] = TimeToStartRegistering.month;
                payloadSupervisorSentUART[indexpayloadSupervisorSentUART++] = TimeToStartRegistering.day;
                payloadSupervisorSentUART[indexpayloadSupervisorSentUART++] = TimeToStartRegistering.hour;
                payloadSupervisorSentUART[indexpayloadSupervisorSentUART++] = TimeToStartRegistering.minute;
                payloadSupervisorSentUART[indexpayloadSupervisorSentUART++] = TimeToStartRegistering.second ;
                payloadSupervisorSentUART[indexpayloadSupervisorSentUART++] = supervisorState.recordingState;
                uint32_t timestamp = GetFullTimestamp();// 1000*timestampSecond + timestampMillisecond; //getGlobalTimestamp();
                payloadSupervisorSentUART[indexpayloadSupervisorSentUART++] = BREAK_UINT32(timestamp,0);
                payloadSupervisorSentUART[indexpayloadSupervisorSentUART++] = BREAK_UINT32(timestamp,1);
                payloadSupervisorSentUART[indexpayloadSupervisorSentUART++] = BREAK_UINT32(timestamp,2);
                payloadSupervisorSentUART[indexpayloadSupervisorSentUART++] = BREAK_UINT32(timestamp,3);

                for(int i = 0; i<8; i++)
                    payloadSupervisorSentUART[indexpayloadSupervisorSentUART++] = supervisorState.localTime.ID[i];

                if(supervisorState.recordingState != SHUTDOWN_En_Cours || supervisorState.recordParameters.storageTarget == 2)
                    MakeAndSendMessageWithUTLNProtocol(command,indexpayloadSupervisorSentUART,payloadSupervisorSentUART);
                break;
            }
            default: break;
        }
}

uint8_t ledBlancheState = 0;
void TaskSupervisorTrameSenderPIC24(uint16_t trameID, uint8_t LED_Blanche){
    switch(trameID){
            case MLT_SET_LED:
           {
               uint16_t command = MLT_SET_LED;
               //uint16_t command = DEMANDE_STATE_BUOY;
               uint16_t indexpayloadSupervisorSentUART = 0;
               //if(supervisorState.recordParameters.storageTarget != 2)
               //    ledBlancheState ^= 1;
               //else
               //    ledBlancheState = 0;
               ledBlancheState = LED_Blanche;
               payloadSupervisorSentUARTPIC24[indexpayloadSupervisorSentUART++] = ledBlancheState;
               //MakeAndSendMessageWithUTLNProtocolPIC24(command,0,payloadSupervisorSentUART);
               MakeAndSendMessageWithUTLNProtocolPIC24(command,indexpayloadSupervisorSentUART,payloadSupervisorSentUARTPIC24,false,0);
               break;
           }
            case DEMANDE_STATE_BUOY:
           {
               uint16_t command = DEMANDE_STATE_BUOY;
               uint16_t indexpayloadSupervisorSentUART = 0;
               payloadSupervisorSentUARTPIC24[indexpayloadSupervisorSentUART++] = supervisorState.globalStateForBuoy;
               MakeAndSendMessageWithUTLNProtocolPIC24(command,indexpayloadSupervisorSentUART,payloadSupervisorSentUARTPIC24,false,0);
               //MakeAndSendMessageWithUTLNProtocolPIC24(0x0500,indexpayloadSupervisorSentUART,payloadSupervisorSentUART);
               break;
           }
            case MLT_SET_UART2:
           {
               uint16_t command = MLT_SET_UART2;
               uint16_t indexpayloadSupervisorSentUART = 0;
               payloadSupervisorSentUARTPIC24[indexpayloadSupervisorSentUART++] = multiplexeur_PIC24_State_Requested.UART1State;
               payloadSupervisorSentUARTPIC24[indexpayloadSupervisorSentUART++] = BREAK_UINT32(multiplexeur_PIC24_State_Requested.BaudRateUART1,3);
               payloadSupervisorSentUARTPIC24[indexpayloadSupervisorSentUART++] = BREAK_UINT32(multiplexeur_PIC24_State_Requested.BaudRateUART1,2);
               payloadSupervisorSentUARTPIC24[indexpayloadSupervisorSentUART++] = BREAK_UINT32(multiplexeur_PIC24_State_Requested.BaudRateUART1,1);
               payloadSupervisorSentUARTPIC24[indexpayloadSupervisorSentUART++] = BREAK_UINT32(multiplexeur_PIC24_State_Requested.BaudRateUART1,0);
               payloadSupervisorSentUARTPIC24[indexpayloadSupervisorSentUART++] = multiplexeur_PIC24_State_Requested.UART2State;
               payloadSupervisorSentUARTPIC24[indexpayloadSupervisorSentUART++] = BREAK_UINT32(multiplexeur_PIC24_State_Requested.BaudRateUART2,3);
               payloadSupervisorSentUARTPIC24[indexpayloadSupervisorSentUART++] = BREAK_UINT32(multiplexeur_PIC24_State_Requested.BaudRateUART2,2);
               payloadSupervisorSentUARTPIC24[indexpayloadSupervisorSentUART++] = BREAK_UINT32(multiplexeur_PIC24_State_Requested.BaudRateUART2,1);
               payloadSupervisorSentUARTPIC24[indexpayloadSupervisorSentUART++] = BREAK_UINT32(multiplexeur_PIC24_State_Requested.BaudRateUART2,0);
               payloadSupervisorSentUARTPIC24[indexpayloadSupervisorSentUART++] = multiplexeur_PIC24_State_Requested.UART3State;
               payloadSupervisorSentUARTPIC24[indexpayloadSupervisorSentUART++] = BREAK_UINT32(multiplexeur_PIC24_State_Requested.BaudRateUART3,3);
               payloadSupervisorSentUARTPIC24[indexpayloadSupervisorSentUART++] = BREAK_UINT32(multiplexeur_PIC24_State_Requested.BaudRateUART3,2);
               payloadSupervisorSentUARTPIC24[indexpayloadSupervisorSentUART++] = BREAK_UINT32(multiplexeur_PIC24_State_Requested.BaudRateUART3,1);
               payloadSupervisorSentUARTPIC24[indexpayloadSupervisorSentUART++] = BREAK_UINT32(multiplexeur_PIC24_State_Requested.BaudRateUART3,0);
               MakeAndSendMessageWithUTLNProtocolPIC24(command,indexpayloadSupervisorSentUART,payloadSupervisorSentUARTPIC24,false,0);
               //MakeAndSendMessageWithUTLNProtocolPIC24(0x0500,indexpayloadSupervisorSentUART,payloadSupervisorSentUART);
               break;
           }
            case DEMANDE_STATE_GSM:
           {
               uint16_t command = DEMANDE_STATE_GSM;
               uint16_t indexpayloadSupervisorSentUART = 0;

               //MakeAndSendMessageWithUTLNProtocolPIC24(command,indexpayloadSupervisorSentUART,payloadSupervisorSentUARTPIC24,false,0);
               //MakeAndSendMessageWithUTLNProtocolPIC24(0x0500,indexpayloadSupervisorSentUART,payloadSupervisorSentUART);
               break;
           }
            case GSM_DATA_TO_FORWARD:
           {
               uint16_t command = GSM_DATA_TO_FORWARD;
               uint8_t payloadGSM_DATA_TO_FORWARDSentUART[256] = {0};
               if(supervisorState.multiplexeur_PIC24_State.UART2State == OPEN){
                   OctetsTransferred += 256;
                   MakeAndSendMessageWithUTLNProtocolPIC24(command,256,payloadGSM_DATA_TO_FORWARDSentUART,false,0);
               }
               //MakeAndSendMessageWithUTLNProtocolPIC24(0x0500,indexpayloadSupervisorSentUART,payloadSupervisorSentUART);
               break;
           }

//            case DEMANDE_GSM_CREATION_NOUVEAU_FICHIER:
//           {
//               uint16_t command = DEMANDE_STATE_GSM;
//               uint16_t indexpayloadSupervisorSentUART = 0;
//               //char commandeCreationNewFile100ko[] = "AT+UDWNFILE=\"DATA_FILE1\",100000\r";
//               char commandeCreationNewFile100o[] = "AT+UDWNFILE=\"DATA_FILE1\",100\r";
//               //snprintf(payloadSupervisorSentUARTPIC24, 20, "fat:0:%s", NomDeFichier);
//
//               //payloadSupervisorSentUARTPIC24[payloadSupervisorSentUARTLengthMAX];
//
//               MakeAndSendMessageWithUTLNProtocolPIC24(command,strlen(commandeCreationNewFile100o),commandeCreationNewFile100o,false,0);
//               //MakeAndSendMessageWithUTLNProtocolPIC24(0x0500,indexpayloadSupervisorSentUART,payloadSupervisorSentUART);
//               break;
//           }
            default: break;
        }
}

/******************************* State Machine Recording functions *****************************************/
uint32_t timestampReference = 0;

uint32_t fullTsDebug ;
uint32_t currentFullTsDebug ;
void ManagerRecordingSystem(void)
{

    switch (supervisorState.recordingState)
    {
        case SHUTDOWN_En_Cours:
            if(!RecordingManagerExternalStop)
            {
                //Si on est en external stop, on ne peiut pas quitter le sleep de manire automatique
                if (((GetFullTimestamp() + 1
                        >= timestampReference
                                + 1000
                                        * (supervisorState.recordParameters.shutdownDuration)) //+1 au cas o le quartz low speed soit mal calibr
                || stateTaskSD != SD_CARD_DETECTED) &&
                ((buoyState.currentBuoyNoise == NoNoise) && (buoyState.currentBuoyPosition == Position_Bas))) //Si pas de SD card, on sort du sleep
                {
                    //Si on est en config de la boue, on va attendre qu'elle nous envoie pas de bruit et parking
//                    if((USING_CNN_DETECTION == true) && ((buoyState.currentBuoyNoise != NoNoise) && (buoyState.currentBuoyPosition != Position_Bas))){
//                        ;//On attend
//                    }
//                    else{


                        supervisorState.recordingState = PREPARING_En_Cours;
                        supervisorState.globalStateForBuoy = Ecoute;
                        Clock_setPeriod(Clock_handle(&TimerDebug), 10 * (1000 / Clock_tickPeriod));//Changer periode de clignotement de la led bleu
                        Clock_start(Clock_handle(&TimerDebug));

                        if(supervisorState.recordParameters.storageTarget != 2){
                            #if USING_SPI
                            //Wake up task spi sensors
                            RequestWakeUpTaskSPISensors();
                            #endif
                            #if USING_UART_PIC32
                            Request_UART_PIC32_Open_And_Read();
                            #endif

                            //Get timestamp global (Seconds from sensors controller + milliseconds)
                            timestampReference = GetFullTimestamp();

                            //Start timer 1KHz for millisecond timestamp
                            int32_t status = Timer_start(handleTimer_TimestampMs);





                            SetNormalModeConfig();

                            //Get the time to start registering
                            TimeToStartRegistering = MCP79522DateAddInterval(
                                    &supervisorState.localTime,
                                    supervisorState.recordParameters.preparingDuration);
                            #if USING_UART_PIC32
                            //Turn on PIC32
                            #if !DOING_DEBUG_PIC32
                            GPIO_write(Switch_Alim_PIC32, CONFIG_GPIO_LED_OFF);
                            #endif
                            #endif
                            #if USING_UART_PIC24
                            //#if !BUOY___USING_PIC24_ALWAYS_ON_FOR_UART
                            if(USING_CNN_DETECTION == false){
                                //Turn on PIC24
                                GPIO_write(Switch_Alim_PIC24, CONFIG_GPIO_LED_ON);
                                //Envoie trames UART vers PIC24
                                //Clock_start(Clock_handle(&TimerSendQHBStateToBuoy));
                            }
                            Task_sleep(5 * (1000 / Clock_tickPeriod)); //On attend 5ms APRES ARRETER LE TIMER VIRTUEL SINON IL NE RENTRE PAS EN SLEEP MODE !!!!!!!!!!!!!!
                            #if USING_UART_PIC24
                            //#if !BUOY___USING_PIC24_ALWAYS_ON_FOR_UART
                            if(USING_CNN_DETECTION == false)
                                Request_UART_PIC24_Open_And_Read();
                            //#endif
                            #endif

                            //#endif
                            #endif
                            //Start timer envoi de trames UART vers PIC32
                            Clock_start(Clock_handle(&TimerSendSupervisorState));
                        }


//                    }//else
                }
            }
            break;

        case PREPARING_En_Cours:
            if (GetFullTimestamp() + 1
                    >= timestampReference
                            + 1000
                                    * (supervisorState.recordParameters.preparingDuration)) //+1 au cas o le quartz low speed soit mal calibr
            {
                timestampReference = GetFullTimestamp(); //On update la reference de timestamp
                Clock_setPeriod(Clock_handle(&TimerDebug), 20 * (1000 / Clock_tickPeriod)); //Changer periode de clignotement de la led bleu
                supervisorState.recordingState = RECORDING_En_Cours;
                supervisorState.globalStateForBuoy = Ecoute;
            }
            break;

        case RECORDING_En_Cours:
            if ((GetFullTimestamp() + 1
                    >= timestampReference
                            + 1000
                                    * (supervisorState.recordParameters.recordingDuration)) //+1 au cas o le quartz low speed soit mal calibr
            && stateTaskSD == SD_CARD_DETECTED && supervisorState.recordParameters.recordUseTimeInterval == true) //Si pas de SD card, on reste en mode actif always on
            {
                supervisorState.recordingState = STOPPING_En_Cours;
                supervisorState.globalStateForBuoy = Ecoute;
                Clock_setPeriod(Clock_handle(&TimerDebug), 30 * (1000 / Clock_tickPeriod)); //Changer periode de clignotement de la led bleu
                timestampReference = GetFullTimestamp(); //On update la reference de timestamp
            }
            break;

        case STOPPING_En_Cours:
            if (GetFullTimestamp() + 1
                    >= timestampReference
                            + 1000
                                    * (supervisorState.recordParameters.stoppingDuration)
                    || RecorderStatePIC32 == ReadyToTurnOff || RecorderStatePIC32 == ReadyToStart) //+1 au cas o le quartz low speed soit mal calibr
            {

                //Si on n'utilise pas le detection CNN on passe au mode sleep
                if(USING_CNN_DETECTION == false){
                    //On ferme le UART2 parce que la boue a un bug de merde et ils n'arrivent pas a initaliser le GSM... LCDSM!!!
                    multiplexeur_PIC24_State_Requested.UART1State = OPEN;
                    multiplexeur_PIC24_State_Requested.BaudRateUART1 = 115200;
                    multiplexeur_PIC24_State_Requested.UART2State = CLOSE;
                    multiplexeur_PIC24_State_Requested.BaudRateUART2 = 115200;
                    multiplexeur_PIC24_State_Requested.UART3State = OPEN;
                    multiplexeur_PIC24_State_Requested.BaudRateUART3 = 9600;
                    TaskSupervisorTrameSenderPIC24(MLT_SET_UART2,0);

                    supervisorState.recordingState = SHUTDOWN_En_Cours;
                    supervisorState.globalStateForBuoy = Standby;
                    GPIO_write(LED_Bleue, CONFIG_GPIO_LED_OFF);
                    timestampReference = GetFullTimestamp(); //On update la reference de timestamp
                    Clock_stop(Clock_handle(&TimerDebug));

                    if(supervisorState.recordParameters.storageTarget != 2 && RecordingManagerExternalStop==false)
                    {
                        //On ne met en veille que si on est en mode diffrent de USB et que le recorder n'a pas t arrt de manire externe
                        Clock_stop(Clock_handle(&TimerSendSupervisorState));
                        #if USING_SPI
                        //Set task spi sensors in Sleep mode
                        RequestSleepTaskSPISensors();
                        #endif
                        Task_sleep(5 * (1000 / Clock_tickPeriod)); //On attend 5ms APRES ARRETER LE TIMER VIRTUEL SINON IL NE RENTRE PAS EN SLEEP MODE !!!!!!!!!!!!!!
                        Timer_stop(handleTimer_TimestampMs);
                        #if !DOING_DEBUG_PIC32
                        GPIO_write(Switch_Alim_PIC32, CONFIG_GPIO_LED_ON);
                        #endif
                        //#if !BUOY___USING_PIC24_ALWAYS_ON_FOR_UART

                        //#endif
                        #if USING_UART_PIC32
                        Request_UART_PIC32_Cancel_Read_And_Close();
                        #endif
                        #if USING_UART_PIC24
//                        if(USING_CNN_DETECTION == false){
//                            Clock_stop(Clock_handle(&TimerSendQHBStateToBuoy));
//                            Request_UART_PIC24_Cancel_Read_And_Close();
//                            GPIO_write(Switch_Alim_PIC24, CONFIG_GPIO_LED_OFF);
//                        }

                        #endif

                        //Une fois par cycle on check la carte SD
                        //ReadSDCard();
                        SetSleepModeConfig();
                    }
                }
                else{
                    //Si on utilise le detection CNN on passe au mode CNN detection
                    supervisorState.recordingState = CNN_DETECTION_En_Cours;
                    supervisorState.globalStateForBuoy = Ecoute;
                    Clock_setPeriod(Clock_handle(&TimerDebug), 100 * (1000 / Clock_tickPeriod)); //Changer periode de clignotement de la led bleu
                    timestampReference = GetFullTimestamp(); //On update la reference de timestamp
                    CNNDetectionResult = false;
                    //TODO remove only for debug
                    //CNNDetectionResult = true;
                }
            }

            break;

        case CNN_DETECTION_En_Cours:
            if (GetFullTimestamp() + 1
                    >= timestampReference
                            + 1000
                                    * (supervisorState.recordParameters.DetectionCNNDurationTimeout)
                    || NewCNNDetectionResult == true) //+1 au cas o le quartz low speed soit mal calibr
            {

                NewCNNDetectionResult = false;

                if(CNNDetectionResult){
                    CNNDetectionResult = false;
                    //Si nous avons une detection true on demande une transmision GSM avec la correspondant state machine
                    NewDataToSendGSM = true;
                    //On ne configure pas encore le mode DATA_SEND_En_Cours parce que nous et la boue nous sommes pas pret a envoyer les donnees, cela sera fait dans la 2eme machine a etat
                    supervisorState.recordingState = Preparing_For_DATA_SEND;//DATA_SEND_En_Cours;
                    //On ne passe pas encore  l'tat AttenteDeRemontee car il faut verifier le nb de remontes par jour dans l'autre machine a tat
                    supervisorState.globalStateForBuoy = Ecoute;
                    Clock_setPeriod(Clock_handle(&TimerDebug), 200 * (1000 / Clock_tickPeriod)); //Changer periode de clignotement de la led bleu
                }
                else{
                    supervisorState.recordingState = SHUTDOWN_En_Cours;
                    supervisorState.globalStateForBuoy = Standby;
                    Clock_stop(Clock_handle(&TimerDebug));
                    GPIO_write(LED_Bleue, CONFIG_GPIO_LED_OFF);
                }

                timestampReference = GetFullTimestamp(); //On update la reference de timestamp

                //Dans tous le cas on turn off le PIC32
                if (supervisorState.recordParameters.storageTarget
                        != 2 && RecordingManagerExternalStop==false)
                {
                    //On ne met en veille que si on est en mode diffrent de USB et que le recorder n'a pas t arrt de manire externe
                    //Clock_stop(Clock_handle(&TimerSendSupervisorState));
                    #if USING_SPI
                    //Set task spi sensors in Sleep mode
                    RequestSleepTaskSPISensors();
                    #endif
                    Task_sleep(5 * (1000 / Clock_tickPeriod)); //On attend 5ms APRES ARRETER LE TIMER VIRTUEL SINON IL NE RENTRE PAS EN SLEEP MODE !!!!!!!!!!!!!!
                    Timer_stop(handleTimer_TimestampMs);
                    #if !DOING_DEBUG_PIC32
                    GPIO_write(Switch_Alim_PIC32, CONFIG_GPIO_LED_ON);
                    #endif
                    //#if !BUOY___USING_PIC24_ALWAYS_ON_FOR_UART

                    #if USING_UART_PIC32
                    Request_UART_PIC32_Cancel_Read_And_Close();
                    #endif
//                    #if USING_UART_PIC24
                    //#if !BUOY___USING_PIC24_ALWAYS_ON_FOR_UART
//                    if(USING_CNN_DETECTION == false){
//                        Clock_stop(Clock_handle(&TimerSendQHBStateToBuoy));
//                        Request_UART_PIC24_Cancel_Read_And_Close();
//                    }
//
//                    if(USING_CNN_DETECTION == false){
//                        GPIO_write(Switch_Alim_PIC24, CONFIG_GPIO_LED_OFF);
//                    //#endif
//                    }
                    //#endif
//                    #endif

                    //Une fois par cycle on check la carte SD
                    //ReadSDCard();
                    SetSleepModeConfig();
                }
            }
            break;

        case Preparing_For_DATA_SEND:
            if (GetFullTimestamp() + 1
                    >= timestampReference
                            + 1000
                                    * (supervisorState.recordParameters.DataSendDurationTimeout)) //+1 au cas o le quartz low speed soit mal calibr
            {
                //Dans cet tat on prepare le systeme pour envoyer les donnes par GSM (cela ce fait dans l'autre machine  tats) et ensuite on configure le mode DATA_SEND pour que le PIC32 nous envoie les trames a forwarder a la boue
                //Si il y a un timeout on va passer en veille et on cancele l'envoie des donnes
                supervisorState.recordingState = SHUTDOWN_En_Cours;
                supervisorState.globalStateForBuoy = Standby;
                supervisorState.transferState = WAITING_En_Cours;
                timestampReference = GetFullTimestamp(); //On update la reference de timestamp
                Clock_stop(Clock_handle(&TimerDebug));
                GPIO_write(LED_Bleue, CONFIG_GPIO_LED_OFF);

                if(supervisorState.recordParameters.storageTarget != 2 && RecordingManagerExternalStop==false)
                {
                    //On ne met en veille que si on est en mode diffrent de USB et que le recorder n'a pas t arrt de manire externe
                    Clock_stop(Clock_handle(&TimerSendSupervisorState));
                    #if USING_SPI
                    //Set task spi sensors in Sleep mode
                    RequestSleepTaskSPISensors();
                    #endif
                    Task_sleep(5 * (1000 / Clock_tickPeriod)); //On attend 5ms APRES ARRETER LE TIMER VIRTUEL SINON IL NE RENTRE PAS EN SLEEP MODE !!!!!!!!!!!!!!
                    Timer_stop(handleTimer_TimestampMs);
                    #if !DOING_DEBUG_PIC32
                    GPIO_write(Switch_Alim_PIC32, CONFIG_GPIO_LED_ON);
                    #endif
                    //#if !BUOY___USING_PIC24_ALWAYS_ON_FOR_UART
//                    if(USING_CNN_DETECTION == false){
//                        GPIO_write(Switch_Alim_PIC24, CONFIG_GPIO_LED_OFF);
//                    }
                    //#endif
                    #if USING_UART_PIC32
                    Request_UART_PIC32_Cancel_Read_And_Close();
                    #endif
//                    #if USING_UART_PIC24
//                    //#if !BUOY___USING_PIC24_ALWAYS_ON_FOR_UART
//                    if(USING_CNN_DETECTION == false){
//                        Clock_stop(Clock_handle(&TimerSendQHBStateToBuoy));
//                        Request_UART_PIC24_Cancel_Read_And_Close();
//                    }
//                    //#endif
//                    #endif

                    //Une fois par cycle on check la carte SD
                    //ReadSDCard();
                    SetSleepModeConfig();
                }

                //la configuration au mode DATA_SEND se fait dans l'autre machine  etats
            }

        case DATA_SEND_En_Cours:
            if (GetFullTimestamp() + 1
                    >= timestampReference
                            + 1000
                                    * (supervisorState.recordParameters.DataSendDurationTimeout)) //+1 au cas o le quartz low speed soit mal calibr
            {
                supervisorState.recordingState = SHUTDOWN_En_Cours;
                supervisorState.globalStateForBuoy = Standby;
                supervisorState.transferState = WAITING_En_Cours;
                timestampReference = GetFullTimestamp(); //On update la reference de timestamp
                Clock_stop(Clock_handle(&TimerDebug));
                GPIO_write(LED_Bleue, CONFIG_GPIO_LED_OFF);
                //On ferme le UART2 parce que la boue a un bug de merde et ils n'arrivent pas a initaliser le GSM... LCDSM!!!
                multiplexeur_PIC24_State_Requested.UART1State = OPEN;
                multiplexeur_PIC24_State_Requested.BaudRateUART1 = 115200;
                multiplexeur_PIC24_State_Requested.UART2State = CLOSE;
                multiplexeur_PIC24_State_Requested.BaudRateUART2 = 115200;
                multiplexeur_PIC24_State_Requested.UART3State = OPEN;
                multiplexeur_PIC24_State_Requested.BaudRateUART3 = 9600;
                TaskSupervisorTrameSenderPIC24(MLT_SET_UART2,0);
                //TaskSupervisorTrameSenderPIC24(DEMANDE_GSM_CREATION_NOUVEAU_FICHIER,0);

                if(supervisorState.recordParameters.storageTarget != 2 && RecordingManagerExternalStop==false)
                {
                    //On ne met en veille que si on est en mode diffrent de USB et que le recorder n'a pas t arrt de manire externe
                    Clock_stop(Clock_handle(&TimerSendSupervisorState));
                    #if USING_SPI
                    //Set task spi sensors in Sleep mode
                    RequestSleepTaskSPISensors();
                    #endif
                    Task_sleep(5 * (1000 / Clock_tickPeriod)); //On attend 5ms APRES ARRETER LE TIMER VIRTUEL SINON IL NE RENTRE PAS EN SLEEP MODE !!!!!!!!!!!!!!
                    Timer_stop(handleTimer_TimestampMs);
                    #if !DOING_DEBUG_PIC32
                    GPIO_write(Switch_Alim_PIC32, CONFIG_GPIO_LED_ON);
                    #endif
                    //#if !BUOY___USING_PIC24_ALWAYS_ON_FOR_UART
//                    if(USING_CNN_DETECTION == false){
//                        GPIO_write(Switch_Alim_PIC24, CONFIG_GPIO_LED_OFF);
//                    }
                    //#endif
                    #if USING_UART_PIC32
                    Request_UART_PIC32_Cancel_Read_And_Close();
                    #endif
//                    #if USING_UART_PIC24
//                    //#if !BUOY___USING_PIC24_ALWAYS_ON_FOR_UART
//                    if(USING_CNN_DETECTION == false){
//                        Clock_stop(Clock_handle(&TimerSendQHBStateToBuoy));
//                        Request_UART_PIC24_Cancel_Read_And_Close();
//                    }
//                    //#endif
//                    #endif

                    //Une fois par cycle on check la carte SD
                    //ReadSDCard();
                    SetSleepModeConfig();
                }
            }
            break;

        case DATA_SEND_Finished:
            if (GetFullTimestamp() + 1
                    >= timestampReference
                            + 1000
                                    * (supervisorState.recordParameters.DataSendDurationTimeout)) //+1 au cas o le quartz low speed soit mal calibr
            {
                supervisorState.recordingState = SHUTDOWN_En_Cours;
                supervisorState.globalStateForBuoy = Standby;
                supervisorState.transferState = WAITING_En_Cours;
                timestampReference = GetFullTimestamp(); //On update la reference de timestamp
                Clock_stop(Clock_handle(&TimerDebug));
                GPIO_write(LED_Bleue, CONFIG_GPIO_LED_OFF);
                //On ferme le UART2 parce que la boue a un bug de merde et ils n'arrivent pas a initaliser le GSM... LCDSM!!!
                multiplexeur_PIC24_State_Requested.UART1State = OPEN;
                multiplexeur_PIC24_State_Requested.BaudRateUART1 = 115200;
                multiplexeur_PIC24_State_Requested.UART2State = CLOSE;
                multiplexeur_PIC24_State_Requested.BaudRateUART2 = 115200;
                multiplexeur_PIC24_State_Requested.UART3State = OPEN;
                multiplexeur_PIC24_State_Requested.BaudRateUART3 = 9600;
                TaskSupervisorTrameSenderPIC24(MLT_SET_UART2,0);

                if(supervisorState.recordParameters.storageTarget != 2 && RecordingManagerExternalStop==false)
                {
                    //On ne met en veille que si on est en mode diffrent de USB et que le recorder n'a pas t arrt de manire externe
                    Clock_stop(Clock_handle(&TimerSendSupervisorState));
                    #if USING_SPI
                    //Set task spi sensors in Sleep mode
                    RequestSleepTaskSPISensors();
                    #endif
                    Task_sleep(5 * (1000 / Clock_tickPeriod)); //On attend 5ms APRES ARRETER LE TIMER VIRTUEL SINON IL NE RENTRE PAS EN SLEEP MODE !!!!!!!!!!!!!!
                    Timer_stop(handleTimer_TimestampMs);
                    #if !DOING_DEBUG_PIC32
                    GPIO_write(Switch_Alim_PIC32, CONFIG_GPIO_LED_ON);
                    #endif
                    //#if !BUOY___USING_PIC24_ALWAYS_ON_FOR_UART
//                    if(USING_CNN_DETECTION == false){
//                        GPIO_write(Switch_Alim_PIC24, CONFIG_GPIO_LED_OFF);
//                    }
                    //#endif
                    #if USING_UART_PIC32
                    Request_UART_PIC32_Cancel_Read_And_Close();
                    #endif
                    #if USING_UART_PIC24
                    //#if !BUOY___USING_PIC24_ALWAYS_ON_FOR_UART
//                    if(USING_CNN_DETECTION == false){
//                        Clock_stop(Clock_handle(&TimerSendQHBStateToBuoy));
//                        Request_UART_PIC24_Cancel_Read_And_Close();
//                    }
                    //#endif
                    #endif

                    //Une fois par cycle on check la carte SD
                    //ReadSDCard();
                    SetSleepModeConfig();
                }
            }
            break;


        default:
            supervisorState.recordingState = SHUTDOWN_En_Cours;
            break;
    }
}



/******************************* State Machine Buoy and GSM *****************************************
 *******************************   (Only for GIAS project)  *****************************************/
uint32_t timestampReferenceRemontee = 0;
void CheckTimeOutRemontee(void){
    if (GetFullTimestamp() + 1
            >= timestampReferenceRemontee
                    + 1000
                            * (supervisorState.recordParameters.TimeOutRemontee)) //+1 au cas o le quartz low speed soit mal calibr
    {
        timestampReferenceRemontee = GetFullTimestamp();
    }

}

void ConfigureSleepModeGIAS(void){
    //On ferme le UART2 parce que la boue a un bug!!!
    multiplexeur_PIC24_State_Requested.UART1State = OPEN;
    multiplexeur_PIC24_State_Requested.BaudRateUART1 = 115200;
    multiplexeur_PIC24_State_Requested.UART2State = CLOSE;
    multiplexeur_PIC24_State_Requested.BaudRateUART2 = 115200;
    multiplexeur_PIC24_State_Requested.UART3State = OPEN;
    multiplexeur_PIC24_State_Requested.BaudRateUART3 = 9600;
    TaskSupervisorTrameSenderPIC24(MLT_SET_UART2,0);
    timestampReference = GetFullTimestamp(); //On update la reference de timestamp
    //On ne met en veille que si on est en mode diffrent de USB et que le recorder n'a pas t arrt de manire externe
    Clock_stop(Clock_handle(&TimerSendSupervisorState));
    #if USING_SPI
    //Set task spi sensors in Sleep mode
    RequestSleepTaskSPISensors();
    #endif
    Task_sleep(5 * (1000 / Clock_tickPeriod)); //On attend 5ms APRES ARRETER LE TIMER VIRTUEL SINON IL NE RENTRE PAS EN SLEEP MODE !!!!!!!!!!!!!!
    Timer_stop(handleTimer_TimestampMs);
    #if !DOING_DEBUG_PIC32
    GPIO_write(Switch_Alim_PIC32, CONFIG_GPIO_LED_ON);
    #endif
    #if USING_UART_PIC32
    Request_UART_PIC32_Cancel_Read_And_Close();
    #endif
    supervisorState.recordingState = SHUTDOWN_En_Cours;
    supervisorState.globalStateForBuoy = Standby;
    supervisorState.transferState = WAITING_En_Cours;
}

void ManagerBuoyAndGSMSystem(void)
{
    switch (supervisorState.transferState)
    {
        case WAITING_En_Cours:
            //On attend un timeout ou des detections a transmettre
            if(NewDataToSendGSM)
            {
                NewDataToSendGSM = false;
                //Si nous avons une nouvelle data pour tx on check le nb de remontes ajdhui
                if(supervisorState.nbRemontesAujdhui < supervisorState.recordParameters.nbRemontesParJour){
                    //Dans le cas o on est inferieur a nbRemontesParJour on va passer  l'tat de demande de remont et demande du canal GSM
                    supervisorState.nbRemontesAujdhui++;
                    supervisorState.transferState = DEMANDE_REMONTE_ET_OUVERTURE_GSM_En_Cours;
                    //--------------Debug-------------------------------------------
                    #if USING_UART_PIC32
                    Request_UART_PIC32_Open_And_Read();
                    #endif
                    GPIO_write(Switch_Alim_PIC32, CONFIG_GPIO_LED_OFF);
                    Clock_start(Clock_handle(&TimerSendSupervisorState));

                    multiplexeur_PIC24_State_Requested.UART1State = OPEN;
                    multiplexeur_PIC24_State_Requested.BaudRateUART1 = 115200;
                    multiplexeur_PIC24_State_Requested.UART2State = CLOSE;
                    multiplexeur_PIC24_State_Requested.BaudRateUART2 = 115200;
                    multiplexeur_PIC24_State_Requested.UART3State = OPEN;
                    multiplexeur_PIC24_State_Requested.BaudRateUART3 = 9600;
                    TaskSupervisorTrameSenderPIC24(MLT_SET_UART2,0);

                    //supervisorState.transferState = DEMANDE_DATA_GSM_AU_PIC32_En_Cours;
                    //--------------Debug-------------------------------------------
                    if(buoyState.currentBuoyPosition != Position_Haut)
                        supervisorState.globalStateForBuoy = AttenteDeRemontee;

                    Clock_setPeriod(Clock_handle(&TimerDebug), 30 * (1000 / Clock_tickPeriod)); //Changer periode de clignotement de la led bleu
                }
                else{
                    ConfigureSleepModeGIAS();
                }

            }
            break;

        case DEMANDE_REMONTE_ET_OUVERTURE_GSM_En_Cours:
                //dans cet tat on demande l'apperture du canal en envoyant AttenteDeRemontee
                supervisorState.transferState = WAITING_FOR_GSM_READY_En_Cours;
                //if(buoyState.currentBuoyPosition != Position_Haut)//TODO verifier avec OSEAN
                supervisorState.globalStateForBuoy = AttenteDeRemontee;

                multiplexeur_PIC24_State_Requested.UART1State = OPEN;
                multiplexeur_PIC24_State_Requested.BaudRateUART1 = 115200;
                multiplexeur_PIC24_State_Requested.UART2State = CLOSE;
                multiplexeur_PIC24_State_Requested.BaudRateUART2 = 115200;
                multiplexeur_PIC24_State_Requested.UART3State = OPEN;
                multiplexeur_PIC24_State_Requested.BaudRateUART3 = 9600;
                TaskSupervisorTrameSenderPIC24(MLT_SET_UART2,0);

            break;

        case WAITING_FOR_GSM_READY_En_Cours:
                //Quand le canal GSM est disponible on passe a l'tat de demande de donnes au PIC32
            if(buoyState.currentGSMState == Disponible)
            {
                //On demande l'ouverture des que la boue nous autorise  utiliser le GSM
                multiplexeur_PIC24_State_Requested.UART1State = OPEN;
                multiplexeur_PIC24_State_Requested.BaudRateUART1 = 115200;
                multiplexeur_PIC24_State_Requested.UART2State = OPEN;
                multiplexeur_PIC24_State_Requested.BaudRateUART2 = 115200;
                multiplexeur_PIC24_State_Requested.UART3State = OPEN;
                multiplexeur_PIC24_State_Requested.BaudRateUART3 = 9600;
                TaskSupervisorTrameSenderPIC24(MLT_SET_UART2,0);
                Task_sleep(15 * (1000 / Clock_tickPeriod));
                if(supervisorState.multiplexeur_PIC24_State.UART2State == OPEN)
                {
                    RapportSentOkGSM = false;
                    //TaskSupervisorTrameSenderPIC24(DEMANDE_GSM_CREATION_NOUVEAU_FICHIER,0);
                    FinalTrameToGSMForwarded = false;
                    supervisorState.recordingState = DATA_SEND_En_Cours;
                    supervisorState.transferState = DEMANDE_DATA_GSM_AU_PIC32_En_Cours;
                    supervisorState.globalStateForBuoy = TransfertDesDonneesVersLeModem;
                    Clock_setPeriod(Clock_handle(&TimerDebug), 60 * (1000 / Clock_tickPeriod)); //Changer periode de clignotement de la led bleu
                }
                else{
                    TaskSupervisorTrameSenderPIC24(MLT_SET_UART2,0);
                }
            }
            break;

        case DEMANDE_DATA_GSM_AU_PIC32_En_Cours:
            //Clock_stop(Clock_handle(&TimerSendSupervisorState));
            //Quand le PIC32 finisse l'envoie des donnes il va changer son etat
            if(FinalTrameToGSMForwarded == true)//RecorderStatePIC32 != DataSend)
            {
                FinalTrameToGSMForwarded = false;
                if(RapportSentOkGSM == true){
                    ConfigureSleepModeGIAS();
                    supervisorState.recordingState = SHUTDOWN_En_Cours;
                    supervisorState.transferState = WAITING_En_Cours;
                    supervisorState.globalStateForBuoy = Standby;
                    timestampReference = GetFullTimestamp(); //On update la reference de timestamp
                    Clock_stop(Clock_handle(&TimerDebug));
                    GPIO_write(LED_Bleue, CONFIG_GPIO_LED_OFF);
                    //supervisorState.recordingState = SHUTDOWN_En_Cours;
                    //Aprs finalisser l'envoie des donnes on returne au mode standby pour que la boue envoie les donnees par GSM
                    //supervisorState.transferState = FERMETURE_GSM_En_Cours;
                    //supervisorState.globalStateForBuoy = TransfertDesDonneesVersLeModem;
                    //Clock_setPeriod(Clock_handle(&TimerDebug), 90 * (1000 / Clock_tickPeriod)); //Changer periode de clignotement de la led bleu
                }
                else{
                    //Si nous n'avons pas reu l'OK du Modem on check le nb d'octets envoys et le nb d'octets  envoyer
                    for(uint8_t iterationsTransfer = 0; iterationsTransfer < 100; iterationsTransfer++){
                        if((OctetsTransferred < (OctetsToTransfer + 20000)) &&
                                (supervisorState.transferState == DEMANDE_DATA_GSM_AU_PIC32_En_Cours) &&
                                (buoyState.currentGSMState == Disponible)){
                            TaskSupervisorTrameSenderPIC24(GSM_DATA_TO_FORWARD,0);
                            Task_sleep(3 * (1000 / Clock_tickPeriod)); //On attend 3ms
                            if(RapportSentOkGSM == true){
                                RapportSentOkGSM = false;
                                break;
                            }
                        }
                        else{
                            break;
                        }
                    }

                    ConfigureSleepModeGIAS();
                    supervisorState.recordingState = SHUTDOWN_En_Cours;
                    supervisorState.transferState = WAITING_En_Cours;
                    supervisorState.globalStateForBuoy = Standby;
                    timestampReference = GetFullTimestamp(); //On update la reference de timestamp
                    Clock_stop(Clock_handle(&TimerDebug));
                    GPIO_write(LED_Bleue, CONFIG_GPIO_LED_OFF);
                    //Aprs remplir de zeros si on reoit ou pas l'OK du modem on passe de toute faon en veille
                    //supervisorState.recordingState = SHUTDOWN_En_Cours;
                    //Aprs finalisser l'envoie des donnes on returne au mode standby pour que la boue envoie les donnees par GSM
                    //supervisorState.transferState = FERMETURE_GSM_En_Cours;
                    //supervisorState.globalStateForBuoy = TransfertDesDonneesVersLeModem;
                    //Clock_setPeriod(Clock_handle(&TimerDebug), 90 * (1000 / Clock_tickPeriod)); //Changer periode de clignotement de la led bleu
                }
            }
            if(buoyState.currentGSMState != Disponible)
            {
                ConfigureSleepModeGIAS();
                supervisorState.recordingState = SHUTDOWN_En_Cours;
                supervisorState.transferState = WAITING_En_Cours;
                supervisorState.globalStateForBuoy = Standby;
                timestampReference = GetFullTimestamp(); //On update la reference de timestamp
                Clock_stop(Clock_handle(&TimerDebug));
                GPIO_write(LED_Bleue, CONFIG_GPIO_LED_OFF);

                //Aprs finalisser l'envoie des donnes on returne au mode standby pour que la boue envoie les donnees par GSM
                //supervisorState.transferState = FERMETURE_GSM_En_Cours;
                //supervisorState.globalStateForBuoy = TransfertDesDonneesVersLeModem;
                //Clock_setPeriod(Clock_handle(&TimerDebug), 90 * (1000 / Clock_tickPeriod)); //Changer periode de clignotement de la led bleu
            }
            break;

        case FERMETURE_GSM_En_Cours:
                supervisorState.transferState = SEND_DATA_GSM_et_REDESCENTE_En_Cours;
                supervisorState.globalStateForBuoy = TransfertDesDonneesVersLeModem;

            break;

        case SEND_DATA_GSM_et_REDESCENTE_En_Cours:

            if(buoyState.currentBuoyNoise == NoNoise && buoyState.currentBuoyPosition == Position_Bas){
                //supervisorState.transferState = BOUEE_EN_BAS_PAS_DE_BRUIT__En_Cours;
                //supervisorState.globalStateForBuoy = Standby;
                Clock_setPeriod(Clock_handle(&TimerDebug), 150 * (1000 / Clock_tickPeriod)); //Changer periode de clignotement de la led bleu
            }
            break;

        case BOUEE_EN_BAS_PAS_DE_BRUIT__En_Cours:
                supervisorState.transferState = WAITING_En_Cours;
                supervisorState.globalStateForBuoy = Standby;
                supervisorState.recordingState = SHUTDOWN_En_Cours;
                timestampReference = GetFullTimestamp(); //On update la reference de timestamp
                Clock_stop(Clock_handle(&TimerDebug));
                GPIO_write(LED_Bleue, CONFIG_GPIO_LED_OFF);
            break;

        default:
            supervisorState.transferState = WAITING_En_Cours;
            break;
    }
}


/******************************* Task functions ***************************************************/

void Supervisor_CreateTask(void){

    Error_Block eb;

    Task_Params taskParams;

    // Configure task
    Task_Params_init(&taskParams);
    taskParams.stack = SupervisorTaskStack;
    taskParams.stackSize = SUPERVISOR_TASK_STACK_SIZE;
    taskParams.priority = SUPERVISOR_TASK_PRIORITY;

    Task_construct(&SupervisorTask, Supervisor_taskFxn, &taskParams, NULL);

    /*Create an Event object. All events are binary*/
    Error_init(&eb);
    TaskSupervisorEvent = Event_create(NULL, &eb);
    if(TaskSupervisorEvent == NULL){
        System_abort("Event create failed");
        while(1);
    }

      // Initialize the SCIF operating system abstraction layer
      scifOsalInit();
      scifOsalRegisterCtrlReadyCallback(scCtrlReadyCallback);
      scifOsalRegisterTaskAlertCallback(scTaskAlertCallback);
      // Initialize the SCIF driver
      scifInit(&scifDriverSetup);

    #if Debug
      Clock_Params clockParamsTimerDebug;
      Clock_Params_init(&clockParamsTimerDebug);
      clockParamsTimerDebug.period = 100 * (1000/Clock_tickPeriod), //20 milliseconds
      Clock_construct(&TimerDebug, TimerDebugFxn,
                      100 * (1000/Clock_tickPeriod), // Initial delay before first timeout
                      &clockParamsTimerDebug);

      Clock_Params clockParamsTimerSendQHBStateToBuoy;
      Clock_Params_init(&clockParamsTimerSendQHBStateToBuoy);
      clockParamsTimerSendQHBStateToBuoy.period = 1000 * (1000/Clock_tickPeriod), //1000 milliseconds
      Clock_construct(&TimerSendQHBStateToBuoy, TimerSendQHBStateToBuoyFxn,
                      1000 * (1000/Clock_tickPeriod), // Initial delay before first timeout
                      &clockParamsTimerSendQHBStateToBuoy);

      Clock_Params clockParamsTimerSendSupervisorState;
      Clock_Params_init(&clockParamsTimerSendSupervisorState);
      clockParamsTimerSendSupervisorState.period = 100 * (1000/Clock_tickPeriod), //20 milliseconds
      Clock_construct(&TimerSendSupervisorState, TimerSendSupervisorStateFxn,
                      100 * (1000/Clock_tickPeriod), // Initial delay before first timeout
                      &clockParamsTimerSendSupervisorState);


    #endif

}

static void Supervisor_taskFxn(UArg a0, UArg a1)
{
    // Dans cette version on n'attend pas l'init du systeme de fichiers de facon de pouvoir envoyer
    // des trames quand on n'a pas la sd (c'est le mode USB, meme s'il n'y a pas de carte sd la flag va passer a true)
    //On attend l'initialisation du systeme de fichiers
    #if USING_SD && USING_SPI && USING_UART_PIC24 && USING_UART_PIC32
    while(SdFileSystemInitDone == false || UARTisOpen == false || SPIInitOk == false || UARTPIC24isOpen == false){
    //while(UARTisOpen == false || SPIInitOk == false || UARTPIC24isOpen == false){
    #elif USING_SD && USING_SPI && USING_UART_PIC24
//     while(SdFileSystemInitDone == false ||  SPIInitOk == false || UARTPIC24isOpen == false){
       while(SPIInitOk == false || UARTPIC24isOpen == false){
    #elif USING_SD && USING_SPI && USING_UART_PIC32
//     while(SdFileSystemInitDone == false ||  SPIInitOk == false || UARTisOpen == false){
       while(SPIInitOk == false || UARTisOpen == false){
    #elif USING_SD && USING_SPI
//     while(SdFileSystemInitDone == false ||  SPIInitOk == false){
       while(SPIInitOk == false){
    #elif USING_SD
//     while(SdFileSystemInitDone == false){
       while(false){
    #endif

        Task_sleep(1000 * (1000 / Clock_tickPeriod)); //On attend 100ms
    }

    #if DOING_TEST_SLEEP_MODE
    //Default init, this values are read in the sd card
    supervisorState.recordParameters.preparingDuration = 1;
    supervisorState.recordParameters.recordingDuration = 1;
    supervisorState.recordParameters.stoppingDuration = 1;
    supervisorState.recordParameters.shutdownDuration = 3;
    #endif

    //First state Initializing for init the others tasks
    supervisorState.currentState = RUNNING;
    supervisorState.recordingState = SHUTDOWN_En_Cours;
    supervisorState.globalStateForBuoy = Standby;
    supervisorState.nbRemontesAujdhui = 0;

//    GPIO_write(Switch_Alim_PIC24, CONFIG_GPIO_LED_ON);
//    Request_UART_PIC24_Open_And_Read();
//    Task_sleep(1000 * (1000 / Clock_tickPeriod)); //On attend 100ms
    //On set UART2  0 parce qu'aprs faut attendre qu'elle soit ouverte
    supervisorState.multiplexeur_PIC24_State.UART1State = OPEN;
    supervisorState.multiplexeur_PIC24_State.UART2State = CLOSE;
    supervisorState.multiplexeur_PIC24_State.UART3State = OPEN;

    //On ferme le UART2 parce que la boue a un bug et ils n'arrivent pas a initaliser le GSM...
    multiplexeur_PIC24_State_Requested.UART1State = OPEN;
    multiplexeur_PIC24_State_Requested.BaudRateUART1 = 115200;
    multiplexeur_PIC24_State_Requested.UART2State = CLOSE;
    multiplexeur_PIC24_State_Requested.BaudRateUART2 = 115200;
    multiplexeur_PIC24_State_Requested.UART3State = OPEN;
    multiplexeur_PIC24_State_Requested.BaudRateUART3 = 9600;
    TaskSupervisorTrameSenderPIC24(MLT_SET_UART2,0);

    if(supervisorState.recordParameters.useAutoStart)
        Clock_start(Clock_handle(&TimerDebug));

    //Si on est en config de la boue, on va attendre qu'elle nous envoie pas de bruit et parking
    if(USING_CNN_DETECTION == true){
        //On initialise les variables de la boue de faon d'attendre qu'elle nous envoie PARKING (Position_bas) et NO NOISE
        buoyState.currentBuoyNoise = Noise;
        buoyState.currentBuoyPosition = Position_Haut;
        //On demmare le timer pour envoyer des message de demande d'tat a la boue
        Clock_start(Clock_handle(&TimerSendQHBStateToBuoy));
        //Turn Off PIC32
        GPIO_write(Switch_Alim_PIC32, CONFIG_GPIO_LED_ON);

        #if USING_SPI
        //Set task spi sensors in Sleep mode
        RequestSleepTaskSPISensors();
        #endif

        #if USING_UART_PIC32
        Request_UART_PIC32_Cancel_Read_And_Close();
        #endif

        while((buoyState.currentBuoyNoise != NoNoise) || (buoyState.currentBuoyPosition != Position_Bas)){
            Task_sleep(1000 * (1000 / Clock_tickPeriod)); //On attend 1s
            Clock_stop(Clock_handle(&TimerDebug));
            //buoyState.currentBuoyNoise = NoNoise;
            //buoyState.currentBuoyPosition = Position_Bas;
        }
        Clock_start(Clock_handle(&TimerDebug));
        #if USING_SPI
        //Wake up task spi sensors
        RequestWakeUpTaskSPISensors();
        #endif
        #if USING_UART_PIC32
        Request_UART_PIC32_Open_And_Read();
        #endif
        //Turn On PIC32
        GPIO_write(Switch_Alim_PIC32, CONFIG_GPIO_LED_OFF);
    }
    else{
        buoyState.currentBuoyNoise = NoNoise;
        buoyState.currentBuoyPosition = Position_Bas;
    }

    InitTimer_TimestampMs();

    TimeToStartRegistering = MCP79522DateAddInterval(
         &supervisorState.localTime,
         supervisorState.recordParameters.preparingDuration);

    //First state Initializing for init the others tasks
    supervisorState.currentState = RUNNING;
    supervisorState.recordingState = PREPARING_En_Cours;
    supervisorState.globalStateForBuoy = Ecoute;
    supervisorState.nbRemontesAujdhui = 0;

    Clock_start(Clock_handle(&TimerSendSupervisorState));


    #if WATCHDOG
    Watchdog_init();
    Watchdog_Params_init(&params);
    params.resetMode = Watchdog_RESET_ON;
    //params.callbackFxn = (Watchdog_Callback) UserCallbackFxn;
    watchdogHandle = Watchdog_open(CONFIG_WATCHDOG_0, &params);
    if (watchdogHandle == NULL) {
       // Error opening Watchdog
       while (1);
    }
    #endif

    //periode en Seconds des interrupts du sensor controller
    scifTaskData.timestapIntGenerator.input.sensorControllerPeriodIRQSeconds = 1;
    // Start the "Analog Light Sensor" Sensor Controller task
    scifStartTasksNbl(1 << SCIF_TIMESTAP_INT_GENERATOR_TASK_ID);

    UInt events;

    // Application main loop
    while(1){
        events = Event_pend(TaskSupervisorEvent, Event_Id_NONE, Sensor_Controller_Event,
                            //500 * (1000/Clock_tickPeriod));
                            BIOS_WAIT_FOREVER);
        //GPIO_write(INT_UART1, CONFIG_GPIO_LED_ON);
        if(events & Sensor_Controller_Event){


            //Evnement en provenance du Sensor Controller
            //Arrive normalement toutes les 1 secondes
            #if WATCHDOG
                 Watchdog_clear(watchdogHandle);
            #endif
            //Reset du timestamp milliseconde
            ResetTimestampMillisecond();
            timestampSecond++; //On incrmente le timestamp seconds

            if(supervisorState.recordParameters.useAutoStart){
                ManagerRecordingSystem();
                if(USING_CNN_DETECTION == true){
                    ManagerBuoyAndGSMSystem();
                    //CheckTimeOutRemontee();
                }
            }

            if(firstHourControl_HeureDeDemmarrage == false){
                //On enregistre l'heure de demmarage
                firstHourControl_HeureDeDemmarrage = true;
                HeureDeDemmarrage = supervisorState.localTime;
                //l'heure de control est toutes les 24h (1 fois par jour)
                HeureDeControl = MCP79522DateAddInterval(&HeureDeDemmarrage , 86400);
            }
            else{
                if(MCP79522IsDatePassed2(&HeureDeControl, &supervisorState.localTime)){
                    //S'il est pass un jour, on enregistre un nouvelle heure de control et on reset les parametres qu'on a besoin
                    HeureDeControl = MCP79522DateAddInterval(&supervisorState.localTime , 86400);

                    supervisorState.nbRemontesAujdhui = 0;
                }
            }

            #if USING_SPI
                RequestRTCCRead();
            #endif

            if(supervisorState.recordingState != SHUTDOWN_En_Cours){
                #if USING_SD
                    RequestSdOperation();
                #endif
            }

#if 0 //Test envoie des donns au GSM
            if(buoyState.currentGSMState == Disponible){
                //On demande l'ouverture des que la boue nous autorise  utiliser le GSM
                multiplexeur_PIC24_State_Requested.UART1State = OPEN;
                multiplexeur_PIC24_State_Requested.BaudRateUART1 = 115200;
                multiplexeur_PIC24_State_Requested.UART2State = OPEN;
                multiplexeur_PIC24_State_Requested.BaudRateUART2 = 115200;
                multiplexeur_PIC24_State_Requested.UART3State = OPEN;
                multiplexeur_PIC24_State_Requested.BaudRateUART3 = 9600;
                TaskSupervisorTrameSenderPIC24(MLT_SET_UART2,0);

                if(supervisorState.multiplexeur_PIC24_State.UART2State == OPEN)
                    TaskSupervisorTrameSenderPIC24(DEMANDE_GSM_CREATION_NOUVEAU_FICHIER,0);
            }
#endif
            //TaskSupervisorTrameSender(SUPERVISOR_STATE);

        }
        //GPIO_write(INT_UART1, CONFIG_GPIO_LED_OFF);
    }
}

void ExternalStartStopManager(void){

    if(supervisorState.recordParameters.useAutoStart){
        //On inverse l'tat actif/pause du recording manager
        RecordingManagerExternalStop = !RecordingManagerExternalStop;

        //Si on est en recording au moment de l'arrive du message start/stop
        //On arrte l'enregistrement
        if(supervisorState.recordingState == RECORDING_En_Cours){
            RecordingManagerExternalStop = true;
            TaskSupervisorTrameSenderPIC24(MLT_SET_LED,1);
            timestampReference = GetFullTimestamp();
            supervisorState.recordingState = STOPPING_En_Cours;
        }
        else
        {
            RecordingManagerExternalStop = false;
            TaskSupervisorTrameSenderPIC24(MLT_SET_LED,0);
            //On demarre le timer de la LED
            Clock_start(Clock_handle(&TimerDebug));
            timestampReference = GetFullTimestamp();
            supervisorState.recordingState =  RECORDING_En_Cours;
        }
    }
    else{
        supervisorState.recordParameters.useAutoStart = true;
        Clock_start(Clock_handle(&TimerDebug));
    }
}

void USBStartStopManager(uint16_t startStop){

    if(supervisorState.recordParameters.useAutoStart){
        //On inverse l'tat actif/pause du recording manager
        RecordingManagerExternalStop = !startStop;//!RecordingManagerExternalStop;

        //Si on est en recording au moment de l'arrive du message start/stop
        //On arrte l'enregistrement
        if(startStop){
            RecordingManagerExternalStop = false;
            TaskSupervisorTrameSenderPIC24(MLT_SET_LED,0);
            //On demarre le timer de la LED
            Clock_start(Clock_handle(&TimerDebug));
            timestampReference = GetFullTimestamp();
            supervisorState.recordingState =  RECORDING_En_Cours;
        }
        else
        {
            RecordingManagerExternalStop = true;
            TaskSupervisorTrameSenderPIC24(MLT_SET_LED,1);
            timestampReference = GetFullTimestamp();
            supervisorState.recordingState = STOPPING_En_Cours;
        }

    }
    else{
        supervisorState.recordParameters.useAutoStart = true;
        Clock_start(Clock_handle(&TimerDebug));
    }
}

void Bouton1Appuye(void){
    ExternalStartStopManager();
}

void Bouton2Appuye(void){

}
void Bouton3Appuye(void){

}
