/*
 * Task_Supervisor.H
 *
 *  Created on: 7 mai 2021
 *      Author: sebas
 */

#ifndef TASK_SUPERVISOR_TASK_SUPERVISOR_H_
#define TASK_SUPERVISOR_TASK_SUPERVISOR_H_

#include <ti/sysbios/knl/Event.h>
#include "Task_SPI/MCP79522/UTLN_MCP79522.h"
#include <stdbool.h>
#include <stdint.h>
#define Sensor_Controller_Event                 Event_Id_01

void Supervisor_CreateTask(void);
static void Supervisor_taskFxn(UArg a0, UArg a1);
void TaskSupervisorTrameSender(uint16_t trameID);
void TaskSupervisorTrameSenderPIC24(uint16_t trameID, uint8_t LED_Blanche);
uint32_t GetFullTimestamp(void);
void Bouton1Appuye(void);
void USBStartStopManager(uint16_t startStop);
void Bouton2Appuye(void);
void Bouton3Appuye(void);

typedef struct RECORDPARAMETERS{
    //Parameters to be transmitted
    int resolution;
    long samplingFrequency;
    int filterSelection;
    int nbChannelsUsed;
    int storageTarget;
    long fileSize;
    int usePPS;
    //Local Parameters
    bool useAutoStart;
    bool recordUseTimeInterval;

    float recordingDuration;
    float shutdownDuration;
    float preparingDuration;
    float stoppingDuration;
    float DetectionCNNDurationTimeout;
    float DataSendDurationTimeout;
    float TimeOutRemontee;

    int nbRemontesParJour;
}recordParameters;


typedef struct{
    uint8_t Type;                                       //type du peripherique (0x01 accel, 0x02 gyro, 0x03 magneto, 0x04 temperature, 0x05 pressure, 0x06 light,...)
    uint8_t ID;                                         //ID du peripherique
    uint8_t Range;                                      //Range de la mesure (ex: 2G, 4G, 6G, 8G, 16G pour un accel)
    uint8_t Resolution;                                 //Resolution de mesure du peripherique
    uint16_t Frequency;                                  //Frequence d'echantillonage du peripherique
}PeripheralConfiguration;

typedef enum STATESUPERVISOR
{
    INITIALISATION,
    RUNNING,
}   StateSupervisor;

typedef enum REC_STATE
{
    SHUTDOWN_En_Cours = 0,
    PREPARING_En_Cours,
    RECORDING_En_Cours,
    STOPPING_En_Cours,
    CNN_DETECTION_En_Cours,
    DATA_SEND_En_Cours,
    Preparing_For_DATA_SEND, // Cet etat vient avant DATA_SEND_En_Cours et aprs CNN_DETECTION_En_Cours
    DATA_SEND_Finished,
} RecordingState;

typedef enum TRANSFER_STATE
{
    WAITING_En_Cours = 0,
    DEMANDE_REMONTE_ET_OUVERTURE_GSM_En_Cours,
    WAITING_FOR_GSM_READY_En_Cours,
    DEMANDE_DATA_GSM_AU_PIC32_En_Cours,
    FERMETURE_GSM_En_Cours,
    SEND_DATA_GSM_et_REDESCENTE_En_Cours,
    BOUEE_EN_BAS_PAS_DE_BRUIT__En_Cours,
} TransferState;

typedef enum PIC32_REC_STATE
{
    Init = 0,
    WaitForStorage,
    ReadyToStart,
    Recording,
    FlushingDDRToFS,
    AnalyseCNN,
    DataSend,
    ReadyToTurnOff,
    Error,
} PIC32_RecorderState;

typedef enum QHB_STATE_FOR_BUOY
{
    Standby = 0,
    Ecoute,
    AttenteDeRemontee,
    TransfertDesDonneesVersLeModem,
} QHB_GlobalStateForBuoy;

typedef enum UART_MULT_PIC24_STATE
{
    CLOSE = 0,
    OPEN,
} UART_MULTIPLEXEUR_PIC24_State;

typedef struct MULT_PIC24_STATE{
    //UART
    UART_MULTIPLEXEUR_PIC24_State   UART1State;
    uint32_t                        BaudRateUART1;
    UART_MULTIPLEXEUR_PIC24_State   UART2State;
    uint32_t                        BaudRateUART2;
    UART_MULTIPLEXEUR_PIC24_State   UART3State;
    uint32_t                        BaudRateUART3;
    //Voltage Battery (mV)
    uint16_t                        BattVoltage;
    //Analog inputs (mV)
    uint16_t                        Ana_1Voltage;
    uint16_t                        Ana_2Voltage;
    uint16_t                        Ana_3Voltage;
    //Led
    bool                            LED_Blanche_State;
} MULTIPLEXEUR_PIC24_State;


typedef struct SUPERVISORSTATE{
    //Etat de la tache Supervisor
    StateSupervisor                 currentState;
    //Etat de la transfert de donnes
    TransferState                   transferState;
    //Etat global de QHB pour envoyer a la boue
    QHB_GlobalStateForBuoy          globalStateForBuoy;
    RecordingState                  recordingState;
    recordParameters                recordParameters;
    RtccDateTime                    localTime;
    PeripheralConfiguration         peripheralConfig[10];
    uint8_t                         nbRemontesAujdhui;
    //Etat du multiplexeur PIC24
    MULTIPLEXEUR_PIC24_State        multiplexeur_PIC24_State;
} SupervisorState;


typedef enum BUOY_POSITION
{
    Position_Haut = 0,
    Position_Bas,
    Remontee_En_Cours,
    Descente_En_Cours,
} BuoyPosition;

typedef enum BUOY_NOISE
{
    NoNoise = 0,
    Noise,
} BuoyNoise;

typedef enum ETAT_CANAL_GSM
{
    NonUtilisable = 0,
    Disponible,
    UtiliseBuoyEnCours,
    ErreurReseau,
} EtatCanalGSM;

typedef struct BUOYSTATE{
    BuoyPosition                 currentBuoyPosition;
    BuoyNoise                    currentBuoyNoise;
    EtatCanalGSM                 currentGSMState;
    uint32_t                     pressionBuoy;
} BuoyState;


#endif /* TASK_SUPERVISOR_TASK_SUPERVISOR_H_ */
