/*
 * MsgProcessor_PIC24.c
 *
 *  Created on: 12 mai 2021
 *      Author: TP-EO-6
 */

#include <stdio.h>
#include <stdint.h>
#include <stdlib.h>
#include <string.h>
#include "Macros/Define.h"
#include <ti/sysbios/knl/Semaphore.h>

#include <ti/sysbios/knl/Task.h>
#include <ti/sysbios/hal/Hwi.h>

#include <ti/ble5stack/hal/src/inc/hal_defs.h>
#include <ti/drivers/UART.h>
#include <ti/drivers/GPIO.h>

#include "ti_drivers_config.h"
#include "hal_types.h"
#include "hal_defs.h"

#include "Macros/Protocol.h"

#include <Task_UART_PIC24/Task_UART_PIC24.h>
#include <Task_UART_PIC24/UART_Driver_PIC24.h>
#include <Task_UART_PIC24/MsgProcessor_PIC24.h>
#include <Task_Supervisor/Task_Supervisor.h>

ProcessorMessageStatePIC24 rxReceptionStatePIC24 = RECEPTION_WAIT_PIC24;
uint16_t rxReceivedFunctionPIC24;
uint16_t rxReceivedPayloadPIC24LengthPIC24;
uint8_t rxReceivedPayloadPIC24[UART_MSG_MAX_SIZE];
uint16_t rxReceivedPayloadPIC24Index = 0;
uint16_t rxErrorCountPIC24=0;
extern uint8_t rxBuf_PIC24[];   // Receive buffer
uint8_t outPayloadPIC24[UART_MSG_MAX_SIZE];
//extern AppData appData;
extern SupervisorState supervisorState;
extern MULTIPLEXEUR_PIC24_State    multiplexeur_PIC24_State_Requested;
extern BuoyState buoyState;
extern UART_Handle uart_PIC24;
extern bool UARTPIC24isOpen;
extern bool RapportSentOkGSM;
uint8_t UartCalculateChecksumPIC24(uint16_t msgFunction,
      uint16_t msgPayloadLength, uint8_t * msgPayload)
{
    uint8_t checksum = 0x00;
    uint16_t i = 0;
    checksum ^= 0xFE;
    checksum ^= (uint8_t) (msgFunction >> 8);
    checksum ^= (uint8_t) (msgFunction);
    checksum ^= (uint8_t) (msgPayloadLength >> 8);
    checksum ^= (uint8_t) (msgPayloadLength);
    for (i = 0; i < msgPayloadLength; i++)
    {
        checksum ^= msgPayload[i];
    }
    return checksum;
}


void UartDecodeMessagePIC24(uint8_t c)
{
    switch (rxReceptionStatePIC24)
    {
        case RECEPTION_WAIT_PIC24:
            if (c == 0xFE)
                rxReceptionStatePIC24 = RECEPTION_FUNCTION_MSB_PIC24;
            break;
        case RECEPTION_FUNCTION_MSB_PIC24:
            rxReceivedFunctionPIC24 = (uint16_t) (((uint16_t)c) << 8);
            rxReceptionStatePIC24 = RECEPTION_FUNCTION_LSB_PIC24;
            break;
        case RECEPTION_FUNCTION_LSB_PIC24:
            rxReceivedFunctionPIC24 += (uint16_t) c ;
            rxReceptionStatePIC24 = RECEPTION_PAYLOAD_LENGTH_MSB_PIC24;
            break;
        case RECEPTION_PAYLOAD_LENGTH_MSB_PIC24:
            rxReceivedPayloadPIC24LengthPIC24 = (uint16_t) (((uint16_t)c) << 8);
            rxReceptionStatePIC24 = RECEPTION_PAYLOAD_LENGTH_LSB_PIC24;
            break;
        case RECEPTION_PAYLOAD_LENGTH_LSB_PIC24:
            rxReceivedPayloadPIC24LengthPIC24 += (uint16_t) c ;
            if (rxReceivedPayloadPIC24LengthPIC24 > UART_MSG_MAX_SIZE)
                rxReceptionStatePIC24 = RECEPTION_WAIT_PIC24;
            else if (rxReceivedPayloadPIC24LengthPIC24 == 0)
                rxReceptionStatePIC24 = RECEPTION_CHECKSUM_PIC24;
            else
                rxReceptionStatePIC24 = RECEPTION_PAYLOAD_PIC24;
            break;
        case RECEPTION_PAYLOAD_PIC24:
            rxReceivedPayloadPIC24[rxReceivedPayloadPIC24Index] = c;
            rxReceivedPayloadPIC24Index++;
            if (rxReceivedPayloadPIC24Index == rxReceivedPayloadPIC24LengthPIC24)
            {
                rxReceivedPayloadPIC24Index = 0;
                rxReceptionStatePIC24 = RECEPTION_CHECKSUM_PIC24;
            }
            break;
        case RECEPTION_CHECKSUM_PIC24:
            if (c == UartCalculateChecksumPIC24(rxReceivedFunctionPIC24,
                    rxReceivedPayloadPIC24LengthPIC24, rxReceivedPayloadPIC24))
            {
                // Process message.
                ProcessMessagePIC24(rxReceivedFunctionPIC24, rxReceivedPayloadPIC24LengthPIC24, rxReceivedPayloadPIC24);
            }
            else
            {
                rxErrorCountPIC24++;
            }
            rxReceptionStatePIC24 = RECEPTION_WAIT_PIC24;
            break;
        default:
            rxReceptionStatePIC24 = RECEPTION_WAIT_PIC24;
            break;
    }
    UART_read(uart_PIC24, rxBuf_PIC24, (size_t)1);
    //UART_read(uart, rxBuf, (size_t)1,rxBuf2);
}

/*******************************************************************************
 * @fn      ProcessEndDeviceMessage
 *
 * @brief   Fonction permettant le traitement des message recus via le ZigBee.
 *          (Ex: Demande d'acquisition sur Magnetometre, demande de mesure de
 *          batterie, allumer une LED, ...). Une reponse peut etre renvoy�e
 *          au travers du reseau .
 *
 * @param   command - 2 byte - Commande a executer (Propre au protocole USTV)
 *          payload - 1-256 byte - Tableau dans lequel est enregistr�e la
 *          Payload.
 *          length - 1 byte - Taille de la payload.
 *
 * @return  None
 *
 ******************************************************************************/
//uint8_t payload0;
uint8_t test = 0;
uint8_t testGSM[10];
uint16_t commandTest;
uint16_t lengthTest;
//uint8_t payloadTest[128];
void ProcessMessagePIC24( uint16_t command, uint16_t length, uint8_t payload[])
{
    uint8_t blockMessage = 0;
    //uint16_t msgTxUARTPayloadLength;
    //uint8_t msgTxUARTPayload[BUFFER_TX_UART_SIZE];

    //Valeur par d�faut pour �viter de renvoyer la payload pr�c�dente si la valeur n'est pas renseign�e
    //msgTxUARTPayloadLength = 0;
    //commandTest = command;
    //lengthTest = length;
    //for(int iii=0; iii<length; iii++)
    //    payloadTest[iii] = payload[iii];

    switch(command)
    {
        // Statut du recorder
        case BUOY_STATUT:
        {
            uint16_t payloadIndex = 0;
            //uint8_t payload0 = payload[0];

            //MakeAndSendMessageWithUTLNProtocolPIC24(DEMANDE_STATE_BUOY,0,payload);

            //if(length == BUOY_STATUT_CMD_LENGHT){
            //Position
            buoyState.currentBuoyPosition = (BuoyPosition)payload[payloadIndex++];
            buoyState.currentBuoyNoise = (BuoyNoise)payload[payloadIndex++];
            buoyState.currentGSMState = (EtatCanalGSM)payload[payloadIndex++];
//            buoyState.pressionBuoy = BUILD_UINT32(payload[payloadIndex++],
//                                                  payload[payloadIndex++],
//                                                  payload[payloadIndex++],
//                                                  payload[payloadIndex++]);
            //}
            //On prepare la reponse
            blockMessage = 0;
            //msgTxUARTPayloadLength = 0;
            //msgTxUARTPayload[msgTxUARTPayloadLength++]=appData.status;
            break;
        }
        // Statut du recorder
        case PING_PIC24_STATUT:
        {
            uint16_t payloadIndex = 0;

            supervisorState.multiplexeur_PIC24_State.BattVoltage = BUILD_UINT16(payload[1], payload[0]);
            supervisorState.multiplexeur_PIC24_State.Ana_1Voltage = BUILD_UINT16(payload[3], payload[2]);
            supervisorState.multiplexeur_PIC24_State.Ana_2Voltage = BUILD_UINT16(payload[5], payload[4]);
            supervisorState.multiplexeur_PIC24_State.Ana_3Voltage = BUILD_UINT16(payload[7], payload[6]);
            //On prepare la reponse
            blockMessage = 0;
            //msgTxUARTPayloadLength = 0;
            //msgTxUARTPayload[msgTxUARTPayloadLength++]=appData.status;
            break;
        }
        // Statut du recorder
        case UART_STATE_PIC24:
        {
            uint16_t payloadIndex = 0;

            supervisorState.multiplexeur_PIC24_State.UART1State = (UART_MULTIPLEXEUR_PIC24_State) payload[0];
            supervisorState.multiplexeur_PIC24_State.UART2State = (UART_MULTIPLEXEUR_PIC24_State) payload[1];
            supervisorState.multiplexeur_PIC24_State.UART3State = (UART_MULTIPLEXEUR_PIC24_State) payload[2];
            //On prepare la reponse
            blockMessage = 0;
            //msgTxUARTPayloadLength = 0;
            //msgTxUARTPayload[msgTxUARTPayloadLength++]=appData.status;
            break;
        }
        case DEMANDE_GSM_CREATION_NOUVEAU_FICHIER:
        {
            uint16_t payloadIndex = 0;
            //uint8_t payload0 = payload[0];
            if(length<10){
                for(uint8_t i=0; i <length;i++)
                    testGSM[i] = payload[i];
            }
            else{
                for(uint8_t i=0; i <10;i++)
                    testGSM[i] = payload[i];
            }
            if(testGSM[0] == 0x0A && testGSM[0] == 0x3E){ // on reoit ">" donc a veut dire qu'on peut commencer a envoyer des caracteres
                payload[0]++;
            }
            else if(testGSM[0] == 0x0D && testGSM[1] == 0x0A &&
                    testGSM[2] == 0x4F && testGSM[3] == 0x4B &&
                    testGSM[4] == 0x0D && testGSM[5] == 0x0A ){ // on reoit "\r\nOK\r\n" : le modem a reu le dernier octet

                RapportSentOkGSM = true;

                //On ferme le UART2 parce que la boue a un bug de merde et ils n'arrivent pas a initaliser le GSM... LCDSM!!!
                multiplexeur_PIC24_State_Requested.UART1State = OPEN;
                multiplexeur_PIC24_State_Requested.BaudRateUART1 = 115200;
                multiplexeur_PIC24_State_Requested.UART2State = CLOSE;
                multiplexeur_PIC24_State_Requested.BaudRateUART2 = 115200;
                multiplexeur_PIC24_State_Requested.UART3State = OPEN;
                multiplexeur_PIC24_State_Requested.BaudRateUART3 = 9600;
                TaskSupervisorTrameSenderPIC24(MLT_SET_UART2,0);
            }
            //0D 0A 4F 4B 0D 0A
            //MakeAndSendMessageWithUTLNProtocolPIC24(DEMANDE_STATE_BUOY,0,payload);

            //if(length == BUOY_STATUT_CMD_LENGHT){
            //Position
//            buoyState.currentBuoyPosition = (BuoyPosition)payload[payloadIndex++];
//            buoyState.currentBuoyNoise = (BuoyNoise)payload[payloadIndex++];
//            buoyState.currentGSMState = (EtatCanalGSM)payload[payloadIndex++];
//            buoyState.pressionBuoy = BUILD_UINT32(payload[payloadIndex++],
//                                                  payload[payloadIndex++],
//                                                  payload[payloadIndex++],
//                                                  payload[payloadIndex++]);
            //}
            //On prepare la reponse
            blockMessage = 0;
            //msgTxUARTPayloadLength = 0;
            //msgTxUARTPayload[msgTxUARTPayloadLength++]=appData.status;
            break;
        }

//        // Demande de RTCC au CC2652
//        case RECORDER_HIGH_SPEED_DEMANDE_RTCC:
//        {
//            //On prepare la reponse pour ACK
//            blockMessage = 0;
//            //msgTxUARTPayloadLength = 0;
//
//            msgTxUARTPayloadLength = SET_RTCC_DU_RECORDER_AUDIO_LENGHT;
//            msgTxUARTPayload[0] = appData.localTime.year;
//            msgTxUARTPayload[1] = appData.localTime.month;
//            msgTxUARTPayload[2] = appData.localTime.day;
//            msgTxUARTPayload[3] = appData.localTime.hour;
//            msgTxUARTPayload[4] = appData.localTime.minute;
//            msgTxUARTPayload[5] = appData.localTime.second;
//
//            MakeAndSendMessageWithUTLNProtocol(SET_RTCC_DU_RECORDER_AUDIO, msgTxUARTPayloadLength,
//                                               msgTxUARTPayload);
//
//            //Notification pour qu'une tache envoie l'heure
//            //UART_PIC24_Send_Data_Trame(TRAME_SET_RTCC);
//            break;
//        }
//        // Data devant tre transmises au GSM. Le contenu de la trame renvoye au GSM nest pas modifi, ce qui permet de connatre sa source.
//        case RECORDER_HIGH_SPEED_DATA_GSM:
//        {
//            //On prepare la reponse pour ACK
//            blockMessage = 0;
//            msgTxUARTPayloadLength = 0;
//
//            //MakeAndSendMessageWithUTLNProtocol_PIC24(command, length, payload);
//            break;
//        }
//        //data devant tre transmises au GSM. Le contenu de la trame renvoye au GSM nest pas modifi, ce qui permet de connatre sa source.
//        case RECORDER_HIGH_SPEED_USB_PIC24:
////            appData.recordParameters.samplingFrequency=BUILD_UINT32(payload[0],payload[1],payload[2],payload[3]);
////            appData.recordParameters.nbChannelsUsed=payload[4];
////            appData.recordParameters.resolution=payload[5];
////            appData.recordParameters.filterSelection=payload[6];
////            appData.recordParameters.fileSizeLimitation=BUILD_UINT32(payload[7],payload[8],payload[9],payload[10]);
////            appData.recordParameters.saveMode=payload[11];
////            appData.localTime.year=payload[12];
////            appData.localTime.month=payload[13];
////            appData.localTime.day=payload[14];
////            appData.localTime.hour=payload[15];
////            appData.localTime.minute=payload[16];
////            appData.localTime.second=payload[17];
////            /* Set bit 8 in the notification value of the task referenced by xTask1Handle. */
////            //xTaskNotify( xTaskAppHandle, PARAMETERS_RECEIVED, eSetBits );
////            blockMessage=0;
//            break;
//
//        //data en provenance de lUSB PIC24 devant tre forwarde au CC2652.
//        case SET_EXTERNAL_PERIPHERALS:
////        {
////            unsigned char peripheralCount=MIN(payload[0], MAX_PERIPHERAL);
////            PeripheralConfiguration config[peripheralCount];
////            int i;
////            for(i=0;i<peripheralCount;i++)
////            {
////                config[i].Type=payload[i*6+1];
////                config[i].ID=payload[i*6+2];
////                config[i].Range=payload[i*6+3];
////                config[i].Resolution=payload[i*6+4];
////                config[i].Frequency= BUILD_UINT16(payload[i*6+5],payload[i*6+6]);
////                appData.peripheralConfig[i]=config[i];
////            }
////            //On injecte la trame dans le buffer des donnes additionnelles
////            MakeAndAddMessageWithUTLNProtocolInAdditionnalBuffer(command, length, payload);
////            blockMessage=0;
////            break;
////        }
////        //START_RECORDING: Demarre l'enregistrement
////        case START_RECORDING:
////            /* Set bit 8 in the notification value of the task referenced by xTask1Handle. */
////            //xTaskNotify( xTaskAppHandle, COM_START_RECORDING, eSetBits );
////            blockMessage=0;
//            break;
////        //STOP_RECORDING: Arrete l'enregistrement
////        case STOP_RECORDING:
////            /* Set bit 8 in the notification value of the task referenced by xTask1Handle. */
////            //xTaskNotify( xTaskAppHandle, COM_STOP_RECORDING, eSetBits );
////            blockMessage=0;
////            break;
////        // Unknown command
        default:
        {
            blockMessage=1;
            //msgTxUARTPayloadLength = 1;
            //msgTxUARTPayload[0]=(unsigned char)0;
        }
        break;
    }
    //On envoie le message
    if(blockMessage==0)
    {
        ;
        //MakeAndSendMessageWithUTLNProtocolPIC24(ACKNOLEDGE(command), msgTxUARTPayloadLength, msgTxUARTPayload);
    }
    blockMessage=0;
}

void MakeAndSendMessageWithUTLNProtocolPIC24(uint16_t command, uint16_t payloadLength, uint8_t* payload, bool forward, uint8_t chkSum)
{
    xdc_UInt taskKey = Task_disable();
    xdc_UInt hwiKey = Hwi_disable();
    /******************************* BEGIN CRITICAL SECTION ******************/
    uint16_t i;
    if(payloadLength+UTLN_FRAME_SIZE <= UART_MSG_MAX_SIZE){
        if(forward){

            outPayloadPIC24[0]=SOF;
            outPayloadPIC24[1]=HI_UINT16(command);
            outPayloadPIC24[2]=LO_UINT16(command);
            outPayloadPIC24[3]=HI_UINT16(payloadLength);
            outPayloadPIC24[4]=LO_UINT16(payloadLength);
            for(i=0;i<payloadLength;i++)
            {
                outPayloadPIC24[5+i]=payload[i];
            }
            outPayloadPIC24[5+payloadLength] = chkSum;
            //outPayloadPIC24[5+payloadLength]=UartCalculateChecksumPIC24(command,payloadLength, payload);
            SendMessagePIC24(outPayloadPIC24, UTLN_FRAME_SIZE+payloadLength);
        }
        else{
            //uint8_t outPayload[payloadLength+UTLN_FRAME_SIZE];
            //uint16_t i;
            outPayloadPIC24[0]=SOF;
            outPayloadPIC24[1]=HI_UINT16(command);
            outPayloadPIC24[2]=LO_UINT16(command);
            outPayloadPIC24[3]=HI_UINT16(payloadLength);
            outPayloadPIC24[4]=LO_UINT16(payloadLength);
            for(i=0;i<payloadLength;i++)
            {
                outPayloadPIC24[5+i]=payload[i];
            }
            outPayloadPIC24[5+payloadLength]=UartCalculateChecksumPIC24(command,payloadLength, payload);

            SendMessagePIC24(outPayloadPIC24, UTLN_FRAME_SIZE+payloadLength);
            //SendMessageToUart0( UTLN_FRAME_SIZE+payloadLength, outPayloadPIC24);
        }

    }

    Hwi_restore(hwiKey);
    Task_restore(taskKey);
    /******************************* END CRITICAL SECTION ******************/
}


void SendMessageToUart0(uint16_t payloadLength, uint8_t* payload)
{
    SendMessagePIC24(payload, payloadLength);

    //TaskUARTPIC24_enqueueMsgTx_PIC24(payloadLength, payload);
    //UART_TaskWrite(payload, payloadLength);
//    DRV_USART_WriteBufferAdd(app_communication_taskData.usart1Handle,payload,payloadLength,&app_communication_taskData.writeBufferHandle);
}
