/*
 * MsgProcessor_PIC24.h
 *
 *  Created on: 12 mai 2021
 *      Author: TP-EO-6
 */

#ifndef TASK_UART_PIC24_MSGPROCESSOR_PIC24_H_
#define TASK_UART_PIC24_MSGPROCESSOR_PIC24_H_

typedef enum PROCESSORMESSAGESTATEPIC24{
    RECEPTION_WAIT_PIC24 = 0,
    RECEPTION_FUNCTION_MSB_PIC24,
    RECEPTION_FUNCTION_LSB_PIC24,
    RECEPTION_PAYLOAD_LENGTH_MSB_PIC24,
    RECEPTION_PAYLOAD_LENGTH_LSB_PIC24,
    RECEPTION_PAYLOAD_PIC24,
    RECEPTION_CHECKSUM_PIC24,
}ProcessorMessageStatePIC24;



uint8_t UartCalculateChecksumPIC24(uint16_t msgFunction, uint16_t msgPayloadLength, uint8_t * msgPayload);
void UartDecodeMessagePIC24(uint8_t c);
void ProcessMessagePIC24( uint16_t command, uint16_t length, uint8_t payload[]);
void MakeAndSendMessageWithUTLNProtocolPIC24(uint16_t command, uint16_t payloadLength, uint8_t* payload, bool forward, uint8_t chkSum);
//void MakeAndSendMessageWithUTLNProtocolPIC24(uint16_t command, uint16_t payloadLength, uint8_t* payload);
void SendMessageToUart0(uint16_t payloadLength, uint8_t* payload);

#endif /* TASK_UART_PIC24_MSGPROCESSOR_PIC24_H_ */
