/*
 * Task_UART_PIC24.C
 *
 *  Created on: 12 mai 2021
 *      Author: TP-EO-6
 */


#include <string.h>
#include <math.h>
#include <stdbool.h>
#include <time.h>
#include <stdlib.h>
#include <stdint.h>
#include <stddef.h>
#include <file.h>
#include <stdio.h>

#include <icall.h>

#include <ti/sysbios/knl/Task.h>
#include <ti/sysbios/knl/Clock.h>
#include <ti/sysbios/knl/Event.h>
#include <ti/sysbios/knl/Queue.h>
#include <ti/sysbios/knl/Semaphore.h>
#include <ti/sysbios/BIOS.h>
#include <ti/drivers/GPIO.h>
#include <ti/drivers/UART.h>

#include "Macros/Protocol.h"
#include "Macros/Define.h"
//#include <GlobalConfiguration/GlobalConfiguration.h>

#include <Task_UART_PIC24/Task_UART_PIC24.h>
#include <Task_UART_PIC24/UART_Driver_PIC24.h>
#include <Task_UART_PIC24/MsgProcessor_PIC24.h>
#include "ti_drivers_config.h"

// Task configuration
#define UART_PIC24_TASK_PRIORITY                     2

#ifndef UART_PIC24_TASK_STACK_SIZE
#define UART_PIC24_TASK_STACK_SIZE                   5120//4096
#endif

// Task configuration
Task_Struct UART_PIC24Task;

Semaphore_Struct semTaskUART_PIC24Struct;
Semaphore_Handle semTaskUART_PIC24Handle;

uint8_t UART_PIC24TaskStack[UART_PIC24_TASK_STACK_SIZE];

extern UART_Handle uart_PIC24;
extern bool UARTPIC24isOpen;
bool UART_PIC24_Cancel_Read_And_Close_Requested = false;
bool UART_PIC24_Open_And_Read_Requested = false;


//Circular Buffer Tx
uint16_t cbTx2Head = 0;
uint16_t cbTx2Tail = 0;
uint8_t cbTx2Buffer[CBTX2_BUFFER_SIZE];
bool isTransmittingToPIC24 = false;

//Circular Buffer Rx
uint16_t cbRx2Head = 0;
uint16_t cbRx2Tail = 0;
uint8_t cbRx2Buffer[CBRX2_BUFFER_SIZE];
bool isDecodingFromPIC24 = false;

/******************************* Sleep Mode UART PIC24 Functions **************************************/

void Request_UART_PIC24_Cancel_Read_And_Close(void){
    UART_PIC24_Cancel_Read_And_Close_Requested = true;
    Semaphore_post(semTaskUART_PIC24Handle);
}

void Request_UART_PIC24_Open_And_Read(void){
    UART_PIC24_Open_And_Read_Requested = true;
    Semaphore_post(semTaskUART_PIC24Handle);
}


/******************************* Circular Buffer Functions **************************************/

void CB_resetBuffer_PIC24(void)
{
    cbTx2Head = 0;
    cbTx2Tail = 0;
    isTransmittingToPIC24 = false;
    //Circular Buffer Rx
    cbRx2Head = 0;
    cbRx2Tail = 0;
    isDecodingFromPIC24 = false;
}

                  /*-------------- Circular Buffer Rx  ------------------*/
void CB_RX2_Add(uint8_t messageByte)
{
    cbRx2Buffer[cbRx2Head++] = messageByte;
    if (cbRx2Head >= CBRX2_BUFFER_SIZE)
    cbRx2Head= 0;

}

uint8_t CB_RX2_Get(void)
{
    uint8_t messageByte = cbRx2Buffer[cbRx2Tail++];
    if(cbRx2Tail >= CBRX2_BUFFER_SIZE)
    cbRx2Tail = 0;
    return messageByte;
}

uint16_t CB_RX2_GetDataSize(void)
{
    uint16_t dataSize = 0;
    if(cbRx2Head > cbRx2Tail){
    dataSize =  cbRx2Head - cbRx2Tail;
    }
    else if (cbRx2Head < cbRx2Tail){
    dataSize = (cbRx2Head + (CBRX2_BUFFER_SIZE - cbRx2Tail));
    }
    return dataSize;
}

uint16_t CB_RX2_RemainingSize(void)
{
    return CBRX2_BUFFER_SIZE - CB_RX2_GetDataSize();
}

                /*-------------- Circular Buffer Tx  ------------------*/
void CB_TX2_Add(uint8_t messageByte)
{
    cbTx2Buffer[cbTx2Head++] = messageByte;
    if (cbTx2Head >= CBTX2_BUFFER_SIZE)
        cbTx2Head= 0;

}

uint8_t CB_TX2_Get(void)
{
    uint8_t messageByte = cbTx2Buffer[cbTx2Tail++];
    if(cbTx2Tail >= CBTX2_BUFFER_SIZE)
        cbTx2Tail = 0;
    return messageByte;
}

uint16_t CB_TX2_GetDataSize(void)
{
    uint16_t dataSize = 0;

    if(cbTx2Head > cbTx2Tail){
        dataSize =  cbTx2Head - cbTx2Tail;
    }
    else if (cbTx2Head < cbTx2Tail){
        dataSize = (cbTx2Head + (CBTX2_BUFFER_SIZE - cbTx2Tail));
    }

    return dataSize;
}

uint16_t CB_TX2_RemainingSize(void)
{
    return CBTX2_BUFFER_SIZE - CB_TX2_GetDataSize();
}

void SendMessagePIC24(uint8_t* message, uint16_t length)
{
    if (UARTPIC24isOpen)
    {
        if(CB_TX2_RemainingSize()>length){
    //        GPIO_write(SPI_SS_EXT2, CONFIG_GPIO_LED_ON);
            //On peut crire le message
            for(uint16_t i = 0; i < length; i++)
                CB_TX2_Add(message[i]);
            if(!isTransmittingToPIC24){
                //Send One Byte
                Semaphore_post(semTaskUART_PIC24Handle);
                isTransmittingToPIC24 = true;
            }
    //        GPIO_write(SPI_SS_EXT2, CONFIG_GPIO_LED_OFF);
        }
        else{
            if(!isTransmittingToPIC24){
                cbTx2Tail = 0;
                cbTx2Head = cbTx2Tail;
            }
        }
    }
}


void UART_PIC24CreateTask(void){

    Task_Params taskParams;
    Semaphore_Params semParams;

    // Configure task
    Task_Params_init(&taskParams);
    taskParams.stack = UART_PIC24TaskStack;
    taskParams.stackSize = UART_PIC24_TASK_STACK_SIZE;
    taskParams.priority = UART_PIC24_TASK_PRIORITY;

    Task_construct(&UART_PIC24Task, UART_PIC24taskFxn, &taskParams, NULL);

    /* Construct a Semaphore object to be used as a resource lock, inital count 0 */
    Semaphore_Params_init(&semParams);
    Semaphore_construct(&semTaskUART_PIC24Struct, 0, &semParams);

    /* Obtain instance handle */
    semTaskUART_PIC24Handle = Semaphore_handle(&semTaskUART_PIC24Struct);
}

static void UART_PIC24taskFxn(UArg a0, UArg a1)
{
    // Initialize application
    SMIOT_UARTPIC24_init();

    UARTPIC24isOpen = true;
    // Application main loop
    while(1){
      Semaphore_pend(semTaskUART_PIC24Handle, BIOS_WAIT_FOREVER);

        if (UARTPIC24isOpen)
        {
            isDecodingFromPIC24 = true;

            if (cbTx2Head != cbTx2Tail)
            {
                isTransmittingToPIC24 = true;
                // Send one byte.
                uint8_t messageByte = CB_TX2_Get();
                UART_write(uart_PIC24, &messageByte, 1);
            }

            while (cbRx2Head != cbRx2Tail)
            {
                uint8_t RxByte = CB_RX2_Get();
                UartDecodeMessagePIC24(RxByte);
            }
            isDecodingFromPIC24 = false;
        }

        if(UART_PIC24_Cancel_Read_And_Close_Requested){
            UART_PIC24_Cancel_Read_And_Close();
            UART_PIC24_Cancel_Read_And_Close_Requested = false;
        }

        if(UART_PIC24_Open_And_Read_Requested){
            UART_PIC24_Open_And_Read();
            UART_PIC24_Open_And_Read_Requested = false;
        }

    }
}
