/*
 * UART_Driver_PIC24.c
 *
 *  Created on: 12 mai 2021
 *      Author: TP-EO-6
 */

#include <string.h>
#include <math.h>
#include <stdbool.h>
#include <time.h>
#include <stdlib.h>
#include <stdint.h>
#include <stddef.h>
#include <file.h>
#include <stdio.h>

#include <ti/sysbios/knl/Task.h>
#include <ti/sysbios/knl/Clock.h>
#include <ti/sysbios/knl/Event.h>
#include <ti/sysbios/knl/Queue.h>
#include <ti/sysbios/knl/Semaphore.h>
#include <ti/sysbios/BIOS.h>
#include <ti/drivers/GPIO.h>
#include <ti/drivers/UART.h>
#include "Macros/Define.h"
#include <Task_UART_PIC24/Task_UART_PIC24.h>
#include <Task_UART_PIC24/UART_Driver_PIC24.h>
#include <Task_UART_PIC24/MsgProcessor_PIC24.h>
#include "ti_drivers_config.h"

UART_Handle uart_PIC24;
bool UARTPIC24isOpen = false;
extern ProcessorMessageStatePIC24 rxReceptionStatePIC24;
extern Semaphore_Handle semTaskUART_PIC24Handle;
extern bool isTransmittingToPIC24;
extern bool isDecodingFromPIC24;
extern uint16_t cbTx2Head;
extern uint16_t cbTx2Tail;

#define MAX_NUM_RX_BYTES_PIC24    1000   // Maximum RX bytes to receive in one go
uint8_t rxBuf_PIC24[MAX_NUM_RX_BYTES_PIC24];   // Receive buffer

static void UARTPIC24_readCallBack(UART_Handle handle, void *buf, size_t count)//(UART_Handle handle, void *buf, size_t count,
//                              void *userArg, int_fast16_t status)
//static void UART_readCallBack(UART_Handle handle, void *rxBuf, size_t size)
{
    for(size_t i = 0; i < count; i++){
        CB_RX2_Add(((uint8_t*)rxBuf_PIC24)[i]);
        if(!isDecodingFromPIC24){
            //Decode One Byte
            Semaphore_post(semTaskUART_PIC24Handle);
        }
    }

    UART_read(uart_PIC24, rxBuf_PIC24, (size_t)1);
}

static void UARTPIC24_writeCallBack(UART_Handle handle, void *buf, size_t count)//,
//                              void *userArg, int_fast16_t status)
{

    if(cbTx2Head!=cbTx2Tail){
        uint8_t messageByte = CB_TX2_Get();
        UART_write(uart_PIC24, &messageByte, 1);
    }
    else
        isTransmittingToPIC24 = false;

}

void SMIOT_UARTPIC24_init(void){

    UART_Params uartParams;
    /* Call driver init functions */
    UART_init();
    /* Create a UART with data processing off. */
    UART_Params_init(&uartParams);
    //uartParams.writeDataMode = UART_DATA_BINARY;
    //uartParams.readDataMode = UART_DATA_BINARY;
    uartParams.readReturnMode = UART_RETURN_FULL;
    uartParams.readEcho = UART_ECHO_OFF;
    uartParams.baudRate = 115200;
    uartParams.writeMode = UART_MODE_CALLBACK; // sets up TX for callback mode
    uartParams.readMode = UART_MODE_CALLBACK; // sets up RX for callback mode
    uartParams.writeCallback = UARTPIC24_writeCallBack; // your callback function
    uartParams.readCallback = UARTPIC24_readCallBack; // your callback function


    uart_PIC24 = UART_open(CONFIG_UART_1, &uartParams);

    if (uart_PIC24 == NULL) {
        GPIO_write(LED_Bleue, CONFIG_GPIO_LED_OFF);
        /* UART_open() failed */
        //while (1);
    }


    UART_read(uart_PIC24, rxBuf_PIC24, (size_t)1);

    rxReceptionStatePIC24 = RECEPTION_WAIT_PIC24;
}

void UART_PIC24_Cancel_Read_And_Close(void){

    // on attend qu'il finisse le tx
//    while (cbTx2Head != cbTx2Tail)
//    {
//        if (isTransmittingToPIC24 == false)
//        {
//            cbTx2Tail = 0;
//            cbTx2Head = cbTx2Tail;
//        }
//    }

    CB_resetBuffer_PIC24();
    isDecodingFromPIC24 = false;
    isTransmittingToPIC24 = false;
//    cbTx2Tail = 0;
//    cbTx2Head = cbTx2Tail;

    if(UARTPIC24isOpen){
    //if (uart_PIC24 != NULL){
        UART_readCancel(uart_PIC24);
        UART_writeCancel(uart_PIC24);
        UART_close(uart_PIC24);
        UARTPIC24isOpen = false;
    }
}

void UART_PIC24_Open_And_Read(void){
    //if (uart_PIC24 == NULL){
    if(UARTPIC24isOpen == false){

        UART_Params uartParams;
       /* Call driver init functions */
       UART_init();
       /* Create a UART with data processing off. */
       UART_Params_init(&uartParams);
       //uartParams.writeDataMode = UART_DATA_BINARY;
       //uartParams.readDataMode = UART_DATA_BINARY;
       uartParams.readReturnMode = UART_RETURN_FULL;
       uartParams.readEcho = UART_ECHO_OFF;
       uartParams.baudRate = 115200;
       uartParams.writeMode = UART_MODE_CALLBACK; // sets up TX for callback mode
       uartParams.readMode = UART_MODE_CALLBACK; // sets up RX for callback mode
       uartParams.writeCallback = UARTPIC24_writeCallBack; // your callback function
       uartParams.readCallback = UARTPIC24_readCallBack; // your callback function


       uart_PIC24 = UART_open(CONFIG_UART_1, &uartParams);

       if (uart_PIC24 == NULL) {
           GPIO_write(LED_Bleue, CONFIG_GPIO_LED_OFF);
           /* UART_open() failed */
           //while (1);
       }

       UARTPIC24isOpen = true;
       UART_read(uart_PIC24, rxBuf_PIC24, (size_t)1);
    }
    CB_resetBuffer_PIC24();
    isDecodingFromPIC24 = false;
    isTransmittingToPIC24 = false;
//    cbTx2Tail = 0;
//    cbTx2Head = cbTx2Tail;

    rxReceptionStatePIC24 = RECEPTION_WAIT_PIC24;
}

