/*
 * MsgProcessor_PIC32.c
 *
 *  Created on: 26 avr. 2021
 *      Author: sebas
 */

/******************************************************************************
  Filename:       ustv_Communication.c
  Revised:        $Date: 2012-11-19 18:52:21 $
  Revision:       $Revision: 00000 $

  Description:   USTV functions for USTV Communication (UART Routine,
  USTV Parser, ...)

  Copyright 2012 Universit� du Sud Toulon Var. All rights reserved.

  IMPORTANT: Your use of this Software is limited to those specific rights
  granted under the terms of a software license agreement between the user
  who downloaded the software, his/her employer .You may not use this
  Software unless you agree to abide by the terms of the License. Other than for
  the foregoing purpose, you may not use, reproduce, copy, prepare derivative
  works of, modify, distribute, perform, display or sell this Software and/or
  its documentation for any purpose.

  YOU FURTHER ACKNOWLEDGE AND AGREE THAT THE SOFTWARE AND DOCUMENTATION ARE
  PROVIDED ?AS IS? WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESS OR IMPLIED,
  INCLUDING WITHOUT LIMITATION, ANY WARRANTY OF MERCHANTABILITY, TITLE,
  NON-INFRINGEMENT AND FITNESS FOR A PARTICULAR PURPOSE. IN NO EVENT SHALL
  TEXAS INSTRUMENTS OR ITS LICENSORS BE LIABLE OR OBLIGATED UNDER CONTRACT,
  NEGLIGENCE, STRICT LIABILITY, CONTRIBUTION, BREACH OF WARRANTY, OR OTHER
  LEGAL EQUITABLE THEORY ANY DIRECT OR INDIRECT DAMAGES OR EXPENSES
  INCLUDING BUT NOT LIMITED TO ANY INCIDENTAL, SPECIAL, INDIRECT, PUNITIVE
  OR CONSEQUENTIAL DAMAGES, LOST PROFITS OR LOST DATA, COST OF PROCUREMENT
  OF SUBSTITUTE GOODS, TECHNOLOGY, SERVICES, OR ANY CLAIMS BY THIRD PARTIES
  (INCLUDING BUT NOT LIMITED TO ANY DEFENSE THEREOF), OR OTHER SIMILAR COSTS.

  Should you have any questions regarding your right to use this Software,
  contact DPT GEII at www.univ-tln.fr.

 *****************************************************************************/
/*******************************************************************************
 * INCLUDES
 ******************************************************************************/
#include <stdio.h>
#include <stdint.h>
#include <stdlib.h>
#include <string.h>
#include "Macros/Define.h"
#include <ti/sysbios/knl/Semaphore.h>

#include <ti/sysbios/knl/Task.h>
#include <ti/sysbios/hal/Hwi.h>
#include <ti/sysbios/knl/Clock.h>
#include <ti/ble5stack/hal/src/inc/hal_defs.h>
#include <ti/drivers/UART2.h>
#include <ti/drivers/GPIO.h>
//#include <TaskCommunication_/SMIOT_Communication/SMIOT_Communication.h>
//#include <TaskCommunication_/TaskCommunication.h>
#include "ti_drivers_config.h"
#include "hal_defs.h"
#include "Macros/Protocol.h"
//#include "GlobalConfiguration/GlobalConfiguration.h"
//#include <TaskSD/SMIOT_SD/SD_HIGHBLUE/APPDATA_PARAMETERS.h>
//#include <TaskSupervisor/TaskSupervisor.h>
//#include <TaskUART_PIC24_/SMIOT_UART_PIC24/UTLN_Communication_PIC24.h>
//#include <TaskUART_PIC24_/TaskUART_PIC24_RX.h>
//#include <TaskUART_PIC24/TaskUART_PIC24_RX.h>
//#include <TaskUART_PIC32_/SMIOT_UART/SMIOT_UART.h>
//#include <TaskUART_PIC32_/SMIOT_UART/UTLN_Communication_PIC32.h>
//#include <TaskUART_PIC32_/TaskUART_PIC32_RX.h>
//#include <TaskUART_PIC32_/TaskUART_PIC32_TX.h>

#include <Task_UART_PIC32/Task_UART_PIC32.h>
#include <Task_UART_PIC32/UART_Driver.h>
#include <Task_UART_PIC32/MsgProcessor_PIC32.h>
#include <Task_UART_PIC24/MsgProcessor_PIC24.h>
#include <Task_Supervisor/Task_Supervisor.h>
#include <Task_SD/SD_Driver.h>
#include <Task_SD/Task_SD.h>
#include <Task_SPI/Task_SPI.h>
/***************************************************************************************************
 * CONSTANTS
 ***************************************************************************************************/

//For debug
//extern bool BlinkLedBlanche;


uint8_t outPayload[UART_MSG_MAX_SIZE];

//extern AppData appData;
extern bool NewCNNDetectionResult;
extern bool CNNDetectionResult;
extern bool FinalTrameToGSMForwarded;
extern SupervisorState supervisorState;
extern PIC32_RecorderState RecorderStatePIC32;
extern UART2_Handle uartPIC32;
extern uint8_t rxBuf[];   // Receive buffer
extern size_t rxBuf2[];   // Receive buffer
extern Semaphore_Handle semTaskUARTTrameDecoderHandle;
extern Semaphore_Handle semTaskRecordingManagerHandle;
extern RtccDateTime    FlashRtccDateTime;
extern bool CLOCKFILEREAD;
extern bool SdCard_FILE_CREATE_Requested;
extern bool SdCard_FILE_APPEND_Requested;
extern bool SdCard_FILE_GET_INFO_Requested;
extern bool SdCard_FILE_DELETE_Requested;
extern bool SDWriteFinished;
bool errorTxGSM = false;
uint32_t OctetsTransferred = 0;
uint32_t OctetsToTransfer = 0;
/*******************************************************************************
 * VARIABLES
 ******************************************************************************/
//extern volatile unsigned long g_longTimeStamp;
//extern APP_COMMUNICATION_TASK_DATA app_communication_taskData;
//extern TaskHandle_t xTaskAppHandle;
//extern APP_DATA appData;
/*******************************************************************************
 * FONCTIONS
 ******************************************************************************/
uint8_t UartCalculateChecksum(uint16_t msgFunction,
      uint16_t msgPayloadLength, uint8_t * msgPayload)
{
    uint8_t checksum = 0x00;
    uint16_t i = 0;
    checksum ^= 0xFE;
    checksum ^= (uint8_t) (msgFunction >> 8);
    checksum ^= (uint8_t) (msgFunction);
    checksum ^= (uint8_t) (msgPayloadLength >> 8);
    checksum ^= (uint8_t) (msgPayloadLength);
    for (i = 0; i < msgPayloadLength; i++)
    {
        checksum ^= msgPayload[i];
    }
    return checksum;
}

ProcessorMessageState rxReceptionState = RECEPTION_WAIT;
uint16_t rxReceivedFunction;
uint16_t rxReceivedPayloadLength;
uint8_t rxReceivedPayload[UART_RX_PAYLOAD_SIZE];
uint8_t AckPayload[128];
uint8_t AckPayloadLenght;
uint16_t rxReceivedPayloadIndex = 0;

//unsigned char c;
uint16_t rxErrorCount=0;
//extern TaskHandle_t xTaskAppCommunicationHandle;
uint8_t testDebugTrameGSMRX =0;
void UartDecodeMessage(uint8_t c)
{
    switch (rxReceptionState)
    {
        case RECEPTION_WAIT:
            if (c == 0xFE){
                rxReceptionState = RECEPTION_FUNCTION_MSB;
                rxReceivedPayloadIndex = 0;
            }

            break;
        case RECEPTION_FUNCTION_MSB:
            rxReceivedFunction = (uint16_t) (((uint16_t)c) << 8);
            rxReceptionState = RECEPTION_FUNCTION_LSB;
            break;
        case RECEPTION_FUNCTION_LSB:
            rxReceivedFunction += (uint16_t) c ;
            rxReceptionState = RECEPTION_PAYLOAD_LENGTH_MSB;
            break;
        case RECEPTION_PAYLOAD_LENGTH_MSB:
            rxReceivedPayloadLength = (uint16_t) (((uint16_t)c) << 8);
            rxReceptionState = RECEPTION_PAYLOAD_LENGTH_LSB;
            break;
        case RECEPTION_PAYLOAD_LENGTH_LSB:
            rxReceivedPayloadLength += ((uint16_t) c) ;
            if (rxReceivedPayloadLength > UART_RX_PAYLOAD_SIZE)
                rxReceptionState = RECEPTION_WAIT;
            else if (rxReceivedPayloadLength == 0)
                rxReceptionState = RECEPTION_CHECKSUM;
            else
                rxReceptionState = RECEPTION_PAYLOAD;
            break;
        case RECEPTION_PAYLOAD:
            rxReceivedPayload[rxReceivedPayloadIndex] = c;
            rxReceivedPayloadIndex++;
            if (rxReceivedPayloadIndex == rxReceivedPayloadLength)
            {
                rxReceivedPayloadIndex = 0;
                rxReceptionState = RECEPTION_CHECKSUM;
            }
            break;
        case RECEPTION_CHECKSUM:
            if (c == UartCalculateChecksum(rxReceivedFunction,
                    rxReceivedPayloadLength, rxReceivedPayload))
            {
                // Process message.
                ProcessMessage(rxReceivedFunction, rxReceivedPayloadLength, rxReceivedPayload);

                if((rxReceivedFunction == GSM_DATA_TO_FORWARD) && (supervisorState.multiplexeur_PIC24_State.UART2State == OPEN)){
                   MakeAndSendMessageWithUTLNProtocolPIC24(rxReceivedFunction, rxReceivedPayloadLength, rxReceivedPayload, true, c);
                    OctetsTransferred += rxReceivedPayloadLength;
//                    if(OctetsTransferred > OctetsToTransfer)
//                        errorTxGSM = true;
                }

            }
            else
            {
                if(rxReceivedFunction == GSM_DATA_TO_FORWARD)
                    testDebugTrameGSMRX++;
                rxErrorCount++;
            }
            rxReceptionState = RECEPTION_WAIT;
            break;
        default:
            rxReceptionState = RECEPTION_WAIT;
            break;
    }
}


/*******************************************************************************
 * @fn      ProcessEndDeviceMessage
 *
 * @brief   Fonction permettant le traitement des message recus via le ZigBee.
 *          (Ex: Demande d'acquisition sur Magnetometre, demande de mesure de
 *          batterie, allumer une LED, ...). Une reponse peut etre renvoy�e
 *          au travers du reseau .
 *
 * @param   command - 2 byte - Commande a executer (Propre au protocole USTV)
 *          payload - 1-256 byte - Tableau dans lequel est enregistr�e la
 *          Payload.
 *          length - 1 byte - Taille de la payload.
 *
 * @return  None
 *
 ******************************************************************************/
uint8_t payload0;
uint16_t debugVariab;


void ProcessMessage( uint16_t command, uint16_t length, uint8_t payload[])
{
    uint8_t blockMessage = 0;
    //uint16_t msgTxUARTPayloadLength;
    //uint8_t msgTxUARTPayload[BUFFER_TX_UART_SIZE];
    //Valeur par d�faut pour �viter de renvoyer la payload pr�c�dente si la valeur n'est pas renseign�e
//    msgTxUARTPayloadLength = 0;

    switch(command)
    {

        // Statut du recorder
        case RECORDER_HIGH_SPEED_STATUT:
        {
            uint16_t payloadIndex = 0;
            //uint8_t payload0 = payload[0];
            if(length == RECORDER_HIGH_SPEED_STATUT_PAYLOAD_LENGHT){
                switch(payload[0])
                {
                    case RECORDER_HIGH_SPEED_STATUT_INIT:
                        RecorderStatePIC32 = Init;
                        break;
                    case RECORDER_HIGH_SPEED_STATUT_WAIT_FOR_STORAGE:
                        RecorderStatePIC32 = WaitForStorage;
                        break;
                    case RECORDER_HIGH_SPEED_STATUT_READY_TO_START:
                        RecorderStatePIC32 = ReadyToStart;
                        break;
                    case RECORDER_HIGH_SPEED_STATUT_RECORDING:
                        RecorderStatePIC32 = Recording;
                        break;
                    case RECORDER_HIGH_SPEED_STATUT_FLUSHING_DDR_TO_FS:
                        RecorderStatePIC32 = FlushingDDRToFS;
                        break;
                    case RECORDER_HIGH_SPEED_STATUT_ANALYSE_CNN:
                        RecorderStatePIC32 = AnalyseCNN;
                        break;
                    case RECORDER_HIGH_SPEED_STATUT_READY_TO_TURN_OFF:
                        RecorderStatePIC32 = ReadyToTurnOff;
                        break;
                    case RECORDER_HIGH_SPEED_STATUT_SEND_DATA_GSM:
                        RecorderStatePIC32 = DataSend;
                        break;
                    case RECORDER_HIGH_SPEED_STATUT_ERROR:
                        RecorderStatePIC32 = Error;
                        break;
                    default: break;
                }
            }
            //On prepare la reponse
            blockMessage = 0;
//            msgTxUARTPayloadLength = 0;
//            msgTxUARTPayload[msgTxUARTPayloadLength++]=appData.status;
            break;
        }
        break;
        case APPUIS_BOUTON:
        {
            uint16_t payloadIndex = 0;
//            uint8_t payload0 = payload[0];
//            if(length == RECORDER_HIGH_SPEED_STATUT_PAYLOAD_LENGHT){
                switch(payload[0])
                {
                    case 1:
                        Bouton1Appuye();
                        break;
                    case 2:
                        Bouton2Appuye();
                        break;
                    case 3:
                        Bouton3Appuye();
                        break;
                }
//            }
            //On prepare la reponse
//            blockMessage = 0;
//            msgTxUARTPayloadLength = 0;
//            msgTxUARTPayload[msgTxUARTPayloadLength++]=appData.status;
            break;
        }
        break;
        case RESULTAT_ANALYSE_CNN:
        {
            uint16_t payloadIndex = 0;
            //On notify un nouveau resultat de CNN
            NewCNNDetectionResult = true;
            //On notify le resultat
            CNNDetectionResult = false;
                if(payload[payloadIndex++])
                    CNNDetectionResult = true;
            break;
        }
        break;
        case GSM_DATA_TO_FORWARD:
        {
            //uint8_t AckPayload[128];
            AckPayloadLenght = 0;
            //MakeAndSendMessageWithUTLNProtocolPIC24(GSM_DATA_TO_FORWARD, length, payload);
            //Ack
            blockMessage = 5;
            break;
        }
        break;
        case GSM_OUVERTURE_NOUVEAU_FICHIER_CMD:
        {
#if 1
            //uint8_t AckPayload[128];
            AckPayloadLenght = 0;
           uint16_t indexpayloadSupervisorSentUART = 0;
           uint32_t LongueurFichierEnOctets = BUILD_UINT32_Lib(payload[3], payload[2], payload[1], payload[0]);
           char NomDuFichier[64]={0};
           for(int i =0; i<length-4;i++){
               NomDuFichier[i] = payload[4+i];
           }
           debugVariab = length;
           char commandeCreationNewFile[90]={0};
           OctetsTransferred = 0;
           OctetsToTransfer = LongueurFichierEnOctets;
           snprintf(commandeCreationNewFile, 90, "AT+UDWNFILE=\"%s\",%d\r", NomDuFichier,LongueurFichierEnOctets);
           //snprintf(commandeCreationNewFile, 90, "AT+UDWNFILE=\"%s\",10000\r", NomDuFichier);//,LongueurFichierEnOctets);
           errorTxGSM = false;
           //char commandeCreationNewFile100ko[] = "AT+UDWNFILE=\"DATA_FILE1\",100000\r";
           //char commandeCreationNewFile100o[] = "AT+UDWNFILE=\"%s\",%d\r";
           //snprintf(payloadSupervisorSentUARTPIC24, 20, "fat:0:%s", NomDeFichier);
           //payloadSupervisorSentUARTPIC24[payloadSupervisorSentUARTLengthMAX];
           if(supervisorState.multiplexeur_PIC24_State.UART2State == OPEN)
               MakeAndSendMessageWithUTLNProtocolPIC24(DEMANDE_STATE_GSM,strlen(commandeCreationNewFile),commandeCreationNewFile,false,0);
#endif



            //MakeAndSendMessageWithUTLNProtocolPIC24(GSM_OUVERTURE_NOUVEAU_FICHIER_CMD, length, payload);
            //Ack
            blockMessage = 5;
            break;
        }
        break;
        case GSM_FERMETURE_FICHIER:
#if 1
            //uint8_t AckPayload[128];
            //AckPayloadLenght = 0;
            //MakeAndSendMessageWithUTLNProtocolPIC24(GSM_FERMETURE_FICHIER, length, payload);
            FinalTrameToGSMForwarded = true;
            //TODO enlever cet commentaire sinon on va pas passer au prochain tat
            supervisorState.recordingState = DATA_SEND_Finished;
            //Ack
#endif
            blockMessage = 5;
            break;



        // Demande de RTCC au CC2652
        case RECORDER_HIGH_SPEED_DEMANDE_RTCC:
        {
            //On prepare la reponse pour ACK
//            blockMessage = 0;
            //msgTxUARTPayloadLength = 0;

//            msgTxUARTPayloadLength = SET_RTCC_DU_RECORDER_AUDIO_LENGHT;
//            msgTxUARTPayload[0] = supervisorState.localTime.year;
//            msgTxUARTPayload[1] = supervisorState.localTime.month;
//            msgTxUARTPayload[2] = supervisorState.localTime.day;
//            msgTxUARTPayload[3] = supervisorState.localTime.hour;
//            msgTxUARTPayload[4] = supervisorState.localTime.minute;
//            msgTxUARTPayload[5] = supervisorState.localTime.second;
//
//            MakeAndSendMessageWithUTLNProtocol(SET_RTCC_DU_RECORDER_AUDIO, msgTxUARTPayloadLength,
//                                               msgTxUARTPayload);

            //Notification pour qu'une tache envoie l'heure
            //UART_PIC32_Send_Data_Trame(TRAME_SET_RTCC);
            break;
        }
        break;
        // Data devant tre transmises au GSM. Le contenu de la trame renvoye au GSM nest pas modifi, ce qui permet de connatre sa source.
        //data devant tre transmises au GSM. Le contenu de la trame renvoye au GSM nest pas modifi, ce qui permet de connatre sa source.
        case RECORDER_HIGH_SPEED_USB_PIC32:
//            appData.recordParameters.samplingFrequency=BUILD_UINT32(payload[0],payload[1],payload[2],payload[3]);
//            appData.recordParameters.nbChannelsUsed=payload[4];
//            appData.recordParameters.resolution=payload[5];
//            appData.recordParameters.filterSelection=payload[6];
//            appData.recordParameters.fileSizeLimitation=BUILD_UINT32(payload[7],payload[8],payload[9],payload[10]);
//            appData.recordParameters.saveMode=payload[11];
//            appData.localTime.year=payload[12];
//            appData.localTime.month=payload[13];
//            appData.localTime.day=payload[14];
//            appData.localTime.hour=payload[15];
//            appData.localTime.minute=payload[16];
//            appData.localTime.second=payload[17];
//            /* Set bit 8 in the notification value of the task referenced by xTask1Handle. */
//            //xTaskNotify( xTaskAppHandle, PARAMETERS_RECEIVED, eSetBits );
//            blockMessage=0;
            break;
        case USB_MODE_DEVICE_START:
        {
            uint16_t payloadIndex = 0;
            USBStartStopManager(payload[0]);
            supervisorState.recordParameters.samplingFrequency = BUILD_UINT32_Lib(payload[4],
                                                                              payload[3],
                                                                              payload[2],
                                                                              payload[1]);
            supervisorState.recordParameters.nbChannelsUsed = payload[5];
            supervisorState.recordParameters.resolution = payload[6];
            supervisorState.recordParameters.filterSelection = payload[7];
            break;
        }
        break;
        case USB_MODE_FILE_CREATE:
        {
            while(!SDWriteFinished){
                Task_sleep(10 * (1000 / Clock_tickPeriod)); //On attends 10ms
            }
            SDWriteFinished = false;
            CopyTrameSD(length, payload);
            SdCard_FILE_CREATE_Requested = true;
            RequestSdOperation();
//            uint16_t payloadIndex = 0;
//            USBStartStopManager(payload[0]);
//            supervisorState.recordParameters.samplingFrequency = BUILD_UINT32_Lib(payload[4],
//                                                                              payload[3],
//                                                                              payload[2],
//                                                                              payload[1]);
//            supervisorState.recordParameters.nbChannelsUsed = payload[5];
//            supervisorState.recordParameters.resolution = payload[6];
//            supervisorState.recordParameters.filterSelection = payload[7];
            break;
        }
        break;
        case USB_MODE_FILE_APPEND:
        {
            while(!SDWriteFinished){
                Task_sleep(10 * (1000 / Clock_tickPeriod)); //On attends 10ms
            }
            SDWriteFinished = false;
            CopyTrameSD(length, payload);
            SdCard_FILE_APPEND_Requested = true;
            RequestSdOperation();


//            uint16_t payloadIndex = 0;
//            USBStartStopManager(payload[0]);
//            supervisorState.recordParameters.samplingFrequency = BUILD_UINT32_Lib(payload[4],
//                                                                              payload[3],
//                                                                              payload[2],
//                                                                              payload[1]);
//            supervisorState.recordParameters.nbChannelsUsed = payload[5];
//            supervisorState.recordParameters.resolution = payload[6];
//            supervisorState.recordParameters.filterSelection = payload[7];
            break;
        }
        break;
        case USB_MODE_FILE_GET_INFO:
        {
            CopyTrameSD(length, payload);
            SdCard_FILE_GET_INFO_Requested = true;
            RequestSdOperation();
//            uint16_t payloadIndex = 0;
//            USBStartStopManager(payload[0]);
//            supervisorState.recordParameters.samplingFrequency = BUILD_UINT32_Lib(payload[4],
//                                                                              payload[3],
//                                                                              payload[2],
//                                                                              payload[1]);
//            supervisorState.recordParameters.nbChannelsUsed = payload[5];
//            supervisorState.recordParameters.resolution = payload[6];
//            supervisorState.recordParameters.filterSelection = payload[7];
            break;
        }
        break;
        case USB_MODE_FILE_DELETE:
        {
            CopyTrameSD(length, payload);
            SdCard_FILE_DELETE_Requested = true;
            RequestSdOperation();
//            uint16_t payloadIndex = 0;
//            USBStartStopManager(payload[0]);
//            supervisorState.recordParameters.samplingFrequency = BUILD_UINT32_Lib(payload[4],
//                                                                              payload[3],
//                                                                              payload[2],
//                                                                              payload[1]);
//            supervisorState.recordParameters.nbChannelsUsed = payload[5];
//            supervisorState.recordParameters.resolution = payload[6];
//            supervisorState.recordParameters.filterSelection = payload[7];
            break;
        }
        break;
        case USB_MODE_SET_CLOCK_TIME:
        {
            CLOCKFILEREAD = true;

            //Save date to flash rtcc
            FlashRtccDateTime.day = payload[2];
            FlashRtccDateTime.hour = payload[3];
            FlashRtccDateTime.minute = payload[4];
            FlashRtccDateTime.month = payload[1];
            FlashRtccDateTime.second = payload[5];
            FlashRtccDateTime.year = payload[0];
            FlashRtccDateTime.weekDay = (unsigned char) 1;

            supervisorState.localTime.year = payload[0];
            supervisorState.localTime.month = payload[1];
            supervisorState.localTime.day = payload[2];
            supervisorState.localTime.hour = payload[3];
            supervisorState.localTime.minute = payload[4];
            supervisorState.localTime.second = payload[5];

            RequestRTCCRead();

            break;
        }
        break;
        //data en provenance de lUSB PIC32 devant tre forwarde au CC2652.
        case SET_EXTERNAL_PERIPHERALS:
//        {
//            unsigned char peripheralCount=MIN(payload[0], MAX_PERIPHERAL);
//            PeripheralConfiguration config[peripheralCount];
//            int i;
//            for(i=0;i<peripheralCount;i++)
//            {
//                config[i].Type=payload[i*6+1];
//                config[i].ID=payload[i*6+2];
//                config[i].Range=payload[i*6+3];
//                config[i].Resolution=payload[i*6+4];
//                config[i].Frequency= BUILD_UINT16(payload[i*6+5],payload[i*6+6]);
//                appData.peripheralConfig[i]=config[i];
//            }
//            //On injecte la trame dans le buffer des donnes additionnelles
//            MakeAndAddMessageWithUTLNProtocolInAdditionnalBuffer(command, length, payload);
//            blockMessage=0;
//            break;
//        }
//        //START_RECORDING: Demarre l'enregistrement
//        case START_RECORDING:
//            /* Set bit 8 in the notification value of the task referenced by xTask1Handle. */
//            //xTaskNotify( xTaskAppHandle, COM_START_RECORDING, eSetBits );
//            blockMessage=0;
            break;
//        //STOP_RECORDING: Arrete l'enregistrement
//        case STOP_RECORDING:
//            /* Set bit 8 in the notification value of the task referenced by xTask1Handle. */
//            //xTaskNotify( xTaskAppHandle, COM_STOP_RECORDING, eSetBits );
//            blockMessage=0;
//            break;
//        // Unknown command
        default:
        {
            blockMessage=0;
//            msgTxUARTPayloadLength = 1;
            //msgTxUARTPayload[0]=(unsigned char)0;
            break;
        }
        break;
    }
    //On envoie le message
    if(blockMessage == 5)
    {
        MakeAndSendMessageWithUTLNProtocol(ACKNOLEDGE(command), AckPayloadLenght, AckPayload);
    }
    blockMessage=0;
}

void MakeAndSendMessageWithUTLNProtocol(uint16_t command, uint16_t payloadLength, uint8_t* payload)
{
    xdc_UInt taskKey = Task_disable();
    xdc_UInt hwiKey = Hwi_disable();
    /******************************* BEGIN CRITICAL SECTION ******************/


    if(payloadLength+UTLN_FRAME_SIZE <= UART_MSG_MAX_SIZE){
        //uint8_t outPayload[payloadLength+UTLN_FRAME_SIZE];
        uint16_t i;
        outPayload[0]=SOF;
        outPayload[1]=HI_UINT16(command);
        outPayload[2]=LO_UINT16(command);
        outPayload[3]=HI_UINT16(payloadLength);
        outPayload[4]=LO_UINT16(payloadLength);
        for(i=0;i<payloadLength;i++)
        {
            outPayload[5+i]=payload[i];
        }
        outPayload[5+payloadLength]=UartCalculateChecksum(command,payloadLength, payload);

        SendMessagePIC32(outPayload,UTLN_FRAME_SIZE+payloadLength);
        //SendMessageToUart1( UTLN_FRAME_SIZE+payloadLength, outPayload);
    }

    Hwi_restore(hwiKey);
    Task_restore(taskKey);
    /******************************* END CRITICAL SECTION ******************/
}


void SendMessageToUart1( uint16_t payloadLength, uint8_t* payload)
{
    SendMessagePIC32(payload,payloadLength);
    //TaskUARTPIC32_enqueueMsgTx_PIC32(payloadLength, payload);
    //UART_TaskWrite(payload, payloadLength);
//    DRV_USART_WriteBufferAdd(app_communication_taskData.usart1Handle,payload,payloadLength,&app_communication_taskData.writeBufferHandle);
}

//============================================================================//
//void MakeAndAddMessageWithUTLNProtocolInAdditionnalBuffer(uint16_t command, uint16_t payloadLength, uint8_t* payload)
//{
//    uint8_t outPayload[payloadLength+UTLN_FRAME_SIZE];
//    uint16_t i;
//    outPayload[0]=SOF;
//    outPayload[1]=MSB_UINT16(command);
//    outPayload[2]=LSB_UINT16(command);
//    outPayload[3]=MSB_UINT16(payloadLength);
//    outPayload[4]=LSB_UINT16(payloadLength);
//    for(i=0;i<payloadLength;i++)
//    {
//        outPayload[5+i]=payload[i];
//    }
//    outPayload[5+payloadLength]=UartCalculateChecksum(command,payloadLength, payload);
//
//    //USTV_AddDataInAdditionnalBuffer(outPayload, UTLN_FRAME_SIZE+payloadLength);
//}
/*******************************************************************************
 End of File
*/



