/*
 * MsgProcessor_PIC32.h
 *
 *  Created on: 26 avr. 2021
 *      Author: sebas
 */

#ifndef TASKUART_PIC32_MSGPROCESSOR_PIC32_MSGPROCESSOR_PIC32_H_
#define TASKUART_PIC32_MSGPROCESSOR_PIC32_MSGPROCESSOR_PIC32_H_

#define UART_RX_PAYLOAD_SIZE 512
#define BUFFER_TX_UART_SIZE 512
/*******************************************************************************
 * VARIABLES
 ******************************************************************************/

extern volatile unsigned long g_longTimeStamp;






//#define RECEPTION_WAIT 0
//#define RECEPTION_FUNCTION_MSB 1
//#define RECEPTION_FUNCTION_LSB 2
//#define RECEPTION_PAYLOAD_LENGTH_MSB 3
//#define RECEPTION_PAYLOAD_LENGTH_LSB 4
//#define RECEPTION_PAYLOAD 5
//#define RECEPTION_CHECKSUM 6


#define MESSAGE_DECODED (1<<0)

//Recorder Input Frame
#define GET_STATUS 0x0100
#define SET_RECORDER_PARAMETERS 0x0101
#define SET_EXTERNAL_PERIPHERALS 0x0102
#define START_RECORDING 0x0103
#define STOP_RECORDING 0x0104

//Recorder Output Frame
#define SEND_STATUS 0x0200
#define SEND_GSM_DATAS 0x0210
#define FORWARD_USB_FRAME 0x0211

#define ACKNOLEDGE(x) (x|0x1000)

//Processor message states
typedef enum PROCESSORMESSAGESTATE{
    RECEPTION_WAIT = 0,
    RECEPTION_FUNCTION_MSB,
    RECEPTION_FUNCTION_LSB,
    RECEPTION_PAYLOAD_LENGTH_MSB,
    RECEPTION_PAYLOAD_LENGTH_LSB,
    RECEPTION_PAYLOAD,
    RECEPTION_CHECKSUM,
}ProcessorMessageState;

void SendMessageToUart1( uint16_t payloadLength, uint8_t* payload);
void MakeAndSendMessageWithUTLNProtocol(uint16_t command, uint16_t payloadLength, uint8_t* payload);
void ProcessMessage( uint16_t command, uint16_t length, uint8_t payload[]);
void UartDecodeMessage(uint8_t c);


#endif /* TASKUART_PIC32_MSGPROCESSOR_PIC32_MSGPROCESSOR_PIC32_H_ */
