/*
 * Task_UART_PIC32.c
 *
 *  Created on: 11 mai 2021
 *      Author: TP-EO-6
 */


#include <string.h>
#include <math.h>
#include <stdbool.h>
#include <time.h>
#include <stdlib.h>
#include <stdint.h>
#include <stddef.h>
#include <file.h>
#include <stdio.h>

#include <icall.h>
#include <ti/sysbios/hal/Hwi.h>
#include <ti/sysbios/knl/Task.h>
#include <ti/sysbios/knl/Clock.h>
#include <ti/sysbios/knl/Event.h>
#include <ti/sysbios/knl/Semaphore.h>
#include <ti/sysbios/BIOS.h>
#include <ti/drivers/GPIO.h>
#include <ti/drivers/UART.h>
#include <ti/drivers/UART2.h>

#include "Macros/Define.h"
#include "Macros/Protocol.h"

#include <Task_UART_PIC32/Task_UART_PIC32.h>
#include <Task_UART_PIC32/UART_Driver.h>
#include <Task_UART_PIC32/MsgProcessor_PIC32.h>
#include <Task_Supervisor/Task_Supervisor.h>
#include "ti_drivers_config.h"

// Task configuration
#define UART_PIC32_TASK_PRIORITY                     2

#ifndef UART_PIC32_TASK_STACK_SIZE
#define UART_PIC32_TASK_STACK_SIZE                   5120//4096
#endif

// Task configuration
Task_Struct UART_PIC32_Task;

Semaphore_Struct semTask_UART_PIC32_Struct;
Semaphore_Handle semTask_UART_PIC32_Handle;

uint8_t UART_PIC32_TaskStack[UART_PIC32_TASK_STACK_SIZE];

//Circular Buffer Tx
uint16_t cbTx1Head = 0;
uint16_t cbTx1Tail = 0;
uint8_t cbTx1Buffer[CBTX1_BUFFER_SIZE];
bool isTransmitting = false;

//Circular Buffer Rx
uint16_t cbRx1Head = 0;
uint16_t cbRx1Tail = 0;
uint8_t cbRx1Buffer[CBRX1_BUFFER_SIZE];
bool isDecoding = false;

extern UART2_Handle uartPIC32;
extern bool UARTisOpen;
bool UART_PIC32_Cancel_Read_And_Close_Requested = false;
bool UART_PIC32_Open_And_Read_Requested = false;

/******************************* Sleep Mode UART PIC32 Functions **************************************/

void Request_UART_PIC32_Cancel_Read_And_Close(void){
    UART_PIC32_Cancel_Read_And_Close_Requested = true;
    Semaphore_post(semTask_UART_PIC32_Handle);
}

void Request_UART_PIC32_Open_And_Read(void){
    UART_PIC32_Open_And_Read_Requested = true;
    Semaphore_post(semTask_UART_PIC32_Handle);
}

/******************************* Circular Buffer Functions **************************************/

                  /*-------------- Circular Buffer Rx  ------------------*/
void CB_RX1_Add(uint8_t messageByte)
{
    cbRx1Buffer[cbRx1Head++] = messageByte;
    if (cbRx1Head >= CBRX1_BUFFER_SIZE)
    cbRx1Head= 0;

}

uint8_t CB_RX1_Get(void)
{
    uint8_t messageByte = cbRx1Buffer[cbRx1Tail++];
    if(cbRx1Tail >= CBRX1_BUFFER_SIZE)
    cbRx1Tail = 0;
    return messageByte;
}

uint16_t CB_RX1_GetDataSize(void)
{
    uint16_t dataSize = 0;
    if(cbRx1Head > cbRx1Tail){
    dataSize =  cbRx1Head - cbRx1Tail;
    }
    else if (cbRx1Head < cbRx1Tail){
    dataSize = (cbRx1Head + (CBRX1_BUFFER_SIZE - cbRx1Tail));
    }
    return dataSize;
}

uint16_t CB_RX1_RemainingSize(void)
{
    return CBRX1_BUFFER_SIZE - CB_RX1_GetDataSize();
}

                /*-------------- Circular Buffer Tx  ------------------*/
void CB_TX1_Add(uint8_t messageByte)
{
    cbTx1Buffer[cbTx1Head++] = messageByte;
    if (cbTx1Head >= CBTX1_BUFFER_SIZE)
        cbTx1Head= 0;

}

uint8_t CB_TX1_Get(void)
{
    uint8_t messageByte = cbTx1Buffer[cbTx1Tail++];
    if(cbTx1Tail >= CBTX1_BUFFER_SIZE)
        cbTx1Tail = 0;
    return messageByte;
}

uint16_t CB_TX1_GetDataSize(void)
{
    uint16_t dataSize = 0;

    if(cbTx1Head > cbTx1Tail){
        dataSize =  cbTx1Head - cbTx1Tail;
    }
    else if (cbTx1Head < cbTx1Tail){
        dataSize = (cbTx1Head + (CBTX1_BUFFER_SIZE - cbTx1Tail));
    }

    return dataSize;
}

uint16_t CB_TX1_RemainingSize(void)
{
    return CBTX1_BUFFER_SIZE - CB_TX1_GetDataSize();
}

void SendMessagePIC32(uint8_t* message, uint16_t length)
{
    if(UARTisOpen){
        if(CB_TX1_RemainingSize()>length){
            //On peut crire le message
            for(uint16_t i = 0; i < length; i++)
                CB_TX1_Add(message[i]);
            if(!isTransmitting){
                isTransmitting = true;
                //Send One Byte
                Semaphore_post(semTask_UART_PIC32_Handle);
            }
        }
        else{
            if(!isTransmitting){
                cbTx1Tail = 0;
                cbTx1Head = cbTx1Tail;
                //isTransmitting = true;
                //Send One Byte
                //Semaphore_post(semTask_UART_PIC32_Handle);
            }
        }
    }

//    else{
//        #if USING_UART_PIC32
//        Request_UART_PIC32_Open_And_Read();
//        #endif
//    }
}

void UART_PIC32CreateTask(void){

    Task_Params taskParams;
    Semaphore_Params semParams;

    // Configure task
    Task_Params_init(&taskParams);
    taskParams.stack = UART_PIC32_TaskStack;
    taskParams.stackSize = UART_PIC32_TASK_STACK_SIZE;
    taskParams.priority = UART_PIC32_TASK_PRIORITY;

    Task_construct(&UART_PIC32_Task, UART_PIC32_taskFxn, &taskParams, NULL);

    /* Construct a Semaphore object to be used as a resource lock, inital count 0 */
    Semaphore_Params_init(&semParams);
    Semaphore_construct(&semTask_UART_PIC32_Struct, 0, &semParams);

    /* Obtain instance handle */
    semTask_UART_PIC32_Handle = Semaphore_handle(&semTask_UART_PIC32_Struct);
}

static void UART_PIC32_taskFxn(UArg a0, UArg a1)
{
    // Initialize application
    SMIOT_UART_init();

    // Application main loop
    while(1){
      Semaphore_pend(semTask_UART_PIC32_Handle, BIOS_WAIT_FOREVER);

          if(UARTisOpen){
              isDecoding = true;

              if(cbTx1Head != cbTx1Tail){
                  isTransmitting = true;
                  // Send one byte.
                  uint8_t messageByte = CB_TX1_Get();
                  UART2_write(uartPIC32, &messageByte, 1, NULL);
              }

              while(cbRx1Head != cbRx1Tail){
                  uint8_t RxByte = CB_RX1_Get();
                  UartDecodeMessage(RxByte);
              }
              isDecoding = false;
          }

          if(UART_PIC32_Cancel_Read_And_Close_Requested){
              UART_PIC32_Cancel_Read_And_Close();

              UART_PIC32_Cancel_Read_And_Close_Requested = false;
          }

          if(UART_PIC32_Open_And_Read_Requested){
              UART_PIC32_Open_And_Read();

              UART_PIC32_Open_And_Read_Requested = false;
          }

    }
}
