/*
 * Task_UART_PIC32.h
 *
 *  Created on: 11 mai 2021
 *      Author: TP-EO-6
 */

#ifndef TASK_UART_PIC32_TASK_UART_PIC32_H_
#define TASK_UART_PIC32_TASK_UART_PIC32_H_

#define CBTX1_BUFFER_SIZE 2*UART_MSG_MAX_SIZE
#define CBRX1_BUFFER_SIZE 2*UART_MSG_MAX_SIZE

static void UART_PIC32_taskFxn(UArg a0, UArg a1);
void UART_PIC32CreateTask(void);
void SendMessagePIC32(uint8_t* message, uint16_t length);

void Request_UART_PIC32_Cancel_Read_And_Close(void);
void Request_UART_PIC32_Open_And_Read(void);

void CB_TX1_Add(uint8_t messageByte);
uint8_t CB_TX1_Get(void);
uint16_t CB_TX1_GetDataSize(void);
uint16_t CB_TX1_RemainingSize(void);

void CB_RX1_Add(uint8_t messageByte);
uint8_t CB_RX1_Get(void);
uint16_t CB_RX1_GetDataSize(void);
uint16_t CB_RX1_RemainingSize(void);

#endif /* TASK_UART_PIC32_TASK_UART_PIC32_H_ */
