/*
 * UART_Driver.c
 *
 *  Created on: 26 avr. 2021
 *      Author: sebas
 */

#include <string.h>
#include <math.h>
#include <stdbool.h>
#include <time.h>
#include <stdlib.h>
#include <stdint.h>
#include <stddef.h>
#include <file.h>
#include <stdio.h>

#include <ti/sysbios/knl/Task.h>
#include <ti/sysbios/knl/Clock.h>
#include <ti/sysbios/knl/Event.h>
#include <ti/sysbios/knl/Queue.h>
#include <ti/sysbios/knl/Semaphore.h>
#include <ti/sysbios/BIOS.h>
#include <ti/drivers/GPIO.h>
//#include <ti/drivers/UART.h>
#include <ti/drivers/UART2.h>
#include "Macros/Define.h"
#include <Task_UART_PIC32/UART_Driver.h>
#include <Task_UART_PIC32/MsgProcessor_PIC32.h>
#include <Task_UART_PIC32/Task_UART_PIC32.h>

#include "ti_drivers_config.h"

UART2_Handle uartPIC32;
bool UARTisOpen = false;


extern Semaphore_Handle semTask_UART_PIC32_Handle;
extern ProcessorMessageState rxReceptionState;
extern bool isTransmitting;
extern bool isDecoding;
extern uint16_t cbTx1Head;
extern uint16_t cbTx1Tail;

#define MAX_NUM_RX_BYTES    1000   // Maximum RX bytes to receive in one go
#define MAX_NUM_TX_BYTES    1000   // Maximum TX bytes to send in one go
uint32_t wantedRxBytes;            // Number of bytes received so far
uint16_t NbBytesReceived;           // Number of bytes Received
uint8_t rxBuf[MAX_NUM_RX_BYTES];   // Receive buffer
size_t rxBuf2[MAX_NUM_RX_BYTES];   // Receive buffer
uint8_t txBuf[MAX_NUM_TX_BYTES];   // Transmit buffer

static void UART_readCallBack(UART2_Handle handle, void *buf, size_t count, void *userArg, int_fast16_t status);

static void UART_writeCallBack(UART2_Handle handle, void *buf, size_t count,
                              void *userArg, int_fast16_t status)
{
    //GPIO_write(SYNCHRO_PPS, CONFIG_GPIO_LED_ON);
    if(cbTx1Head!=cbTx1Tail){
        uint8_t messageByte = CB_TX1_Get();
        UART2_write(uartPIC32, &messageByte, 1, NULL);
    }
    else
        isTransmitting = false;
    //GPIO_write(SYNCHRO_PPS, CONFIG_GPIO_LED_OFF);
}

void SMIOT_UART_init(void){
    rxReceptionState = RECEPTION_WAIT;
    UART2_Params uartParams;
    /* Call driver init functions */
//    UART2_init();
    /* Create a UART with data processing off. */
    UART2_Params_init(&uartParams);
    uartParams.writeMode = UART2_Mode_CALLBACK; // When the transfer has finished, the callback function is called from either the caller's context or from an interrupt context
//    uartParams.readDataMode = UART2_DATA_BINARY;
    uartParams.readReturnMode = UART2_ReadReturnMode_FULL;
//    uartParams.readEcho = UART2_ECHO_OFF;
    uartParams.baudRate = 115200;
    uartParams.readMode = UART2_Mode_CALLBACK; // sets up RX for callback mode
    uartParams.readCallback = UART_readCallBack; // your callback function
    uartParams.writeCallback = UART_writeCallBack; // your callback function
    //    uartParams.readDataMode =


    uartPIC32 = UART2_open(CONFIG_UART2_0, &uartParams);

    if (uartPIC32 == NULL) {
        GPIO_write(LED_Bleue, CONFIG_GPIO_LED_OFF);
        /* UART_open() failed */
        //while (1);
    }
    else
        UARTisOpen = true;

    UART2_rxDisable(uartPIC32);
    UART2_read(uartPIC32, rxBuf, (size_t)1,rxBuf2);
}

void UART_PIC32_Cancel_Read_And_Close(void){

    // on attend qu'il finisse le tx
//    while(cbTx1Head!=cbTx1Tail){
//        if(isTransmitting == false){
//            cbTx1Tail = 0;
//            cbTx1Head = cbTx1Tail;
//        }
//    }
    isTransmitting = false;
    cbTx1Tail = 0;
    cbTx1Head = cbTx1Tail;

    if(UARTisOpen){
        UART2_writeCancel(uartPIC32);
        UART2_readCancel(uartPIC32);
        //UART2_rxDisable(uartPIC32);
        UART2_close(uartPIC32);
        uartPIC32 = NULL;
        UARTisOpen = false;
    }
//    while (1){
//        GPIO_write(LED_Bleue, CONFIG_GPIO_LED_ON);
//        /* UART_open() failed */
//        //while (1);
//    }

}

void UART_PIC32_Open_And_Read(void){
    rxReceptionState = RECEPTION_WAIT;
    if(UARTisOpen == false){

        cbTx1Tail = 0;
        cbTx1Head = cbTx1Tail;

        UART2_Params uartParams;
        /* Call driver init functions */
    //    UART2_init();
        /* Create a UART with data processing off. */
        UART2_Params_init(&uartParams);
        uartParams.writeMode = UART2_Mode_CALLBACK; // When the transfer has finished, the callback function is called from either the caller's context or from an interrupt context
    //    uartParams.readDataMode = UART2_DATA_BINARY;
        uartParams.readReturnMode = UART2_ReadReturnMode_FULL;
    //    uartParams.readEcho = UART2_ECHO_OFF;
        uartParams.baudRate = 115200;
        uartParams.readMode = UART2_Mode_CALLBACK; // sets up RX for callback mode
        uartParams.readCallback = UART_readCallBack; // your callback function
        uartParams.writeCallback = UART_writeCallBack; // your callback function
        //    uartParams.readDataMode =


        uartPIC32 = UART2_open(CONFIG_UART2_0, &uartParams);

        if (uartPIC32 == NULL) {

                //TODO

            //GPIO_write(LED_Bleue, CONFIG_GPIO_LED_ON);
            /* UART_open() failed */
            //while (1);
        }

        UARTisOpen = true;
        //UART2_rxEnable(uartPIC32);
        UART2_rxDisable(uartPIC32);
        UART2_read(uartPIC32, rxBuf, (size_t)1,rxBuf2);

    }
}

static void UART_readCallBack(UART2_Handle handle, void *buf, size_t count,
                              void *userArg, int_fast16_t status)
//static void UART_readCallBack(UART_Handle handle, void *rxBuf, size_t size)
{

    for(size_t i = 0; i < count; i++){
        CB_RX1_Add(((uint8_t*)rxBuf)[i]);
    }

    if(!isDecoding){
        //Decode One Byte
        Semaphore_post(semTask_UART_PIC32_Handle);
    }

    UART2_read(uartPIC32, rxBuf, (size_t)1,rxBuf2);
        //UartDecodeMessage(((uint8_t*)rxBuf)[i]);

}
