/* Microchip Technology Inc. and its subsidiaries.  You may use this software 
 * and any derivatives exclusively with Microchip products. 
 * 
 * THIS SOFTWARE IS SUPPLIED BY MICROCHIP "AS IS".  NO WARRANTIES, WHETHER 
 * EXPRESS, IMPLIED OR STATUTORY, APPLY TO THIS SOFTWARE, INCLUDING ANY IMPLIED 
 * WARRANTIES OF NON-INFRINGEMENT, MERCHANTABILITY, AND FITNESS FOR A 
 * PARTICULAR PURPOSE, OR ITS INTERACTION WITH MICROCHIP PRODUCTS, COMBINATION 
 * WITH ANY OTHER PRODUCTS, OR USE IN ANY APPLICATION. 
 *
 * IN NO EVENT WILL MICROCHIP BE LIABLE FOR ANY INDIRECT, SPECIAL, PUNITIVE, 
 * INCIDENTAL OR CONSEQUENTIAL LOSS, DAMAGE, COST OR EXPENSE OF ANY KIND 
 * WHATSOEVER RELATED TO THE SOFTWARE, HOWEVER CAUSED, EVEN IF MICROCHIP HAS 
 * BEEN ADVISED OF THE POSSIBILITY OR THE DAMAGES ARE FORESEEABLE.  TO THE 
 * FULLEST EXTENT ALLOWED BY LAW, MICROCHIP'S TOTAL LIABILITY ON ALL CLAIMS 
 * IN ANY WAY RELATED TO THIS SOFTWARE WILL NOT EXCEED THE AMOUNT OF FEES, IF 
 * ANY, THAT YOU HAVE PAID DIRECTLY TO MICROCHIP FOR THIS SOFTWARE.
 *
 * MICROCHIP PROVIDES THIS SOFTWARE CONDITIONALLY UPON YOUR ACCEPTANCE OF THESE 
 * TERMS. 
 */

/* 
 * File:  Define.h 
 * Author: Valentin BARCHASZ
 * Comments:
 * Revision history: 1.0
 */

// This is a guard condition so that contents of this file are not included
// more than once.  
#ifndef _DEFINE_H_
#define	_DEFINE_H_
#include <xc.h> // include processor files - each processor file is guarded.  
/*******************************************************************************
 * INCLUDES
 ******************************************************************************/
//#include <libpic30.h>
//#include "UTLN_Typedefs.h"


#define M_PI 3.14159265358979323846f
#define M_2PI 6.28318530717958647692f

/*******************************************************************************
 * CONSTANTS
 ******************************************************************************/


/*******************************************************************************
 * PORT MAPPING Values
 ******************************************************************************/
#define INPUT 1
#define OUTPUT 0
#define LOW 0
#define HIGH 1
#define TRUE 1
#define FALSE 0
#define CLEAR 0

#define UNUSED(expr) do { (void)(expr); } while (0)

/*******************************************************************************
 * FRAMES IDs
 ******************************************************************************/


#define TRAME_ACCEL_DATA 0xA0

/*******************************************************************************
 * FRAMES GLOBALS PARAMETERS
 ******************************************************************************/


#define BUFFER_TX_UART_SIZE 128

/*******************************************************************************
 * MACROS
 ******************************************************************************/
#define CLRWDT()  asm(" clrwdt")
#define BUILD_UINT16(hiByte, loByte) \
          ((unsigned short int)(((loByte) & 0x00FF) + (((hiByte) & 0x00FF) << 8)))
#define BUILD_INT16(hiByte, loByte) \
          ((int)(((loByte) & 0x00FF) + (((hiByte) & 0x00FF) << 8)))
#define MSB_UINT16(a) (((a) >> 8) & 0xFF)
#define LSB_UINT16(a) ((a) & 0xFF)
#define BUILD_UINT32(Byte0, Byte1, Byte2, Byte3) \
          ((unsigned long)((unsigned long)((Byte0) & 0x00FF) \
          + ((unsigned long)((Byte1) & 0x00FF) << 8) \
          + ((unsigned long)((Byte2) & 0x00FF) << 16) \
          + ((unsigned long)((Byte3) & 0x00FF) << 24)))
#define BUILD_INT32(Byte0, Byte1, Byte2, Byte3) \
          ((long)((long)((Byte0) & 0x00FF) \
          + ((long)((Byte1) & 0x00FF) << 8) \
          + ((long)((Byte2) & 0x00FF) << 16) \
          + ((long)((Byte3) & 0x00FF) << 24)))
#define BREAK_UINT32( var, ByteNum ) \
          (unsigned char)((unsigned int)(((var) >>((ByteNum) * 8)) & 0x00FF))
#define MSB_LSB_INVERT(uShort) ((((uShort) & 0x00FF)<<8) + ((uShort) & 0xFF00)>>8)
#ifndef MIN
#define MIN(n,m)   (((n) < (m)) ? (n) : (m))
#endif
#ifndef MAX
#define MAX(n,m)   (((n) < (m)) ? (m) : (n))
#endif
#ifndef ABS
#define ABS(x) ((x>0) ? x : (-x))
#endif
#ifndef ABS_Q16
#define ABS_Q16(x) ((_itofQ16(x)>0) ? x : _Q16neg(x))
#endif
#ifndef CEILING
#define CEILING(x) ((int)x == (double)x) ? (int)x : ((int)x) + 1;
#endif
#ifndef DegreeToRadian
#define DegreeToRadian(value) ((double)value * M_PI / 180.0)
#endif


#endif	/* _DEFINE_H_ */

