#include "FFT.h"
#include "app_cnn_detection.h"  
#include "USTV_SystemTrace.h"
#include "HighBlue_Header.h"
#include "peripheral/gpio/plib_gpio.h"
#include "app_sd_tasks.h"
#include "app.h"
#include <math.h>
#include "fftc.h"
#include "FreeRTOS.h"
#include <string.h>
#include <stdio.h>
#ifndef pi
    #define pi	3.14159265358979323846264338327950288
#endif

extern short SPECIE;
extern APP_DATA appData;
int frontend(APP_CNN_DETECTION_DATA* app_cnn_detectionData, int samplerate, int lensig, short winsize_log2, short hopsize, short minfreq, short maxfreq, short melfeat){
    
    if(loadLogSignal(app_cnn_detectionData, lensig, samplerate)==0){
        return 0;
    }
    #ifdef USE_SYSTEM_TRACE
        USTV_SystemTraceWriteLine("APP_CNN: Sound file read done");
    #endif
    short winsize = 1<<winsize_log2;
    short lenspec = (lensig - winsize) / hopsize;
    short specHeight = winsize / 2;
    app_cnn_detectionData->meldspectro = app_cnn_detectionData->startaddr;
    app_cnn_detectionData->startaddr = (void*) (app_cnn_detectionData->meldspectro + lenspec * melfeat);
    float* melpeaks = (float*) app_cnn_detectionData->startaddr; // we don't push startaddr for this to dump it after
    get_melpeaks(samplerate, minfreq, maxfreq, melfeat, melpeaks, winsize);
    #ifdef USE_SYSTEM_TRACE
        USTV_SystemTraceWriteLine("APP_CNN: melbank created");
    #endif
    if(melstft(app_cnn_detectionData->meldspectro, melpeaks, (int32*) (melpeaks+melfeat+2), app_cnn_detectionData->sig, winsize_log2, specHeight, hopsize, melfeat, lenspec)==0){
        return 0;
    }
    #ifdef USE_SYSTEM_TRACE
        USTV_SystemTraceWriteLine("APP_CNN: Mel Spectrogram computed");
    #endif
    if(Log1p(app_cnn_detectionData->meldspectro, lenspec, melfeat)==0){ 
        return 0;
    }
    #ifdef USE_SYSTEM_TRACE
        USTV_SystemTraceWriteLine("APP_CNN: Log1p applied");
    #endif
    return 1;
}

int loadLogSignal(APP_CNN_DETECTION_DATA* app_cnn_detectionData, int lensig, int samplerate){
    char* path=USTV_GetFilePath(appData.currentFileName);
    
    SYS_FS_HANDLE logFile = SYS_FS_FileOpen(path, (SYS_FS_FILE_OPEN_READ));
    if(logFile == SYS_FS_HANDLE_INVALID){
        #ifdef USE_SYSTEM_TRACE
            USTV_SystemTraceWriteLine("APP_CNN: Could not open sound file");
        #endif
        return 0;
    }
    HighBlueHeader readHdr = USTV_ParseHeaderAndSeekToFirstAudioDataBlock(logFile);
    int uds = readHdr.samplingFrequency / samplerate;
    size_t bytesRead=0;
    app_cnn_detectionData->sig = (int32*) app_cnn_detectionData->startaddr;
    app_cnn_detectionData->startaddr = (void*) (app_cnn_detectionData->sig + lensig);
    unsigned char* buffer = (unsigned char*) app_cnn_detectionData->startaddr;
    int i, sampleread = 0;
    short resBytes = readHdr.resolutionBits/8;
    do{
        bytesRead = USTV_GetRAWAudioDataBlock(logFile, buffer, (uint32_t)readHdr.dmaBlockSize);
        for(i=0; i < bytesRead / (readHdr.numberOfChan * resBytes * uds); i++){
            *(app_cnn_detectionData->sig + sampleread + i) = 0;
            memcpy(app_cnn_detectionData->sig + sampleread + i, buffer + i * uds * resBytes, resBytes);
        }
        sampleread += bytesRead / (readHdr.numberOfChan * resBytes * uds );
        //Si on arrive pas a se deplacer c'est qu'il y a eu une erreur
        if(USTV_SeekToNextDataBlock(logFile, readHdr.sizeOfAdditionnalDataBuffer ) == -1){
            #ifdef USE_SYSTEM_TRACE
                USTV_SystemTraceWriteLine("APP_CNN: ERROR : error in reading sound file");
            #endif
            return 0;
        }
    }while(bytesRead==readHdr.dmaBlockSize && sampleread<lensig);
    //On ferme le fichier
    SYS_FS_FileClose(logFile);
    return 1;
}

// <editor-fold defaultstate="collapsed" desc="loadWavSignal">
int loadWavSignal(APP_CNN_DETECTION_DATA* app_cnn_detectionData, int lensig, int uds, int byteDepth){
    SYS_FS_HANDLE wavfile;
    if(SPECIE==CACHA){
        wavfile = SYS_FS_FileOpen("/mnt/myDrive1/cacha.wav", (SYS_FS_FILE_OPEN_READ));
    }else{
        wavfile = SYS_FS_FileOpen("/mnt/myDrive1/cacha.wav", (SYS_FS_FILE_OPEN_READ));
    }
    if(wavfile == SYS_FS_HANDLE_INVALID){
        #ifdef USE_SYSTEM_TRACE
            USTV_SystemTraceWriteLine("APP_CNN: Could not open sound file");
        #endif
        return 0;
    }
    SYS_FS_FileSeek(wavfile, 44, SYS_FS_SEEK_SET);  //wav header is 44 bytes long
    app_cnn_detectionData->sig = (int32*) app_cnn_detectionData->startaddr;
    app_cnn_detectionData->startaddr = (void*) (app_cnn_detectionData->sig + lensig);
    int i=0;
    int16 temp;
    for(i=0; i<lensig; i++){ //lis sample par sample et remplis la table sig
        SYS_FS_FileRead(wavfile, &temp, byteDepth);
        *(app_cnn_detectionData->sig + i) = (int32) temp;
        if(uds>1){
            SYS_FS_FileSeek(wavfile, (uds-1)*byteDepth, SYS_FS_SEEK_CUR);
        }
    }
    //mips_vec_addc32(app_cnn_detectionData->sig, app_cnn_detectionData->sig, -mean, LENSIG);
    // standardisation impossible (les entiers ne peuvent pas etre entre 0 et 1)
    /*int32 std = mips_vec_sum_squares32(diff, LENSIG, 8);
    std = sqrt(std/LENSIG + 1e-5);
    //mips_vec_addc32(app_cnn_detectionData->sig, app_cnn_detectionData->sig, (int32)-mean, LENSIG);
    //mips_vec_mulc32(app_cnn_detectionData->sig, app_cnn_detectionData->sig, (int32)(1/std), LENSIG);*/
    return 1;
}
// </editor-fold>

void get_melpeaks(int fs, int minfreq, int maxfreq, int melfeat, float* binpeaks, short winsize){
    int i;
    // mel-spaced peak frequencies
    float minmel = 1127 * log(1 + minfreq / 700.0);
    float maxmel = 1127 * log(1 + maxfreq / 700.0);
    float temp;
    for(i=0; i<melfeat+2; i++){
        temp = minmel + i*(maxmel - minmel)/(melfeat+1); // compute mel peak
        temp = 700* (exp(temp/1127) -1); // compute Hz peak
        binpeaks[i] = (temp*winsize / fs); // compute bin peak
    }
}

float mag32(int32c in){
    float re = (float) in.re;
    float im = (float) in.im;
    return re*re + im*im;
}


int melstft(float* meldspectro, float* melpeaks, int32* startaddr, int32* sig, short winsize_log2, short specHeight, short hopsize, short melfeat, short lenspec){
    int i, j, k;
    short winsize = 1<<winsize_log2;
    int32c* din = (int32c*) startaddr;
    int32c* dout = (int32c*) (din + winsize);
    float* magdout = (float*) (dout + winsize);
    int32* hanning = (int32*) (magdout + winsize);
    int32c* scratch = (int32c*) (hanning + winsize);
    int32c* fftc;
    
    if(winsize==512){
        fftc = (int32c*) fft32c512;
    }else if(winsize==4096){
        fftc = (int32c*) fft32c4096;
    }else{
        #ifdef USE_SYSTEM_TRACE
            USTV_SystemTraceWriteLine("APP_CNN: unsuported winsize");
        #endif
        return 0;
    }
    float cum = 0.0;
    //init Hanning window
    for(i=0; i<winsize; i++){
        hanning[i]= (int32)((1.0-cos(2.0*pi*i/(winsize-1)))*64); // *64 == * 128 / 2 
    }
    for(i=0; i<lenspec; i++){
        // fill input data hanning windowed
        //mips_vec_mul32(dinre, hanning, app_cnn_detectionData->sig + i*HOPSIZE, WINSIZE);
        for(j=0; j<winsize; j++){
            din[j] = (int32c){ ((int32)(*(sig + i*hopsize + j) * hanning[j])) >> 7 , 0};
        }
        portTASK_USES_FLOATING_POINT();
        mips_fft32(dout, din, fftc, scratch, winsize_log2);
        for(k=0; k<specHeight; k++){
            magdout[k] = mag32(dout[k]);
        }
        for(j=0; j<melfeat; j++){
            cum = 0;
            for(k=((int)melpeaks[j]); k<melpeaks[j+1]; k++){
                cum += fmaxf(magdout[k] * (k - melpeaks[j]) / (melpeaks[j+1] - melpeaks[j]), 0.0);
            }
            for(k=((int)melpeaks[j+1]); k<melpeaks[j+2]; k++){
                cum += magdout[k] * (k - melpeaks[j+2]) / (melpeaks[j+1] - melpeaks[j+2]);
            }
            *(meldspectro + i * melfeat + j) = cum / (melpeaks[j+2] - melpeaks[j+1]);
        }
    }
    return 1;
}

int Log1p(float* matrix, int width, int height){
    char* path;
    if(SPECIE==CACHA){
        path=USTV_GetFilePath("cacha_stdc.txt");
    }else{
        path=USTV_GetFilePath("rorqual_stdc.txt");
    }
    SYS_FS_HANDLE fp = SYS_FS_FileOpen(path, (SYS_FS_FILE_OPEN_READ));
    if(fp == SYS_FS_HANDLE_INVALID){
        #ifdef USE_SYSTEM_TRACE
            USTV_SystemTraceWriteLine("APP_CNN: failed to open stdc file ");
        #endif
        return 0;
    }
    char line[15];
    SYS_FS_FileStringGet(fp, line, 15); //skip first line
    SYS_FS_FileStringGet(fp, line, 15);
    float logparam = atof(line);
    SYS_FS_FileClose(fp);
    int i, j;
    logparam = pow(10, logparam)* 0.5; // divide by 2 to get the root of the square norm of the spectro
    for(i=0; i<width; i++){
        for(j=0; j<height; j++){
            *(matrix + i*height + j) = log1p(*(matrix + i*height + j) * logparam);
        }
    }
    return 1;
}

float fmaxf(float a, float b){
    if(a>b){
        return a;
    }else{
        return b;
    }
}
float fminf(float a, float b){
    if(a<b){
        return a;
    }else{
        return b;
    }
}

void print_to_file(float* spectro, int width, int height, char* path){
    SYS_FS_HANDLE ftpr = SYS_FS_FileOpen(path, (SYS_FS_FILE_OPEN_WRITE));
    if(ftpr == SYS_FS_HANDLE_INVALID){
        #ifdef USE_SYSTEM_TRACE
            USTV_SystemTraceWriteLine("APP_CNN: frontend fail : failed to open spectro.txt file ");
        #endif
        return;
    }
    int i, j;
    char* line= "";
    for(i=0; i< width; i++){
        line = "                    ";
        for(j=0; j<height; j++){
            snprintf(line, 20, "%e ", *(spectro + i*height + j));
            SYS_FS_FilePrintf(ftpr, line);
        }
        SYS_FS_FilePrintf(ftpr, "\n");
    }
    SYS_FS_FileClose(ftpr);
    return;
}

