#ifndef _FFT_H    /* Guard against multiple inclusion */
#define _FFT_H


#include "config/default/system/fs/sys_fs.h"
#include "app_cnn_detection.h"
#include "USTV_SystemTrace.h"
#include "dsplib_dsp.h"

void FFTM(int dir, float m, float x[],float* y);

int melstft(float* meldspectro, float* melpeaks, int32* startaddr, int32* sig, short winsize_log2, short specHeight, short hopsize, short melfeat, short lenspec);

void get_melpeaks(int fs, int minfreq, int maxfreq, int melfeat, float* binpeaks, short winsize);

int Log1p(float* matrix, int width, int height);

void print_to_file(float* spectro, int width, int height, char* path);

int frontend(APP_CNN_DETECTION_DATA* app_cnn_detectionData, int samplerate, int lensig, short winsize_log2, short hopsize, short minfreq, short maxfreq, short melfeat);

int loadWavSignal(APP_CNN_DETECTION_DATA* app_cnn_detectionData, int lensig, int uds, int byteDepth);

int loadLogSignal(APP_CNN_DETECTION_DATA* app_cnn_detectionData, int lensig, int samplerate);

float fmaxf(float a, float b);

float fminf(float a, float b);

float mag32(int32c in);

#endif