/* ************************************************************************** */
/** Descriptive File Name

  @Company
    Company Name

  @File Name
    filename.h

  @Summary
    Brief description of the file.

  @Description
    Describe the purpose of this file.
 */
/* ************************************************************************** */

#ifndef _HIGHBLUE_CONFIGURATION_H    /* Guard against multiple inclusion */
#define _HIGHBLUE_CONFIGURATION_H


/* ************************************************************************** */
/* ************************************************************************** */
/* Section: Included Files                                                    */
/* ************************************************************************** */
/* ************************************************************************** */

/* This section lists the other files that are included in this file.
 */

/* TODO:  Include other files here if needed. */


/* Provide C++ Compatibility */
#ifdef __cplusplus
extern "C" {
#endif


    /* ************************************************************************** */
    /* ************************************************************************** */
    /* Section: Constants                                                         */
    /* ************************************************************************** */
    /* ************************************************************************** */




    /* ************************************************************************** */
//Definition du numero de version: Major.Minor (Hardware revision defined in hardwareProfile.h)
#define SOFTWARE_MAJOR_REV 1
#define SOFTWARE_MINOR_REV 2

#define CC2652_TIMOUT 10    // x100ms
//#define HARDWARE_WORKAROUND
//#define VERSION_GIAS
#define USE_DDR_BUFFER_POOL
//#define MISSION_MAURICE
#define CONFIG_WITH_EXFAT
#ifdef CONFIG_WITH_EXFAT
//    //Toutes les tailles doivent etre multiple de 32!!!!!
//    #define ADDITIONNAL_DATA_SIZE      1216//(10 + 0)
//    #define ANALOG_DATA_SIZE        64320   // = 65536-1024 Nombre d'octets correspondant a la taille du buffer de donnes. 
//    #define DATA_BUFFER_SIZE 65536
    
    //Toutes les tailles doivent etre multiple de 180!!!!!
    #define PACKET_BUFFER_SIZE 65536
    //#define DMA_CUSTOM_PACKET_BUFFER_SIZE 32768
    #define ADDITIONNAL_DATA_SIZE  736

    #define UART3_CIRCULAR_BUFFER_SIZE 1024
    
#else
    //Toutes les tailles doivent etre multiple de 32!!!!!
    #define ADDITIONNAL_DATA_SIZE      1024//(10 + 0)
    #define ANALOG_DATA_SIZE        131040   //Nombre d'octets correspondant a la taille du buffer de donnes.
    #define PACKET_BUFFER_SIZE (ANALOG_DATA_SIZE + ADDITIONNAL_DATA_SIZE)
#endif

#define HEADER_SIZE 1024            //1024

#define USE_SYSTEM_TRACE
#define JASON_TRACE_BUFFER_LENGTH 4096
#define USB_CIRCULAR_BUFFER_SIZE 1024

//Parametres de limitation du soft
#define FREQUENCY_LIMITATION 512000     //Frequence maximum autorise

#define JASON_DEFAULT_FREQ 128000                                     //Frequence d'acquisition par defaut
#define JASON_DEFAULT_CHAN_COUNT 5                                    //Nb de voies par defaut
#define JASON_DEFAULT_FILTER_SEL 1                                     //Filtre par defaut
#define JASON_DEFAULT_RESOLUTION 24                                     //Resolution par defaut
#define JASON_DEFAULT_FILE_SIZE 512000000


//#define FILENAME_FORMAT1
//#define USE_WAV_FORMAT
    
#define MAX_PERIPHERAL 5                   //Nombre max de peripheriques externes
    // *****************************************************************************
    // *****************************************************************************
    // Section: Data Types
    // *****************************************************************************
    // *****************************************************************************

    /*  A brief description of a section can be given directly below the section
        banner.
     */


    // *****************************************************************************



    // *****************************************************************************
    // *****************************************************************************
    // Section: Interface Functions
    // *****************************************************************************
    // *****************************************************************************

   

    /* Provide C++ Compatibility */
#ifdef __cplusplus
}
#endif

#endif /* _EXAMPLE_FILE_NAME_H */

/* *****************************************************************************
 End of File
 */
