/* 
 * File:   HighBlue_Header.h
 * Author: Barchasz
 *
 * Created on 22 juin 2020, 11:14
 */

#ifndef HIGHBLUE_HEADER_H
#define	HIGHBLUE_HEADER_H
#include "HighBlue_Configuration.h"
#ifdef	__cplusplus
extern "C" {
#endif
    
typedef struct{
    uint8_t Type;                                       //type du peripherique (0x01 accel, 0x02 gyro, 0x03 magneto, 0x04 temperature, 0x05 pressure, 0x06 light,...)
    uint8_t ID;                                         //ID du peripherique
    uint8_t Range;                                      //Range de la mesure (ex: 2G, 4G, 6G, 8G, 16G pour un accel)
    uint8_t Resolution;                                 //Resolution de mesure du peripherique
    uint16_t Frequency;                                  //Frequence d'echantillonage du peripherique
}PERIPHERAL_CONFIGURATION;
    
    typedef struct{
        unsigned long headerSize;       //Taille du header ce champ exclu
        unsigned short versionNumber;
        unsigned char numberOfChan;
        unsigned char resolutionBits;
        unsigned long samplingFrequency;
        unsigned long dmaBlockSize;
        unsigned long sizeOfAdditionnalDataBuffer;
        unsigned char numberOfExternalPeripheral;
        unsigned long timeStampOfStart;
        PERIPHERAL_CONFIGURATION periphConfig[MAX_PERIPHERAL];
    }HighBlueHeader;


#ifdef	__cplusplus
}
#endif

#endif	/* HIGHBLUE_HEADER_H */

