/* Microchip Technology Inc. and its subsidiaries.  You may use this software 
 * and any derivatives exclusively with Microchip products. 
 * 
 * THIS SOFTWARE IS SUPPLIED BY MICROCHIP "AS IS".  NO WARRANTIES, WHETHER 
 * EXPRESS, IMPLIED OR STATUTORY, APPLY TO THIS SOFTWARE, INCLUDING ANY IMPLIED 
 * WARRANTIES OF NON-INFRINGEMENT, MERCHANTABILITY, AND FITNESS FOR A 
 * PARTICULAR PURPOSE, OR ITS INTERACTION WITH MICROCHIP PRODUCTS, COMBINATION 
 * WITH ANY OTHER PRODUCTS, OR USE IN ANY APPLICATION. 
 *
 * IN NO EVENT WILL MICROCHIP BE LIABLE FOR ANY INDIRECT, SPECIAL, PUNITIVE, 
 * INCIDENTAL OR CONSEQUENTIAL LOSS, DAMAGE, COST OR EXPENSE OF ANY KIND 
 * WHATSOEVER RELATED TO THE SOFTWARE, HOWEVER CAUSED, EVEN IF MICROCHIP HAS 
 * BEEN ADVISED OF THE POSSIBILITY OR THE DAMAGES ARE FORESEEABLE.  TO THE 
 * FULLEST EXTENT ALLOWED BY LAW, MICROCHIP'S TOTAL LIABILITY ON ALL CLAIMS 
 * IN ANY WAY RELATED TO THIS SOFTWARE WILL NOT EXCEED THE AMOUNT OF FEES, IF 
 * ANY, THAT YOU HAVE PAID DIRECTLY TO MICROCHIP FOR THIS SOFTWARE.
 *
 * MICROCHIP PROVIDES THIS SOFTWARE CONDITIONALLY UPON YOUR ACCEPTANCE OF THESE 
 * TERMS. 
 */

/*******************************************************************************
  This source file has NOT been generated by the MHC
 *******************************************************************************/

/* 
 * File: USTV_DMA.c  
 * Author: Valentin BARCHASZ
 * Comments:
 * Revision history: 1.0
 */

// *****************************************************************************
// *****************************************************************************
// Section: Included Files 
// *****************************************************************************
// *****************************************************************************
#include "USTV_DMA.h"
#include "app.h"
#include "UTLN_spi.h"
#include "UTLN_DDR_CircularBuffer.h"
#include "peripheral/gpio/plib_gpio.h"

// *****************************************************************************
// *****************************************************************************
// Section: Global Data Definitions
// *****************************************************************************
// *****************************************************************************

//#define SPI_DMA_BUFFER_SIZE 65536

// *****************************************************************************
// *****************************************************************************
// Section: User Functions
// *****************************************************************************
// *****************************************************************************


APP_MAKE_BUFFER_DMA_READY unsigned char packetConstructionBuffer[PACKET_BUFFER_SIZE]; //

volatile SPIDMADonebits SPIDMAArrivedFlag;

////<editor-fold defaultstate="collapsed" desc="DMA for SPI INIT">
//void USTV_InitDMAForSPI(unsigned char nbChan, unsigned char resolution)
//{
//    //DDRResetBufferPool();
//    switch(nbChan)
//    {
//        case 1:
//            //<editor-fold defaultstate="collapsed" desc="1 Chan">
//                //===============================DMA Channel 0============================//
//                DCH0CON         = 0x3;  // channel off, priority 3, no chaining
//                DCH0ECON        = 0;    // no start or stop IRQs, no pattern match
//                switch(resolution)
//                {
//                    case 8:
//                        DCH0SSA         = KVA_2_PA((int)&SPI1BUF+3);  // transfer source physical address
//                        DCH0DSA         = KVA_2_PA((unsigned int)DDRGetPointerOfCurrentFillingBuffer(0));    // transfer destination physical address
//                        DCH0SSIZ        = 1;                    // source size 2 bytes
//                        DCH0DSIZ        = DMA_TRANSFERT_SIZE_1_CHAN;      // destination size 0=65536    0x0000ffff=65535
//                        DCH0CSIZ        = 1;    
//                        break;
//                    case 16:
//                        DCH0SSA         = KVA_2_PA((int)&SPI1BUF+2);  // transfer source physical address
//                        DCH0DSA         = KVA_2_PA((unsigned int)DDRGetPointerOfCurrentFillingBuffer(0));    // transfer destination physical address
//                        DCH0SSIZ        = 2;                    // source size 2 bytes
//                        DCH0DSIZ        = DMA_TRANSFERT_SIZE_1_CHAN;      // destination size 0=65536    0x0000ffff=65535
//                        DCH0CSIZ        = 2;    
//                        break;
//                    case 24:
//                        DCH0SSA         = KVA_2_PA((int)&SPI1BUF+1);  // transfer source physical address
//                        DCH0DSA         = KVA_2_PA((unsigned int)DDRGetPointerOfCurrentFillingBuffer(0));    // transfer destination physical address
//                        DCH0SSIZ        = 3;                    // source size 2 bytes
//                        DCH0DSIZ        = DMA_TRANSFERT_SIZE_1_CHAN;      // destination size 0=65536    0x0000ffff=65535
//                        DCH0CSIZ        = 3;                    // 3 bytes transferred per event
//                        break;
//                    case 32:
//                        DCH0SSA         = KVA_2_PA((int)&SPI1BUF);  // transfer source physical address
//                        DCH0DSA         = KVA_2_PA((unsigned int)DDRGetPointerOfCurrentFillingBuffer(0));    // transfer destination physical address
//                        DCH0SSIZ        = 4;                    // source size 2 bytes
//                        DCH0DSIZ        = DMA_TRANSFERT_SIZE_1_CHAN;//ffff;      // destination size 0=65536    0x0000ffff=65535
//                        DCH0CSIZ        = 4;                    // 3 bytes transferred per event
//                        break;
//                }
//                
//                DCH0INT         = 0;                    // clear all interrupts
//                DCH0ECONbits.CHSIRQ = _SPI1_RX_VECTOR;
//                DCH0ECONbits.SIRQEN = 1;                // enable DMA 0 for IRQ trigger
//                DCH0INTbits.CHDDIE = 1;                 // Interrupt when the fill is done.
//                DCH0CONbits.CHEN    = 1;    // turn on DMA channel 0
//                //</editor-fold>
//            break;
//        case 2:
//            //<editor-fold defaultstate="collapsed" desc="2 Chan">
//            //Pas de Ping pong avec le buffer pool
//            DCH0CON         = 0x3;  // channel off, priority 3, no chaining
//            DCH0ECON        = 0;    // no start or stop IRQs, no pattern match
//            #ifdef USE_DDR_BUFFER_POOL
//                DCH0DSA         = KVA_2_PA((unsigned int)DDRGetPointerOfCurrentFillingBuffer(0));    // transfer destination physical address
//            #else
//                DCH0DSA         = KVA_2_PA((int)drvAdcBufferA+ADDITIONNAL_DATA_SIZE);    // transfer destination physical address
//            #endif
//            switch(resolution)
//            {
//                case 8:
//                    DCH0SSA         = KVA_2_PA((int)&SPI1BUF+3);  // transfer source physical address
//                    DCH0SSIZ        = 1;                    // source size 2 bytes
//                    DCH0DSIZ        = DMA_TRANSFERT_SIZE_2_CHAN;      // destination size 0=65536    0x0000ffff=65535
//                    DCH0CSIZ        = 1;    
//                    break;
//                case 16:
//                    DCH0SSA         = KVA_2_PA((int)&SPI1BUF+2);  // transfer source physical address
//                    DCH0SSIZ        = 2;                    // source size 2 bytes
//                    DCH0DSIZ        = DMA_TRANSFERT_SIZE_2_CHAN;      // destination size 0=65536    0x0000ffff=65535
//                    DCH0CSIZ        = 2;    
//                    break;
//                case 24:
//                    DCH0SSA         = KVA_2_PA((int)&SPI1BUF+1);  // transfer source physical address
//                    DCH0SSIZ        = 3;                    // source size 3 bytes
//                    DCH0DSIZ        = DMA_TRANSFERT_SIZE_2_CHAN;      // destination size 0=65536    0x0000ffff=65535
//                    DCH0CSIZ        = 3;                    // 3 bytes transferred per event
//                    break;
//                case 32:
//                    DCH0SSA         = KVA_2_PA((int)&SPI1BUF);  // transfer source physical address
//                    DCH0SSIZ        = 4;                    // source size 2 bytes
//                    DCH0DSIZ        = DMA_TRANSFERT_SIZE_2_CHAN;//ffff;      // destination size 0=65536    0x0000ffff=65535
//                    DCH0CSIZ        = 4;                    // 3 bytes transferred per event
//                    break;
//            }
//            DCH0INT         = 0;                    // clear all interrupts
//            DCH0ECONbits.CHSIRQ = _SPI1_RX_VECTOR;
//            DCH0ECONbits.SIRQEN = 1;                // enable DMA 0 for IRQ trigger
//            DCH0INTbits.CHDDIE = 1;                 // Interrupt when the fill is done.
//            DCH0CONbits.CHEN    = 1;    // turn on DMA channel 0
//
//            //===============================DMA Channel 1============================//
//            DCH1CON         = 0x3;  // channel off, priority 3, no chainin
//            DCH1ECON        = 0;    // no start or stop IRQs, no pattern match
//            #ifdef USE_DDR_BUFFER_POOL
//                DCH1DSA         = KVA_2_PA((unsigned int)DDRGetPointerOfCurrentFillingBuffer(1));    // transfer destination physical address
//            #else
//                DCH1DSA         = KVA_2_PA((int)drvAdcBufferA+ADDITIONNAL_DATA_SIZE+DMA_6CHAN_1_OFFSET);    // transfer destination physical address
//            #endif
//            switch(resolution)
//            {
//                case 8:
//                    DCH1SSA         = KVA_2_PA((int)&SPI2BUF+3);  // transfer source physical address
//                    DCH1SSIZ        = 1;                    // source size 2 bytes
//                    DCH1DSIZ        = DMA_TRANSFERT_SIZE_2_CHAN;      // destination size 0=65536    0x0000ffff=65535
//                    DCH1CSIZ        = 1;    
//                    break;
//                case 16:
//                    DCH1SSA         = KVA_2_PA((int)&SPI2BUF+2);  // transfer source physical address
//                    DCH1SSIZ        = 2;                    // source size 2 bytes
//                    DCH1DSIZ        = DMA_TRANSFERT_SIZE_2_CHAN;      // destination size 0=65536    0x0000ffff=65535
//                    DCH1CSIZ        = 2;    
//                    break;
//                case 24:
//                    DCH1SSA         = KVA_2_PA((int)&SPI2BUF+1);  // transfer source physical address
//                    DCH1SSIZ        = 3;                    // source size 3 bytes
//                    DCH1DSIZ        = DMA_TRANSFERT_SIZE_2_CHAN;      // destination size 0=65536    0x0000ffff=65535
//                    DCH1CSIZ        = 3;                    // 3 bytes transferred per event
//                    break;
//                case 32:
//                    DCH1SSA         = KVA_2_PA((int)&SPI2BUF);  // transfer source physical address
//                    DCH1SSIZ        = 4;                    // source size 2 bytes
//                    DCH1DSIZ        = DMA_TRANSFERT_SIZE_2_CHAN;//ffff;      // destination size 0=65536    0x0000ffff=65535
//                    DCH1CSIZ        = 4;                    // 3 bytes transferred per event
//                    break;
//            }
//            DCH1INT         = 0;                    // clear all interrupts
//            DCH1ECONbits.CHSIRQ = _SPI2_RX_VECTOR;
//            DCH1ECONbits.SIRQEN = 1;                // enable DMA 1 for IRQ trigger
//            DCH1INTbits.CHDDIE = 1;                 // Interrupt when the fill is done.
//            DCH1CONbits.CHEN    = 1;    // turn on DMA channel 0
//
//            //</editor-fold>
//            break;
//        case 3:
//            //<editor-fold defaultstate="collapsed" desc="3 Chan">
//            //===============================DMA Channel 0============================//
//            DCH0CON         = 0x3;  // channel off, priority 3, no chaining
//            DCH0ECON        = 0;    // no start or stop IRQs, no pattern match
//            #ifdef USE_DDR_BUFFER_POOL
//                DCH0DSA         = KVA_2_PA((unsigned int)DDRGetPointerOfCurrentFillingBuffer(0));    // transfer destination physical address
//            #else
//                DCH0DSA         = KVA_2_PA((int)drvAdcBufferA+ADDITIONNAL_DATA_SIZE);    // transfer destination physical address
//            #endif
//                switch(resolution)
//                {
//                    case 8:
//                        DCH0SSA         = KVA_2_PA((int)&SPI1BUF+3);  // transfer source physical address
//                        DCH0SSIZ        = 1;                    // source size 2 bytes
//                        DCH0DSIZ        = DMA_TRANSFERT_SIZE_3_CHAN;      // destination size 0=65536    0x0000ffff=65535
//                        DCH0CSIZ        = 1;    
//                        break;
//                    case 16:
//                        DCH0SSA         = KVA_2_PA((int)&SPI1BUF+2);  // transfer source physical address
//                        DCH0SSIZ        = 2;                    // source size 2 bytes
//                        DCH0DSIZ        = DMA_TRANSFERT_SIZE_3_CHAN;      // destination size 0=65536    0x0000ffff=65535
//                        DCH0CSIZ        = 2;    
//                        break;
//                    case 24:
//                        DCH0SSA         = KVA_2_PA((int)&SPI1BUF+1);  // transfer source physical address
//                        DCH0SSIZ        = 3;                    // source size 2 bytes
//                        DCH0DSIZ        = DMA_TRANSFERT_SIZE_3_CHAN;      // destination size 0=65536    0x0000ffff=65535
//                        DCH0CSIZ        = 3;                    // 3 bytes transferred per event
//                        break;
//                    case 32:
//                        DCH0SSA         = KVA_2_PA((int)&SPI1BUF);  // transfer source physical address
//                        DCH0SSIZ        = 4;                    // source size 2 bytes
//                        DCH0DSIZ        = DMA_TRANSFERT_SIZE_3_CHAN;//ffff;      // destination size 0=65536    0x0000ffff=65535
//                        DCH0CSIZ        = 4;                    // 3 bytes transferred per event
//                        break;
//                }
//            DCH0INT         = 0;                    // clear all interrupts
//            DCH0ECONbits.CHSIRQ = _SPI1_RX_VECTOR;
//            DCH0ECONbits.SIRQEN = 1;                // enable DMA 0 for IRQ trigger
//            //DCH0INTbits.CHDDIE = 1;                 // Interrupt when the fill is done.
//            DCH0CONbits.CHAED=1;                    //Channel start/abort events will be registered, even if the channel is disabled
//            DCH0CONbits.CHEN    = 1;    // turn on DMA channel 0
//            //===============================DMA Channel 1============================//
//            //===============================Chained by chan0=========================//
//            DCH1CON         = 0x3;  // channel off, priority 3, no chainin
//            DCH1ECON        = 0;    // no start or stop IRQs, no pattern match
//            #ifdef USE_DDR_BUFFER_POOL
//                DCH1DSA         = KVA_2_PA((unsigned int)DDRGetPointerOfCurrentFillingBuffer(1));    // transfer destination physical address
//            #else
//                DCH1DSA         = KVA_2_PA((int)drvAdcBufferB+ADDITIONNAL_DATA_SIZE);    // transfer destination physical address
//            #endif
//                switch(resolution)
//                {
//                    case 8:
//                        DCH1SSA         = KVA_2_PA((int)&SPI1BUF+3);  // transfer source physical address
//                        DCH1SSIZ        = 1;                    // source size 2 bytes
//                        DCH1DSIZ        = DMA_TRANSFERT_SIZE_3_CHAN;      // destination size 0=65536    0x0000ffff=65535
//                        DCH1CSIZ        = 1;    
//                        break;
//                    case 16:
//                        DCH1SSA         = KVA_2_PA((int)&SPI1BUF+2);  // transfer source physical address
//                        DCH1SSIZ        = 2;                    // source size 2 bytes
//                        DCH1DSIZ        = DMA_TRANSFERT_SIZE_3_CHAN;      // destination size 0=65536    0x0000ffff=65535
//                        DCH1CSIZ        = 2;    
//                        break;
//                    case 24:
//                        DCH1SSA         = KVA_2_PA((int)&SPI1BUF+1);  // transfer source physical address
//                        DCH1SSIZ        = 3;                    // source size 2 bytes
//                        DCH1DSIZ        = DMA_TRANSFERT_SIZE_3_CHAN;      // destination size 0=65536    0x0000ffff=65535
//                        DCH1CSIZ        = 3;                    // 3 bytes transferred per event
//                        break;
//                    case 32:
//                        DCH1SSA         = KVA_2_PA((int)&SPI1BUF);  // transfer source physical address
//                        DCH1SSIZ        = 4;                    // source size 2 bytes
//                        DCH1DSIZ        = DMA_TRANSFERT_SIZE_3_CHAN;//ffff;      // destination size 0=65536    0x0000ffff=65535
//                        DCH1CSIZ        = 4;                    // 3 bytes transferred per event
//                        break;
//                }
//            DCH1INT         = 0;                    // clear all interrupts
//            DCH1ECONbits.CHSIRQ = _SPI1_RX_VECTOR;
//            DCH1ECONbits.SIRQEN = 1;                // enable DMA 0 for IRQ trigger
//            //DCH1INTbits.CHDDIE = 1;                 // Interrupt when the fill is done.
//            DCH1CONbits.CHAED=1;                    //Channel start/abort events will be registered, even if the channel is disabled
//            DCH1CONbits.CHEN    = 1;    // turn on DMA channel 0
//
//
//
//
//            //===============================DMA Channel 2============================//
//            DCH2CON         = 0x3;  // channel off, priority 3, no chaining
//            DCH2ECON        = 0;    // no start or stop IRQs, no pattern match
//            DCH2DSA         = KVA_2_PA((unsigned int)DDRGetPointerOfCurrentFillingBuffer(2));    // transfer destination physical address
//            switch(resolution)
//            {
//                case 8:
//                    DCH2SSA         = KVA_2_PA((int)&SPI2BUF+3);  // transfer source physical address
//                    DCH2SSIZ        = 1;                    // source size 2 bytes
//                    DCH2DSIZ        = DMA_TRANSFERT_SIZE_3_CHAN;      // destination size 0=65536    0x0000ffff=65535
//                    DCH2CSIZ        = 1;    
//                    break;
//                case 16:
//                    DCH2SSA         = KVA_2_PA((int)&SPI2BUF+2);  // transfer source physical address
//                    DCH2SSIZ        = 2;                    // source size 2 bytes
//                    DCH2DSIZ        = DMA_TRANSFERT_SIZE_3_CHAN;      // destination size 0=65536    0x0000ffff=65535
//                    DCH2CSIZ        = 2;    
//                    break;
//                case 24:
//                    DCH2SSA         = KVA_2_PA((int)&SPI2BUF+1);  // transfer source physical address
//                    DCH2SSIZ        = 3;                    // source size 2 bytes
//                    DCH2DSIZ        = DMA_TRANSFERT_SIZE_3_CHAN;      // destination size 0=65536    0x0000ffff=65535
//                    DCH2CSIZ        = 3;                    // 3 bytes transferred per event
//                    break;
//                case 32:
//                    DCH2SSA         = KVA_2_PA((int)&SPI2BUF);  // transfer source physical address
//                    DCH2SSIZ        = 4;                    // source size 2 bytes
//                    DCH2DSIZ        = DMA_TRANSFERT_SIZE_3_CHAN;//ffff;      // destination size 0=65536    0x0000ffff=65535
//                    DCH2CSIZ        = 4;                    // 3 bytes transferred per event
//                    break;
//            }
//            DCH2INT         = 0;                    // clear all interrupts
//            DCH2ECONbits.CHSIRQ = _SPI2_RX_VECTOR;
//            DCH2ECONbits.SIRQEN = 1;                // enable DMA 2 for IRQ trigger
//            DCH2INTbits.CHDDIE = 1;                 // Interrupt when the fill is done.
//            DCH2CONbits.CHAED=1;                    //Channel start/abort events will be registered, even if the channel is disabled
//            DCH2CONbits.CHEN    = 1;    // turn on DMA channel 0
//            //</editor-fold>
//            break;
//        case 4:
//            //<editor-fold defaultstate="collapsed" desc="4 Chan">
//            //Pas de Ping pong avec le buffer pool
//            DCH0CON         = 0x3;  // channel off, priority 3, no chaining
//            DCH0ECON        = 0;    // no start or stop IRQs, no pattern match
//            DCH0DSA         = KVA_2_PA((unsigned int)DDRGetPointerOfCurrentFillingBuffer(0));    // transfer destination physical address
//            switch(resolution)
//            {
//                case 8:
//                    DCH0SSA         = KVA_2_PA((int)&SPI1BUF+3);  // transfer source physical address
//                    DCH0SSIZ        = 1;                    // source size 2 bytes
//                    DCH0DSIZ        = DMA_TRANSFERT_SIZE_4_CHAN;      // destination size 0=65536    0x0000ffff=65535
//                    DCH0CSIZ        = 1;    
//                    break;
//                case 16:
//                    DCH0SSA         = KVA_2_PA((int)&SPI1BUF+2);  // transfer source physical address
//                    DCH0SSIZ        = 2;                    // source size 2 bytes
//                    DCH0DSIZ        = DMA_TRANSFERT_SIZE_4_CHAN;      // destination size 0=65536    0x0000ffff=65535
//                    DCH0CSIZ        = 2;    
//                    break;
//                case 24:
//                    DCH0SSA         = KVA_2_PA((int)&SPI1BUF+1);  // transfer source physical address
//                    DCH0SSIZ        = 3;                    // source size 3 bytes
//                    DCH0DSIZ        = DMA_TRANSFERT_SIZE_4_CHAN;      // destination size 0=65536    0x0000ffff=65535
//                    DCH0CSIZ        = 3;                    // 3 bytes transferred per event
//                    break;
//                case 32:
//                    DCH0SSA         = KVA_2_PA((int)&SPI1BUF);  // transfer source physical address
//                    DCH0SSIZ        = 4;                    // source size 2 bytes
//                    DCH0DSIZ        = DMA_TRANSFERT_SIZE_4_CHAN;//ffff;      // destination size 0=65536    0x0000ffff=65535
//                    DCH0CSIZ        = 4;                    // 3 bytes transferred per event
//                    break;
//            }
//            DCH0INT         = 0;                    // clear all interrupts
//            DCH0ECONbits.CHSIRQ = _SPI1_RX_VECTOR;
//            DCH0ECONbits.SIRQEN = 1;                // enable DMA 0 for IRQ trigger
//            DCH0INTbits.CHDDIE = 1;                 // Interrupt when the fill is done.
//            DCH0CONbits.CHAED=1;                    //Channel start/abort events will be registered, even if the channel is disabled
//            DCH0CONbits.CHEN    = 1;    // turn on DMA channel 0
//
//            //===============================DMA Channel 1============================//
//            DCH1CON         = 0x3;  // channel off, priority 3, no chainin
//            DCH1ECON        = 0;    // no start or stop IRQs, no pattern match
//            DCH1DSA         = KVA_2_PA((unsigned int)DDRGetPointerOfCurrentFillingBuffer(1));    // transfer destination physical address
//            
//            switch(resolution)
//            {
//                case 8:
//                    DCH1SSA         = KVA_2_PA((int)&SPI2BUF+3);  // transfer source physical address
//                    DCH1SSIZ        = 1;                    // source size 2 bytes
//                    DCH1DSIZ        = DMA_TRANSFERT_SIZE_4_CHAN;      // destination size 0=65536    0x0000ffff=65535
//                    DCH1CSIZ        = 1;    
//                    break;
//                case 16:
//                    DCH1SSA         = KVA_2_PA((int)&SPI2BUF+2);  // transfer source physical address
//                    DCH1SSIZ        = 2;                    // source size 2 bytes
//                    DCH1DSIZ        = DMA_TRANSFERT_SIZE_4_CHAN;      // destination size 0=65536    0x0000ffff=65535
//                    DCH1CSIZ        = 2;    
//                    break;
//                case 24:
//                    DCH1SSA         = KVA_2_PA((int)&SPI2BUF+1);  // transfer source physical address
//                    DCH1SSIZ        = 3;                    // source size 3 bytes
//                    DCH1DSIZ        = DMA_TRANSFERT_SIZE_4_CHAN;      // destination size 0=65536    0x0000ffff=65535
//                    DCH1CSIZ        = 3;                    // 3 bytes transferred per event
//                    break;
//                case 32:
//                    DCH1SSA         = KVA_2_PA((int)&SPI2BUF);  // transfer source physical address
//                    DCH1SSIZ        = 4;                    // source size 2 bytes
//                    DCH1DSIZ        = DMA_TRANSFERT_SIZE_4_CHAN;//ffff;      // destination size 0=65536    0x0000ffff=65535
//                    DCH1CSIZ        = 4;                    // 3 bytes transferred per event
//                    break;
//            }
//            DCH1INT         = 0;                    // clear all interrupts
//            DCH1ECONbits.CHSIRQ = _SPI2_RX_VECTOR;
//            DCH1ECONbits.SIRQEN = 1;                // enable DMA 1 for IRQ trigger
//            DCH1INTbits.CHDDIE = 1;                 // Interrupt when the fill is done.
//            DCH1CONbits.CHAED=1;                    //Channel start/abort events will be registered, even if the channel is disabled
//            DCH1CONbits.CHEN    = 1;    // turn on DMA channel 0
//
//            //Pas de Ping pong avec le buffer pool
//            DCH2CON         = 0x3;  // channel off, priority 3, no chaining
//            DCH2ECON        = 0;    // no start or stop IRQs, no pattern match
//            DCH2DSA         = KVA_2_PA((unsigned int)DDRGetPointerOfCurrentFillingBuffer(2));    // transfer destination physical address
//            switch(resolution)
//            {
//                case 8:
//                    DCH2SSA         = KVA_2_PA((int)&SPI3BUF+3);  // transfer source physical address
//                    DCH2SSIZ        = 1;                    // source size 2 bytes
//                    DCH2DSIZ        = DMA_TRANSFERT_SIZE_4_CHAN;      // destination size 0=65536    0x0000ffff=65535
//                    DCH2CSIZ        = 1;    
//                    break;
//                case 16:
//                    DCH2SSA         = KVA_2_PA((int)&SPI3BUF+2);  // transfer source physical address
//                    DCH2SSIZ        = 2;                    // source size 2 bytes
//                    DCH2DSIZ        = DMA_TRANSFERT_SIZE_4_CHAN;      // destination size 0=65536    0x0000ffff=65535
//                    DCH2CSIZ        = 2;    
//                    break;
//                case 24:
//                    DCH2SSA         = KVA_2_PA((int)&SPI3BUF+1);  // transfer source physical address
//                    DCH2SSIZ        = 3;                    // source size 3 bytes
//                    DCH2DSIZ        = DMA_TRANSFERT_SIZE_4_CHAN;      // destination size 0=65536    0x0000ffff=65535
//                    DCH2CSIZ        = 3;                    // 3 bytes transferred per event
//                    break;
//                case 32:
//                    DCH2SSA         = KVA_2_PA((int)&SPI3BUF);  // transfer source physical address
//                    DCH2SSIZ        = 4;                    // source size 2 bytes
//                    DCH2DSIZ        = DMA_TRANSFERT_SIZE_4_CHAN;//ffff;      // destination size 0=65536    0x0000ffff=65535
//                    DCH2CSIZ        = 4;                    // 3 bytes transferred per event
//                    break;
//            }
//            DCH2INT         = 0;                    // clear all interrupts
//            DCH2ECONbits.CHSIRQ = _SPI3_RX_VECTOR;
//            DCH2ECONbits.SIRQEN = 1;                // enable DMA 0 for IRQ trigger
//            DCH2INTbits.CHDDIE = 1;                 // Interrupt when the fill is done.
//            DCH2CONbits.CHAED=1;                    //Channel start/abort events will be registered, even if the channel is disabled
//            DCH2CONbits.CHEN    = 1;    // turn on DMA channel 0
//
//            //===============================DMA Channel 1============================//
//            DCH3CON         = 0x3;  // channel off, priority 3, no chainin
//            DCH3ECON        = 0;    // no start or stop IRQs, no pattern match
//            DCH3DSA         = KVA_2_PA((unsigned int)DDRGetPointerOfCurrentFillingBuffer(3));    // transfer destination physical address            
//            switch(resolution)
//            {
//                case 8:
//                    DCH3SSA         = KVA_2_PA((int)&SPI4BUF+3);  // transfer source physical address
//                    DCH3SSIZ        = 1;                    // source size 2 bytes
//                    DCH3DSIZ        = DMA_TRANSFERT_SIZE_4_CHAN;      // destination size 0=65536    0x0000ffff=65535
//                    DCH3CSIZ        = 1;    
//                    break;
//                case 16:
//                    DCH3SSA         = KVA_2_PA((int)&SPI4BUF+2);  // transfer source physical address
//                    DCH3SSIZ        = 2;                    // source size 2 bytes
//                    DCH3DSIZ        = DMA_TRANSFERT_SIZE_4_CHAN;      // destination size 0=65536    0x0000ffff=65535
//                    DCH3CSIZ        = 2;    
//                    break;
//                case 24:
//                    DCH3SSA         = KVA_2_PA((int)&SPI4BUF+1);  // transfer source physical address
//                    DCH3SSIZ        = 3;                    // source size 3 bytes
//                    DCH3DSIZ        = DMA_TRANSFERT_SIZE_4_CHAN;      // destination size 0=65536    0x0000ffff=65535
//                    DCH3CSIZ        = 3;                    // 3 bytes transferred per event
//                    break;
//                case 32:
//                    DCH3SSA         = KVA_2_PA((int)&SPI4BUF);  // transfer source physical address
//                    DCH3SSIZ        = 4;                    // source size 2 bytes
//                    DCH3DSIZ        = DMA_TRANSFERT_SIZE_4_CHAN;//ffff;      // destination size 0=65536    0x0000ffff=65535
//                    DCH3CSIZ        = 4;                    // 3 bytes transferred per event
//                    break;
//            }
//            DCH3INT         = 0;                    // clear all interrupts
//            DCH3ECONbits.CHSIRQ = _SPI4_RX_VECTOR;
//            DCH3ECONbits.SIRQEN = 1;                // enable DMA 1 for IRQ trigger
//            DCH3INTbits.CHDDIE = 1;                 // Interrupt when the fill is done.
//            DCH3CONbits.CHAED=1;                    //Channel start/abort events will be registered, even if the channel is disabled
//            DCH3CONbits.CHEN    = 1;    // turn on DMA channel 0           
//            //</editor-fold>
//            break;
//        case 5://Pas de ping pong en mode 6 chan, du au nombre de cannaux DMA limit a 8
//            //<editor-fold defaultstate="collapsed" desc="5 Chan">
//
//            //Pas de Ping pong avec le buffer pool
//            DCH0CON         = 0x3;  // channel off, priority 3, no chaining
//            DCH0ECON        = 0;    // no start or stop IRQs, no pattern match
//            DCH0DSA         = KVA_2_PA((unsigned int)DDRGetPointerOfCurrentFillingBuffer(0));    // transfer destination physical address
//            DCH0DSIZ        = DMA_TRANSFERT_SIZE_5_CHAN;//ffff;      // destination size 0=65536    0x0000ffff=65535
//            switch(resolution)
//            {
//                case 8:
//                    DCH0SSA         = KVA_2_PA((int)&SPI1BUF+3);  // transfer source physical address
//                    DCH0SSIZ        = 1;                    // source size 2 bytes
//                    DCH0CSIZ        = 1;    
//                    break;
//                case 16:
//                    DCH0SSA         = KVA_2_PA((int)&SPI1BUF+2);  // transfer source physical address
//                    DCH0SSIZ        = 2;                    // source size 2 bytes
//                    DCH0CSIZ        = 2;    
//                    break;
//                case 24:
//                    DCH0SSA         = KVA_2_PA((int)&SPI1BUF+1);  // transfer source physical address
//                    DCH0SSIZ        = 3;                    // source size 3 bytes
//                    DCH0CSIZ        = 3;                    // 3 bytes transferred per event
//                    break;
//                case 32:
//                    DCH0SSA         = KVA_2_PA((int)&SPI1BUF);  // transfer source physical address
//                    DCH0SSIZ        = 4;                    // source size 2 bytes
//                    DCH0CSIZ        = 4;                    // 3 bytes transferred per event
//                    break;
//            }
//            DCH0INT         = 0;                    // clear all interrupts
//            DCH0ECONbits.CHSIRQ = _SPI1_RX_VECTOR;
//            DCH0ECONbits.SIRQEN = 1;                // enable DMA 0 for IRQ trigger
//            DCH0INTbits.CHDDIE = 1;                 // Interrupt when the fill is done.
//            DCH0CONbits.CHAED=1;                    //Channel start/abort events will be registered, even if the channel is disabled
//            DCH0CONbits.CHEN    = 1;    // turn on DMA channel 0
//
//            //===============================DMA Channel 1============================//
//            DCH1CON         = 0x3;  // channel off, priority 3, no chainin
//            DCH1ECON        = 0;    // no start or stop IRQs, no pattern match
//            DCH1DSA         = KVA_2_PA((unsigned int)DDRGetPointerOfCurrentFillingBuffer(1));    // transfer destination physical address
//            DCH1DSIZ        = DMA_TRANSFERT_SIZE_5_CHAN;//ffff;      // destination size 0=65536    0x0000ffff=65535
//            switch(resolution)
//            {
//                case 8:
//                    DCH1SSA         = KVA_2_PA((int)&SPI2BUF+3);  // transfer source physical address
//                    DCH1SSIZ        = 1;                    // source size 2 bytes
//                    DCH1CSIZ        = 1;    
//                    break;
//                case 16:
//                    DCH1SSA         = KVA_2_PA((int)&SPI2BUF+2);  // transfer source physical address
//                    DCH1SSIZ        = 2;                    // source size 2 bytes
//                    DCH1CSIZ        = 2;    
//                    break;
//                case 24:
//                    DCH1SSA         = KVA_2_PA((int)&SPI2BUF+1);  // transfer source physical address
//                    DCH1SSIZ        = 3;                    // source size 3 bytes
//                    DCH1CSIZ        = 3;                    // 3 bytes transferred per event
//                    break;
//                case 32:
//                    DCH1SSA         = KVA_2_PA((int)&SPI2BUF);  // transfer source physical address
//                    DCH1SSIZ        = 4;                    // source size 2 bytes
//                    DCH1CSIZ        = 4;                    // 3 bytes transferred per event
//                    break;
//            }
//            DCH1INT         = 0;                    // clear all interrupts
//            DCH1ECONbits.CHSIRQ = _SPI2_RX_VECTOR;
//            DCH1ECONbits.SIRQEN = 1;                // enable DMA 1 for IRQ trigger
//            DCH1INTbits.CHDDIE = 1;                 // Interrupt when the fill is done.
//            DCH1CONbits.CHAED=1;                    //Channel start/abort events will be registered, even if the channel is disabled
//            DCH1CONbits.CHEN    = 1;    // turn on DMA channel 0
//
//            //Pas de Ping pong avec le buffer pool
//            DCH2CON         = 0x3;  // channel off, priority 3, no chaining
//            DCH2ECON        = 0;    // no start or stop IRQs, no pattern match
//            DCH2DSA         = KVA_2_PA((unsigned int)DDRGetPointerOfCurrentFillingBuffer(2));    // transfer destination physical address
//            DCH2DSIZ        = DMA_TRANSFERT_SIZE_5_CHAN;//ffff;      // destination size 0=65536    0x0000ffff=65535
//            switch(resolution)
//            {
//                case 8:
//                    DCH2SSA         = KVA_2_PA((int)&SPI3BUF+3);  // transfer source physical address
//                    DCH2SSIZ        = 1;                    // source size 2 bytes
//                    DCH2CSIZ        = 1;    
//                    break;
//                case 16:
//                    DCH2SSA         = KVA_2_PA((int)&SPI3BUF+2);  // transfer source physical address
//                    DCH2SSIZ        = 2;                    // source size 2 bytes
//                    DCH2CSIZ        = 2;    
//                    break;
//                case 24:
//                    DCH2SSA         = KVA_2_PA((int)&SPI3BUF+1);  // transfer source physical address
//                    DCH2SSIZ        = 3;                    // source size 3 bytes
//                    DCH2CSIZ        = 3;                    // 3 bytes transferred per event
//                    break;
//                case 32:
//                    DCH2SSA         = KVA_2_PA((int)&SPI3BUF);  // transfer source physical address
//                    DCH2SSIZ        = 4;                    // source size 2 bytes
//                    DCH2CSIZ        = 4;                    // 3 bytes transferred per event
//                    break;
//            }
//            DCH2INT         = 0;                    // clear all interrupts
//            DCH2ECONbits.CHSIRQ = _SPI3_RX_VECTOR;
//            DCH2ECONbits.SIRQEN = 1;                // enable DMA 0 for IRQ trigger
//            DCH2INTbits.CHDDIE = 1;                 // Interrupt when the fill is done.
//            DCH2CONbits.CHAED=1;                    //Channel start/abort events will be registered, even if the channel is disabled
//            DCH2CONbits.CHEN    = 1;    // turn on DMA channel 0
//
//            //===============================DMA Channel 3============================//
//            DCH3CON         = 0x3;  // channel off, priority 3, no chainin
//            DCH3ECON        = 0;    // no start or stop IRQs, no pattern match
//            DCH3DSA         = KVA_2_PA((unsigned int)DDRGetPointerOfCurrentFillingBuffer(3));    // transfer destination physical address
//            DCH3DSIZ        = DMA_TRANSFERT_SIZE_5_CHAN;      // destination size 0=65536    0x0000ffff=65535
//            switch(resolution)
//            {
//                case 8:
//                    DCH3SSA         = KVA_2_PA((int)&SPI4BUF+3);  // transfer source physical address
//                    DCH3SSIZ        = 1;                    // source size 2 bytes
//                    DCH3CSIZ        = 1;    
//                    break;
//                case 16:
//                    DCH3SSA         = KVA_2_PA((int)&SPI4BUF+2);  // transfer source physical address
//                    DCH3SSIZ        = 2;                    // source size 2 bytes
//                    DCH3CSIZ        = 2;    
//                    break;
//                case 24:
//                    DCH3SSA         = KVA_2_PA((int)&SPI4BUF+1);  // transfer source physical address
//                    DCH3SSIZ        = 3;                    // source size 3 bytes
//                    DCH3CSIZ        = 3;                    // 3 bytes transferred per event
//                    break;
//                case 32:
//                    DCH3SSA         = KVA_2_PA((int)&SPI4BUF);  // transfer source physical address
//                    DCH3SSIZ        = 4;                    // source size 2 bytes
//                    DCH3CSIZ        = 4;                    // 3 bytes transferred per event
//                    break;
//            }
//            DCH3INT         = 0;                    // clear all interrupts
//            DCH3ECONbits.CHSIRQ = _SPI4_RX_VECTOR;
//            DCH3ECONbits.SIRQEN = 1;                // enable DMA 1 for IRQ trigger
//            DCH3INTbits.CHDDIE = 1;                 // Interrupt when the fill is done.
//            DCH3CONbits.CHAED=1;                    //Channel start/abort events will be registered, even if the channel is disabled
//            DCH3CONbits.CHEN    = 1;    // turn on DMA channel 0
//            //===============================DMA Channel 4============================//
//            DCH4CON         = 0x3;  // channel off, priority 3, no chainin
//            DCH4ECON        = 0;    // no start or stop IRQs, no pattern match
//            DCH4DSA         = KVA_2_PA((unsigned int)DDRGetPointerOfCurrentFillingBuffer(4));    // transfer destination physical address
//            DCH4DSIZ        = DMA_TRANSFERT_SIZE_5_CHAN;      // destination size 0=65536    0x0000ffff=65535
//            switch(resolution)
//            {
//                case 8:
//                    DCH4SSA         = KVA_2_PA((int)&SPI5BUF+3);  // transfer source physical address
//                    DCH4SSIZ        = 1;                    // source size 2 bytes
//                    DCH4CSIZ        = 1;    
//                    break;
//                case 16:
//                    DCH4SSA         = KVA_2_PA((int)&SPI5BUF+2);  // transfer source physical address
//                    DCH4SSIZ        = 2;                    // source size 2 bytes
//                    DCH4CSIZ        = 2;    
//                    break;
//                case 24:
//                    DCH4SSA         = KVA_2_PA((int)&SPI5BUF+1);  // transfer source physical address
//                    DCH4SSIZ        = 3;                    // source size 3 bytes
//                    DCH4CSIZ        = 3;                    // 3 bytes transferred per event
//                    break;
//                case 32:
//                    DCH4SSA         = KVA_2_PA((int)&SPI5BUF);  // transfer source physical address
//                    DCH4SSIZ        = 4;                    // source size 2 bytes
//                    DCH4CSIZ        = 4;                    // 3 bytes transferred per event
//                    break;
//            }
//            DCH4INT         = 0;                    // clear all interrupts
//            DCH4ECONbits.CHSIRQ = _SPI5_RX_VECTOR;
//            DCH4ECONbits.SIRQEN = 1;                // enable DMA 1 for IRQ trigger
//            DCH4INTbits.CHDDIE = 1;                 // Interrupt when the fill is done.
//            DCH4CONbits.CHAED=1;                    //Channel start/abort events will be registered, even if the channel is disabled
//            DCH4CONbits.CHEN    = 1;    // turn on DMA channel 0   
//            //</editor-fold>
//            break;
//            
//        case 6://Pas de ping pong en mode 5 chan, du au nombre de cannaux DMA limit a 8
//            //<editor-fold defaultstate="collapsed" desc="6 Chan">
//            //Pas de Ping pong avec le buffer pool
//            DCH0CON         = 0x3;  // channel off, priority 3, no chaining
//            DCH0ECON        = 0;    // no start or stop IRQs, no pattern match
//            DCH0DSA         = KVA_2_PA((unsigned int)DDRGetPointerOfCurrentFillingBuffer(0));    // transfer destination physical address
//            DCH0DSIZ        = DMA_TRANSFERT_SIZE_6_CHAN;      // destination size 0=65536    0x0000ffff=65535
//            switch(resolution)
//            {
//                case 8:
//                    DCH0SSA         = KVA_2_PA((int)&SPI1BUF+3);  // transfer source physical address
//                    DCH0SSIZ        = 1;                    // source size 2 bytes
//                    DCH0CSIZ        = 1;    
//                    break;
//                case 16:
//                    DCH0SSA         = KVA_2_PA((int)&SPI1BUF+2);  // transfer source physical address
//                    DCH0SSIZ        = 2;                    // source size 2 bytes
//                    DCH0CSIZ        = 2;    
//                    break;
//                case 24:
//                    DCH0SSA         = KVA_2_PA((int)&SPI1BUF+1);  // transfer source physical address
//                    DCH0SSIZ        = 3;                    // source size 3 bytes
//                    DCH0CSIZ        = 3;                    // 3 bytes transferred per event
//                    break;
//                case 32:
//                    DCH0SSA         = KVA_2_PA((int)&SPI1BUF);  // transfer source physical address
//                    DCH0SSIZ        = 4;                    // source size 2 bytes
//                    DCH0CSIZ        = 4;                    // 3 bytes transferred per event
//                    break;
//            }
//            DCH0INT         = 0;                    // clear all interrupts
//            DCH0ECONbits.CHSIRQ = _SPI1_RX_VECTOR;
//            DCH0ECONbits.SIRQEN = 1;                // enable DMA 0 for IRQ trigger
//            DCH0INTbits.CHDDIE = 1;                 // Interrupt when the fill is done.
//            DCH0CONbits.CHAED=1;                    //Channel start/abort events will be registered, even if the channel is disabled
//            DCH0CONbits.CHEN    = 1;    // turn on DMA channel 0
//
//            //===============================DMA Channel 1============================//
//            DCH1CON         = 0x3;  // channel off, priority 3, no chainin
//            DCH1ECON        = 0;    // no start or stop IRQs, no pattern match
//            DCH1DSA         = KVA_2_PA((unsigned int)DDRGetPointerOfCurrentFillingBuffer(1));    // transfer destination physical address
//            DCH1DSIZ        = DMA_TRANSFERT_SIZE_6_CHAN;//ffff;      // destination size 0=65536    0x0000ffff=65535
//            switch(resolution)
//            {
//                case 8:
//                    DCH1SSA         = KVA_2_PA((int)&SPI2BUF+3);  // transfer source physical address
//                    DCH1SSIZ        = 1;                    // source size 2 bytes
//                    DCH1CSIZ        = 1;    
//                    break;
//                case 16:
//                    DCH1SSA         = KVA_2_PA((int)&SPI2BUF+2);  // transfer source physical address
//                    DCH1SSIZ        = 2;                    // source size 2 bytes
//                    DCH1CSIZ        = 2;    
//                    break;
//                case 24:
//                    DCH1SSA         = KVA_2_PA((int)&SPI2BUF+1);  // transfer source physical address
//                    DCH1SSIZ        = 3;                    // source size 3 bytes
//                    DCH1CSIZ        = 3;                    // 3 bytes transferred per event
//                    break;
//                case 32:
//                    DCH1SSA         = KVA_2_PA((int)&SPI2BUF);  // transfer source physical address
//                    DCH1SSIZ        = 4;                    // source size 2 bytes
//                    DCH1CSIZ        = 4;                    // 3 bytes transferred per event
//                    break;
//            }
//            DCH1INT         = 0;                    // clear all interrupts
//            DCH1ECONbits.CHSIRQ = _SPI2_RX_VECTOR;
//            DCH1ECONbits.SIRQEN = 1;                // enable DMA 1 for IRQ trigger
//            DCH1INTbits.CHDDIE = 1;                 // Interrupt when the fill is done.
//            DCH1CONbits.CHAED=1;                    //Channel start/abort events will be registered, even if the channel is disabled
//            DCH1CONbits.CHEN    = 1;    // turn on DMA channel 0
//
//            //Pas de Ping pong avec le buffer pool
//            DCH2CON         = 0x3;  // channel off, priority 3, no chaining
//            DCH2ECON        = 0;    // no start or stop IRQs, no pattern match
//            DCH2DSA         = KVA_2_PA((unsigned int)DDRGetPointerOfCurrentFillingBuffer(2));    // transfer destination physical address
//            DCH2DSIZ        = DMA_TRANSFERT_SIZE_6_CHAN;//ffff;      // destination size 0=65536    0x0000ffff=65535
//            switch(resolution)
//            {
//                case 8:
//                    DCH2SSA         = KVA_2_PA((int)&SPI3BUF+3);  // transfer source physical address
//                    DCH2SSIZ        = 1;                    // source size 2 bytes
//                    DCH2CSIZ        = 1;    
//                    break;
//                case 16:
//                    DCH2SSA         = KVA_2_PA((int)&SPI3BUF+2);  // transfer source physical address
//                    DCH2SSIZ        = 2;                    // source size 2 bytes
//                    DCH2CSIZ        = 2;    
//                    break;
//                case 24:
//                    DCH2SSA         = KVA_2_PA((int)&SPI3BUF+1);  // transfer source physical address
//                    DCH2SSIZ        = 3;                    // source size 3 bytes
//                    DCH2CSIZ        = 3;                    // 3 bytes transferred per event
//                    break;
//                case 32:
//                    DCH2SSA         = KVA_2_PA((int)&SPI3BUF);  // transfer source physical address
//                    DCH2SSIZ        = 4;                    // source size 2 bytes
//                    DCH2CSIZ        = 4;                    // 3 bytes transferred per event
//                    break;
//            }
//            DCH2INT         = 0;                    // clear all interrupts
//            DCH2ECONbits.CHSIRQ = _SPI3_RX_VECTOR;
//            DCH2ECONbits.SIRQEN = 1;                // enable DMA 0 for IRQ trigger
//            DCH2INTbits.CHDDIE = 1;                 // Interrupt when the fill is done.
//            DCH2CONbits.CHAED=1;                    //Channel start/abort events will be registered, even if the channel is disabled
//            DCH2CONbits.CHEN    = 1;    // turn on DMA channel 0
//
//            //===============================DMA Channel 3============================//
//            DCH3CON         = 0x3;  // channel off, priority 3, no chainin
//            DCH3ECON        = 0;    // no start or stop IRQs, no pattern match
//            DCH3DSA         = KVA_2_PA((unsigned int)DDRGetPointerOfCurrentFillingBuffer(3));    // transfer destination physical address
//            DCH3DSIZ        = DMA_TRANSFERT_SIZE_6_CHAN;//ffff;      // destination size 0=65536    0x0000ffff=65535
//            switch(resolution)
//            {
//                case 8:
//                    DCH3SSA         = KVA_2_PA((int)&SPI4BUF+3);  // transfer source physical address
//                    DCH3SSIZ        = 1;                    // source size 2 bytes
//                    DCH3CSIZ        = 1;    
//                    break;
//                case 16:
//                    DCH3SSA         = KVA_2_PA((int)&SPI4BUF+2);  // transfer source physical address
//                    DCH3SSIZ        = 2;                    // source size 2 bytes
//                    DCH3CSIZ        = 2;    
//                    break;
//                case 24:
//                    DCH3SSA         = KVA_2_PA((int)&SPI4BUF+1);  // transfer source physical address
//                    DCH3SSIZ        = 3;                    // source size 3 bytes
//                    DCH3CSIZ        = 3;                    // 3 bytes transferred per event
//                    break;
//                case 32:
//                    DCH3SSA         = KVA_2_PA((int)&SPI4BUF);  // transfer source physical address
//                    DCH3SSIZ        = 4;                    // source size 2 bytes
//                    DCH3CSIZ        = 4;                    // 3 bytes transferred per event
//                    break;
//            }
//            DCH3INT         = 0;                    // clear all interrupts
//            DCH3ECONbits.CHSIRQ = _SPI4_RX_VECTOR;
//            DCH3ECONbits.SIRQEN = 1;                // enable DMA 1 for IRQ trigger
//            DCH3INTbits.CHDDIE = 1;                 // Interrupt when the fill is done.
//            DCH3CONbits.CHAED=1;                    //Channel start/abort events will be registered, even if the channel is disabled
//            DCH3CONbits.CHEN    = 1;    // turn on DMA channel 0
//            //===============================DMA Channel 4============================//
//            DCH4CON         = 0x3;  // channel off, priority 3, no chainin
//            DCH4ECON        = 0;    // no start or stop IRQs, no pattern match
//            DCH4DSA         = KVA_2_PA((unsigned int)DDRGetPointerOfCurrentFillingBuffer(4));    // transfer destination physical address
//            DCH4DSIZ        = DMA_TRANSFERT_SIZE_6_CHAN;//ffff;      // destination size 0=65536    0x0000ffff=65535
//            switch(resolution)
//            {
//                case 8:
//                    DCH4SSA         = KVA_2_PA((int)&SPI5BUF+3);  // transfer source physical address
//                    DCH4SSIZ        = 1;                    // source size 2 bytes
//                    DCH4CSIZ        = 1;    
//                    break;
//                case 16:
//                    DCH4SSA         = KVA_2_PA((int)&SPI5BUF+2);  // transfer source physical address
//                    DCH4SSIZ        = 2;                    // source size 2 bytes
//                    DCH4CSIZ        = 2;    
//                    break;
//                case 24:
//                    DCH4SSA         = KVA_2_PA((int)&SPI5BUF+1);  // transfer source physical address
//                    DCH4SSIZ        = 3;                    // source size 3 bytes
//                    DCH4CSIZ        = 3;                    // 3 bytes transferred per event
//                    break;
//                case 32:
//                    DCH4SSA         = KVA_2_PA((int)&SPI5BUF);  // transfer source physical address
//                    DCH4SSIZ        = 4;                    // source size 2 bytes
//                    DCH4CSIZ        = 4;                    // 3 bytes transferred per event
//                    break;
//            }
//            DCH4INT         = 0;                    // clear all interrupts
//            DCH4ECONbits.CHSIRQ = _SPI5_RX_VECTOR;
//            DCH4ECONbits.SIRQEN = 1;                // enable DMA 1 for IRQ trigger
//            DCH4INTbits.CHDDIE = 1;                 // Interrupt when the fill is done.
//            DCH4CONbits.CHAED=1;                    //Channel start/abort events will be registered, even if the channel is disabled
//            DCH4CONbits.CHEN    = 1;    // turn on DMA channel 0                
//            //===============================DMA Channel 5============================//
//            DCH5CON         = 0x3;  // channel off, priority 3, no chainin
//            DCH5ECON        = 0;    // no start or stop IRQs, no pattern match
//            DCH5DSA         = KVA_2_PA((unsigned int)DDRGetPointerOfCurrentFillingBuffer(5));    // transfer destination physical address
//            DCH5DSIZ        = DMA_TRANSFERT_SIZE_6_CHAN;//ffff;      // destination size 0=65536    0x0000ffff=65535
//            switch(resolution)
//            {
//                case 8:
//                    DCH5SSA         = KVA_2_PA((int)&SPI6BUF+3);  // transfer source physical address
//                    DCH5SSIZ        = 1;                    // source size 2 bytes
//                    DCH5CSIZ        = 1;    
//                    break;
//                case 16:
//                    DCH5SSA         = KVA_2_PA((int)&SPI6BUF+2);  // transfer source physical address
//                    DCH5SSIZ        = 2;                    // source size 2 bytes
//                    DCH5CSIZ        = 2;    
//                    break;
//                case 24:
//                    DCH5SSA         = KVA_2_PA((int)&SPI6BUF+1);  // transfer source physical address
//                    DCH5SSIZ        = 3;                    // source size 3 bytes
//                    DCH5CSIZ        = 3;                    // 3 bytes transferred per event
//                    break;
//                case 32:
//                    DCH5SSA         = KVA_2_PA((int)&SPI6BUF);  // transfer source physical address
//                    DCH5SSIZ        = 4;                    // source size 2 bytes
//                    DCH5CSIZ        = 4;                    // 3 bytes transferred per event
//                    break;
//            }
//            DCH5INT         = 0;                    // clear all interrupts
//            DCH5ECONbits.CHSIRQ = _SPI6_RX_VECTOR;
//            DCH5ECONbits.SIRQEN = 1;                // enable DMA 1 for IRQ trigger
//            DCH5INTbits.CHDDIE = 1;                 // Interrupt when the fill is done.
//            DCH5CONbits.CHAED=1;                    //Channel start/abort events will be registered, even if the channel is disabled
//            DCH5CONbits.CHEN    = 1;    // turn on DMA channel 0    
//            //</editor-fold>
//            break;            
//        default:
//            break;
//    }
//    //DMACONbits.ON = 1;          // enable global DMA controller
//}
////</editor-fold>

//<editor-fold defaultstate="collapsed" desc="DMA for SPI INIT Version 2">
unsigned int packetBufferSize;
unsigned int spiDmaBufferSize;
void USTV_InitDMAForSPIV2(unsigned char nbChan, unsigned char resolution)
{    
    //#define SPI_DMA_BUFFER_SIZE (DMA_CUSTOM_PACKET_BUFFER_SIZE-ADDITIONNAL_DATA_SIZE)/3
    
    packetBufferSize = PACKET_BUFFER_SIZE; // ADDITIONNAL_DATA_SIZE + SPI_DMA_BUFFER_SIZE*nbChan;
    spiDmaBufferSize = (PACKET_BUFFER_SIZE - ADDITIONNAL_DATA_SIZE)/nbChan;
    
    
    /// Autre version de la configuration
    /// On configure tous les DMA lis aux canaux analogiques, et on active seulement ceux qui sont ncessaires  la fin
    /// Effectu une seule fois en dbut d'acquisition
    
    DMACONbits.ON = 0;
    
    DCH0CON         = 0x3;  // channel off, priority 3, no chaining
    DCH1CON         = 0x3;  // channel off, priority 3, no chaining
    DCH2CON         = 0x3;  // channel off, priority 3, no chaining
    DCH3CON         = 0x3;  // channel off, priority 3, no chaining
    DCH4CON         = 0x3;  // channel off, priority 3, no chaining
    DCH5CON         = 0x3;  // channel off, priority 3, no chaining
    
    DCH0ECON        = 0;    // no start or stop IRQs, no pattern match
    DCH1ECON        = 0;    // no start or stop IRQs, no pattern match
    DCH2ECON        = 0;    // no start or stop IRQs, no pattern match
    DCH3ECON        = 0;    // no start or stop IRQs, no pattern match
    DCH4ECON        = 0;    // no start or stop IRQs, no pattern match
    DCH5ECON        = 0;    // no start or stop IRQs, no pattern match
    
    DCH0DSA         = KVA_2_PA((unsigned int)packetConstructionBuffer+ADDITIONNAL_DATA_SIZE);    // transfer destination physical address            
    DCH1DSA         = KVA_2_PA((unsigned int)packetConstructionBuffer+ADDITIONNAL_DATA_SIZE+1*spiDmaBufferSize);    // transfer destination physical address
    DCH2DSA         = KVA_2_PA((unsigned int)packetConstructionBuffer+ADDITIONNAL_DATA_SIZE+2*spiDmaBufferSize);    // transfer destination physical address
    DCH3DSA         = KVA_2_PA((unsigned int)packetConstructionBuffer+ADDITIONNAL_DATA_SIZE+3*spiDmaBufferSize);    // transfer destination physical address
    DCH4DSA         = KVA_2_PA((unsigned int)packetConstructionBuffer+ADDITIONNAL_DATA_SIZE+4*spiDmaBufferSize);    // transfer destination physical address
    DCH5DSA         = KVA_2_PA((unsigned int)packetConstructionBuffer+ADDITIONNAL_DATA_SIZE+5*spiDmaBufferSize);    // transfer destination physical address
    
    //Attention, en 1 voie a ne passe pas !!!!    
    DCH0DSIZ        = spiDmaBufferSize;      // destination size 0=65536    0x0000ffff=65535
    DCH1DSIZ        = spiDmaBufferSize;      // destination size 0=65536    0x0000ffff=65535
    DCH2DSIZ        = spiDmaBufferSize;      // destination size 0=65536    0x0000ffff=65535
    DCH3DSIZ        = spiDmaBufferSize;      // destination size 0=65536    0x0000ffff=65535
    DCH4DSIZ        = spiDmaBufferSize;      // destination size 0=65536    0x0000ffff=65535
    DCH5DSIZ        = spiDmaBufferSize;      // destination size 0=65536    0x0000ffff=65535
                        
    switch(resolution)
    {
        case 8:
            DCH0SSA         = KVA_2_PA((int)&SPI1BUF+3);  // transfer source physical address
            DCH1SSA         = KVA_2_PA((int)&SPI2BUF+3);  // transfer source physical address
            DCH2SSA         = KVA_2_PA((int)&SPI3BUF+3);  // transfer source physical address
            DCH3SSA         = KVA_2_PA((int)&SPI4BUF+3);  // transfer source physical address
            DCH4SSA         = KVA_2_PA((int)&SPI5BUF+3);  // transfer source physical address
            DCH5SSA         = KVA_2_PA((int)&SPI6BUF+3);  // transfer source physical address
            
            DCH0SSIZ        = 1;                    // source size 2 bytes
            DCH1SSIZ        = 1;                    // source size 2 bytes
            DCH2SSIZ        = 1;                    // source size 2 bytes
            DCH3SSIZ        = 1;                    // source size 2 bytes
            DCH4SSIZ        = 1;                    // source size 2 bytes
            DCH5SSIZ        = 1;                    // source size 2 bytes
            
            DCH0CSIZ        = 1;    
            DCH1CSIZ        = 1;    
            DCH2CSIZ        = 1;    
            DCH3CSIZ        = 1;    
            DCH4CSIZ        = 1;    
            DCH5CSIZ        = 1;    
            break;
        case 16:
            DCH0SSA         = KVA_2_PA((int)&SPI1BUF+2);  // transfer source physical address
            DCH1SSA         = KVA_2_PA((int)&SPI2BUF+2);  // transfer source physical address
            DCH2SSA         = KVA_2_PA((int)&SPI3BUF+2);  // transfer source physical address
            DCH3SSA         = KVA_2_PA((int)&SPI4BUF+2);  // transfer source physical address
            DCH4SSA         = KVA_2_PA((int)&SPI5BUF+2);  // transfer source physical address
            DCH5SSA         = KVA_2_PA((int)&SPI6BUF+2);  // transfer source physical address
                    
            DCH0SSIZ        = 2;                    // source size 2 bytes
            DCH1SSIZ        = 2;                    // source size 2 bytes
            DCH2SSIZ        = 2;                    // source size 2 bytes
            DCH3SSIZ        = 2;                    // source size 2 bytes
            DCH4SSIZ        = 2;                    // source size 2 bytes
            DCH5SSIZ        = 2;                    // source size 2 bytes
            
            DCH0CSIZ        = 2;    
            DCH1CSIZ        = 2;    
            DCH2CSIZ        = 2;    
            DCH3CSIZ        = 2;    
            DCH4CSIZ        = 2;    
            DCH5CSIZ        = 2;    
            break;
        case 24:
            DCH0SSA         = KVA_2_PA((int)&SPI1BUF+1);  // transfer source physical address
            DCH1SSA         = KVA_2_PA((int)&SPI2BUF+1);  // transfer source physical address
            DCH2SSA         = KVA_2_PA((int)&SPI3BUF+1);  // transfer source physical address
            DCH3SSA         = KVA_2_PA((int)&SPI4BUF+1);  // transfer source physical address
            DCH4SSA         = KVA_2_PA((int)&SPI5BUF+1);  // transfer source physical address
            DCH5SSA         = KVA_2_PA((int)&SPI6BUF+1);  // transfer source physical address
            
            DCH0SSIZ        = 3;                    // source size 3 bytes
            DCH1SSIZ        = 3;                    // source size 3 bytes
            DCH2SSIZ        = 3;                    // source size 3 bytes
            DCH3SSIZ        = 3;                    // source size 3 bytes
            DCH4SSIZ        = 3;                    // source size 3 bytes
            DCH5SSIZ        = 3;                    // source size 3 bytes
            
            DCH0CSIZ        = 3;                    // 3 bytes transferred per event
            DCH1CSIZ        = 3;                    // 3 bytes transferred per event
            DCH2CSIZ        = 3;                    // 3 bytes transferred per event
            DCH3CSIZ        = 3;                    // 3 bytes transferred per event
            DCH4CSIZ        = 3;                    // 3 bytes transferred per event
            DCH5CSIZ        = 3;                    // 3 bytes transferred per event
            break;
        case 32:
            DCH0SSA         = KVA_2_PA((int)&SPI1BUF);  // transfer source physical address
            DCH1SSA         = KVA_2_PA((int)&SPI2BUF);  // transfer source physical address
            DCH2SSA         = KVA_2_PA((int)&SPI3BUF);  // transfer source physical address
            DCH3SSA         = KVA_2_PA((int)&SPI4BUF);  // transfer source physical address
            DCH4SSA         = KVA_2_PA((int)&SPI5BUF);  // transfer source physical address
            DCH5SSA         = KVA_2_PA((int)&SPI6BUF);  // transfer source physical address
            
            DCH0SSIZ        = 4;                    // source size 2 bytes
            DCH1SSIZ        = 4;                    // source size 2 bytes
            DCH2SSIZ        = 4;                    // source size 2 bytes
            DCH3SSIZ        = 4;                    // source size 2 bytes
            DCH4SSIZ        = 4;                    // source size 2 bytes
            DCH5SSIZ        = 4;                    // source size 2 bytes
            
            DCH0CSIZ        = 4;                    // 3 bytes transferred per event
            DCH1CSIZ        = 4;                    // 3 bytes transferred per event
            DCH2CSIZ        = 4;                    // 3 bytes transferred per event
            DCH3CSIZ        = 4;                    // 3 bytes transferred per event
            DCH4CSIZ        = 4;                    // 3 bytes transferred per event
            DCH5CSIZ        = 4;                    // 3 bytes transferred per event
            break;
    }
        
    DCH0INT         = 0;                    // clear all interrupts
    DCH1INT         = 0;                    // clear all interrupts
    DCH2INT         = 0;                    // clear all interrupts
    DCH3INT         = 0;                    // clear all interrupts
    DCH4INT         = 0;                    // clear all interrupts
    DCH5INT         = 0;                    // clear all interrupts
    
    DCH0ECONbits.CHSIRQ = _SPI1_RX_VECTOR;
    DCH1ECONbits.CHSIRQ = _SPI2_RX_VECTOR;
    DCH2ECONbits.CHSIRQ = _SPI3_RX_VECTOR;
    DCH3ECONbits.CHSIRQ = _SPI4_RX_VECTOR;
    DCH4ECONbits.CHSIRQ = _SPI5_RX_VECTOR;
    DCH5ECONbits.CHSIRQ = _SPI6_RX_VECTOR;
    
    DCH0ECONbits.SIRQEN = 1;                // enable DMA 0 for IRQ trigger
    DCH1ECONbits.SIRQEN = 1;                // enable DMA 1 for IRQ trigger
    DCH2ECONbits.SIRQEN = 1;                // enable DMA 2 for IRQ trigger
    DCH3ECONbits.SIRQEN = 1;                // enable DMA 3 for IRQ trigger
    DCH4ECONbits.SIRQEN = 1;                // enable DMA 4 for IRQ trigger
    DCH5ECONbits.SIRQEN = 1;                // enable DMA 5 for IRQ trigger   
    
    DCH0INTbits.CHDHIE = 1;                 // Interrupt when the fill is half done.    
    DCH1INTbits.CHDHIE = 1;                 // Interrupt when the fill is half done.
    DCH2INTbits.CHDHIE = 1;                 // Interrupt when the fill is half done.
    DCH3INTbits.CHDHIE = 1;                 // Interrupt when the fill is half done.
    DCH4INTbits.CHDHIE = 1;                 // Interrupt when the fill is half done.
    DCH5INTbits.CHDHIE = 1;                 // Interrupt when the fill is half done.
    
    DCH0INTbits.CHDDIE = 1;                 // Interrupt when the fill is done.    
    DCH1INTbits.CHDDIE = 1;                 // Interrupt when the fill is done.
    DCH2INTbits.CHDDIE = 1;                 // Interrupt when the fill is done.
    DCH3INTbits.CHDDIE = 1;                 // Interrupt when the fill is done.
    DCH4INTbits.CHDDIE = 1;                 // Interrupt when the fill is done.
    DCH5INTbits.CHDDIE = 1;                 // Interrupt when the fill is done.
    
    DCH0CONbits.CHAED=1;                    //Channel start/abort events will be registered, even if the channel is disabled
    DCH1CONbits.CHAED=1;                    //Channel start/abort events will be registered, even if the channel is disabled
    DCH2CONbits.CHAED=1;                    //Channel start/abort events will be registered, even if the channel is disabled
    DCH3CONbits.CHAED=1;                    //Channel start/abort events will be registered, even if the channel is disabled
    DCH4CONbits.CHAED=1;                    //Channel start/abort events will be registered, even if the channel is disabled
    DCH5CONbits.CHAED=1;                    //Channel start/abort events will be registered, even if the channel is disabled
    
    DCH0CONbits.CHAEN=1; 
    DCH1CONbits.CHAEN=1; 
    DCH2CONbits.CHAEN=1; 
    DCH3CONbits.CHAEN=1; 
    DCH4CONbits.CHAEN=1; 
    DCH5CONbits.CHAEN=1; 
    
    switch(nbChan)
    {
        case 1:
            DCH0CONbits.CHEN    = 1;    // turn on DMA channel 0
            break;
        case 2:
            DCH0CONbits.CHEN    = 1;    // turn on DMA channel 0
            DCH1CONbits.CHEN    = 1;    // turn on DMA channel 1
            break;
        case 3:
            DCH0CONbits.CHEN    = 1;    // turn on DMA channel 0
            DCH1CONbits.CHEN    = 1;    // turn on DMA channel 1
            DCH2CONbits.CHEN    = 1;    // turn on DMA channel 2
            break;
        case 4:
            DCH0CONbits.CHEN    = 1;    // turn on DMA channel 0
            DCH1CONbits.CHEN    = 1;    // turn on DMA channel 1
            DCH2CONbits.CHEN    = 1;    // turn on DMA channel 2
            DCH3CONbits.CHEN    = 1;    // turn on DMA channel 3
            break;
        case 5:
            DCH0CONbits.CHEN    = 1;    // turn on DMA channel 0
            DCH1CONbits.CHEN    = 1;    // turn on DMA channel 1
            DCH2CONbits.CHEN    = 1;    // turn on DMA channel 2
            DCH3CONbits.CHEN    = 1;    // turn on DMA channel 3
            DCH4CONbits.CHEN    = 1;    // turn on DMA channel 4
            break;
        case 6:
            DCH0CONbits.CHEN    = 1;    // turn on DMA channel 0
            DCH1CONbits.CHEN    = 1;    // turn on DMA channel 1
            DCH2CONbits.CHEN    = 1;    // turn on DMA channel 2
            DCH3CONbits.CHEN    = 1;    // turn on DMA channel 3
            DCH4CONbits.CHEN    = 1;    // turn on DMA channel 4
            DCH5CONbits.CHEN    = 1;    // turn on DMA channel 5
            break;
    }         
    
//    DCH6CON         = 0x3;  // channel off, priority 3, no chaining
//    DCH6ECON        = 0;    // no start or stop IRQs, no pattern match
////    DCH6SSA         = KVA_2_PA((unsigned int)toto);  // transfer source physical address
////    DCH6DSA         = KVA_2_PA((unsigned int)toto2);    // transfer destination physical address    
//    DCH6SSA         = (unsigned int)packetConstructionBuffer;  // transfer source physical address
//    DCH6DSA         = KVA_2_PA(DDR_START_UNCACHED);    // transfer destination physical address
//    DCH6SSIZ        = 0;                    // source size 2 bytes
//    DCH6DSIZ        = 0;      // destination size 0=65536    0x0000ffff=65535
//    DCH6CSIZ        = 0;    
//    DCH6INT         = 0;                    // clear all interrupts
//    DCH6ECONbits.CHSIRQ = _TIMER_3_VECTOR;
//    DCH6ECONbits.SIRQEN = 1;                // enable DMA 0 for IRQ trigger
//    DCH6INTbits.CHDDIE = 1;                 // Interrupt when the fill is done.
//    DCH6INTbits.CHDHIE = 1;                 // Interrupt when the fill is half done.
//    DCH6CONbits.CHAED=1;                    //Channel start/abort events will be registered, even if the channel is disabled
//    DCH6CONbits.CHAEN=1;                    //1:Channel is continuously enabled, and not automatically disabled after a block transfer is complete
//    DCH6CONbits.CHEN    = 1;    // turn on DMA channel 0
    
    //DMACONbits.ON = 1;          // enable global DMA controller
}

extern APP_DATA appData;
extern bool DMABurstPartieHauteEnCours;
bool USTV_DMA_IsReadyForTransferToDDR(void)
{
    switch(appData.recordParameters.nbChannelsUsed)
    {
        case 1:
            if(SPIDMAArrivedFlag.DMA0LowReady)
            {
                SPIDMAArrivedFlag.ALL=0;
                IO_7_Clear();
                IO_8_Clear();
                DMABurstPartieHauteEnCours = false;
                return true;
            }      
            else if(SPIDMAArrivedFlag.DMA0HighReady)
            {
                SPIDMAArrivedFlag.ALL=0;
                IO_7_Clear();
                IO_8_Clear();
                DMABurstPartieHauteEnCours = true;
                return true;
            } 
            break;
        case 2:
            if(SPIDMAArrivedFlag.DMA0LowReady && SPIDMAArrivedFlag.DMA1LowReady)
            {
                SPIDMAArrivedFlag.ALL=0;
                IO_7_Clear();
                IO_8_Clear();
                DMABurstPartieHauteEnCours = false;
                return true;
            }      
            else if(SPIDMAArrivedFlag.DMA0HighReady && SPIDMAArrivedFlag.DMA1HighReady)
            {
                SPIDMAArrivedFlag.ALL=0;
                IO_7_Clear();
                IO_8_Clear();
                DMABurstPartieHauteEnCours = true;
                return true;
            }      
            break;
        case 3:
            if(SPIDMAArrivedFlag.DMA0LowReady && SPIDMAArrivedFlag.DMA1LowReady && SPIDMAArrivedFlag.DMA2LowReady)
            {
                SPIDMAArrivedFlag.ALL=0;
                IO_7_Clear();
                IO_8_Clear();                
                DMABurstPartieHauteEnCours = false;
                return true;
            }     
            else if(SPIDMAArrivedFlag.DMA0HighReady && SPIDMAArrivedFlag.DMA1HighReady && SPIDMAArrivedFlag.DMA2HighReady)
            {
                SPIDMAArrivedFlag.ALL=0;
                IO_7_Clear();
                IO_8_Clear();
                DMABurstPartieHauteEnCours = true;
                return true;
            }     
            break;
        case 4:
            if(SPIDMAArrivedFlag.DMA0LowReady && SPIDMAArrivedFlag.DMA1LowReady && SPIDMAArrivedFlag.DMA2LowReady
            && SPIDMAArrivedFlag.DMA3LowReady)
            {
                SPIDMAArrivedFlag.ALL=0;
                IO_7_Clear();
                IO_8_Clear();
                DMABurstPartieHauteEnCours = false;
                return true;
            }         
            else if(SPIDMAArrivedFlag.DMA0HighReady && SPIDMAArrivedFlag.DMA1HighReady && SPIDMAArrivedFlag.DMA2HighReady
            && SPIDMAArrivedFlag.DMA3HighReady)
            {
                SPIDMAArrivedFlag.ALL=0;
                IO_7_Clear();
                IO_8_Clear();
                DMABurstPartieHauteEnCours = true;
                return true;
            }         
            break;
        case 5:
            if(SPIDMAArrivedFlag.DMA0LowReady && SPIDMAArrivedFlag.DMA1LowReady && SPIDMAArrivedFlag.DMA2LowReady
            && SPIDMAArrivedFlag.DMA3LowReady && SPIDMAArrivedFlag.DMA4LowReady)
            {
                SPIDMAArrivedFlag.ALL=0;
                IO_7_Clear();
                DMABurstPartieHauteEnCours = false;
                return true;
            }     
            else if(SPIDMAArrivedFlag.DMA0HighReady && SPIDMAArrivedFlag.DMA1HighReady && SPIDMAArrivedFlag.DMA2HighReady
            && SPIDMAArrivedFlag.DMA3HighReady && SPIDMAArrivedFlag.DMA4HighReady)
            {
                SPIDMAArrivedFlag.ALL=0;
                IO_7_Clear();
                DMABurstPartieHauteEnCours = true;
                return true;
            }     
            break;
        case 6:
            if(SPIDMAArrivedFlag.DMA0LowReady && SPIDMAArrivedFlag.DMA1LowReady && SPIDMAArrivedFlag.DMA2LowReady
            && SPIDMAArrivedFlag.DMA3LowReady && SPIDMAArrivedFlag.DMA4LowReady && SPIDMAArrivedFlag.DMA5LowReady)
            {
                SPIDMAArrivedFlag.ALL=0;
                IO_7_Clear();
                DMABurstPartieHauteEnCours = false;
                return true;
            }        
            else if(SPIDMAArrivedFlag.DMA0HighReady && SPIDMAArrivedFlag.DMA1HighReady && SPIDMAArrivedFlag.DMA2HighReady
            && SPIDMAArrivedFlag.DMA3HighReady && SPIDMAArrivedFlag.DMA4HighReady && SPIDMAArrivedFlag.DMA5HighReady)
            {
                SPIDMAArrivedFlag.ALL=0;
                IO_7_Clear();
                DMABurstPartieHauteEnCours = true;
                return true;
            }        
            break;            
        default:
            return false;
            break;
    }
    return false;
}

//</editor-fold>
volatile bool dma6TransfertDone=true;



void USTV_DMACopieTo(unsigned int source, unsigned int destination, unsigned int length)
{
    IO_1_Set();
    dma6TransfertDone=false;
    DMACONSET=0x00008000; // enable the DMA controller
    DCH6CON=0x2; // channel off, priority 3, no chaining
    DCH6ECON=0; // no start or stop IRQs, no pattern match
    DCH6SSA=KVA_2_PA(source);    // transfer source physical address
    DCH6DSA=KVA_2_PA(destination);    // transfer destination physical address
    DCH6SSIZ=length; // source size 200 bytes
    DCH6DSIZ=length; // destination size 200 bytes
    DCH6CSIZ=length; // 200 bytes transferred per event
    DCH6INTbits.CHDDIE = 1;                 // Interrupt when the fill is done.
    DCH6CONSET=0x80; // turn channel on
    
    // initiate a transfer
    DCH6ECONSET=0x00000080; // set CFORCE to 1
    
}
