/* Microchip Technology Inc. and its subsidiaries.  You may use this software 
 * and any derivatives exclusively with Microchip products. 
 * 
 * THIS SOFTWARE IS SUPPLIED BY MICROCHIP "AS IS".  NO WARRANTIES, WHETHER 
 * EXPRESS, IMPLIED OR STATUTORY, APPLY TO THIS SOFTWARE, INCLUDING ANY IMPLIED 
 * WARRANTIES OF NON-INFRINGEMENT, MERCHANTABILITY, AND FITNESS FOR A 
 * PARTICULAR PURPOSE, OR ITS INTERACTION WITH MICROCHIP PRODUCTS, COMBINATION 
 * WITH ANY OTHER PRODUCTS, OR USE IN ANY APPLICATION. 
 *
 * IN NO EVENT WILL MICROCHIP BE LIABLE FOR ANY INDIRECT, SPECIAL, PUNITIVE, 
 * INCIDENTAL OR CONSEQUENTIAL LOSS, DAMAGE, COST OR EXPENSE OF ANY KIND 
 * WHATSOEVER RELATED TO THE SOFTWARE, HOWEVER CAUSED, EVEN IF MICROCHIP HAS 
 * BEEN ADVISED OF THE POSSIBILITY OR THE DAMAGES ARE FORESEEABLE.  TO THE 
 * FULLEST EXTENT ALLOWED BY LAW, MICROCHIP'S TOTAL LIABILITY ON ALL CLAIMS 
 * IN ANY WAY RELATED TO THIS SOFTWARE WILL NOT EXCEED THE AMOUNT OF FEES, IF 
 * ANY, THAT YOU HAVE PAID DIRECTLY TO MICROCHIP FOR THIS SOFTWARE.
 *
 * MICROCHIP PROVIDES THIS SOFTWARE CONDITIONALLY UPON YOUR ACCEPTANCE OF THESE 
 * TERMS. 
 */

/* 
 * File: USTV_DMA.h  
 * Author: Valentin BARCHASZ
 * Comments:
 * Revision history: 1.0
 */

// This is a guard condition so that contents of this file are not included
// more than once.  
#ifndef USTV_DMA_H
#define	USTV_DMA_H

#include <xc.h> // include processor files - each processor file is guarded.  
#include <stdbool.h>
#include "HighBlue_Configuration.h"
//#include "USTV_USB.h"

#ifdef CONFIG_WITH_EXFAT

////Multiple of 32
//#define DMA_1CHAN_0_OFFSET 1216 //= ADDITIONNAL_DATA_SIZE + 0/1*ANALOG_DATA_SIZE
//#define DMA_TRANSFERT_SIZE_1_CHAN  64320
//
//#define DMA_2CHAN_0_OFFSET 1216 //= ADDITIONNAL_DATA_SIZE + 0/2*ANALOG_DATA_SIZE
//#define DMA_2CHAN_1_OFFSET 33376 //= ADDITIONNAL_DATA_SIZE + 1/2*ANALOG_DATA_SIZE
//#define DMA_TRANSFERT_SIZE_2_CHAN  32160 //=1/2*ANALOG_DATA_SIZE
//
//#define DMA_3CHAN_0_OFFSET 1216  //= ADDITIONNAL_DATA_SIZE + 0/3*ANALOG_DATA_SIZE
//#define DMA_3CHAN_1_OFFSET 22656  //= ADDITIONNAL_DATA_SIZE + 1/3*ANALOG_DATA_SIZE
//#define DMA_3CHAN_2_OFFSET 44096  //= ADDITIONNAL_DATA_SIZE + 2/3*ANALOG_DATA_SIZE
//#define DMA_TRANSFERT_SIZE_3_CHAN  (21440) //=1/3*ANALOG_DATA_SIZE
//
//#define DMA_OFFSET_4CHAN 32760
//#define DMA_4CHAN_0_OFFSET 1216 
//#define DMA_4CHAN_1_OFFSET 17296 
//#define DMA_4CHAN_2_OFFSET 33376 
//#define DMA_4CHAN_3_OFFSET 49456 
//#define DMA_TRANSFERT_SIZE_4_CHAN  (16080)
//
//#define DMA_5CHAN_0_OFFSET 1216
//#define DMA_5CHAN_1_OFFSET 14080
//#define DMA_5CHAN_2_OFFSET 26944 
//#define DMA_5CHAN_3_OFFSET 39808
//#define DMA_5CHAN_4_OFFSET 52672
//#define DMA_TRANSFERT_SIZE_5_CHAN  (12864)
//
//#define DMA_6CHAN_0_OFFSET 1216
//#define DMA_6CHAN_1_OFFSET 11936        
//#define DMA_6CHAN_2_OFFSET 22656 
//#define DMA_6CHAN_3_OFFSET 33376
//#define DMA_6CHAN_4_OFFSET 44096
//#define DMA_6CHAN_5_OFFSET 54816
//#define DMA_TRANSFERT_SIZE_6_CHAN  (10720)


//Multiple of 180
//#define DMA_1CHAN_0_OFFSET 1096 //= ADDITIONNAL_DATA_SIZE + 0/1*ANALOG_DATA_SIZE
//#define DMA_TRANSFERT_SIZE_1_CHAN  64440
//
//#define DMA_2CHAN_0_OFFSET 1096 //= ADDITIONNAL_DATA_SIZE + 0/2*ANALOG_DATA_SIZE
//#define DMA_2CHAN_1_OFFSET 33316 //= ADDITIONNAL_DATA_SIZE + 1/2*ANALOG_DATA_SIZE
//#define DMA_TRANSFERT_SIZE_2_CHAN  32220 //=1/2*ANALOG_DATA_SIZE
//
//#define DMA_3CHAN_0_OFFSET 1096  //= ADDITIONNAL_DATA_SIZE + 0/3*ANALOG_DATA_SIZE
//#define DMA_3CHAN_1_OFFSET 22576  //= ADDITIONNAL_DATA_SIZE + 1/3*ANALOG_DATA_SIZE
//#define DMA_3CHAN_2_OFFSET 44056  //= ADDITIONNAL_DATA_SIZE + 2/3*ANALOG_DATA_SIZE
//#define DMA_TRANSFERT_SIZE_3_CHAN  (21480) //=1/3*ANALOG_DATA_SIZE
//
//#define DMA_4CHAN_0_OFFSET 1096 
//#define DMA_4CHAN_1_OFFSET 17206 
//#define DMA_4CHAN_2_OFFSET 33316 
//#define DMA_4CHAN_3_OFFSET 49426 
//#define DMA_TRANSFERT_SIZE_4_CHAN  (16110)
//
//#define DMA_5CHAN_0_OFFSET 1096
//#define DMA_5CHAN_1_OFFSET 13984
//#define DMA_5CHAN_2_OFFSET 26872 
//#define DMA_5CHAN_3_OFFSET 39760
//#define DMA_5CHAN_4_OFFSET 52648
//#define DMA_TRANSFERT_SIZE_5_CHAN  (12888)
//
//#define DMA_6CHAN_0_OFFSET 1096
//#define DMA_6CHAN_1_OFFSET 11836        
//#define DMA_6CHAN_2_OFFSET 22576 
//#define DMA_6CHAN_3_OFFSET 33316
//#define DMA_6CHAN_4_OFFSET 44056
//#define DMA_6CHAN_5_OFFSET 54796
//#define DMA_TRANSFERT_SIZE_6_CHAN  (10740)

#else
#define DMA_OFFSET_1CHAN (ANALOG_DATA_SIZE/2)

#define DMA_TRANSFERT_SIZE_1_CHAN  DMA_OFFSET_1CHAN


#define DMA_2CHAN_1_OFFSET (ANALOG_DATA_SIZE/2)
#define DMA_TRANSFERT_SIZE_2_CHAN  DMA_2CHAN_1_OFFSET

//For multi chan, les offset contiennent aussi le decalage de l'entete USB
#define DMA_3CHAN_1_OFFSET 43680
#define DMA_3CHAN_2_OFFSET 87360
#define DMA_TRANSFERT_SIZE_3_CHAN  (43680)

#define DMA_OFFSET_4CHAN 32760
#define DMA_4CHAN_1_OFFSET 65520 
#define DMA_4CHAN_2_OFFSET 98280 
#define DMA_TRANSFERT_SIZE_4_CHAN  (32760)

#define DMA_5CHAN_1_OFFSET 26208
#define DMA_5CHAN_2_OFFSET 52416 
#define DMA_5CHAN_3_OFFSET 78624
#define DMA_5CHAN_4_OFFSET 104832
#define DMA_TRANSFERT_SIZE_5_CHAN  (26208)

#define DMA_6CHAN_1_OFFSET 21840
#define DMA_6CHAN_2_OFFSET 43680 
#define DMA_6CHAN_3_OFFSET 65520
#define DMA_6CHAN_4_OFFSET 87360
#define DMA_6CHAN_5_OFFSET 109200
#define DMA_TRANSFERT_SIZE_6_CHAN  (21840)
#endif

__extension__ typedef struct SPI_DMA_DONEBITS{
union {
struct{
  unsigned ALL:8;
   };

struct {
  unsigned DMA0LowReady:1;
  unsigned DMA1LowReady:1;
  unsigned DMA2LowReady:1;
  unsigned DMA3LowReady:1;
  unsigned DMA4LowReady:1;
  unsigned DMA5LowReady:1;
  unsigned DMA0HighReady:1;
  unsigned DMA1HighReady:1;
  unsigned DMA2HighReady:1;
  unsigned DMA3HighReady:1;
  unsigned DMA4HighReady:1;
  unsigned DMA5HighReady:1;
  unsigned :2;
  };
};
}SPIDMADonebits;

// TODO Insert declarations or function prototypes (right here) to leverage 
// live documentation
void USTV_InitDMAForSPI2FramedSlave(unsigned char resolution);
void USTV_InitDMAForSPI(unsigned char nbChan, unsigned char resolution);
void USTV_InitDMAForSPIV2(unsigned char nbChan, unsigned char resolution);
void USTV_SetCurrentDMABufferAddress(unsigned char* ptr, unsigned char chanCount);
void USTV_InitDMAForSPI5_6(unsigned char nbChan, unsigned char resolution);
void USTV_InitSPI6(void);
void USTV_DMACopieTo(unsigned int source, unsigned int destination, unsigned int length);
bool USTV_DMA_IsReadyForTransferToDDR(void);
#endif	/* XC_HEADER_TEMPLATE_H */

