/* ************************************************************************** */
/** Descriptive File Name

  @Company
    Company Name

  @File Name
    filename.c

  @Summary
    Brief description of the file.

  @Description
    Describe the purpose of this file.
 */
/* ************************************************************************** */

/* ************************************************************************** */
/* ************************************************************************** */
/* Section: Included Files                                                    */
/* ************************************************************************** */
/* ************************************************************************** */
#include <stdio.h>
#include <string.h>
#include "USTV_SystemTrace.h"
#include "third_party/rtos/FreeRTOS/Source/include/FreeRTOS.h"
#include "third_party/rtos/FreeRTOS/Source/include/message_buffer.h"
#include "config/default/system/fs/sys_fs.h"
#include "app_sd_tasks.h"
#include "task.h"
/* ************************************************************************** */
/* ************************************************************************** */
/* Section: File Scope or Global Data                                         */
/* ************************************************************************** */
extern unsigned long g_longTimeStamp;
#ifdef SYS_TRACE_STATIC
    char systemTraceBuffer[JASON_TRACE_BUFFER_LENGTH];
    int systemTraceBufferLength;
#else
MessageBufferHandle_t xSystemTraceMessageBuffer;
#endif


/* ************************************************************************** */
/* ************************************************************************** */
// Section: Local Functions                                                   */
/* ************************************************************************** */
/* ************************************************************************** */
void USTV_SystemTraceInit(void)
{
    /* Create a message buffer that can hold 100 bytes.  The memory used to hold
    both the message buffer structure and the data in the message buffer is
    allocated dynamically. */
    xSystemTraceMessageBuffer = xMessageBufferCreate( JASON_TRACE_BUFFER_LENGTH );

    if( xSystemTraceMessageBuffer == NULL )
    {
        /* There was not enough heap memory space available to create the
        message buffer. */
    }
    else
    {
        /* The message buffer was created successfully and can now be used. */
    }
}

/******************************************************************************
  Function:
    void USTV_SystemTraceWriteLineToBuffer ( char* str )

  Summary:
    Write a line into a messageBuffer.

  Description:
    This function Write a line (TimeStamped) into a messageBuffer..

  Parameters:
    str          - pointer to the string

  Returns:
    None.
 */
void USTV_SystemTraceWriteLineToBuffer(char* str)
{
    USTV_SystemTraceWriteLine( str);
    
//    char buff[250]={0};
//    //int length;
//    sprintf(buff,"%ld:",g_longTimeStamp);
//    strcat(buff,str);
//    strcat(buff,"\n");
//   // length=strlen(buff);
//
//    /* enqueu in temp buffer*/
//    #ifdef SYS_TRACE_STATIC
//        if(systemTraceBufferLength+length<JASON_TRACE_BUFFER_LENGTH)
//        {
//            systemTraceBufferLength+=length;
//            strcat(systemTraceBuffer,buff);
//            OSAL_set_event( USTV_DATA_READWRITE_TASK, USTV_TRACE_BUFFER_READY_TO_WRITE );
//        }
//    #else
//        size_t xBytesSent;
//        taskENTER_CRITICAL();
//        /* Send the string to the message buffer.  Return immediately if there is
//        not enough space in the buffer. */
//        xBytesSent = xMessageBufferSend( xSystemTraceMessageBuffer,
//                                        ( void * ) buff,
//                                        strlen( buff ), 0 );
//        taskEXIT_CRITICAL();
//        if( xBytesSent != strlen( buff ) )
//        {
//            /* The string could not be added to the message buffer because there was
//            not enough free space in the buffer. */
//        }
//    #endif
}

/******************************************************************************
  Function:
    void USTV_SystemTraceWriteLine ( char* str )

  Summary:
    Write a line into a file, or into a messageBuffer if file is busy.

  Description:
    This function Write a line (TimeStamped) nto a file, or into a messageBuffer 
    if file is busy.

  Parameters:
    str          - pointer to the string

  Returns:
    None.
 */

int mutexSystemTrace = 0;
#define SYSTRACE_BUFF_LENGTH 256
#define SYSTRACE_PATH_LENGTH 64
void USTV_SystemTraceWriteLine(char* str)
{
    if(mutexSystemTrace==0)
    {
        //Acquire MUTEX
        mutexSystemTrace = 1;
        char buff[SYSTRACE_BUFF_LENGTH]={0};
        unsigned int length;
        sprintf(buff,"%ld:",g_longTimeStamp);
        strncat(buff,str, SYSTRACE_BUFF_LENGTH- strlen(buff));
        strncat(buff,"\n", SYSTRACE_BUFF_LENGTH- strlen(buff));
        length=strlen(buff);
        char path[SYSTRACE_PATH_LENGTH]={0};
        SYS_FS_HANDLE fileHandle=SYS_FS_HANDLE_INVALID;
        
        if(USTV_IsCurrentDriveSet())
        {
            strncat(path, USTV_GetCurrentDrive(), SYSTRACE_PATH_LENGTH - strlen(path));
            strncat(path,SYS_TRACE_FILENAME, SYSTRACE_PATH_LENGTH - strlen(path));
            fileHandle = SYS_FS_FileOpen(path,(SYS_FS_FILE_OPEN_APPEND));
        }
        
        if(fileHandle == SYS_FS_HANDLE_INVALID)
        {
            /* enqueu in temp buffer*/
            #ifdef SYS_TRACE_STATIC
                if(systemTraceBufferLength+length<JASON_TRACE_BUFFER_LENGTH)
                {
                    systemTraceBufferLength+=length;
                    strcat(systemTraceBuffer,buff);
                    OSAL_set_event( USTV_DATA_READWRITE_TASK, USTV_TRACE_BUFFER_READY_TO_WRITE );
                }
            #else
                size_t xBytesSent;
                taskENTER_CRITICAL();
                /* Send the string to the message buffer.  Return immediately if there is
                not enough space in the buffer. */
                xBytesSent = xMessageBufferSend( xSystemTraceMessageBuffer,
                                                ( void * ) buff,
                                                strlen( buff ), 0 );

                taskEXIT_CRITICAL();
                if( xBytesSent != strlen( buff ) )
                {
                    /* The string could not be added to the message buffer because there was
                    not enough free space in the buffer. */
                }
            #endif
            //RELEASE MUTEX
            mutexSystemTrace = 0;
            return ;
        }
        else
        {
            /* Try writing to the file */
            if (SYS_FS_FileWrite( fileHandle, (const void *) buff, length ) == -1)
            {
                /* Write was not successful. Close the file
                 * and error out.*/
                SYS_FS_FileClose(fileHandle);
            }
            else
            {
                /* We are done writing. */
                 SYS_FS_FileClose(fileHandle);
            }

            //RELEASE MUTEX
            mutexSystemTrace = 0;
        }
    }
}

/******************************************************************************
  Function:
    void USTV_SystemTraceWriteBufferToFile ( void )

  Summary:
    Write a line into a file, or into a messageBuffer if file is busy.

  Description:
    This function Write the messageBuffer content into SystemTrace file

  Parameters:
    None

  Returns:
    None.
 */
void USTV_SystemTraceWriteBufferToFile(void)
{
    #ifdef USE_TRACE_STATIC
        if(systemTraceBufferLength>0)
        {
           char systemTraceBuffertmp[systemTraceBufferLength+strlen("//==========Writing TraceBuffer=========//\n")+20];
           sprintf(systemTraceBuffertmp,"%d:",timeStamp);
           strcat(systemTraceBuffertmp,"//==========Writing TraceBuffer=========//\n");
           strcat(systemTraceBuffertmp,systemTraceBuffer);
           strcat(systemTraceBuffertmp,"\n");
           int len=strlen(systemTraceBuffertmp);
            SYS_FS_HANDLE fileHandle=SYS_FS_HANDLE_INVALID;
            fileHandle = SYS_FS_FileOpen("/mnt/myDrive1/SysTrace.log",(SYS_FS_FILE_OPEN_APPEND));
            if(fileHandle == SYS_FS_HANDLE_INVALID)
            {
                return ;
            }
            else
            {
                /* Try writing to the file */
                if (SYS_FS_FileWrite( fileHandle, (const void *) systemTraceBuffertmp, len ) == -1)
                {
                    /* Write was not successful. Close the file
                     * and error out.*/
                    SYS_FS_FileClose(fileHandle);
                }
                else
                {
                    /* We are done writing. */
                    SYS_FS_FileClose(fileHandle);

                    int i;
                    for(i=0;i<systemTraceBufferLength;i++)
                        systemTraceBuffer[i]=0;

                    systemTraceBufferLength=0;
                }
            }
        }
    #else
        if(!xMessageBufferIsEmpty( xSystemTraceMessageBuffer ))
        {
            //Si on a au moins un message dans le buffer
            SYS_FS_HANDLE fileHandle=SYS_FS_HANDLE_INVALID;
            char path[50]={0};
            if(USTV_IsCurrentDriveSet())
            {
                strcat(path,USTV_GetCurrentDrive());
                strcat(path,SYS_TRACE_FILENAME);
                fileHandle = SYS_FS_FileOpen(path,(SYS_FS_FILE_OPEN_APPEND));
            }
            if(fileHandle == SYS_FS_HANDLE_INVALID)
            {
                return ;
            }
            else
            {
                char baliseStr[strlen(SYS_TRACE_BALISE_STR)+20];
                sprintf(baliseStr,"%ld:",g_longTimeStamp);
                strcat(baliseStr,SYS_TRACE_BALISE_STR);
                /* Try writing to the file */
                if (SYS_FS_FileWrite( fileHandle, (const void *) baliseStr, strlen(baliseStr) ) == -1)
                {
                    /* Write was not successful. Close the file
                     * and error out.*/
                    SYS_FS_FileClose(fileHandle);
                }
                else
                {
                    /* We are done writing. */
                    while(!xMessageBufferIsEmpty( xSystemTraceMessageBuffer ))
                    {
                        char ucRxData[ 256 ]={0};
                        size_t xReceivedBytes;

                        /* Receive the next message from the message buffer.  Wait in the Blocked
                        state (so not using any CPU processing time) for a maximum of 100ms for
                        a message to become available. */
                        xReceivedBytes = xMessageBufferReceive( xSystemTraceMessageBuffer,
                                                                ( void * ) ucRxData,
                                                                sizeof( ucRxData ),
                                                                0 );

                        if( xReceivedBytes > 0 )
                        {
                            /* A ucRxData contains a message that is xReceivedBytes long.  Process
                            the message here.... */

                            char systemTraceBuffertmp[xReceivedBytes+1];
                            memset(systemTraceBuffertmp,0,xReceivedBytes+1);
                            strcat(systemTraceBuffertmp,ucRxData);
                            int len=strlen(systemTraceBuffertmp);
                            /* Try writing to the file */
                            if (SYS_FS_FileWrite( fileHandle, (const void *) systemTraceBuffertmp, len ) == -1)
                            {
                                /* Write was not successful. Close the file
                                 * and error out.*/
                                SYS_FS_FileClose(fileHandle);
                            }
                        }
                    }
                    
                    char baliseStr[strlen(SYS_TRACE_END_BALISE_STR)+20];
                    sprintf(baliseStr,"%ld:",g_longTimeStamp);
                    strcat(baliseStr,SYS_TRACE_END_BALISE_STR);
                    /* Try writing to the file */
                    if (SYS_FS_FileWrite( fileHandle, (const void *) baliseStr, strlen(baliseStr) ) == -1)
                    {
                        /* Write was not successful. Close the file
                         * and error out.*/
                        SYS_FS_FileClose(fileHandle);
                    }
                    else
                    {
                        SYS_FS_FileClose(fileHandle);
                    }
                }
            }
        }
    #endif
}

/* *****************************************************************************
 End of File
 */
