/* 
 * File:   ustv_MainFunc.h
 * Author: Val
 *
 * Created on 21 janvier 2013, 16:20
 */

#ifndef USTV_COMMUNICATION_H
#define	USTV_COMMUNICATION_H
#include <stdbool.h>
/*******************************************************************************
 * INCLUDES
 ******************************************************************************/

#define UART3_RX_PAYLOAD_SIZE 256
/*******************************************************************************
 * VARIABLES
 ******************************************************************************/

extern volatile unsigned long g_longTimeStamp;

#define SOF 0xFE
#define UTLN_FRAME_SIZE 6

//Processor message states
typedef enum{
    RECEPTION_WAIT=0,
            RECEPTION_FUNCTION_MSB,
            RECEPTION_FUNCTION_LSB,
            RECEPTION_PAYLOAD_LENGTH_MSB,
            RECEPTION_PAYLOAD_LENGTH_LSB,
            RECEPTION_PAYLOAD,
            RECEPTION_CHECKSUM    
}RECEPTION_STATE;


#define MESSAGE_DECODED (1<<0)

//Recorder Input Frame
#define GET_STATUS 0x0100
#define SET_RECORDER_PARAMETERS 0x0101
#define SUPERVISOR_STATE 0x0101
#define SET_RTCC 0x0102
#define START_RECORDING 0x0103
#define STOP_RECORDING 0x0104
#define TOA_EVENT_FRAME 0x0105
#define FILE_GETINFO_RESP 0x0106

#define SET_EXTERNAL_PERIPHERALS 0x0111

//Trames forward?es vers le GSM
#define OPEN_FILE_IN_GSM 0x0520
#define TRANSFER_DATA_BLOC_TO_GSM 0x0521
#define CLOSE_FILE_IN_GSM 0x0522

//Trames forwardes SD
#define HS_DATA_PACKET_FULL_TIMESTAMP 0x0A0A
#define HS_DATA_PACKET_ONE_TIMESTAMP 0x0A0B

//Trames vers USB (Mode device)
#define QHB_DATA_PACKET 0x0B01
#define QHB_STATUS 0x0B02

//Recorder Output Frame
#define SEND_STATUS 0x0200
#define GET_RTCC 0x0202
#define SEND_BUTTON_CLICK 0x0203
#define SEND_GSM_DATAS 0x0210
#define FORWARD_USB_FRAME 0x0211
#define SEND_CNN_ANALYSE_RESULT 0x0212

#define ACKNOLEDGE(x) (x|0x1000)

/*******************************************************************************
 * PROTOTYPES
 ******************************************************************************/
unsigned char UartCalculateChecksum(unsigned int msgFunction,
        unsigned int msgPayloadLength, unsigned char * msgPayload);
void Uart3DecodeMessage(unsigned char c);
int SendMessageTxUART(unsigned char* payload, unsigned char payloadLength);
void ProcessMessage( unsigned short int command, unsigned short int length, unsigned char payload[]);
void MakeAndSendMessageWithUTLNProtocol(unsigned short command, unsigned int payloadLength, unsigned char* payload);
void MakeAndAddMessageWithUTLNProtocolInAdditionnalBuffer(unsigned short command, unsigned int payloadLength, unsigned char* payload);
void SendMessageToUart1( unsigned short int payloadLength, unsigned char* payload);
void ProcessDecodedMessageTask(void);

//void UART3ReadToRxBuffer(void);
//bool UART3IsDataReadyInRxBuffer(void);
//unsigned char UART3ReadFromRxBuffer(void);
void UART3WriteToTxBuffer(unsigned char value);
bool UART3IsDataReadyInTxBuffer(void);
void UART3WriteFromTxBuffer(void);
unsigned int UART3GetRemainingSpaceInTxBuffer(void);
unsigned int UART3GetNbOfValuesInTxBuffer(void);
bool UART3IsTransmissionActive(void);
void UART3SetTransmissionActive(void);
void UART3ClearTransmissionActive(void);
#endif	/* USTV_MAINFUNC_H */

