#include "UTLN_DDR_CircularBuffer.h"
#include "USTV_DMA.h"
#include "peripheral/gpio/plib_gpio.h"
#include <math.h>

volatile unsigned int DDRCircularBufferHead = 0;
volatile unsigned int DDRCircularBufferTail = 0;
//volatile DDRBuffer_Donebits DDRBufferDoneTab[DDR_CIRCULAR_BUFFER_SIZE];
volatile DDRCurrentBuffersIndex DDRDMACurrentBuffersIndex;
//volatile unsigned int offset=0;
unsigned int blockSize=0;


void DDRInitCircularBuffer(uint8_t chanCount)
{
    blockSize=ADDITIONNAL_DATA_SIZE+chanCount*32768;
//    switch(chanCount)
//    {
//        case 1:break;
//        case 2: offset=ANALOG_DATA_SIZE_DIV2; break;
//        case 3: offset=ANALOG_DATA_SIZE_DIV3; break;
//        case 4: offset=ANALOG_DATA_SIZE_DIV4; break;
//        case 5: offset=ANALOG_DATA_SIZE_DIV5; break;
//        case 6: offset=ANALOG_DATA_SIZE_DIV6; break;
//        default: break;
//    }
}
//Permet de resetter la pool des buffers dispo dans la DDR
void DDRResetBufferPool(void)
{
    int i;
    for(i=0;i<DDR_CIRCULAR_BUFFER_SIZE;i++)
        DDRClearBufferReadyToWriteBits(i);
    
    DDRDMACurrentBuffersIndex.DMA0Index=0;
    DDRDMACurrentBuffersIndex.DMA1Index=0;
    DDRDMACurrentBuffersIndex.DMA2Index=0;
    DDRDMACurrentBuffersIndex.DMA3Index=0;
    DDRDMACurrentBuffersIndex.DMA4Index=0;
    DDRDMACurrentBuffersIndex.DMA5Index=0;
}


//Permet d'obtenir l' address(dans la DDR, espace non cached) du buffer n bufferNum
volatile unsigned char* DDRGetPointerFromBuffer(volatile unsigned int bufferNum)
{
    volatile unsigned char* pBuf=(volatile unsigned char*)DDR_START_UNCACHED+bufferNum*65536;
    return pBuf;
}

//Permet de recuperer l'addresse du buffer courant (pour le DMA selectionn)
volatile unsigned int DDRGetPointerOfCurrentFillingBuffer(uint8_t dmaNum)
{
   // IO_0_Set();
    switch(dmaNum)
    {
        case 0: return /*(volatile unsigned char*)*/(DDR_START_UNCACHED+DDRDMACurrentBuffersIndex.DMA0Index*blockSize+ADDITIONNAL_DATA_SIZE/*+0*offset*/);break;
        case 1: return /*(volatile unsigned char*)*/(DDR_START_UNCACHED+DDRDMACurrentBuffersIndex.DMA1Index*blockSize+ADDITIONNAL_DATA_SIZE+1*32768);break;
        case 2: return /*(volatile unsigned char*)*/(DDR_START_UNCACHED+DDRDMACurrentBuffersIndex.DMA2Index*blockSize+ADDITIONNAL_DATA_SIZE+2*32768);break;
        case 3: return /*(volatile unsigned char*)*/(DDR_START_UNCACHED+DDRDMACurrentBuffersIndex.DMA3Index*blockSize+ADDITIONNAL_DATA_SIZE+3*32768);break;
        case 4: return /*(volatile unsigned char*)*/(DDR_START_UNCACHED+DDRDMACurrentBuffersIndex.DMA4Index*blockSize+ADDITIONNAL_DATA_SIZE+4*32768);break;
        case 5: return /*(volatile unsigned char*)*/(DDR_START_UNCACHED+DDRDMACurrentBuffersIndex.DMA5Index*blockSize+ADDITIONNAL_DATA_SIZE+5*32768);break;
        default:break;
    }
    return 0;    
}

volatile unsigned char* DDRGetPointerOfCurrentAdditionnalData(void)
{
    return (volatile unsigned char*)(DDR_START_UNCACHED+DDRDMACurrentBuffersIndex.DMA0Index*PACKET_BUFFER_SIZE);
}

void DDRSetDMATransfertDone(uint8_t dmaNum)
{
    switch(dmaNum)
    {
        case 0: //DDRBufferDoneTab[DDRDMACurrentBuffersIndex.DMA0Index].DMA0Done=1;           //On indique que le transfert du DMA0 est termin
                DDRDMACurrentBuffersIndex.DMA0Index+=1;   //On incremente l'index  courant
                if(DDRDMACurrentBuffersIndex.DMA0Index>=DDR_CIRCULAR_BUFFER_SIZE)
                    DDRDMACurrentBuffersIndex.DMA0Index=0;
                break;
        case 1: //DDRBufferDoneTab[DDRDMACurrentBuffersIndex.DMA1Index].DMA1Done=1;           //On indique que le transfert du DMA0 est termin
                DDRDMACurrentBuffersIndex.DMA1Index+=1;   //On incremente l'index  courant
                if(DDRDMACurrentBuffersIndex.DMA1Index>=DDR_CIRCULAR_BUFFER_SIZE)
                    DDRDMACurrentBuffersIndex.DMA1Index=0;
                break;
        case 2: //DDRBufferDoneTab[DDRDMACurrentBuffersIndex.DMA2Index].DMA2Done=1;           //On indique que le transfert du DMA0 est termin
                DDRDMACurrentBuffersIndex.DMA2Index+=1;   //On incremente l'index  courant
                if(DDRDMACurrentBuffersIndex.DMA2Index>=DDR_CIRCULAR_BUFFER_SIZE)
                    DDRDMACurrentBuffersIndex.DMA2Index=0;
                break;
        case 3: //DDRBufferDoneTab[DDRDMACurrentBuffersIndex.DMA3Index].DMA3Done=1;           //On indique que le transfert du DMA0 est termin
                DDRDMACurrentBuffersIndex.DMA3Index+=1;   //On incremente l'index  courant 
                if(DDRDMACurrentBuffersIndex.DMA3Index>=DDR_CIRCULAR_BUFFER_SIZE)
                    DDRDMACurrentBuffersIndex.DMA3Index=0;
                break;
        case 4: //DDRBufferDoneTab[DDRDMACurrentBuffersIndex.DMA4Index].DMA4Done=1;           //On indique que le transfert du DMA0 est termin
                DDRDMACurrentBuffersIndex.DMA4Index+=1;   //On incremente l'index  courant; 
                if(DDRDMACurrentBuffersIndex.DMA4Index>=DDR_CIRCULAR_BUFFER_SIZE)
                    DDRDMACurrentBuffersIndex.DMA4Index=0;
                break;
        case 5: //DDRBufferDoneTab[DDRDMACurrentBuffersIndex.DMA5Index].DMA5Done=1;           //On indique que le transfert du DMA0 est termin
                DDRDMACurrentBuffersIndex.DMA5Index+=1;   //On incremente l'index  courant
                if(DDRDMACurrentBuffersIndex.DMA5Index>=DDR_CIRCULAR_BUFFER_SIZE)
                    DDRDMACurrentBuffersIndex.DMA5Index=0;
                break;
        default:break;
    }
}
bool DDRIsBufferReadyToWrite(unsigned int bufferNum, uint8_t DMAChanCount)
{
//    switch(DMAChanCount)
//    {
//        case 1: return (DDRBufferDoneTab[bufferNum].DMA0Done)?true:false; break;
//        case 2:
//            if(DDRBufferDoneTab[bufferNum].DMA0Done && DDRBufferDoneTab[bufferNum].DMA1Done)
//                return true;
//            else
//                return false;
//            break;
//        case 3:
//            if(DDRBufferDoneTab[bufferNum].DMA0Done && DDRBufferDoneTab[bufferNum].DMA1Done && DDRBufferDoneTab[bufferNum].DMA2Done)
//                return true;
//            else
//                return false;     
//            break;
//        case 4:
//            if(DDRBufferDoneTab[bufferNum].DMA0Done && DDRBufferDoneTab[bufferNum].DMA1Done && DDRBufferDoneTab[bufferNum].DMA2Done && DDRBufferDoneTab[bufferNum].DMA3Done)
//                return true;
//            else
//                return false;  
//            break;
//        case 5:
//            if(DDRBufferDoneTab[bufferNum].DMA0Done && DDRBufferDoneTab[bufferNum].DMA1Done && DDRBufferDoneTab[bufferNum].DMA2Done && DDRBufferDoneTab[bufferNum].DMA3Done && DDRBufferDoneTab[bufferNum].DMA4Done)
//                return true;
//            else
//                return false;   
//            break;
//        case 6:
//            if(DDRBufferDoneTab[bufferNum].DMA0Done && DDRBufferDoneTab[bufferNum].DMA1Done && DDRBufferDoneTab[bufferNum].DMA2Done && DDRBufferDoneTab[bufferNum].DMA3Done && DDRBufferDoneTab[bufferNum].DMA4Done && DDRBufferDoneTab[bufferNum].DMA5Done)
//                return true;
//            else
//                return false;   
//            break;
//        default:return false;
//        break;
//    }
    return false;
}

void DDRClearBufferReadyToWriteBits(unsigned int bufferNum)
{
////    DDRBufferDoneTab[bufferNum].ALL=0;
}


