/* ************************************************************************** */
/** Descriptive File Name

  @Company
    Company Name

  @File Name
    filename.h

  @Summary
    Brief description of the file.

  @Description
    Describe the purpose of this file.
 */
/* ************************************************************************** */

#ifndef _UTLN_DDR_CIRCULAR_BUFFER_H    /* Guard against multiple inclusion */
#define _UTLN_DDR_CIRCULAR_BUFFER_H
#include "HighBlue_Configuration.h"

/* ************************************************************************** */
/* ************************************************************************** */
/* Section: Included Files                                                    */
/* ************************************************************************** */
/* ************************************************************************** */
#include <stdbool.h>
#include <stdint.h>

typedef struct{
  uint16_t DMA0Index;
  uint16_t DMA1Index;
  uint16_t DMA2Index;
  uint16_t DMA3Index;
  uint16_t DMA4Index;
  uint16_t DMA5Index;
}DDRCurrentBuffersIndex;

//#define RESERVED_SIZE_FOR_DMABUFF 393216
//#define DDR_START_ADD_AFTER_DMABUFF (0xA8060000)

#define DDR_SIZE (33554432)     //32MB (2^25)
#define DDR_START_CACHED (0x88000000)  //KSEG0 cacheable (0x88000000 to 0x89FFFFFF)
#define DDR_START_UNCACHED (0xA8000000)  //KSEG0 not-cacheable (0xA8000000 to 0xA9FFFFFF)


#define DDR_CIRCULAR_BUFFER_SIZE (DDR_SIZE/PACKET_BUFFER_SIZE)-1

void DDRResetBufferPool(void);
void DDRInitCircularBuffer(uint8_t chanCount);
volatile unsigned char* DDRGetPointerFromBuffer(volatile unsigned int bufferNum);
volatile unsigned int DDRGetPointerOfCurrentFillingBuffer(uint8_t dmaNum);
volatile unsigned char* DDRGetPointerOfCurrentAdditionnalData(void);
void DDRSetDMATransfertDone(uint8_t dmaNum);
bool DDRIsBufferReadyToWrite(unsigned int bufferNum, uint8_t DMAChanCount);
void DDRClearBufferReadyToWriteBits(unsigned int bufferNum);

#endif /* _EXAMPLE_FILE_NAME_H */

/* *****************************************************************************
 End of File
 */
