/*******************************************************************************
  SPI PLIB

  Company:
    Microchip Technology Inc.

  File Name:
    plib_spi2.c

  Summary:
    SPI2 Source File

  Description:
    This file has implementation of all the interfaces provided for particular
    SPI peripheral.

*******************************************************************************/

/*******************************************************************************
* Copyright (C) 2018-2019 Microchip Technology Inc. and its subsidiaries.
*
* Subject to your compliance with these terms, you may use Microchip software
* and any derivatives exclusively with Microchip products. It is your
* responsibility to comply with third party license terms applicable to your
* use of third party software (including open source software) that may
* accompany Microchip software.
*
* THIS SOFTWARE IS SUPPLIED BY MICROCHIP "AS IS". NO WARRANTIES, WHETHER
* EXPRESS, IMPLIED OR STATUTORY, APPLY TO THIS SOFTWARE, INCLUDING ANY IMPLIED
* WARRANTIES OF NON-INFRINGEMENT, MERCHANTABILITY, AND FITNESS FOR A
* PARTICULAR PURPOSE.
*
* IN NO EVENT WILL MICROCHIP BE LIABLE FOR ANY INDIRECT, SPECIAL, PUNITIVE,
* INCIDENTAL OR CONSEQUENTIAL LOSS, DAMAGE, COST OR EXPENSE OF ANY KIND
* WHATSOEVER RELATED TO THE SOFTWARE, HOWEVER CAUSED, EVEN IF MICROCHIP HAS
* BEEN ADVISED OF THE POSSIBILITY OR THE DAMAGES ARE FORESEEABLE. TO THE
* FULLEST EXTENT ALLOWED BY LAW, MICROCHIP'S TOTAL LIABILITY ON ALL CLAIMS IN
* ANY WAY RELATED TO THIS SOFTWARE WILL NOT EXCEED THE AMOUNT OF FEES, IF ANY,
* THAT YOU HAVE PAID DIRECTLY TO MICROCHIP FOR THIS SOFTWARE.
*******************************************************************************/
#include "config/default/peripheral/spi/plib_spi2.h"
#include "UTLN_spi.h"

// *****************************************************************************
// *****************************************************************************
// Section: SPI2 Implementation
// *****************************************************************************
// *****************************************************************************
#define SPI1_CON_MSTEN                      (0 << _SPI1CON_MSTEN_POSITION)          //Slave mode
#define SPI1_CON_CKP                        (1 << _SPI1CON_CKP_POSITION)            //CKP=1
#define SPI1_CON_SSEN                       (1 << _SPI1CON_SSEN_POSITION)           //SS2 pin used for slave mode
#define SPI1_CON_CKE                        (0 << _SPI1CON_CKE_POSITION)            //CKE=0 sec 8.5.2.1.3 Datasheet ADS127L01 - CKE=1 CKP=0
#define SPI1_CON_MODE_32_MODE_16            (2 << _SPI1CON_MODE16_POSITION)         //
#define SPI1_CON_ENHBUF                     (1 << _SPI1CON_ENHBUF_POSITION)
#define SPI1_CON_MCLKSEL                    (0 << _SPI1CON_MCLKSEL_POSITION)        //Select PBCLK2 clock
#define SPI1_CON_MSSEN                      (0 << _SPI1CON_MSSEN_POSITION)          //MSSEN=0
#define SPI1_CON_SMP                        (0 << _SPI1CON_SMP_POSITION)            //Sampling in middle
#define SPI1_CON_FRMEN                      (1 << _SPI1CON_FRMEN_POSITION)          //Framed SPI enabled
#define SPI1_CON_FRMSYNC                    (1 << _SPI1CON_FRMSYNC_POSITION)        //Frame sync pulse input
#define SPI1_CON_FRMPOL                     (1 << _SPI1CON_FRMPOL_POSITION)         //Frame pulse active High
#define SPI1_CON_FRMSYPW                    (1 << _SPI1CON_FRMSYPW_POSITION)        //Frame pulse is one word length
#define SPI1_CON_FRMCNT                     (0 << _SPI1CON_FRMCNT_POSITION)         //Frame pulse every character
#define SPI1_CON_SPIFE                      (1 << _SPI1CON_SPIFE_POSITION)          //0 : Frame sync pulse precede first bit clock 
                                                                                    //1 : Frame synchronization pulse coincides with the first bit clock
#define SPI1_CON_DISSDO                     (1<< _SPI1CON_DISSDO_POSITION)          //1= SDOx pin is not used by the module. Pin is controlled by associated PORT register
                                                                                    //0 = SDOx pin is controlled by the module

void USTV_SPI1_Initialize ( void )
{
    uint32_t rdata;

    /* Disable SPI2 Interrupts */
    IEC3CLR = 0x2000;
    IEC3CLR = 0x4000;
    IEC3CLR = 0x8000;

    /* STOP and Reset the SPI */
    SPI1CON = 0;

    /* Clear the Receiver buffer */
    rdata = SPI1BUF;
    rdata = rdata;

    /* Clear SPI2 Interrupt flags */
    IFS3CLR = 0x2000;
    IFS3CLR = 0x4000;
    IFS3CLR = 0x8000;

    /* BAUD Rate register Setup */
    SPI1BRG = 49;

    /* CLear the Overflow */
    SPI1STATCLR = _SPI1STAT_SPIROV_MASK;

    /*
    MSTEN = 0
    CKP = 0
    CKE = 1
    MODE<32,16> = 0
    ENHBUF = 1
    MSSEN = 1
    MCLKSEL = 0
    */
    SPI1CONSET = (SPI1_CON_MSSEN | SPI1_CON_MCLKSEL | SPI1_CON_ENHBUF | SPI1_CON_MODE_32_MODE_16 | SPI1_CON_CKE | SPI1_CON_CKP | SPI1_CON_MSTEN | SPI1_CON_SMP | SPI1_CON_FRMEN |
                   SPI1_CON_FRMSYNC | SPI1_CON_FRMPOL | SPI1_CON_FRMSYPW | SPI1_CON_FRMCNT | SPI1_CON_SPIFE | SPI1_CON_SSEN | SPI1_CON_DISSDO);

    /* Enable transmit interrupt when transmit buffer is completely empty (STXISEL = '01') */
    /* Enable receive interrupt when the receive buffer is not empty (SRXISEL = '01') */
    SPI1CONSET = 0x00000005;
    
    IEC3bits.SPI1EIE=1;
    SPI1CON2bits.IGNROV=1;
    SPI1CON2bits.SPIROVEN=0;
    SPI1CON2bits.FRMERREN=0;
    SPI1CONbits.SRXISEL=0b01; //Interrupt tant qu'il y a des choses dans le buffer de rception
    
//    /* Enable SPI2 */
//    SPI1CONSET = _SPI1CON_ON_MASK;
}

#define SPI2_CON_MSTEN                      (0 << _SPI2CON_MSTEN_POSITION)          //Slave mode
#define SPI2_CON_CKP                        (1 << _SPI2CON_CKP_POSITION)            //CKP=1
#define SPI2_CON_SSEN                       (1 << _SPI2CON_SSEN_POSITION)           //SS2 pin used for slave mode
#define SPI2_CON_CKE                        (0 << _SPI2CON_CKE_POSITION)            //CKE=0 sec 8.5.2.1.3 Datasheet ADS127L01 - CKE=1 CKP=0
#define SPI2_CON_MODE_32_MODE_16            (2 << _SPI2CON_MODE16_POSITION)         //
#define SPI2_CON_ENHBUF                     (1 << _SPI2CON_ENHBUF_POSITION)
#define SPI2_CON_MCLKSEL                    (0 << _SPI2CON_MCLKSEL_POSITION)        //Select PBCLK2 clock
#define SPI2_CON_MSSEN                      (0 << _SPI2CON_MSSEN_POSITION)          //MSSEN=0
#define SPI2_CON_SMP                        (0 << _SPI2CON_SMP_POSITION)            //Sampling in middle
#define SPI2_CON_FRMEN                      (1 << _SPI2CON_FRMEN_POSITION)          //Framed SPI enabled
#define SPI2_CON_FRMSYNC                    (1 << _SPI2CON_FRMSYNC_POSITION)        //Frame sync pulse input
#define SPI2_CON_FRMPOL                     (1 << _SPI2CON_FRMPOL_POSITION)         //Frame pulse active High
#define SPI2_CON_FRMSYPW                    (1 << _SPI2CON_FRMSYPW_POSITION)        //Frame pulse is one word length
#define SPI2_CON_FRMCNT                     (0 << _SPI2CON_FRMCNT_POSITION)         //Frame pulse every character
#define SPI2_CON_SPIFE                      (1 << _SPI2CON_SPIFE_POSITION)          //Frame sync pulse precede first bit clock
#define SPI2_CON_DISSDO                     (1<< _SPI2CON_DISSDO_POSITION)          //1= SDOx pin is not used by the module. Pin is controlled by associated PORT register
                                                                                    //0 = SDOx pin is controlled by the module
void USTV_SPI2_Initialize ( void )
{
    uint32_t rdata;

    /* Disable SPI2 Interrupts */
    IEC4CLR = 0x4000;
    IEC4CLR = 0x8000;
    IEC4CLR = 0x10000;

    /* STOP and Reset the SPI */
    SPI2CON = 0;

    /* Clear the Receiver buffer */
    rdata = SPI2BUF;
    rdata = rdata;

    /* Clear SPI2 Interrupt flags */
    IFS4CLR = 0x4000;
    IFS4CLR = 0x8000;
    IFS4CLR = 0x10000;

    /* BAUD Rate register Setup */
    SPI2BRG = 49;

    /* CLear the Overflow */
    SPI2STATCLR = _SPI2STAT_SPIROV_MASK;

    /*
    MSTEN = 0
    CKP = 0
    CKE = 1
    MODE<32,16> = 0
    ENHBUF = 1
    MSSEN = 1
    MCLKSEL = 0
    */
    SPI2CONSET = (SPI2_CON_MSSEN | SPI2_CON_MCLKSEL | SPI2_CON_ENHBUF | SPI2_CON_MODE_32_MODE_16 | SPI2_CON_CKE | SPI2_CON_CKP | SPI2_CON_MSTEN | SPI2_CON_SMP | SPI2_CON_FRMEN |
                   SPI2_CON_FRMSYNC | SPI2_CON_FRMPOL | SPI2_CON_FRMSYPW | SPI2_CON_FRMCNT | SPI2_CON_SPIFE | SPI2_CON_SSEN | SPI2_CON_DISSDO);

    /* Enable transmit interrupt when transmit buffer is completely empty (STXISEL = '01') */
    /* Enable receive interrupt when the receive buffer is not empty (SRXISEL = '01') */
    SPI2CONSET = 0x00000005;

    IEC4bits.SPI2EIE=1;
    SPI2CON2bits.IGNROV=1;
    SPI2CON2bits.SPIROVEN=0;
    SPI2CON2bits.FRMERREN=0;
    //SPI2CONbits.SRXISEL=0b01;
    
//    /* Enable SPI2 */
//    SPI2CONSET = _SPI2CON_ON_MASK;
}

#define SPI3_CON_MSTEN                      (0 << _SPI3CON_MSTEN_POSITION)          //Slave mode
#define SPI3_CON_CKP                        (1 << _SPI3CON_CKP_POSITION)            //CKP=0
#define SPI3_CON_SSEN                       (1 << _SPI3CON_SSEN_POSITION)           //SS2 pin used for slave mode
#define SPI3_CON_CKE                        (0 << _SPI3CON_CKE_POSITION)            //CKE=1
#define SPI3_CON_MODE_32_MODE_16            (2 << _SPI3CON_MODE16_POSITION)         //
#define SPI3_CON_ENHBUF                     (1 << _SPI3CON_ENHBUF_POSITION)
#define SPI3_CON_MCLKSEL                    (0 << _SPI3CON_MCLKSEL_POSITION)        //Select PBCLK2 clock
#define SPI3_CON_MSSEN                      (0 << _SPI3CON_MSSEN_POSITION)          //MSSEN=0
#define SPI3_CON_SMP                        (0 << _SPI3CON_SMP_POSITION)            //Sampling in middle
#define SPI3_CON_FRMEN                      (1 << _SPI3CON_FRMEN_POSITION)          //Framed SPI enabled
#define SPI3_CON_FRMSYNC                    (1 << _SPI3CON_FRMSYNC_POSITION)        //Frame sync pulse input
#define SPI3_CON_FRMPOL                     (1 << _SPI3CON_FRMPOL_POSITION)         //Frame pulse active High
#define SPI3_CON_FRMSYPW                    (1 << _SPI3CON_FRMSYPW_POSITION)        //Frame pulse is one word length
#define SPI3_CON_FRMCNT                     (0 << _SPI3CON_FRMCNT_POSITION)         //Frame pulse every character
#define SPI3_CON_SPIFE                      (1 << _SPI3CON_SPIFE_POSITION)          //Frame sync pulse precede first bit clock
#define SPI3_CON_DISSDO                     (1<< _SPI3CON_DISSDO_POSITION)          //1= SDOx pin is not used by the module. Pin is controlled by associated PORT register
                                                                                    //0 = SDOx pin is controlled by the module
void USTV_SPI3_Initialize ( void )
{
    uint32_t rdata;

    /* Disable SPI3 Interrupts */
    IEC4CLR = 0x4000000;
    IEC4CLR = 0x8000000;
    IEC4CLR = 0x10000000;

    /* STOP and Reset the SPI */
    SPI3CON = 0;

    /* Clear the Receiver buffer */
    rdata = SPI3BUF;
    rdata = rdata;

    /* Clear SPI3 Interrupt flags */
    IFS4CLR = 0x4000000;
    IFS4CLR = 0x8000000;
    IFS4CLR = 0x10000000;

    /* BAUD Rate register Setup */
    SPI3BRG = 49;

    /* CLear the Overflow */
    SPI3STATCLR = _SPI3STAT_SPIROV_MASK;

    /*
    MSTEN = 1
    CKP = 0
    CKE = 1
    MODE<32,16> = 0
    ENHBUF = 1
    MSSEN = 1
    MCLKSEL = 0
    */
    SPI3CONSET = (SPI3_CON_MSSEN | SPI3_CON_MCLKSEL | SPI3_CON_ENHBUF | SPI3_CON_MODE_32_MODE_16 | SPI3_CON_CKE | SPI3_CON_CKP | SPI3_CON_MSTEN | SPI3_CON_SMP | SPI3_CON_FRMEN |
                   SPI3_CON_FRMSYNC | SPI3_CON_FRMPOL | SPI3_CON_FRMSYPW | SPI3_CON_FRMCNT | SPI3_CON_SPIFE | SPI3_CON_SSEN | SPI3_CON_DISSDO);

    /* Enable transmit interrupt when transmit buffer is completely empty (STXISEL = '01') */
    /* Enable receive interrupt when the receive buffer is not empty (SRXISEL = '01') */
    SPI3CONSET = 0x00000005;

    IEC4bits.SPI3EIE=1;
    SPI3CON2bits.IGNROV=1;
    SPI3CON2bits.SPIROVEN=0;
    SPI3CON2bits.FRMERREN=0;
    //SPI3CONbits.SRXISEL=0b01;
//    /* Enable SPI3 */
//    SPI3CONSET = _SPI3CON_ON_MASK;
    
}

#define SPI4_CON_MSTEN                      (0 << _SPI4CON_MSTEN_POSITION)          //Slave mode
#define SPI4_CON_CKP                        (1 << _SPI4CON_CKP_POSITION)            //CKP=0
#define SPI4_CON_SSEN                       (1 << _SPI4CON_SSEN_POSITION)           //SS2 pin used for slave mode
#define SPI4_CON_CKE                        (0 << _SPI4CON_CKE_POSITION)            //CKE=1
#define SPI4_CON_MODE_32_MODE_16            (2 << _SPI4CON_MODE16_POSITION)         //
#define SPI4_CON_ENHBUF                     (1 << _SPI4CON_ENHBUF_POSITION)
#define SPI4_CON_MCLKSEL                    (0 << _SPI4CON_MCLKSEL_POSITION)        //Select PBCLK2 clock
#define SPI4_CON_MSSEN                      (0 << _SPI4CON_MSSEN_POSITION)          //MSSEN=0
#define SPI4_CON_SMP                        (0 << _SPI4CON_SMP_POSITION)            //Sampling in middle
#define SPI4_CON_FRMEN                      (1 << _SPI4CON_FRMEN_POSITION)          //Framed SPI enabled
#define SPI4_CON_FRMSYNC                    (1 << _SPI4CON_FRMSYNC_POSITION)        //Frame sync pulse input
#define SPI4_CON_FRMPOL                     (1 << _SPI4CON_FRMPOL_POSITION)         //Frame pulse active High
#define SPI4_CON_FRMSYPW                    (1 << _SPI4CON_FRMSYPW_POSITION)        //Frame pulse is one word length
#define SPI4_CON_FRMCNT                     (0 << _SPI4CON_FRMCNT_POSITION)         //Frame pulse every character
#define SPI4_CON_SPIFE                      (1 << _SPI4CON_SPIFE_POSITION)          //Frame sync pulse precede first bit clock
#define SPI4_CON_DISSDO                     (1<< _SPI4CON_DISSDO_POSITION)          //1= SDOx pin is not used by the module. Pin is controlled by associated PORT register
                                                                                    //0 = SDOx pin is controlled by the module
void USTV_SPI4_Initialize ( void )
{
    uint32_t rdata;

    /* Disable SPI4 Interrupts */
    IEC5CLR = 0x8;
    IEC5CLR = 0x10;
    IEC5CLR = 0x20;

    /* STOP and Reset the SPI */
    SPI4CON = 0;

    /* Clear the Receiver buffer */
    rdata = SPI4BUF;
    rdata = rdata;

    /* Clear SPI4 Interrupt flags */
    IFS5CLR = 0x8;
    IFS5CLR = 0x10;
    IFS5CLR = 0x20;

    /* BAUD Rate register Setup */
    SPI4BRG = 49;

    /* CLear the Overflow */
    SPI4STATCLR = _SPI4STAT_SPIROV_MASK;

    /*
    MSTEN = 1
    CKP = 0
    CKE = 1
    MODE<32,16> = 0
    ENHBUF = 1
    MSSEN = 1
    MCLKSEL = 0
    */
    SPI4CONSET = (SPI4_CON_MSSEN | SPI4_CON_MCLKSEL | SPI4_CON_ENHBUF | SPI4_CON_MODE_32_MODE_16 | SPI4_CON_CKE | SPI4_CON_CKP | SPI4_CON_MSTEN | SPI4_CON_SMP | SPI4_CON_FRMEN |
                   SPI4_CON_FRMSYNC | SPI4_CON_FRMPOL | SPI4_CON_FRMSYPW | SPI4_CON_FRMCNT | SPI4_CON_SPIFE | SPI4_CON_SSEN | SPI4_CON_DISSDO);

    /* Enable transmit interrupt when transmit buffer is completely empty (STXISEL = '01') */
    /* Enable receive interrupt when the receive buffer is not empty (SRXISEL = '01') */
    SPI4CONSET = 0x00000005;

    IEC5bits.SPI4EIE=1;
    SPI4CON2bits.IGNROV=1;
    SPI4CON2bits.SPIROVEN=0;
    SPI4CON2bits.FRMERREN=0;
    
//    /* Enable SPI4 */
//    SPI4CONSET = _SPI4CON_ON_MASK;
}

#define SPI5_CON_MSTEN                      (0 << _SPI5CON_MSTEN_POSITION)          //Slave mode
#define SPI5_CON_CKP                        (1 << _SPI5CON_CKP_POSITION)            //CKP=0
#define SPI5_CON_SSEN                       (1 << _SPI5CON_SSEN_POSITION)           //SS2 pin used for slave mode
#define SPI5_CON_CKE                        (0 << _SPI5CON_CKE_POSITION)            //CKE=1
#define SPI5_CON_MODE_32_MODE_16            (2 << _SPI5CON_MODE16_POSITION)         //
#define SPI5_CON_ENHBUF                     (1 << _SPI5CON_ENHBUF_POSITION)
#define SPI5_CON_MCLKSEL                    (0 << _SPI5CON_MCLKSEL_POSITION)        //Select PBCLK2 clock
#define SPI5_CON_MSSEN                      (0 << _SPI5CON_MSSEN_POSITION)          //MSSEN=0
#define SPI5_CON_SMP                        (0 << _SPI5CON_SMP_POSITION)            //Sampling in middle
#define SPI5_CON_FRMEN                      (1 << _SPI5CON_FRMEN_POSITION)          //Framed SPI enabled
#define SPI5_CON_FRMSYNC                    (1 << _SPI5CON_FRMSYNC_POSITION)        //Frame sync pulse input
#define SPI5_CON_FRMPOL                     (1 << _SPI5CON_FRMPOL_POSITION)         //Frame pulse active High
#define SPI5_CON_FRMSYPW                    (1 << _SPI5CON_FRMSYPW_POSITION)        //Frame pulse is one word length
#define SPI5_CON_FRMCNT                     (0 << _SPI5CON_FRMCNT_POSITION)         //Frame pulse every character
#define SPI5_CON_SPIFE                      (1 << _SPI5CON_SPIFE_POSITION)          //Frame sync pulse precede first bit clock
#define SPI5_CON_DISSDO                     (1<< _SPI5CON_DISSDO_POSITION)          //1= SDOx pin is not used by the module. Pin is controlled by associated PORT register
                                                                                    //0 = SDOx pin is controlled by the module
void USTV_SPI5_Initialize ( void )
{
    uint32_t rdata;

    /* Disable SPI5 Interrupts */
    IEC5CLR = 0x10000;
    IEC5CLR = 0x20000;
    IEC5CLR = 0x40000;

    /* STOP and Reset the SPI */
    SPI5CON = 0;

    /* Clear the Receiver buffer */
    rdata = SPI5BUF;
    rdata = rdata;

    /* Clear SPI5 Interrupt flags */
    IFS5CLR = 0x10000;
    IFS5CLR = 0x20000;
    IFS5CLR = 0x40000;

    /* BAUD Rate register Setup */
    SPI5BRG = 49;

    /* CLear the Overflow */
    SPI5STATCLR = _SPI5STAT_SPIROV_MASK;

    /*
    MSTEN = 1
    CKP = 0
    CKE = 1
    MODE<32,16> = 0
    ENHBUF = 1
    MSSEN = 1
    MCLKSEL = 0
    */
    SPI5CONSET = (SPI5_CON_MSSEN | SPI5_CON_MCLKSEL | SPI5_CON_ENHBUF | SPI5_CON_MODE_32_MODE_16 | SPI5_CON_CKE | SPI5_CON_CKP | SPI5_CON_MSTEN | SPI5_CON_SMP | SPI5_CON_FRMEN |
                   SPI5_CON_FRMSYNC | SPI5_CON_FRMPOL | SPI5_CON_FRMSYPW | SPI5_CON_FRMCNT | SPI5_CON_SPIFE | SPI5_CON_SSEN | SPI5_CON_DISSDO);

    /* Enable transmit interrupt when transmit buffer is completely empty (STXISEL = '01') */
    /* Enable receive interrupt when the receive buffer is not empty (SRXISEL = '01') */
    SPI5CONSET = 0x00000005;

    IEC5bits.SPI5EIE=1;
    SPI5CON2bits.IGNROV=1;
    SPI5CON2bits.SPIROVEN=0;
    SPI5CON2bits.FRMERREN=0;
    
//    /* Enable SPI5 */
//    SPI5CONSET = _SPI5CON_ON_MASK;
}

#define SPI6_CON_MSTEN                      (0 << _SPI6CON_MSTEN_POSITION)          //Slave mode
#define SPI6_CON_CKP                        (1 << _SPI6CON_CKP_POSITION)            //CKP=0
#define SPI6_CON_SSEN                       (1 << _SPI6CON_SSEN_POSITION)           //SS2 pin used for slave mode
#define SPI6_CON_CKE                        (0 << _SPI6CON_CKE_POSITION)            //CKE=1
#define SPI6_CON_MODE_32_MODE_16            (2 << _SPI6CON_MODE16_POSITION)         //
#define SPI6_CON_ENHBUF                     (1 << _SPI6CON_ENHBUF_POSITION)
#define SPI6_CON_MCLKSEL                    (0 << _SPI6CON_MCLKSEL_POSITION)        //Select PBCLK2 clock
#define SPI6_CON_MSSEN                      (0 << _SPI6CON_MSSEN_POSITION)          //MSSEN=0
#define SPI6_CON_SMP                        (0 << _SPI6CON_SMP_POSITION)            //Sampling in middle
#define SPI6_CON_FRMEN                      (1 << _SPI6CON_FRMEN_POSITION)          //Framed SPI enabled
#define SPI6_CON_FRMSYNC                    (1 << _SPI6CON_FRMSYNC_POSITION)        //Frame sync pulse input
#define SPI6_CON_FRMPOL                     (1 << _SPI6CON_FRMPOL_POSITION)         //Frame pulse active High
#define SPI6_CON_FRMSYPW                    (1 << _SPI6CON_FRMSYPW_POSITION)        //Frame pulse is one word length
#define SPI6_CON_FRMCNT                     (0 << _SPI6CON_FRMCNT_POSITION)         //Frame pulse every character
#define SPI6_CON_SPIFE                      (1 << _SPI6CON_SPIFE_POSITION)          //Frame sync pulse precede first bit clock
#define SPI6_CON_DISSDO                     (1<< _SPI6CON_DISSDO_POSITION)          //1= SDOx pin is not used by the module. Pin is controlled by associated PORT register
                                                                                    //0 = SDOx pin is controlled by the module
void USTV_SPI6_Initialize ( void )
{
    uint32_t rdata;

    /* Disable SPI6 Interrupts */
    IEC5CLR = 0x2000000;
    IEC5CLR = 0x4000000;
    IEC5CLR = 0x8000000;

    /* STOP and Reset the SPI */
    SPI6CON = 0;

    /* Clear the Receiver buffer */
    rdata = SPI6BUF;
    rdata = rdata;

    /* Clear SPI6 Interrupt flags */
    IFS5CLR = 0x2000000;
    IFS5CLR = 0x4000000;
    IFS5CLR = 0x8000000;

    /* BAUD Rate register Setup */
    SPI6BRG = 49;

    /* CLear the Overflow */
    SPI6STATCLR = _SPI6STAT_SPIROV_MASK;

    /*
    MSTEN = 0
    CKP = 0
    CKE = 1
    MODE<32,16> = 0
    ENHBUF = 1
    MSSEN = 1
    MCLKSEL = 0
    */
    SPI6CONSET = (SPI6_CON_MSSEN | SPI6_CON_MCLKSEL | SPI6_CON_ENHBUF | SPI6_CON_MODE_32_MODE_16 | SPI6_CON_CKE | SPI6_CON_CKP | SPI6_CON_MSTEN | SPI6_CON_SMP | SPI6_CON_FRMEN |
                   SPI6_CON_FRMSYNC | SPI6_CON_FRMPOL | SPI6_CON_FRMSYPW | SPI6_CON_FRMCNT | SPI6_CON_SPIFE | SPI6_CON_SSEN | SPI6_CON_DISSDO);

    /* Enable transmit interrupt when transmit buffer is completely empty (STXISEL = '01') */
    /* Enable receive interrupt when the receive buffer is not empty (SRXISEL = '01') */
    SPI6CONSET = 0x00000005;

    
    IEC5bits.SPI6IE=1; //TODO Erreur syntax Microchip
    SPI6CON2bits.IGNROV=1;
    SPI6CON2bits.SPIROVEN=0;
    SPI6CON2bits.FRMERREN=0;
    
//    /* Enable SPI2 */
//    SPI6CONSET = _SPI6CON_ON_MASK;
}
