/*******************************************************************************
  MPLAB Harmony Application Source File

  Company:
    Microchip Technology Inc.

  File Name:
    app.c

  Summary:
    This file contains the source code for the MPLAB Harmony application.

  Description:
    This file contains the source code for the MPLAB Harmony application.  It
    implements the logic of the application's state machine and it may call
    API routines of other MPLAB Harmony modules in the system, such as drivers,
    system services, and middleware.  However, it does not call any of the
    system interfaces (such as the "Initialize" and "Tasks" functions) of any of
    the modules in the system or make any assumptions about when those functions
    are called.  That is the responsibility of the configuration-specific system
    files.
 *******************************************************************************/

// *****************************************************************************
// *****************************************************************************
// Section: Included Files
// *****************************************************************************
// *****************************************************************************

#include "app.h"
#include "peripheral/gpio/plib_gpio.h"
#include "app_sd_tasks.h"
#include "UTLN_spi.h"
#include "Define.h"
#include "USTV_DMA.h"
#include "config/default/peripheral/dmac/plib_dmac.h"
#include "FreeRTOS.h"
#include "event_groups.h"
#include "HighBlue_Configuration.h"
#include "app_user_input.h"
#include "config/default/peripheral/tmr/plib_tmr2.h"
#include "config/default/peripheral/tmr/plib_tmr4.h"
#include "UTLN_Communication.h"
#ifdef USE_SYSTEM_TRACE
    #include <stdio.h>
    #include "USTV_SystemTrace.h"
#endif
#include "app_usb.h"
#include "app_cnn_detection.h"
#include "UTLN_DDR_CircularBuffer.h"
#define TEST_BUFF_SIZE 65536

#include <math.h>

APP_MAKE_BUFFER_DMA_READY uint8_t buff[TEST_BUFF_SIZE];
unsigned char* buffer = (unsigned char*) DDR_START_UNCACHED;
extern volatile bool dma6TransfertDone;
// *****************************************************************************
// *****************************************************************************
// Section: Global Data Definitions
// *****************************************************************************
// *****************************************************************************

// *****************************************************************************
/* Application Data

  Summary:
    Holds application data

  Description:
    This structure holds the application's data.

  Remarks:
    This structure should be initialized by the APP_Initialize function.

    Application strings and buffers are be defined outside this structure.
*/

APP_DATA appData;

extern APP_SD_TASKS_DATA app_sd_tasksData;
extern APP_USB_DATA app_usbData;

extern TaskHandle_t xTaskSDHandle;
extern TaskHandle_t xTaskCNNDetectionHandle;
TaskHandle_t xTaskAppHandle=NULL;
extern bool sw1Pushed;
volatile unsigned long g_longTimeStamp=0;


//extern DDRBuffer_Donebits DDRBufferDoneTab[];
extern DDRCurrentBuffersIndex DDRDMACurrentBuffersIndex;

extern APP_MAKE_BUFFER_DMA_READY unsigned char packetConstructionBuffer[]; //6 canaux avec DMA de taille max + 1000 octets au dbut 

//PACKET_BUFFER_SIZE



// *****************************************************************************
// *****************************************************************************
// Section: Application Callback Functions
// *****************************************************************************
// *****************************************************************************
//static char pingPong=0;
//static char isFirstPacket=0;
//1Chan
//<editor-fold defaultstate="collapsed" desc="DMA0 Callback">
//volatile int i0=0;

extern volatile SPIDMADonebits SPIDMAArrivedFlag;

volatile unsigned int DDR_CB_Head=0;
volatile unsigned int DDR_CB_Tail=0;

int DMABurstChannelIndex = 0;
//bool DMABurstEnCours = false;
volatile bool DMABurstPartieHauteEnCours = false;
extern unsigned int spiDmaBufferSize;

void USTV_DMA_TryToWriteToDDR() //IsDMAFull = true si on process la partie haute des demi buffer DMA, flase si on process la partie basse
{
//        BaseType_t xHigherPriorityTaskWoken;
    /* xHigherPriorityTaskWoken must be initialised to pdFALSE.  If calling
    xTaskNotifyFromISR() unblocks the handling task, and the priority of
    the handling task is higher than the priority of the currently running task,
    then xHigherPriorityTaskWoken will automatically get set to pdTRUE. */
//    xHigherPriorityTaskWoken = pdFALSE;
    if(USTV_DMA_IsReadyForTransferToDDR())
    {
        //DMABurstPartieHauteEnCours = IsDMAPartieFull;
        IO_1_Set();
        
        //On dmarre un transfert des morceaux de data prsents dans chaque channel en faisant un burst de n (chans) + 1 transferts successifs              
        //if(!DMABurstEnCours)
        {
            //On dclare que le burst DMA est en cours
            //DMABurstEnCours=true;
            DMABurstChannelIndex=0; //On remet l'indice des transferts DMA  0, on ne l'incrmente qu'au transfert des data des canaux DMA lis aux SPI, donc pas ici.
                        
            if(!DMABurstPartieHauteEnCours)
            {
                //On est dans la partie bazsse du buffer, on commence par le transfert du channel 0 DMA correspondant au SPI1
                //La data de la partie basse du channel 0 se situe dans le packetConstructionBuffer juste aprs l'espace AdditionalData
                USTV_DMACopieTo((unsigned int)packetConstructionBuffer
                        +ADDITIONNAL_DATA_SIZE, 
                        DDR_START_UNCACHED+PACKET_BUFFER_SIZE*DDR_CB_Head+
                        ADDITIONNAL_DATA_SIZE, 
                        spiDmaBufferSize/2);
                DMABurstChannelIndex++; //On transfert le channel 0, on incrmente.
            }
            else
            {
                //On transfre le paquet correspondant aux datas additionnelles d'abord
                //La data de la partie additionnelle se situe dans le packetConstructionBuffer au tout dbut
                USTV_DMACopieTo((unsigned int)packetConstructionBuffer, 
                        DDR_START_UNCACHED+PACKET_BUFFER_SIZE*DDR_CB_Head, 
                        ADDITIONNAL_DATA_SIZE);
                //On transfert les data additionnelles, on n'incrmente pas les canaux.
            }
        }
  
    }
}

void USTV_DMAC_CHANNEL0_CallBack()
{
    //Destination full
    if(DCH0INTbits.CHDDIF)
    {
        IO_7_Set();
        DCH0INTbits.CHDDIF=0;
        DCH0INTbits.CHDHIF=0;
        SPIDMAArrivedFlag.DMA0HighReady = 1;
        USTV_DMA_TryToWriteToDDR();
        IO_3_Clear();
//        while(!dma6TransfertDone)
//            ;
//        USTV_DMACopieTo(DDR_START_UNCACHED, DDRGetPointerOfCurrentFillingBuffer(0), 32768);
    }
    
    //Destination half
    if(DCH0INTbits.CHDHIF)
    {      
        IO_8_Set(); 
        //ATTENTION : ici ne pas clearer CHDHIF c'est juste un statut de milieu de buffer atteint. 
        //Si on le clear, il va repasser  1 de suite, gnrant une nouvelle interruption
        //DCH0INTbits.CHDHIF=0;
        SPIDMAArrivedFlag.DMA0LowReady = 1;        
        USTV_DMA_TryToWriteToDDR();
        IO_3_Set();
//        while(!dma6TransfertDone)
//            ;
//        USTV_DMACopieTo(DDR_START_UNCACHED+32768, DDRGetPointerOfCurrentFillingBuffer(0), 32768);
    }
}
//</editor-fold>

//<editor-fold defaultstate="collapsed" desc="DMA1 Callback">
//volatile int i1=0;
void USTV_DMAC_CHANNEL1_CallBack()
{
    //Destination full
    if(DCH1INTbits.CHDDIF)
    {
        IO_7_Set();
        DCH1INTbits.CHDDIF=0;
        DCH1INTbits.CHDHIF=0;
        SPIDMAArrivedFlag.DMA1HighReady = 1;        
        USTV_DMA_TryToWriteToDDR();
        IO_4_Clear();
//        while(!dma6TransfertDone)
//            ;
//        USTV_DMACopieTo(DDR_START_UNCACHED+DATA_BUFFER_SIZE, DDRGetPointerOfCurrentFillingBuffer(1), 32768);
    }
    
    //Destination half
    if(DCH1INTbits.CHDHIF)
    {       
        IO_8_Set();
        //ATTENTION : ici ne pas clearer CHDHIF c'est juste un statut de milieu de buffer atteint. 
        //Si on le clear, il va repasser  1 de suite, gnrant une nouvelle interruption
        //DCH1INTbits.CHDHIF=0;
        SPIDMAArrivedFlag.DMA1LowReady = 1;        
        USTV_DMA_TryToWriteToDDR();
        IO_4_Set();
//        while(!dma6TransfertDone)
//            ;
//        USTV_DMACopieTo(DDR_START_UNCACHED+DATA_BUFFER_SIZE+32768, DDRGetPointerOfCurrentFillingBuffer(1), 32768);
    }
}
//</editor-fold>

//2 Chan
//<editor-fold defaultstate="collapsed" desc="DMA2 Callback">
//volatile int i2=0;
void USTV_DMAC_CHANNEL2_CallBack()
{
    //Destination full
    if(DCH2INTbits.CHDDIF)
    {
        IO_7_Set();
        DCH2INTbits.CHDDIF=0;
        DCH2INTbits.CHDHIF=0;
        SPIDMAArrivedFlag.DMA2HighReady = 1;        
        USTV_DMA_TryToWriteToDDR();
        IO_5_Clear();
//        while(!dma6TransfertDone)
//            ;
//        USTV_DMACopieTo(DDR_START_UNCACHED+DATA_BUFFER_SIZE*2, DDRGetPointerOfCurrentFillingBuffer(2), 32768);
    }
    
    //Destination half
    if(DCH2INTbits.CHDHIF)
    {       
        IO_8_Set();
        //ATTENTION : ici ne pas clearer CHDHIF c'est juste un statut de milieu de buffer atteint. 
        //Si on le clear, il va repasser  1 de suite, gnrant une nouvelle interruption
        //DCH2INTbits.CHDHIF=0;
        SPIDMAArrivedFlag.DMA2LowReady = 1;        
        USTV_DMA_TryToWriteToDDR();
        IO_5_Set();
//                while(!dma6TransfertDone)
//            ;
//        USTV_DMACopieTo(DDR_START_UNCACHED+DATA_BUFFER_SIZE*2+32768, DDRGetPointerOfCurrentFillingBuffer(2), 32768);
    }
}
//</editor-fold>
//<editor-fold defaultstate="collapsed" desc="DMA3 Callback">
//volatile int i3=0;
void USTV_DMAC_CHANNEL3_CallBack()
{
    //Destination full
    if(DCH3INTbits.CHDDIF)
    {
        IO_7_Set();
        DCH3INTbits.CHDDIF=0;
        DCH3INTbits.CHDHIF=0;
        SPIDMAArrivedFlag.DMA3HighReady = 1;        
        USTV_DMA_TryToWriteToDDR();
        IO_6_Clear();
//        while(!dma6TransfertDone)
//            ;
//        USTV_DMACopieTo(DDR_START_UNCACHED+DATA_BUFFER_SIZE*3, DDRGetPointerOfCurrentFillingBuffer(3), 32768);
    }
    
    //Destination half
    if(DCH3INTbits.CHDHIF)
    {       
        IO_8_Set();
        //ATTENTION : ici ne pas clearer CHDHIF c'est juste un statut de milieu de buffer atteint. 
        //Si on le clear, il va repasser  1 de suite, gnrant une nouvelle interruption
        //DCH3INTbits.CHDHIF=0;
        SPIDMAArrivedFlag.DMA3LowReady = 1;        
        USTV_DMA_TryToWriteToDDR();
        IO_6_Set();
//        while(!dma6TransfertDone)
//            ;
//        USTV_DMACopieTo(DDR_START_UNCACHED+DATA_BUFFER_SIZE*3+32768, DDRGetPointerOfCurrentFillingBuffer(3), 32768);
    }
}
//</editor-fold>

// 5 Chan
//<editor-fold defaultstate="collapsed" desc="DMA4 Callback">
//volatile int i4=0;
void USTV_DMAC_CHANNEL4_CallBack()
{
    if(DCH4INTbits.CHDDIF)
    {
        IO_7_Set();
        DCH4INTbits.CHDDIF=0;
        DCH4INTbits.CHDHIF=0;
        SPIDMAArrivedFlag.DMA4HighReady = 1;        
        USTV_DMA_TryToWriteToDDR();
        //IO_7_Clear();
//        while(!dma6TransfertDone)
//            ;
//        USTV_DMACopieTo(DDR_START_UNCACHED+DATA_BUFFER_SIZE*3, DDRGetPointerOfCurrentFillingBuffer(3), 32768);
    }
    
    //Destination half
    if(DCH4INTbits.CHDHIF)
    {      
        IO_8_Set();
        //ATTENTION : ici ne pas clearer CHDHIF c'est juste un statut de milieu de buffer atteint. 
        //Si on le clear, il va repasser  1 de suite, gnrant une nouvelle interruption
        //DCH4INTbits.CHDHIF=0;
        SPIDMAArrivedFlag.DMA4LowReady = 1;        
        USTV_DMA_TryToWriteToDDR();
        //IO_7_Set();
//        while(!dma6TransfertDone)
//            ;
//        USTV_DMACopieTo(DDR_START_UNCACHED+DATA_BUFFER_SIZE*3+32768, DDRGetPointerOfCurrentFillingBuffer(3), 32768);
    }
}
//</editor-fold>
// 6 Chan
//<editor-fold defaultstate="collapsed" desc="DMA5 Callback">
void USTV_DMAC_CHANNEL5_CallBack()
{
    if(DCH5INTbits.CHDDIF)
    {
        IO_7_Set();
        DCH5INTbits.CHDDIF=0;
        DCH5INTbits.CHDHIF=0;
        SPIDMAArrivedFlag.DMA5HighReady = 1;        
        USTV_DMA_TryToWriteToDDR();
//        while(!dma6TransfertDone)
//            ;
//        USTV_DMACopieTo(DDR_START_UNCACHED+DATA_BUFFER_SIZE*3, DDRGetPointerOfCurrentFillingBuffer(3), 32768);
    }
    
    //Destination half
    if(DCH5INTbits.CHDHIF)
    {       
        IO_8_Set();
        //ATTENTION : ici ne pas clearer CHDHIF c'est juste un statut de milieu de buffer atteint. 
        //Si on le clear, il va repasser  1 de suite, gnrant une nouvelle interruption
        //DCH5INTbits.CHDHIF=0;
        SPIDMAArrivedFlag.DMA5LowReady = 1;        
        USTV_DMA_TryToWriteToDDR();
//        while(!dma6TransfertDone)
//            ;
//        USTV_DMACopieTo(DDR_START_UNCACHED+DATA_BUFFER_SIZE*3+32768, DDRGetPointerOfCurrentFillingBuffer(3), 32768);
    }
}
//</editor-fold>

//DMA de transfert vers DDR (copie)
//<editor-fold defaultstate="collapsed" desc="DMA6 Callback">

void USTV_DMAC_CHANNEL6_CallBack()
{
    BaseType_t xHigherPriorityTaskWoken;
    /* xHigherPriorityTaskWoken must be initialised to pdFALSE.  If calling
    xTaskNotifyFromISR() unblocks the handling task, and the priority of
    the handling task is higher than the priority of the currently running task,
    then xHigherPriorityTaskWoken will automatically get set to pdTRUE. */
    xHigherPriorityTaskWoken = pdFALSE;
    if(DCH6INTbits.CHDDIF)
    {
        IO_1_Clear();
        DCH6INTbits.CHDDIF=0;
        DCH6INTbits.CHDHIF=0;
        
        //La copie via le DMA est termine
        //Si on n'a pas termin le burst de transferts, on relance un trasnfert DMA des blocs de data des demis buffers DMA
        if(DMABurstChannelIndex<appData.recordParameters.nbChannelsUsed)
        {
            IO_1_Set();
            if(!DMABurstPartieHauteEnCours)
                USTV_DMACopieTo((unsigned int)packetConstructionBuffer+
                        ADDITIONNAL_DATA_SIZE+DMABurstChannelIndex*spiDmaBufferSize,
                        
                        DDR_START_UNCACHED+PACKET_BUFFER_SIZE*DDR_CB_Head+
                        ADDITIONNAL_DATA_SIZE+DMABurstChannelIndex*spiDmaBufferSize/*/2*/, 
                        spiDmaBufferSize/2);
            else
                USTV_DMACopieTo((unsigned int)packetConstructionBuffer+                        
                        ADDITIONNAL_DATA_SIZE+DMABurstChannelIndex*spiDmaBufferSize+spiDmaBufferSize/2,
                        
                        DDR_START_UNCACHED+PACKET_BUFFER_SIZE*DDR_CB_Head+
                        ADDITIONNAL_DATA_SIZE+DMABurstChannelIndex*spiDmaBufferSize+spiDmaBufferSize/2, 
                        spiDmaBufferSize/2);
            DMABurstChannelIndex++;
        }
        else
        {
            if(DMABurstPartieHauteEnCours)
            {
                //Si on a termin d'envoyer les channels et qu'on est dans la partie haute du buffer, alors le buffer est termin
                //On incrmente le pointeur head et on sort
                DDR_CB_Head++;
                if(DDR_CB_Head>=DDR_CIRCULAR_BUFFER_SIZE)
                    DDR_CB_Head=0;             
                appData.stats.spiPacketReceived++;
                USTV_ResetAdditionnalDataIndexBufferA();
                xTaskNotifyFromISR( xTaskSDHandle, BUFFER_A_READY, eSetBits, &xHigherPriorityTaskWoken );
            }
        }
    }
    
    //Destination half
    if(DCH6INTbits.CHDHIF)
    {       
    }
    
        /* Force a scheduler call on exit */
    if( xHigherPriorityTaskWoken == pdTRUE )
    {
         portYIELD();
    }
}
//</editor-fold>

//<editor-fold defaultstate="collapsed" desc="DMA7 Callback">
void USTV_DMAC_CHANNEL7_CallBack(DMAC_TRANSFER_EVENT status, uintptr_t contextHandle)
{
    BaseType_t xHigherPriorityTaskWoken=pdFALSE;
   

    /* Notify the task that the transmission is complete by setting the TX_BIT
    in the task's notification value. */
    xTaskNotifyFromISR( xTaskSDHandle,
                   BUFFER_B_READY,
                   eSetBits,
                   &xHigherPriorityTaskWoken );
//        drvAdcBufferB[6]=BREAK_UINT32(timeStamp,3);
//        drvAdcBufferB[7]=BREAK_UINT32(timeStamp,2);
//        drvAdcBufferB[8]=BREAK_UINT32(timeStamp,1);
//        drvAdcBufferB[9]=BREAK_UINT32(timeStamp,0);
    //On change le buffer courant de data additionnelles
    USTV_SetCurrentFillingAdditionnalBuffer(BUFFER_A);
    
    DCH7INT=0;
    DCH7INTbits.CHDDIE = 1;                 // Interrupt when the fill is done.
    appData.stats.spiPacketReceived++;
        /* Force a scheduler call on exit */
    if( xHigherPriorityTaskWoken == pdTRUE )
    {
         portYIELD();
    }
}
//</editor-fold>


//<editor-fold defaultstate="collapsed" desc="TMR2 Callback (TimeStamp)">
void USTV_TMR2_CallBack(uint32_t status, uintptr_t contextHandle)
{
    g_longTimeStamp++;
}
//</editor-fold>
//<editor-fold defaultstate="collapsed" desc="TMR4 Callback (1 seconde)">
void USTV_TMR4_CallBack(uint32_t status, uintptr_t contextHandle)
{
   // USTV_AddSecondToLocalTime();
    uint8_t msg[1];
    msg[0]=appData.status;
    
    //On enqueue une future command
    APP_COMMUNICATION_SetNextMessage(SEND_STATUS, 1,msg);
    
    unsigned char payload[25];
    payload[0]=BREAK_UINT32(appData.recordParameters.samplingFrequency,3);
    payload[1]=BREAK_UINT32(appData.recordParameters.samplingFrequency,2);
    payload[2]=BREAK_UINT32(appData.recordParameters.samplingFrequency,1);
    payload[3]=BREAK_UINT32(appData.recordParameters.samplingFrequency,0);
    payload[4]= appData.recordParameters.nbChannelsUsed;
    payload[5]= appData.recordParameters.resolution;
    payload[6]=appData.localTime.year;
    payload[7]=appData.localTime.month;
    payload[8]=appData.localTime.day;
    payload[9]=appData.localTime.hour;
    payload[10]=appData.localTime.min;
    payload[11]=appData.localTime.sec;
    for(int i=0;i<8;i++)
    {
        payload[12+i]= appData.UUID64[i];
    }
    payload[20]=appData.ads1602IsLogging;
    payload[21]=BREAK_UINT32(appData.stats.spiPacketReceived,3);
    payload[22]=BREAK_UINT32(appData.stats.spiPacketReceived,2);
    payload[23]=BREAK_UINT32(appData.stats.spiPacketReceived,1);
    payload[24]=BREAK_UINT32(appData.stats.spiPacketReceived,0);
    MakeAndSendUSBMessageWithUTLNProtocol(QHB_STATUS, 25, payload);
    

}
//</editor-fold>


/* Define a callback function that will be used by multiple timer
 instances.  The callback function does nothing but count the number
 of times the associated timer expires, and stop the timer once the
 timer has expired 10 times.  The count is saved as the ID of the
 timer. */
 void vTimerCallback( TimerHandle_t xTimer )
 {

    /* Optionally do something if the pxTimer parameter is NULL. */
    configASSERT( xTimer );

    BaseType_t xHigherPriorityTaskWoken=pdFALSE;
   

    /* Notify the task that the transmission is complete by setting the TX_BIT
    in the task's notification value. */
    xTaskNotifyFromISR( xTaskAppHandle,
                   TMR_STOP_RECORDING,
                   eSetBits,
                   &xHigherPriorityTaskWoken );
    /* Force a scheduler call on exit */
//    if( xHigherPriorityTaskWoken == pdTRUE )
//    {
//         portYIELD();
//    }
 }
 
// *****************************************************************************
// *****************************************************************************
// Section: Application Local Functions
// *****************************************************************************
// *****************************************************************************
//<editor-fold defaultstate="collapsed" desc="USTV AddSecondeToLocalTime">
void USTV_AddSecondToLocalTime(void)
{
    unsigned char year=0,month=0, day=0, hour=0,min=0;
        if(appData.localTime.sec+1>59)
            min++;
    appData.localTime.sec=(appData.localTime.sec+1)%60;

    if(appData.localTime.min+min>59)
        hour++;
    appData.localTime.min=(appData.localTime.min+min)%60;

    if(appData.localTime.hour+hour>23)
        day++;
    appData.localTime.hour=(appData.localTime.hour+hour)%24;
    
    int nbDayInMonth=31;
    int currentYear=appData.localTime.year + 2000;
    switch(appData.localTime.month)
    {
        case 1: nbDayInMonth=31; break;
        case 2: if( (currentYear%4) == 0 && ( (currentYear % 100) !=0 || (currentYear % 400)==0) )
                    nbDayInMonth=29;        // Leap year
                else
                    nbDayInMonth=28;        // Not Leap year
        case 3: nbDayInMonth=31; break;
        case 4: nbDayInMonth=30; break;
        case 5: nbDayInMonth=31; break;
        case 6: nbDayInMonth=30; break;
        case 7: nbDayInMonth=31; break;
        case 8: nbDayInMonth=31; break;
        case 9: nbDayInMonth=30; break;
        case 10: nbDayInMonth=31; break;
        case 11: nbDayInMonth=30; break;
        case 12: nbDayInMonth=31; break;
        default: nbDayInMonth=31; break;
    }
    
    if(appData.localTime.day+day >nbDayInMonth)
    {
        month++;
        appData.localTime.day = ((appData.localTime.day+day)%nbDayInMonth);
    }
    else
    {
        appData.localTime.day = (appData.localTime.day+day);
    }

    if(appData.localTime.month+month >12)
    {
        year++;
        appData.localTime.month = (appData.localTime.month+month)%12;
    }
    else
    {
        appData.localTime.month = (appData.localTime.month+month);
    }
    appData.localTime.year = appData.localTime.year+year;
}
//</editor-fold>

//<editor-fold defaultstate="collapsed" desc="USTV Configure ADS127L01">
unsigned char USTV_ConfigureADS127L01( unsigned int samplingFreq, unsigned char filterSelection)
{
  //  RESET_ADC_Clear(); 
    switch(filterSelection)
    {
        case 0: ADC_FILTER0_Clear();
                ADC_FILTER1_Clear();
            break;
        case 1: ADC_FILTER0_Set();
                ADC_FILTER1_Clear();
            break;
        case 2: ADC_FILTER0_Clear();
                ADC_FILTER1_Set();
            break;
        default: ADC_FILTER0_Clear();
                 ADC_FILTER1_Clear();
            break;
    }
    
    switch(samplingFreq)
    {
        case 512000:ADC_OSR0_Clear();
                    ADC_OSR1_Clear();
            break;
        case 256000:
            if(filterSelection==0 || filterSelection==1)
            {
                ADC_OSR0_Set();
                ADC_OSR1_Clear();
            }
            else
            {
                return 0;
            }
            break;
        case 128000:
            if(filterSelection==0 || filterSelection==1)
            {
                ADC_OSR0_Clear();
                ADC_OSR1_Set();
            }
            else
            {
                ADC_OSR0_Set();
                ADC_OSR1_Clear();
            }
            break;
        case 64000:
            if(filterSelection==0 || filterSelection==1)
            {
                ADC_OSR0_Set();
                ADC_OSR1_Set();
            }
            else
            {
                return 0;
            }
            break;
        case 32000:
            if(filterSelection==2)
            {
                ADC_OSR0_Clear();
                ADC_OSR1_Set();
            }
            else
            {
                return 0;
            }
            break;
        case 8000:
            if(filterSelection==2)
            {
                ADC_OSR0_Set();
                ADC_OSR1_Set();
            }
            else
            {
                return 0;
            }
            break;
        default:return 0;
            break;
    }
    return 1;
}
//</editor-fold>

//<editor-fold defaultstate="collapsed" desc="USTV PrepareRecordingOpt">
unsigned int filePeriodeMax;
void USTV_PrepareRecordingOpt(bool manualStart)
{
    unsigned char result;
    appData.stats.spiPacketReceived=0;
    appData.stats.packetSuccessfullyWrittenToFS=0;
    appData.stats.totalUSBWriteError=0;

    #ifdef USE_WAV_FORMAT
        USTV_PrepareWAVFile();
        //Update WaveHeader
        USTV_WavHeaderWriteFunc(appData.recordParameters.resolution, appData.recordParameters.nbChannelsUsed,
                                appData.recordParameters.samplingFrequency, appData.stats.packetSuccessfullyWrittenToFS*PACKET_BUFFER_SIZE);
    #else
#ifdef MISSION_MAURICE
USTV_PrepareFile(&appData.timeForFileName);
#else
    if(appData.recordParameters.saveMode==REC_SD_HDD)
    {
        if(manualStart)
            USTV_PrepareFile(&appData.localTime);
        else
            USTV_PrepareFile(&appData.timeForFileName);
    }

#endif
    if(appData.recordParameters.saveMode==REC_SD_HDD)
    {
        USTV_LogHeaderWriteFunc(app_sd_tasksData.fileHandle,appData.recordParameters.resolution, appData.recordParameters.nbChannelsUsed, appData.recordParameters.samplingFrequency, appData.numberOfExternalPeripheral,appData.currentStartOfFileTimeStamp, appData.peripheralConfig);
    }
    #endif
    #ifdef USE_SYSTEM_TRACE
        USTV_SystemTraceWriteLineToBuffer("FS: Creating new Audio File ");
    #endif
    
    //USTV_InitDMAForSPI(appData.recordParameters.nbChannelsUsed, appData.recordParameters.resolution);
        USTV_InitDMAForSPIV2(appData.recordParameters.nbChannelsUsed, appData.recordParameters.resolution);

    result=USTV_ConfigureADS127L01( appData.recordParameters.samplingFrequency, appData.recordParameters.filterSelection);
    if(result)
        ;
    if(app_sd_tasksData.fileHandle!=SYS_FS_HANDLE_INVALID)
    {
        appData.isFilePrepared=true;
        LED_ROUGE_Clear();
    }
    else
    {
        LED_ROUGE_Set();
    }
}
//</editor-fold>

//<editor-fold defaultstate="collapsed" desc="USTV StopRecording">
void USTV_StopRecording(void)
{    
    DMACONbits.ON = 0;          // enable global DMA controller
    
    ADC_START_Clear();
    RESET_ADC_Clear();  //On passe le composant en veille (ou RESET si RESETADC=0 pendant <2^15tck)   
//    
//    if(app_sd_tasksData.fileHandle != SYS_FS_HANDLE_INVALID /*&& appData.USBMode==MODE_HOST */)
//    {  
//        #ifdef USE_WAV_FORMAT
//            //Update WaveHeader
//            USTV_WavHeaderWriteFunc(appData.recordParameters.resolution, appData.recordParameters.nbChannelsUsed,
//                                    appData.recordParameters.samplingFrequency, appData.stats.packetSuccessfullyWrittenToFS*131072);
//        #else
//            USTV_LogHeaderWriteFunc(app_sd_tasksData.fileHandle,appData.recordParameters.resolution, appData.recordParameters.nbChannelsUsed, appData.recordParameters.samplingFrequency, appData.numberOfExternalPeripheral,appData.currentStartOfFileTimeStamp, appData.peripheralConfig);
//        #endif
//        /* Close the file */
//        SYS_FS_FileClose(app_sd_tasksData.fileHandle);
//        app_sd_tasksData.fileHandle=SYS_FS_HANDLE_INVALID;
//    }

    SPI1CON=0;
    SPI2CON=0;
    SPI3CON=0;
    SPI4CON=0;
    SPI5CON=0;
    SPI6CON=0;
    appData.ads1602IsLogging=false;
    
    if(appData.isFilePrepared)
    {
        appData.isFileReadyForCNN=true;
    }
    appData.isFilePrepared=false;
    
    for(int i=0;i<10000;i++)
        Nop();
    RESET_ADC_Set();                    //On sort le composant de veille
}
//</editor-fold>
//<editor-fold defaultstate="collapsed" desc="USTV StartRecording">
void USTV_StartRecording(void)
{   
    appData.stats.spiPacketReceived=0;
    //Ajout en-tete pour forward trame vers USB
    //Un decalage de cette entete pour indiquer au processeur de message un debut de packet USB.
    packetConstructionBuffer[0]=0xFE;
    packetConstructionBuffer[1]=0x0B;
    packetConstructionBuffer[2]=0x01;
    packetConstructionBuffer[3]=0xFF;
    packetConstructionBuffer[4]=0xFB;
    ADC_FSMODE_Set();                   //On passe l'ADS en SPI Master
    DDRInitCircularBuffer(appData.recordParameters.nbChannelsUsed);
    //on init le SPI
    USTV_SPI1_Initialize();
    USTV_SPI2_Initialize();
    USTV_SPI3_Initialize();
    USTV_SPI4_Initialize();
    USTV_SPI5_Initialize();
    USTV_SPI6_Initialize();


    //ADC_START_Clear();
    RESET_ADC_Clear();  //On passe le composant en veille (ou RESET si RESETADC=0 pendant <2^15tck)   
    
     for(int i=0;i<10000;i++)
        Nop();
    
    RESET_ADC_Set();                    //On sort le composant de veille
    ADC_START_Set();                    //On demarre l'acquisition
    /* Enable SPI2 */
    SPI1CONSET = _SPI1CON_ON_MASK;
    /* Enable SPI2 */
    SPI2CONSET = _SPI2CON_ON_MASK;
    /* Enable SPI2 */
    SPI3CONSET = _SPI3CON_ON_MASK;
    /* Enable SPI2 */
    SPI4CONSET = _SPI4CON_ON_MASK;
    /* Enable SPI2 */
    SPI5CONSET = _SPI5CON_ON_MASK;
    /* Enable SPI2 */
    SPI6CONSET = _SPI6CON_ON_MASK;

    appData.ads1602IsLogging=true;
    appData.currentStartOfFileTimeStamp=g_longTimeStamp;
    for(int i=0;i<1500000;i++)
        Nop();
    
    DMACONbits.ON = 1;          // enable global DMA controller
}
//</editor-fold>


// *****************************************************************************
// *****************************************************************************
// Section: Application Initialization and State Machine Functions
// *****************************************************************************
// *****************************************************************************

/*******************************************************************************
  Function:
    void APP_Initialize ( void )

  Remarks:
    See prototype in app.h.
 */

void APP_Initialize ( void )
{
    /* Place the App state machine in its initial state. */
    appData.state = APP_STATE_INIT;

    LED_ORANGE_Set();
    LED_ROUGE_Set();
    
    ADC_FSMODE_Set();                   //On passe l'ADS en SPI Master
    ADC_START_Clear();                  //On s'assure que la pin start est bien a 0
    RESET_ADC_Set();                    //Attention, temps de sortie de veille  respecter
    for(int i=0;i<50000;i++)
        Nop();
    
    //On effectu un RESET de l'ADC
    RESET_ADC_Clear();        
    for(int i=0;i<3700;i++)
        Nop();

    RESET_ADC_Set();

    /* TODO: Initialize your application's state machine and other
     * parameters.
     */
}


/******************************************************************************
  Function:
    void APP_Tasks ( void )

  Remarks:
    See prototype in app.h.
 */
unsigned long cc2652NoResp=0;
TimerHandle_t timer;
void APP_Tasks ( void )
{
    /* Check the application's current state. */
    switch ( appData.state )
    {
        /* Application's initial state. */
        case APP_STATE_INIT:
        {
            bool appInitialized = true;
            
            //Register DMA CallBacks
            DMAC_ChannelCallbackRegister(DMAC_CHANNEL_0, USTV_DMAC_CHANNEL0_CallBack, (uintptr_t) NULL);
            DMAC_ChannelCallbackRegister(DMAC_CHANNEL_1, USTV_DMAC_CHANNEL1_CallBack, (uintptr_t) NULL);
            DMAC_ChannelCallbackRegister(DMAC_CHANNEL_2, USTV_DMAC_CHANNEL2_CallBack, (uintptr_t) NULL);
            DMAC_ChannelCallbackRegister(DMAC_CHANNEL_3, USTV_DMAC_CHANNEL3_CallBack, (uintptr_t) NULL);
            DMAC_ChannelCallbackRegister(DMAC_CHANNEL_4, USTV_DMAC_CHANNEL4_CallBack, (uintptr_t) NULL);
            DMAC_ChannelCallbackRegister(DMAC_CHANNEL_5, USTV_DMAC_CHANNEL5_CallBack, (uintptr_t) NULL);
            DMAC_ChannelCallbackRegister(DMAC_CHANNEL_6, USTV_DMAC_CHANNEL6_CallBack, (uintptr_t) NULL);
            DMAC_ChannelCallbackRegister(DMAC_CHANNEL_7, USTV_DMAC_CHANNEL7_CallBack, (uintptr_t) NULL);
            
            TMR2_CallbackRegister( USTV_TMR2_CallBack, 0 ); //(TimeStamp)
            TMR4_CallbackRegister( USTV_TMR4_CallBack, 0);   //Timer 32bit pour horloge 1 sec
            
            //Timer virtuel pour les demarrage manuel (appuis SW1)
            timer = xTimerCreate(   "Timer",/* Just a text name, not used by the RTOS kernel. */
                                    60000, /* The timer period in ticks, must be greater than 0. */
                                    pdFALSE, /* The timers will not auto-reload themselves when they expire. */            
                                    ( void * ) 0, /* The ID is used to store a count of the number of times the timer has expired, which is initialised to 0. */
                                    vTimerCallback /* Each timer calls the same callback when it expires. */
                   );
            if( timer == NULL )
            {
                /* The timer was not created. */
            }
            TMR2_Start();           //Start 16bit Timer (timeStamp 1ms)
            
            TMR4_Start();           //Start 32bit Timer (1s Maintient heure locale)
            xTaskAppHandle=xTaskGetCurrentTaskHandle();
            if (appInitialized)
            {
                appData.recordParameters.resolution=JASON_DEFAULT_RESOLUTION;
                appData.recordParameters.nbChannelsUsed=JASON_DEFAULT_CHAN_COUNT;
                
                appData.recordParameters.samplingFrequency=JASON_DEFAULT_FREQ;
                appData.recordParameters.fileSizeLimitation=JASON_DEFAULT_FILE_SIZE;
                appData.state = APP_STATE_WAIT_FOR_STORAGE;
                appData.status=APP_STATUS_WAITING_FOR_STORAGE;
                appData.numberOfExternalPeripheral=0;
                LED_ORANGE_Clear();
                LED_ROUGE_Clear();
                
                //ADS127L01
                ADC_FSMODE_Set();                   //On passe l'ADS en SPI Master
                RESET_ADC_Set();                    //On sort le composant de veille
            }
            break;
        }

        case APP_STATE_WAIT_FOR_STORAGE:
        {
            uint32_t ulNotifiedValue=0;
            BaseType_t xResult;
            //const TickType_t xTicksToWait = 1 / portTICK_PERIOD_MS;
            #ifdef USE_SYSTEM_TRACE
                USTV_SystemTraceWriteLine("APP: Wait For Storage");
            #endif
            /* Wait to be notified of an interrupt. */
            xResult = xTaskNotifyWait( pdFALSE,    /* Don't clear bits on entry. */
                           0xFFFFFFFF,        /* Clear all bits exept parametersReceived on exit. */
                           &ulNotifiedValue, /* Stores the notified value. */
                           0xFFFFFFFF );
            if( xResult == pdPASS )
            {
               if( ( ulNotifiedValue & SD_INSERTED ) != 0 )
                {
#ifdef MISSION_MAURICE
                   appData.currentFileNumber=FindStatFileAndGetCurrentNum();
                   appData.currentFileNumber+=2;
                   appData.timeForFileName.year=appData.currentFileNumber;
                   appData.state=APP_STATE_READY;
                   xTaskNotify( xTaskAppHandle, AUTOMATED_START, eSetBits );
#else
                   appData.state=APP_STATE_READY;
#endif
                   appData.status=APP_STATUS_READY_TO_START;
                }
               
                if( ( ulNotifiedValue & HDD_INSERTED ) != 0 )
                {
#ifdef MISSION_MAURICE
                   appData.currentFileNumber=FindStatFileAndGetCurrentNum();
                   appData.currentFileNumber+=2;
                   appData.timeForFileName.year=appData.currentFileNumber;
                   appData.state=APP_STATE_READY;
                   xTaskNotify( xTaskAppHandle, AUTOMATED_START, eSetBits );
#else
                   appData.state=APP_STATE_READY;
#endif
                   appData.status=APP_STATUS_READY_TO_START;
                }
               
               if( ( ulNotifiedValue & APP_SWITCHROLE_DEVICE_EVENT ) != 0 )
                {
                   appData.state=APP_STATE_READY;
                   appData.status=APP_STATUS_READY_TO_START;
                }
               
            }
            break;
        }
        
      
        case APP_STATE_READY:
        {
            uint32_t ulNotifiedValue=0;
            BaseType_t xResult;
            //const TickType_t xTicksToWait = 1 / portTICK_PERIOD_MS;
            
            /* Wait to be notified of an interrupt. */
            xResult = xTaskNotifyWait( pdFALSE,    /* Don't clear bits on entry. */
                           0xFFFFFFFF,        /* Clear all bits on exit. */
                           &ulNotifiedValue, /* Stores the notified value. */
                           0xFFFFFFFF );
            if( xResult == pdPASS )
            {
                // <editor-fold defaultstate="collapsed" desc="PREPARE_FILE Event">
                //On prepare le fichier (ouverture + ecriture du header)
                if( ( ulNotifiedValue & PREPARE_FILE ) != 0 )
                {
                    if(!appData.ads1602IsLogging && (app_sd_tasksData.sdCardPresent || app_usbData.deviceIsConnected|| app_usbData.isConfigured) && app_sd_tasksData.fileHandle==SYS_FS_HANDLE_INVALID)
                    {
                        #ifdef USE_SYSTEM_TRACE
                            USTV_SystemTraceWriteLine("APP: Prepare File\nAPP: APP_STATE_SEND_READY_SIGNAL");
                        #endif
                        DDRResetBufferPool();             //On reset la pile de buffers
                        USTV_PrepareRecordingOpt(false);    //False: demarrage Automatique, True: Demarrage Manuel

                        ADC_FSMODE_Set();                   //On passe l'ADS en SPI Master
                        //RESET_ADC_Set();                    //On sort le composant de veille    
                        appData.state=APP_STATE_READY;
                        appData.status=APP_STATUS_READY_TO_START;
                    }
                }
                // </editor-fold>
                // <editor-fold defaultstate="collapsed" desc="AUTOMATED_START Event">
                if( ( ulNotifiedValue & AUTOMATED_START ) != 0 )
                {
                    if(!appData.ads1602IsLogging && (app_sd_tasksData.sdCardPresent || app_usbData.deviceIsConnected))
                    {
                        //On prepare et ouvre un fichier pour l'enregistrement des datas
                        USTV_PrepareRecordingOpt(true);     //False: demarrage Automatique, True: Demarrage Manuel
                        
                        USTV_StartRecording();
                        appData.status=APP_STATUS_RECORDING;
                        #ifdef USE_SYSTEM_TRACE
                            USTV_SystemTraceWriteLine("APP: Recording STARTED for Continuous Mode ");
                        #endif
                        LED_ORANGE_Set();
                    }
                    else
                    {
                        USTV_StopRecording();
                        #ifdef USE_SYSTEM_TRACE
                            USTV_SystemTraceWriteLine("APP: Recording STOPPED by SW1");
                        #endif
                        appData.status=APP_STATUS_FLUSHING_DDR_TO_SD;
                        appData.state=APP_STATE_FLUSHING_DDR_TO_SD;
                        LED_ORANGE_Clear();
                    }
                }
                // </editor-fold>
                // <editor-fold defaultstate="collapsed" desc="SW1_PUSHED Event">
                //Si on a eu un appuis sur le bouton 1: on Demarre une acquisition de 60sec(Virtual timer)
                if( ( ulNotifiedValue & SW1_PUSHED ) != 0 )
                {
                    if(!appData.ads1602IsLogging && (app_sd_tasksData.sdCardPresent || app_usbData.deviceIsConnected))
                    {
                        USTV_PrepareRecordingOpt(true);     //False: demarrage Automatique, True: Demarrage Manuel
                        
#ifndef MISSION_MAURICE
                        /* Start the timer.  No block time is specified, and
                        even if one was it would be ignored because the RTOS
                        scheduler has not yet been started. */
//                        if( xTimerReset( timer, 0 ) != pdPASS )
//                        {
//                            /* The timer could not be set into the Active
//                            state. */
//                            //xTimerReset(timer,0);
//                        }
#endif
                        #ifdef USE_SYSTEM_TRACE
                            USTV_SystemTraceWriteLine("APP: Recording STARTED for 60sec by SW1 ");
                        #endif

                        USTV_StartRecording();

                        appData.currentStartOfFileTimeStamp=g_longTimeStamp;
                        appData.status=APP_STATUS_RECORDING;
                        LED_ORANGE_Set();
                    }
                    else
                    {
                        USTV_StopRecording();

                        #ifdef USE_SYSTEM_TRACE
                            USTV_SystemTraceWriteLine("APP: Recording STOPPED by SW1");
                        #endif
                        LED_ORANGE_Clear();
                        LED_ROUGE_Set();
                        //On passe a l'etape vidage du buffer circulaire
                        appData.status=APP_STATUS_FLUSHING_DDR_TO_SD;
                        appData.state=APP_STATE_FLUSHING_DDR_TO_SD;
                        cc2652NoResp=0;
                    }
                }
                // </editor-fold>
        
                
                // <editor-fold defaultstate="collapsed" desc="COM_START_RECORDING Event">
                //Demarrage acquisition depuis un message UART (ou USB)
                if( ( ulNotifiedValue & COM_START_RECORDING ) != 0 )
                {
                    if(!appData.ads1602IsLogging && (app_sd_tasksData.sdCardPresent || app_usbData.deviceIsConnected || app_usbData.isConfigured )/*&& (app_sd_tasksData.fileHandle==SYS_FS_HANDLE_INVALID ) */)
                    {
                        if(appData.isFilePrepared)
                        {
                            USTV_StartRecording();
                        }
                        else
                        {
                            USTV_PrepareRecordingOpt(true);     //False: demarrage Automatique, True: Demarrage Manuel
                            USTV_StartRecording();
                        }
                        
                        appData.status=APP_STATUS_RECORDING;
                        #ifdef USE_SYSTEM_TRACE
                            USTV_SystemTraceWriteLineToBuffer("APP: Recording STARTED by COM");
                        #endif
                        LED_ORANGE_Set();
                    }
                }
                // </editor-fold>
                
                // <editor-fold defaultstate="collapsed" desc="COM_STOP_RECORDING Event">
                //Arret acquisition depuis un message UART (ou USB)
                if( ( ulNotifiedValue & COM_STOP_RECORDING ) != 0 )
                {
                    if(appData.ads1602IsLogging && (app_sd_tasksData.sdCardPresent || app_usbData.deviceIsConnected || app_usbData.isConfigured))
                    {
                        
                        //On arrete l'acquisition, on ferme le/les fichiers
                        USTV_StopRecording();
                        
                        #ifdef USE_SYSTEM_TRACE
                            USTV_SystemTraceWriteLine("APP: Recording STOPPED by COM");
                        #endif
                        #ifdef VERSION_GIAS
                            //On passe a l'etape Analyse du fichier (taski CNN)
                            //appData.state=APP_STATE_SEND_READY_SIGNAL;
                            /* Set bit 8 in the notification value of the task referenced by xTask1Handle. */
                            xTaskNotify( xTaskCNNDetectionHandle, PRE_DETECTION_MANUAL_TRIGGER, eSetBits );
                            appData.status=APP_STATUS_ANALYSING_CNN;
                        #else
                            
                            //On passe a l'etape vidage du buffer circulaire
                            appData.status=APP_STATUS_FLUSHING_DDR_TO_SD;
                            appData.state=APP_STATE_FLUSHING_DDR_TO_SD;
                            LED_ROUGE_Set();
                        #endif
                        LED_ORANGE_Clear();
                    }
                }
                // </editor-fold>
                
                // <editor-fold defaultstate="collapsed" desc="TMR_STOP_RECORDING Event">
                //Arret acquisition depuis le timeout du timer virtuel
                if( ( ulNotifiedValue & TMR_STOP_RECORDING ) != 0 )
                {
                    if(appData.ads1602IsLogging && (app_sd_tasksData.sdCardPresent || app_usbData.deviceIsConnected))
                    {
                        //On arrete l'acquisition, on ferme le/les fichiers
                        USTV_StopRecording();
                        
                        #ifdef USE_SYSTEM_TRACE
                            USTV_SystemTraceWriteLine("APP: Recording STOPPED by TMR");
                        #endif
                        //On passe a l'etape vidage du buffer circulaire
                        appData.status=APP_STATUS_FLUSHING_DDR_TO_SD;
                        appData.state=APP_STATE_FLUSHING_DDR_TO_SD;
                        LED_ORANGE_Clear();
                        if(appData.preDetectionOccured)
                        {
                            appData.preDetectionOccured=false;
                            //On notifie a la tache CNN que l'enregistrement est termin.
                            //La tache peut donc analyser le fichier
                            if(appData.preDetectionType==0)
                            {
                                /* Set bit 11 in the notification value of the task referenced by xTask1Handle. */
                                xTaskNotify( xTaskCNNDetectionHandle, PRE_DETECTION_CACHALOT, eSetBits );
                            }
                            else
                            {
                                /* Set bit 11 in the notification value of the task referenced by xTask1Handle. */
                                xTaskNotify( xTaskCNNDetectionHandle, PRE_DETECTION_RORQUAL, eSetBits );
                            }
                        }
                    }
                }
                // </editor-fold>
                
                // <editor-fold defaultstate="collapsed" desc="PRE_DETECTION_CACHALOT Event">
                //Si on a eu un message du CC2652 indiquant qu'une detection a eu lieu
                if( ( ulNotifiedValue & PRE_DETECTION_CACHALOT ) != 0 )
                {
                    if(!appData.ads1602IsLogging && (app_sd_tasksData.sdCardPresent || app_usbData.deviceIsConnected))
                    {
                        //On set les parametres specifiques au cachalot
                        appData.recordParameters.samplingFrequency=64000;
                        appData.preDetectionOccured=true;
                        appData.preDetectionType=0;     //Cachalot
                        
                        //On prepare et ouvre un fichier pour l'enregistrement des datas
                        USTV_PrepareRecordingOpt(true);     //False: demarrage Automatique, True: Demarrage Manuel
                        
                        //On effectue un enregistrement sur 5 secondes
                        xTimerChangePeriod( timer, 5000 / portTICK_PERIOD_MS, 0 );
                        /* Start the timer.  No block time is specified, and
                        even if one was it would be ignored because the RTOS
                        scheduler has not yet been started. */
                        if( xTimerReset( timer, 0 ) != pdPASS )
                        {
                            /* The timer could not be set into the Active
                            state. */
                            //xTimerReset(timer,0);
                        }
                        USTV_StartRecording();
                        appData.status=APP_STATUS_RECORDING;
                        #ifdef USE_SYSTEM_TRACE
                            USTV_SystemTraceWriteLine("APP: Recording STARTED for 5sec by PRE DETECTION CACHALOT ");
                        #endif
                        LED_ORANGE_Set();
                    }
                }
                // </editor-fold>
                
                // <editor-fold defaultstate="collapsed" desc="COM_ANALYSE_CNN Event">
                //Si on a eu un message depuis le CC pour nous demander d'effectuer une analyse CNN
                if( ( ulNotifiedValue & COM_ANALYSE_CNN ) != 0 )
                {
                    if(appData.isFileReadyForCNN)
                    {
                        //On notifie a la tache CNN de faire une analyse sur le dernier fichier enregistrer
                        xTaskNotify( xTaskCNNDetectionHandle, COM_ANALYSE_CNN, eSetBits );


                        #ifdef USE_SYSTEM_TRACE
                                USTV_SystemTraceWriteLine("APP: COM_ANALYSE_CNN Event");
                        #endif
                        //On envois un signal Ready (qui implique que le CC peut passer le systeme en veille)
                        appData.state=APP_STATE_WAITING_CNN;
                        appData.status=APP_STATUS_ANALYSING_CNN;
                    }
                }
                // </editor-fold>
                
                // <editor-fold defaultstate="collapsed" desc="COM_SEND_DATA_TO_GSM Event">
                //Si on a eu un message depuis le CC pour nous demander d'effectuer une analyse CNN
                if( ( ulNotifiedValue & COM_SEND_DATA_TO_GSM ) != 0 )
                {
                        #ifdef USE_SYSTEM_TRACE
                                USTV_SystemTraceWriteLine("APP: COM_SEND_DATA_TO_GSM Event");
                        #endif
                    //On notifie a la tache CNN que l'on soughaite envoyer des datas vers le GSM
                    xTaskNotify( xTaskCNNDetectionHandle, CNN_SEND_DATA_TO_GSM, eSetBits );
                    
                    //On change l'etats du status, et passe dans un etat d'attente de fin de transmission des datas
                    appData.state=APP_STATE_SEND_DATA_TO_GSM;
                    appData.status=APP_STATUS_SEND_DATA_TO_GSM;
                }
                // </editor-fold>
                
                // <editor-fold defaultstate="collapsed" desc="SD_OR_HDD_REMOVED Event">
                if( ( ulNotifiedValue & SD_OR_HDD_REMOVED ) != 0 )
                {
                    if(appData.ads1602IsLogging)
                    {
                        //On arrete l'acquisition, on ferme le/les fichiers
                        USTV_StopRecording();
                        
                        #ifdef USE_SYSTEM_TRACE
                            USTV_SystemTraceWriteLine("APP: Recording STOPPED by HDD/SD REMOVED");
                            char buff[128]={0};
                            sprintf(buff,"Packet received: %d",appData.stats.spiPacketReceived);
                            USTV_SystemTraceWriteLine(buff);
                            sprintf(buff,"Packet written: %d",appData.stats.packetSuccessfullyWrittenToFS);
                            USTV_SystemTraceWriteLine(buff);
                            sprintf(buff,"Packet Lost: %d",appData.stats.spiPacketReceived-appData.stats.packetSuccessfullyWrittenToFS);
                            USTV_SystemTraceWriteLine(buff);
                        #endif


                        #ifdef USE_SYSTEM_TRACE
                            USTV_SystemTraceWriteLine("APP: Recording STOPPED - FS Removed ");
                        #endif
                        LED_ORANGE_Clear();
                        LED_VERTE_Clear();
                    }
                        appData.status=APP_STATUS_WAITING_FOR_STORAGE;
                        appData.state= APP_STATE_WAIT_FOR_STORAGE;
                }
                // </editor-fold>
            }
        }
            break;
        
        case APP_STATE_FLUSHING_DDR_TO_SD:
        {
            uint32_t ulNotifiedValue=0;
            BaseType_t xResult;
            //const TickType_t xTicksToWait = 1 / portTICK_PERIOD_MS;
            
            /* Wait to be notified of an interrupt. */
            xResult = xTaskNotifyWait( pdFALSE,    /* Don't clear bits on entry. */
                           0xFFFFFFFF,        /* Clear all bits on exit. */
                           &ulNotifiedValue, /* Stores the notified value. */
                           0xFFFFFFFF );
            if( xResult == pdPASS )
            {
                // <editor-fold defaultstate="collapsed" desc="DDR_FLUSHED Event">
                //Si on a eu un appuis sur le bouton 1: on Demarre une acquisition de 60sec(Virtual timer)
                if( ( ulNotifiedValue & DDR_FLUSHED ) != 0 )
                {
                        LED_ROUGE_Clear();
                        DDRResetBufferPool();             //On reset la pile de buffers
                        #ifdef USE_SYSTEM_TRACE
                            USTV_SystemTraceWriteLine("APP: DDR_FLUSHED");
                            char buff[128]={0};
                            sprintf(buff,"Packet received: %d",appData.stats.spiPacketReceived);
                            USTV_SystemTraceWriteLine(buff);
                            sprintf(buff,"Packet written: %d",appData.stats.packetSuccessfullyWrittenToFS);
                            USTV_SystemTraceWriteLine(buff);
                            sprintf(buff,"Packet Lost: %d",appData.stats.spiPacketReceived-appData.stats.packetSuccessfullyWrittenToFS);
                            USTV_SystemTraceWriteLine(buff);
                            sprintf(buff,"FS Write Error: %d",appData.stats.totalUSBWriteError);
                            USTV_SystemTraceWriteLine(buff);
                        #endif
                        if(app_sd_tasksData.sdCardPresent || app_usbData.deviceIsConnected)
                        {
                            LED_VERTE_Set();
                        }
                        
                        #ifdef USE_CNN_AUTO
                            xTaskNotify( xTaskCNNDetectionHandle, COM_ANALYSE_CNN, eSetBits );
                            appData.state=APP_STATE_WAITING_CNN;
                            appData.status=APP_STATUS_ANALYSING_CNN;
                        #else
                            appData.state=APP_STATE_READY;
                            appData.status=APP_STATUS_READY_TO_START;
                        #endif

                    }
                }
                // </editor-fold>
                
                // <editor-fold defaultstate="collapsed" desc="SD_OR_HDD_REMOVED Event">
                if( ( ulNotifiedValue & SD_OR_HDD_REMOVED ) != 0 )
                {
                    if(appData.ads1602IsLogging)
                    {
                        //On arrete l'acquisition, on ferme le/les fichiers
                        USTV_StopRecording();
                        
                        #ifdef USE_SYSTEM_TRACE
                            USTV_SystemTraceWriteLine("APP: Recording STOPPED by HDD/SD REMOVED");
                            char buff[128]={0};
                            sprintf(buff,"Packet received: %d",appData.stats.spiPacketReceived);
                            USTV_SystemTraceWriteLine(buff);
                            sprintf(buff,"Packet written: %d",appData.stats.packetSuccessfullyWrittenToFS);
                            USTV_SystemTraceWriteLine(buff);
                            sprintf(buff,"Packet Lost: %d",appData.stats.spiPacketReceived-appData.stats.packetSuccessfullyWrittenToFS);
                            USTV_SystemTraceWriteLine(buff);
                        #endif

                        appData.status=APP_STATUS_WAITING_FOR_STORAGE;
                        #ifdef USE_SYSTEM_TRACE
                            USTV_SystemTraceWriteLine("APP: Recording STOPPED - FS Removed ");
                        #endif
                        LED_ORANGE_Clear();
                        LED_VERTE_Clear();
                    }
                }
                // </editor-fold>
            break;            
        }
        case APP_STATE_WAITING_CNN:
        {
            uint32_t ulNotifiedValue=0;
            BaseType_t xResult;
            //const TickType_t xTicksToWait = 1 / portTICK_PERIOD_MS;
            
            /* Wait to be notified of an interrupt. */
            xResult = xTaskNotifyWait( pdFALSE,    /* Don't clear bits on entry. */
                           0xFFFFFFFF,        /* Clear all bits on exit. */
                           &ulNotifiedValue, /* Stores the notified value. */
                           0xFFFFFFFF );
            if( xResult == pdPASS )
            {
                // <editor-fold defaultstate="collapsed" desc="CNN_DONE Event">
                //Si on a eu un appuis sur le bouton 1: on Demarre une acquisition de 60sec(Virtual timer)
                if( ( ulNotifiedValue & CNN_ANALYSE_DONE ) != 0 )
                {
                    appData.isFileReadyForCNN=false;
                    #ifdef USE_SYSTEM_TRACE
                        USTV_SystemTraceWriteLine("APP: CNN_ANALYSE_DONE Event");
                    #endif
                    //On repasse en state ready
                    appData.state=APP_STATE_READY;
                    appData.status=APP_STATUS_READY_TO_START;
                }
                // </editor-fold>
            }
                
            break;            
        }
        case APP_STATE_SEND_DATA_TO_GSM:
        {
            uint32_t ulNotifiedValue=0;
            BaseType_t xResult;
            //const TickType_t xTicksToWait = 1 / portTICK_PERIOD_MS;
            
            /* Wait to be notified of an interrupt. */
            xResult = xTaskNotifyWait( pdFALSE,    /* Don't clear bits on entry. */
                           0xFFFFFFFF,        /* Clear all bits on exit. */
                           &ulNotifiedValue, /* Stores the notified value. */
                           0xFFFFFFFF );
            if( xResult == pdPASS )
            {
                // <editor-fold defaultstate="collapsed" desc="CNN_GSM_DATA_SENT Event">
                if( ( ulNotifiedValue & CNN_GSM_DATA_SENT ) != 0 )
                {
                    //On repasse en state ready
                    appData.state=APP_STATE_READY;
                    appData.status=APP_STATUS_READY_TO_START;
                }
                // </editor-fold>
            }
                
            break;            
        }

        /* The default state should never be executed. */
        default:
        {
            /* TODO: Handle error in application's state machine. */
            break;
        }
    }
}


/*******************************************************************************
 End of File
 */
