/*******************************************************************************
  MPLAB Harmony Application Header File

  Company:
    Microchip Technology Inc.

  File Name:
    app.h

  Summary:
    This header file provides prototypes and definitions for the application.

  Description:
    This header file provides function prototypes and data type definitions for
    the application.  Some of these are required by the system (such as the
    "APP_Initialize" and "APP_Tasks" prototypes) and some of them are only used
    internally by the application (such as the "APP_STATES" definition).  Both
    are defined here for convenience.
*******************************************************************************/

#ifndef _APP_H
#define _APP_H

// *****************************************************************************
// *****************************************************************************
// Section: Included Files
// *****************************************************************************
// *****************************************************************************

#include <stdint.h>
#include <stdbool.h>
#include <stddef.h>
#include <stdlib.h>
#include "configuration.h"
#include "HighBlue_Configuration.h"
#include "HighBlue_Header.h"
// DOM-IGNORE-BEGIN
#ifdef __cplusplus  // Provide C++ Compatibility

extern "C" {

#endif
    
        /* Fulfill USB DMA transfer criteria */
#define APP_MAKE_BUFFER_DMA_READY  __attribute__((coherent)) __attribute__((aligned(32)))
// DOM-IGNORE-END


#define KVA_2_PA(v) ((v) & 0x1fffffff)

//Event en provenance de la tache communication
// (1<<0) utilis par SW1    
#define COM_START_RECORDING (1u<<1)
#define COM_STOP_RECORDING (1u<<2)
#define SD_INSERTED (1u<<3)
#define HDD_INSERTED (1u<<4)
#define ONE_SECONDE_ELAPSED (1u<<5)
#define ACK_RECEIVED (1u<<6)
#define PREPARE_FILE (1u<<7)
#define TMR_STOP_RECORDING (1u<<8)
//#define RTCC_RECEIVED (1u<<9)
#define PRE_DETECTION_RORQUAL (1u<<10)
#define PRE_DETECTION_CACHALOT (1u<<11)
#define CNN_ANALYSE_DONE (1u<<12)
#define AUTOMATED_START (1u<<13)
#define SD_OR_HDD_REMOVED (1u<<14)
#define DDR_FLUSHED (1u<<15)
#define APP_SWITCHROLE_DEVICE_EVENT (1u<<16)
#define COM_ANALYSE_CNN (1u<<17)
#define COM_SEND_DATA_TO_GSM (1u<<18)
#define CNN_GSM_DATA_SENT (1u<<19)

//Event en provenance de la tache APP    
#define DMA0_INTERRUPT (1<<0)
#define DMA1_INTERRUPT (1<<1)
    
// *****************************************************************************
// *****************************************************************************
// Section: Type Definitions
// *****************************************************************************
// *****************************************************************************

// *****************************************************************************
/* Application states

  Summary:
    Application states enumeration

  Description:
    This enumeration defines the valid application states.  These states
    determine the behavior of the application at various times.
*/

typedef enum
{
    /* Application's state machine's initial state. */
    APP_STATE_INIT=0,
    APP_STATE_SERVICE_TASKS,
    APP_STATE_WAIT_FOR_STORAGE=1,
    APP_STATE_ASK_FOR_RTCC_FROM_CC2652,
    APP_STATE_WAIT_FOR_RTCC_FROM_CC2652,
    APP_STATE_SEND_READY_SIGNAL,
    APP_STATE_WAIT_FOR_ACK,
    APP_STATE_SEND_READY,
    APP_STATE_READY,
    APP_STATE_FLUSHING_DDR_TO_SD,
    APP_STATE_WAITING_CNN,
    APP_STATE_SEND_DATA_TO_GSM
} APP_STATES;

typedef enum
{
    SHUTDOWN=0,
    PREPARE_RECORDING=1,
    RECORDING=2,
    STOPPING=3,
    ANALYSE_CNN=4,
    SEND_DATA_TO_GSM=5
} CC2652_STATE;

typedef enum
{
    REC_SD_HDD=0,
    REC_USB_HOST=1,
    REC_USB_DEV=2,
    REC_BOTH_SD_HOST
} RECORD_MODE;

typedef struct{
    uint8_t hour;
    uint8_t min;
    uint8_t sec;
    uint8_t year;
    uint8_t month;
    uint8_t weekDay;
    uint8_t day;
}CURRENT_TIME;

typedef struct{
    uint8_t dataSaveOption;
    uint8_t nbChannelsUsed;
    uint32_t samplingFrequency;
    uint8_t resolution;
    uint8_t filterSelection;
    RECORD_MODE saveMode;
    

    uint32_t recording_Time;                        
    uint32_t recording_Interval;
    bool recordUseTimeInterval;
    
    //Parametres a transmettre au supervisor
    bool useAutoStart;
   
    bool disableLedDuringAcq;                       //Permet de desactiver ou non les leds pendant l'acquisition
    bool logError;
    bool useSDCard;
   
    uint32_t fileSizeLimitation;                    //Limite en taille des fichiers .log
}ADC_CONFIG;

typedef struct{
    uint32_t filesCreated;                                      //Nombre de fichiers ecris
    uint32_t spiPacketReceived;                                 //Nombre de packet recus provenants des ADS
    uint32_t packetSuccessfullyWrittenToFS;                     //Nombre de packets reelements ecris dans le fichier courant
    uint32_t totalPacketSuccessfullyWrittenToFS;                //Nombre de packets reelements ecris sur le systeme de fichiers
    uint32_t SupervisorInvalidMessageReceived;                  //Nombre de messages invalidesrecus du superviseur
    
    //USB Device stats
    uint32_t totalUSBPacketSent;                                //Nombre de paquets USB emis
    uint32_t totalUSBWriteComplete;                             //Nombre de paquets reelement emis
    uint32_t totalUSBWriteError;                                //Nombre de paquet qui n'ont pas reussi a etre ecris
    uint32_t USBDeviceWriteError;
    
    uint16_t uartError;
    
}DEBUG_STATISTIQUES;


typedef enum
{
    APP_STATUS_INIT=0,
    APP_STATUS_WAITING_FOR_STORAGE=1,
    APP_STATUS_READY_TO_START=2,
    APP_STATUS_RECORDING=3,
    APP_STATUS_FLUSHING_DDR_TO_SD=4,
    APP_STATUS_ANALYSING_CNN=5,
    APP_STATUS_READY_TO_STOP=6,
    APP_STATUS_SEND_DATA_TO_GSM=7,
    APP_ERROR=0xEE
} APP_STATUS;


// *****************************************************************************
/* Application Data

  Summary:
    Holds application data

  Description:
    This structure holds the application's data.

  Remarks:
    Application strings and buffers are be defined outside this structure.
 */

typedef struct
{
    /* The application's current state */
    APP_STATES state;

    bool preDetectionOccured;                          //On a eu une predetection
    unsigned char preDetectionType;                 //Cachalot ou Rorqual
    bool ads1602IsLogging;                          //ads en cour d'acq
    ADC_CONFIG recordParameters;
    DEBUG_STATISTIQUES stats;
    CURRENT_TIME localTime;
    CURRENT_TIME timeForFileName;               //Date a laquelle le CC2652 demarrera l'acquisition
    APP_STATUS status;
    unsigned char numberOfExternalPeripheral;
    PERIPHERAL_CONFIGURATION peripheralConfig[MAX_PERIPHERAL];
    unsigned char UUID64[8];
    unsigned long currentStartOfFileTimeStamp;
    
    char* currentFileName;
    
    unsigned int currentFileNumber;
    CC2652_STATE supervisorStatus;
    bool isFilePrepared;
    bool isFileReadyForCNN;
    
} APP_DATA;




// *****************************************************************************
// *****************************************************************************
// Section: Application Callback Routines
// *****************************************************************************
// *****************************************************************************
/* These routines are called by drivers when certain events occur.
*/

// *****************************************************************************
// *****************************************************************************
// Section: Application Initialization and State Machine Functions
// *****************************************************************************
// *****************************************************************************

/*******************************************************************************
  Function:
    void APP_Initialize ( void )

  Summary:
     MPLAB Harmony application initialization routine.

  Description:
    This function initializes the Harmony application.  It places the
    application in its initial state and prepares it to run so that its
    APP_Tasks function can be called.

  Precondition:
    All other system initialization routines should be called before calling
    this routine (in "SYS_Initialize").

  Parameters:
    None.

  Returns:
    None.

  Example:
    <code>
    APP_Initialize();
    </code>

  Remarks:
    This routine must be called from the SYS_Initialize function.
*/

void APP_Initialize ( void );


/*******************************************************************************
  Function:
    void APP_Tasks ( void )

  Summary:
    MPLAB Harmony Demo application tasks function

  Description:
    This routine is the Harmony Demo application's tasks function.  It
    defines the application's state machine and core logic.

  Precondition:
    The system and application initialization ("SYS_Initialize") should be
    called before calling this.

  Parameters:
    None.

  Returns:
    None.

  Example:
    <code>
    APP_Tasks();
    </code>

  Remarks:
    This routine must be called from SYS_Tasks() routine.
 */
void USTV_DMA_TryToWriteToDDR();
void APP_Tasks( void );

void USTV_AddSecondToLocalTime(void);
unsigned char USTV_ConfigureADS127L01( unsigned int samplingFreq, unsigned char filterSelection);
void USTV_PrepareRecordingOpt(bool manualStart);
void USTV_StopRecording(void);
void USTV_StartRecording(void);

void USTV_DMAC_CHANNEL0_CallBack();
void USTV_DMAC_CHANNEL1_CallBack();
void USTV_DMAC_CHANNEL2_CallBack();
void USTV_DMAC_CHANNEL3_CallBack();
void USTV_DMAC_CHANNEL4_CallBack();
void USTV_DMAC_CHANNEL5_CallBack();
void USTV_DMAC_CHANNEL6_CallBack();


#endif /* _APP_H */

//DOM-IGNORE-BEGIN
#ifdef __cplusplus
}
#endif
//DOM-IGNORE-END

/*******************************************************************************
 End of File
 */

