/*******************************************************************************
  MPLAB Harmony Application Source File

  Company:
    Microchip Technology Inc.

  File Name:
    app_cnn_detection.c

  Summary:
    This file contains the source code for the MPLAB Harmony application.

  Description:
    This file contains the source code for the MPLAB Harmony application.  It
    implements the logic of the application's state machine and it may call
    API routines of other MPLAB Harmony modules in the system, such as drivers,
    system services, and middleware.  However, it does not call any of the
    system interfaces (such as the "Initialize" and "Tasks" functions) of any of
    the modules in the system or make any assumptions about when those functions
    are called.  That is the responsibility of the configuration-specific system
    files.
 *******************************************************************************/

// *****************************************************************************
// *****************************************************************************
// Section: Included Files
// *****************************************************************************
// *****************************************************************************

#include "app_cnn_detection.h"
#include "FreeRTOS.h"
#include "event_groups.h"
#include "system/fs/sys_fs_media_manager.h"
#include "app.h"
#include "USTV_DMA.h"
#include "Define.h"
#include "HighBlue_Header.h"
#include "app_sd_tasks.h"
#include "peripheral/gpio/plib_gpio.h"
#include <string.h>
#include "USTV_SystemTrace.h"
#include "UTLN_Communication.h"
#include <stdio.h>
#include <string.h>
#include "config/default/peripheral/dmac/plib_dmac.h"
#include "crc32.h"
#include "FFT.h"
#include "cnn.h"
#include <math.h>
// *****************************************************************************
// *****************************************************************************
// Section: Global Data Definitions
// *****************************************************************************
// *****************************************************************************

// *****************************************************************************

short SPECIE;

APP_CNN_DETECTION_DATA app_cnn_detectionData;
TaskHandle_t xTaskCNNDetectionHandle=NULL;
//extern APP_MAKE_BUFFER_DMA_READY unsigned char drvAdcBufferA[PACKET_BUFFER_SIZE];
//extern APP_MAKE_BUFFER_DMA_READY unsigned char drvAdcBufferB[PACKET_BUFFER_SIZE];

extern APP_DATA appData;
extern TaskHandle_t xTaskAppHandle;
RAPPORT* rapport;
TRAME_TOA ToA_buffer[NTOAS_MAX];

// *****************************************************************************
// *****************************************************************************
// Section: Application Initialization and State Machine Functions
// *****************************************************************************
// *****************************************************************************

/*******************************************************************************
  Function:
    void APP_CNN_DETECTION_Initialize ( void )

  Remarks:
    See prototype in app_cnn_detection.h.
 */

void APP_CNN_DETECTION_Initialize ( void )
{
    /* Place the App state machine in its initial state. */
    app_cnn_detectionData.state = APP_CNN_DETECTION_STATE_INIT;
    rapport = (RAPPORT*) DDR_START_UNCACHED;
    app_cnn_detectionData.startaddr = (void*) (rapport + 1); // on met startaddr sur la DDR, apr?s le rapport
}


/******************************************************************************
  Function:
    void APP_CNN_DETECTION_Tasks ( void )

  Remarks:
    See prototype in app_cnn_detection.h.
 */
char debug[68];
unsigned char payload[4+64]={0};
unsigned char mutexdemerde=0;
void APP_CNN_DETECTION_Tasks ( void )
{
    /* Check the application's current state. */
    switch ( app_cnn_detectionData.state )
    {
        /* Application's initial state. */
        case APP_CNN_DETECTION_STATE_INIT:
        {
            APP_CNN_DETECTION_Initialize();
            bool appInitialized = true;

            xTaskCNNDetectionHandle=xTaskGetCurrentTaskHandle();                //On recupere le handle de la tache courante
            
            if (appInitialized)
            {
                app_cnn_detectionData.state = APP_CNN_DETECTION_STATE_IDLE;
            }
            break;
        }

        case APP_CNN_DETECTION_STATE_RUN_RORQUAL_CNN:
        {   
            app_cnn_detectionData.startaddr = (void*) (rapport + 1); // on met startaddr sur la DDR, apr?s le rapport
            unsigned char loadOK=0;
            unsigned long startProcess=g_longTimeStamp;
            SPECIE=RORQUAL;
            LED_ROUGE_Set();
            #ifdef USE_SYSTEM_TRACE
                USTV_SystemTraceWriteLine("APP_CNN : starting cnn validation for rorqual");
            #endif

            loadOK=frontend(&app_cnn_detectionData, RORQUAL_SAMPLE_RATE, RORQUAL_LENSIG, RORQUAL_WINSIZELOG2, RORQUAL_HOPSIZE, RORQUAL_MINFREQ, RORQUAL_MAXFREQ, RORQUAL_MELFEAT); 
            if(loadOK)
            {
                loadOK=run_CNN(&app_cnn_detectionData, RORQUAL_LENSPEC, RORQUAL_MELFEAT, rapport->predsR);
                if(loadOK)
                {
                    rapport->numDetectionsRorqual = 0;
                    for(int i=0; i<RORQUAL_LENPRED; i++){ // go through predictions looking for a positive
                        if(rapport->predsR[i] > 0)
                        {
                            rapport->numDetectionsRorqual = 1; // this is just to signal a detection, we will count the full number in getSamplesToSend
                            break;
                        }
                    }
                    #ifdef USE_SYSTEM_TRACE
                        char buff[128] = {0};
                        sprintf(buff,"APP_CNN: Done prediction rorqual %d in %ldms\n", rapport->numDetectionsRorqual, g_longTimeStamp-startProcess);
                        USTV_SystemTraceWriteLine(buff);
                    #endif
                    app_cnn_detectionData.state = APP_CNN_DETECTION_STATE_RUN_CACHA_CNN;
                    #ifdef USE_SYSTEM_TRACE
                        USTV_SystemTraceWriteLine("APP_CNN: APP_CNN_DETECTION_STATE_RUN_CACHA_CNN");
                    #endif
                }
                else
                {
                    #ifdef USE_SYSTEM_TRACE
                        USTV_SystemTraceWriteLine("APP_CNN: ERROR in run_CNN RORQUAL");
                    #endif
                    app_cnn_detectionData.state = APP_CNN_DETECTION_STATE_DONE;
                }
            }
            else
            {
                #ifdef USE_SYSTEM_TRACE
                    USTV_SystemTraceWriteLine("APP_CNN: ERROR in Frontend RORQUAL");
                #endif
                app_cnn_detectionData.state = APP_CNN_DETECTION_STATE_DONE;
            }
            LED_ROUGE_Clear();
        }
        break;
        case APP_CNN_DETECTION_STATE_RUN_CACHA_CNN:
        {
            app_cnn_detectionData.startaddr = (void*) (rapport + 1); // on reset startaddr juste apr?s le rapport
            unsigned char loadOK=0;
            unsigned long startProcess=g_longTimeStamp;
            SPECIE=CACHA;
            LED_ORANGE_Set();
            #ifdef USE_SYSTEM_TRACE
                USTV_SystemTraceWriteLine("APP_CNN : starting cnn validation for cachalot");
            #endif

            loadOK = frontend(&app_cnn_detectionData, CACHA_SAMPLE_RATE, CACHA_LENSIG, CACHA_WINSIZELOG2, CACHA_HOPSIZE, CACHA_MINFREQ, CACHA_MAXFREQ, CACHA_MELFEAT); 
            if(loadOK)
            {
                loadOK=run_CNN(&app_cnn_detectionData, CACHA_LENSPEC, CACHA_MELFEAT, rapport->predsC);
                if(loadOK)
                {
                    rapport->numDetectionsCachalot = 0;
                    for(int i=0; i<CACHA_LENPRED; i++){ // go through predictions looking for a positive
                        if(rapport->predsC[i] > 0)
                        {
                            rapport->numDetectionsCachalot = 1; // this is just to signal a detection, we will count the full number in getSamplesToSend
                            break;
                        }
                    }
                    #ifdef USE_SYSTEM_TRACE
                        char buff[128] = {0};
                        sprintf(buff,"APP_CNN: Done prediction cacha %d in %ldms\n", rapport->numDetectionsCachalot, g_longTimeStamp-startProcess);
                        USTV_SystemTraceWriteLine(buff);
                    #endif
                    app_cnn_detectionData.state = APP_CNN_DETECTION_STATE_BUILD_REPORT;
                    #ifdef USE_SYSTEM_TRACE
                        USTV_SystemTraceWriteLine("APP_CNN: APP_CNN_DETECTION_STATE_BUILD_REPORT");
                    #endif
                }
                else
                {
                    #ifdef USE_SYSTEM_TRACE
                        USTV_SystemTraceWriteLine("APP_CNN: ERROR in run_CNN CACHA");
                    #endif
                    app_cnn_detectionData.state = APP_CNN_DETECTION_STATE_DONE;
                }
            }
            else
            {
                #ifdef USE_SYSTEM_TRACE
                    USTV_SystemTraceWriteLine("APP_CNN: ERROR in Frontend CACHA");
                #endif
                app_cnn_detectionData.state = APP_CNN_DETECTION_STATE_DONE;
            }
            LED_ORANGE_Clear();
        }
        break;
        case APP_CNN_DETECTION_STATE_BUILD_REPORT:
        {   
            #ifdef USE_SYSTEM_TRACE
                USTV_SystemTraceWriteLine("APP_CNN: start building report");
            #endif
            LED_ORANGE_Set();
            LED_ROUGE_Set();
            //On enregistre le rapport uniquement si il y a eu une detection positive
            bool detection= (rapport->numDetectionsCachalot > 0 || rapport->numDetectionsRorqual > 0);
            if(detection)
            {
                //preds are already in rapport
                int i=0;
                for(i=0; i<NTOAS_MAX; i++){
                    rapport->ToAs_cacha[i] = ToA_buffer[i].timestamp;
                    rapport->hydros_ToAs_cacha[i] = ToA_buffer[i].hydroid;
                }
                getSamplesToSend(rapport);
                strcpy(rapport->fileName, appData.currentFileName);

                //On ecris le rapport sur la carte SD
                char rapportFileName[64] = {0};
                snprintf(rapportFileName, 64, "Rapport_%s.info", appData.currentFileName);
                SYS_FS_HANDLE rapportFile = SYS_FS_FileOpen(USTV_GetFilePath(rapportFileName), (SYS_FS_FILE_OPEN_APPEND_PLUS));
                if(rapportFile == SYS_FS_HANDLE_INVALID){
                    #ifdef USE_SYSTEM_TRACE
                        USTV_SystemTraceWriteLine("APP_CNN: Could not open rapport file");
                    #endif
                }else{
                    if (SYS_FS_FileWrite( rapportFile,  rapport, sizeof(RAPPORT)) == -1){
                        //Write was not successful. Close the file
                        SYS_FS_FileClose(rapportFile);
                        #ifdef USE_SYSTEM_TRACE
                            USTV_SystemTraceWriteLine("APP_CNN: writing report   failed");
                        #endif
                    }else{
                        SYS_FS_FileClose(rapportFile);
                    }
                }
            }
            LED_ORANGE_Clear();
            LED_ROUGE_Clear();
            //On notifie au CC2652 si une detection est presente ou non
            unsigned char payload[1]={0};
            payload[0]=detection;
            MakeAndSendMessageWithUTLNProtocol(SEND_CNN_ANALYSE_RESULT, 1,payload );
             
            app_cnn_detectionData.state = APP_CNN_DETECTION_STATE_DONE;
            #ifdef USE_SYSTEM_TRACE
                USTV_SystemTraceWriteLine("APP_CNN: APP_CNN_DETECTION_STATE_DONE");
            #endif
        }           
        break;
        
        
        case APP_CNN_DETECTION_OPEN_FILE_IN_GSM:
        {
            //On prepare la trame d'ouverture du fichier
            //unsigned char payload[4+64]={0};
            uint32_t fileLength=sizeof(RAPPORT);
            payload[0]=BREAK_UINT32(fileLength,3);
            payload[1]=BREAK_UINT32(fileLength,2);
            payload[2]=BREAK_UINT32(fileLength,1);
            payload[3]=BREAK_UINT32(fileLength,0);
            static char rapportFileName[64]={0};
            //char* index=strrchr(appData.currentFileName,'/');
            snprintf(rapportFileName, 64, "Rapport_%s.info", appData.currentFileName);
            
            int i;
            for(i=0;i<strlen(rapportFileName) && i<64;i++)
            {
                payload[4+i]=rapportFileName[i];
            }
            MakeAndSendMessageWithUTLNProtocol(OPEN_FILE_IN_GSM, 4+i,payload );

            
            uint32_t ulNotifiedValue=0;
            BaseType_t xResult;
            const TickType_t xTicksToWait = 3000 / portTICK_PERIOD_MS;
            
            /* Wait to be notified of an interrupt. */
            xResult = xTaskNotifyWait( pdFALSE,    /* Don't clear bits on entry. */
                           0xFFFFFFFF,        /* Clear all bits on exit. */
                           &ulNotifiedValue, /* Stores the notified value. */
                           xTicksToWait );
            
            if( xResult == pdPASS )
            {
                if( ( ulNotifiedValue & ACK_RECEIVED ) != 0 )
                {
                    app_cnn_detectionData.state=APP_CNN_DETECTION_TRANSFERT_TO_GSM;
                    #ifdef USE_SYSTEM_TRACE
                        USTV_SystemTraceWriteLine("APP_CNN: ACK Received\nAPP_CNN: APP_CNN_DETECTION_TRANSFERT_TO_GSM");
                    #endif
                }
            }
        }
        break;
        case APP_CNN_DETECTION_TRANSFERT_TO_GSM:
        {
            //On doit envoyer un rapport de detection a OSEAN (bloquant))
            SendDataToGSM((uint8_t*)rapport,sizeof(RAPPORT));
            
            app_cnn_detectionData.state = APP_CNN_DETECTION_CLOSE_FILE_IN_GSM;
            //app_cnn_detectionData.state = APP_CNN_DETECTION_STATE_IDLE;
            //On notifie a la tache app que l'analyse et l'envoi du rapport est termin?
            xTaskNotify( xTaskAppHandle, CNN_GSM_DATA_SENT, eSetBits );
            #ifdef USE_SYSTEM_TRACE
                USTV_SystemTraceWriteLine("APP_CNN: TRANSFERT DONE\nAPP_CNN: APP_CNN_DETECTION_STATE_IDLE");
            #endif
        }
        break;
        case APP_CNN_DETECTION_CLOSE_FILE_IN_GSM:
        {
            //On prepare la trame de fermeture du fichier
            unsigned char payload[1]={0};
            payload[0]=1;                   //1: fin de fichier
            MakeAndSendMessageWithUTLNProtocol(CLOSE_FILE_IN_GSM, 1,payload );
            
            uint32_t ulNotifiedValue=0;
            BaseType_t xResult;
            const TickType_t xTicksToWait = 1000 / portTICK_PERIOD_MS;
            
            /* Wait to be notified of an interrupt. */
            xResult = xTaskNotifyWait( pdFALSE,    /* Don't clear bits on entry. */
                           0xFFFFFFFF,        /* Clear all bits on exit. */
                           &ulNotifiedValue, /* Stores the notified value. */
                           xTicksToWait );
            
            if( xResult == pdPASS )
            {
                if( ( ulNotifiedValue & ACK_RECEIVED ) != 0 )
                {
                    app_cnn_detectionData.state=APP_CNN_DETECTION_STATE_IDLE;
                    //On notifie a la tache app que l'analyse et l'envoi du rapport est termin?
                    xTaskNotify( xTaskAppHandle, CNN_GSM_DATA_SENT, eSetBits );
                    #ifdef USE_SYSTEM_TRACE
                        USTV_SystemTraceWriteLine("APP_CNN: ACK Received\nAPP_CNN: APP_CNN_DETECTION_STATE_IDLE");
                    #endif
                }
            }
        }
        break;
        
        case APP_CNN_DETECTION_STATE_DONE:
        {
            //On notifie a la tache app que l'analyse et l'envoi du rapport est termin?
            xTaskNotify( xTaskAppHandle, CNN_ANALYSE_DONE, eSetBits );
            app_cnn_detectionData.state=APP_CNN_DETECTION_STATE_IDLE;
            #ifdef USE_SYSTEM_TRACE
                USTV_SystemTraceWriteLine("APP_CNN: APP_CNN_DETECTION_STATE_IDLE");
            #endif
        }
        break;
        
        case APP_CNN_DETECTION_STATE_IDLE:
        {
            uint32_t ulNotifiedValue=0;
            BaseType_t xResult;
            const TickType_t xTicksToWait = 1000 / portTICK_PERIOD_MS;
            /* Wait to be notified of an interrupt. */
            xResult = xTaskNotifyWait( pdFALSE,    /* Don't clear bits on entry. */
                           0xFFFFFFFF,        /* Clear all bits on exit. */
                           &ulNotifiedValue, /* Stores the notified value. */
                           xTicksToWait );
            if( xResult == pdPASS )
            {
                //Quand on a termin? l'enregistrement, on doit avoir une notification du CC qui nous demande une analyse
                if(ulNotifiedValue & COM_ANALYSE_CNN)
                {
                    if(appData.currentFileName!=0)
                        app_cnn_detectionData.state=APP_CNN_DETECTION_STATE_RUN_RORQUAL_CNN;
                }
                
                //Si on a ene demande d'emission du rapport vers le GSQM
                if(ulNotifiedValue & CNN_SEND_DATA_TO_GSM)
                {
                    app_cnn_detectionData.state=APP_CNN_DETECTION_OPEN_FILE_IN_GSM;
                }
            }
        }
        break;        
        /* The default state should never be executed. */
        default:
        {
            /* TODO: Handle error in application's state machine. */
            break;
        }
    }
}

void SendDataToGSM(uint8_t* ptr, uint32_t length)
{
    uint32_t dataSent=0;
//    uint32_t indexInFile=0;
    uint32_t currentLen=length;
    uint32_t remainingDataToSend=length;
    
    //On commence par effectuer la demande d'ouverture du fichier
    do
    {
        if(remainingDataToSend>256)
        {
            currentLen=256;
        }
        else
        {
            currentLen=remainingDataToSend;
        }
        unsigned char outPayload[currentLen+8+UTLN_FRAME_SIZE];
        outPayload[0]=SOF;
        outPayload[1]=MSB_UINT16(TRANSFER_DATA_BLOC_TO_GSM);
        outPayload[2]=LSB_UINT16(TRANSFER_DATA_BLOC_TO_GSM);
        outPayload[3]=MSB_UINT16(currentLen);
        outPayload[4]=LSB_UINT16(currentLen);   //+8

        //Index dans le fichier
//        outPayload[5]=BREAK_UINT32(indexInFile,3);
//        outPayload[6]=BREAK_UINT32(indexInFile,2);
//        outPayload[7]=BREAK_UINT32(indexInFile,1);
//        outPayload[8]=BREAK_UINT32(indexInFile,0);

        //Datas (max 256)
        int i;
        for(i=0;i<currentLen;i++)
        {
            outPayload[5+i]=ptr[i]; // 9+i
        }
        //On calcule le CRC32 correspondant
//        int32_t crc32=crc_32( ptr, currentLen );
//        outPayload[9+i]=BREAK_UINT32(crc32,3);
//        outPayload[10+i]=BREAK_UINT32(crc32,2);
//        outPayload[11+i]=BREAK_UINT32(crc32,1);
//        outPayload[12+i]=BREAK_UINT32(crc32,0);
        outPayload[5+i]=UartCalculateChecksum(TRANSFER_DATA_BLOC_TO_GSM,i, outPayload+5); //9+i //8+i
        SendMessageToUart1( UTLN_FRAME_SIZE+currentLen, outPayload);    //+8
        dataSent+=currentLen; 
        remainingDataToSend-=currentLen;
        
        uint32_t ulNotifiedValue=0;
        BaseType_t xResult;
        //const TickType_t xTicksToWait = 1000 / portTICK_PERIOD_MS;

        /* Wait to be notified of an interrupt. */
        xResult = xTaskNotifyWait( pdFALSE,    /* Don't clear bits on entry. */
                       0xFFFFFFFF,        /* Clear all bits on exit. */
                       &ulNotifiedValue, /* Stores the notified value. */
                       portMAX_DELAY );

        if( xResult == pdPASS )
        {
            if(ulNotifiedValue & ACK_RECEIVED)
            {
                //On continue
            }
        }
    }while(dataSent<length);
        
    #ifdef USE_SYSTEM_TRACE
        char buff[128] = {0};
        sprintf(buff,"APP_CNN: %d Bytes Sent to GSM", dataSent);
        USTV_SystemTraceWriteLine(buff);
        USTV_SystemTraceWriteLine("APP_CNN: TRANSFERT DONE\nAPP_CNN: APP_CNN_DETECTION_CLOSE_FILE_IN_GSM");
    #endif
}



void getSamplesToSend(RAPPORT* rapport){
    int i, j, chan = 0;
    #ifdef USE_SYSTEM_TRACE
        USTV_SystemTraceWriteLine("APP_CNN: start getSampleToSend");
    #endif
    //Prepare file
    SYS_FS_HANDLE logFile = SYS_FS_FileOpen(appData.currentFileName, (SYS_FS_FILE_OPEN_READ));
    if(logFile == SYS_FS_HANDLE_INVALID){
        #ifdef USE_SYSTEM_TRACE
            USTV_SystemTraceWriteLine("APP_CNN: getSamplesToSend Could not open sound file");
        #endif
        return;
    }
    HighBlueHeader readHdr = USTV_ParseHeaderAndSeekToFirstAudioDataBlock(logFile);
    size_t bytesRead=0;
    unsigned char* buffer = (unsigned char*) app_cnn_detectionData.startaddr;
    int sampleread = 0, positionSample, positionBytes;
    short resBytes = readHdr.resolutionBits/8;
    short uds = readHdr.samplingFrequency / RORQUAL_RAPPORT_SAMPLE_RATE;
    // RORQUAL
    i = 0, rapport->numDetectionsRorqual = 0;
    while(i<RORQUAL_LENPRED-1){
        if(rapport->predsR[i] > 0 && rapport->predsR[i] > rapport->predsR[i+1]){
            rapport->predPeaksR[rapport->numDetectionsRorqual] = i;
            rapport->numDetectionsRorqual ++;
            i += 80; // 5 seconds forward (5 x 16) pred hopsize is 256, so 16*256 ~ 1sec
        }
        i++;
    }
    for(i=0; i<RORQUAL_RAPPORT_NSAMPLESTOSEND; i++){ // /!\ position in seconds depends on models kernel size (15 : 3 layers kernels 5)
        positionSample = fmax((rapport->predPeaksR[i] * RORQUAL_HOPSIZE + (RORQUAL_WINSIZE/2 + RORQUAL_HOPSIZE * 13) / 2) - RORQUAL_SAMPLE_RATE, 0) * readHdr.samplingFrequency / RORQUAL_SAMPLE_RATE;
        positionBytes = USTV_CalculateFilePositionAtNSamples(readHdr, positionSample);
        SYS_FS_FileSeek(logFile, positionBytes, SYS_FS_SEEK_SET);
        USTV_SeekToNextDataBlock(logFile, readHdr.sizeOfAdditionnalDataBuffer);
        sampleread = 0; // number of samples read so far for each channel
        do{ // fait pour du int 16
            bytesRead = USTV_GetRAWAudioDataBlock(logFile, buffer, (uint32_t)readHdr.dmaBlockSize);
            for(chan=0; chan < RAPPORT_CHANNELS; chan++){
                for(j=0; j < bytesRead / (readHdr.numberOfChan * resBytes * uds); j++){
                    memcpy(&rapport->samplesR[i][sampleread + j][chan], buffer + chan * bytesRead / readHdr.numberOfChan + j * uds * resBytes, resBytes);
                }
            }
            sampleread += bytesRead / (readHdr.numberOfChan * resBytes * uds);
            //Si on arrive pas a se deplacer c'est qu'il y a eu une erreur ou que l'on a atteint la fin du fichier
            if(USTV_SeekToNextDataBlock(logFile, readHdr.sizeOfAdditionnalDataBuffer )==-1)
                break;
        }while(bytesRead==readHdr.dmaBlockSize && sampleread < RORQUAL_RAPPORT_SAMPLESPERSAMPLE);
    }
    // CACHA
    i = 0, rapport->numDetectionsCachalot = 0;
    while(i<CACHA_LENPRED-1){
        if(rapport->predsC[i] > 0 && rapport->predsC[i] > rapport->predsR[i+1]){
            rapport->predPeaksC[rapport->numDetectionsCachalot] = i;
            rapport->numDetectionsCachalot ++;
            i += 10; // 0.3 second forward pred hopsize is 8*256samples == 0.032sec
        }
        i++;
    }
    uds = readHdr.samplingFrequency / CACHA_RAPPORT_SAMPLE_RATE;
    for(i=0; i<CACHA_RAPPORT_NSAMPLESTOSEND; i++){ // /!\ position in seconds depends on models kernel size (3 layers kernels 7 stride 2)
        positionSample = fmax((rapport->predPeaksC[i] * CACHA_HOPSIZE * 8 + (CACHA_WINSIZE + CACHA_HOPSIZE * 7*6) / 2) - CACHA_SAMPLE_RATE/20, 0) * readHdr.samplingFrequency / CACHA_SAMPLE_RATE;
        positionBytes = USTV_CalculateFilePositionAtNSamples(readHdr, positionSample);
        SYS_FS_FileSeek(logFile, positionBytes, SYS_FS_SEEK_SET);
        USTV_SeekToNextDataBlock(logFile, readHdr.sizeOfAdditionnalDataBuffer );
        sampleread = 0;
        do{ //fait pour du int 16
            bytesRead = USTV_GetRAWAudioDataBlock(logFile, buffer, (uint32_t)readHdr.dmaBlockSize);
            for(chan=0; chan < RAPPORT_CHANNELS; chan++){
                for(j=0; j < bytesRead / (readHdr.numberOfChan * resBytes * uds); j++){
                    memcpy(&rapport->samplesC[i][sampleread + j][chan], buffer + chan * bytesRead / readHdr.numberOfChan + j * uds * resBytes, resBytes);
                }
            }
            sampleread += bytesRead / (readHdr.numberOfChan * resBytes * uds);
            //Si on arrive pas a se deplacer c'est qu'il y a eu une erreur ou que l'on a atteint la fin du fichier
            if(USTV_SeekToNextDataBlock(logFile, readHdr.sizeOfAdditionnalDataBuffer )==-1)
                break;
        }while(bytesRead==readHdr.dmaBlockSize && sampleread<CACHA_RAPPORT_SAMPLESPERSAMPLE);
    }
    //On ferme le fichier
    SYS_FS_FileClose(logFile);
    #ifdef USE_SYSTEM_TRACE
        USTV_SystemTraceWriteLine("APP_CNN: done getSamplesToSend");
    #endif
    return;
}

/*******************************************************************************
 End of File
 */
