/*******************************************************************************
  MPLAB Harmony Application Header File

  Company:
    Microchip Technology Inc.

  File Name:
    app_cnn_detection.h

  Summary:
    This header file provides prototypes and definitions for the application.

  Description:
    This header file provides function prototypes and data type definitions for
    the application.  Some of these are required by the system (such as the
    "APP_CNN_DETECTION_Initialize" and "APP_CNN_DETECTION_Tasks" prototypes) and some of them are only used
    internally by the application (such as the "APP_CNN_DETECTION_STATES" definition).  Both
    are defined here for convenience.
*******************************************************************************/

#ifndef _APP_CNN_DETECTION_H
#define _APP_CNN_DETECTION_H

#define DDR_START_CACHED           (0x88000000)  //KSEG0 cacheable (0x88000000 to 0x89FFFFFF)
#define DDR_START_UNCACHED  (0xA8000000)  //KSEG0 not-cacheable (0xA8000000 to 0xA9FFFFFF)
// *****************************************************************************
// *****************************************************************************
// Section: Included Files
// *****************************************************************************
// *****************************************************************************

#include <stdint.h>
#include <stdbool.h>
#include <stddef.h>
#include <stdlib.h>
#include "configuration.h"
#include "config/default/system/fs/sys_fs.h"

// DOM-IGNORE-BEGIN
#ifdef __cplusplus  // Provide C++ Compatibility

extern "C" {

#endif
// DOM-IGNORE-END
    
#define PRE_DETECTION_FROM_CC2652 (1<<0)
#define PRE_DETECTION_MANUAL_TRIGGER (1<<2)
#define PRE_DETECTION_TRANSFERT_DATA_NEEDED (1<<3)
#define CNN_SEND_DATA_TO_GSM (1u<<4)
#define ACK_RECEIVED (1u<<6)
// *****************************************************************************
// *****************************************************************************
// Section: Type Definitions
// *****************************************************************************
// *****************************************************************************

// *****************************************************************************
/* Application states

  Summary:
    Application states enumeration

  Description:
    This enumeration defines the valid application states.  These states
    determine the behavior of the application at various times.
*/

typedef enum
{
    /* Application's state machine's initial state. */
    APP_CNN_DETECTION_STATE_INIT=0,
    APP_CNN_DETECTION_STATE_RUN_CACHA_CNN,
    APP_CNN_DETECTION_STATE_RUN_RORQUAL_CNN,
    APP_CNN_DETECTION_STATE_BUILD_REPORT,
    APP_CNN_DETECTION_OPEN_FILE_IN_GSM,    
    APP_CNN_DETECTION_TRANSFERT_TO_GSM,
    APP_CNN_DETECTION_CLOSE_FILE_IN_GSM,
    APP_CNN_DETECTION_STATE_DONE,
    APP_CNN_DETECTION_STATE_IDLE
    /* TODO: Define states used by the application state machine. */
} APP_CNN_DETECTION_STATES;

enum SPECIES { CACHA, RORQUAL };
#define NTOAS_MAX 200

#define RORQUAL_SAMPLE_RATE 4000
#define RORQUAL_LENSIG RORQUAL_SAMPLE_RATE*60 // load 60sec
#define RORQUAL_WINSIZE 4096
#define RORQUAL_LENSPEC (RORQUAL_LENSIG - RORQUAL_WINSIZE)/RORQUAL_HOPSIZE 
#define RORQUAL_HOPSIZE 256
#define RORQUAL_WINSIZELOG2 12
#define RORQUAL_MELFEAT 64
#define RORQUAL_MINFREQ 0
#define RORQUAL_MAXFREQ 100
#define RORQUAL_LENPRED RORQUAL_LENSPEC - (5-1)*3 //3 layers of kernel size 5
#define RORQUAL_RAPPORT_NSAMPLESTOSEND 3 // see cacha
#define RORQUAL_RAPPORT_SAMPLE_RATE 128000
#define RORQUAL_RAPPORT_SAMPLESPERSAMPLE 256000 // see cacha

#define CACHA_SAMPLE_RATE 64000
#define CACHA_LENSIG CACHA_SAMPLE_RATE*10 // load 10sec
#define CACHA_WINSIZE 512
#define CACHA_LENSPEC (CACHA_LENSIG - CACHA_WINSIZE)/CACHA_HOPSIZE
#define CACHA_HOPSIZE 256
#define CACHA_WINSIZELOG2 9
#define CACHA_MELFEAT 64
#define CACHA_MINFREQ 2000
#define CACHA_MAXFREQ 25000
#define CACHA_LENPRED (((CACHA_LENSPEC - 6)/2 - 6)/2 -6)/2 // 3 layers hopsize 2 kernel 7
#define CACHA_RAPPORT_NSAMPLESTOSEND 10 // a sample is positionned at a high pred from the cnn, we extract the audio signal arround to send back via network
#define CACHA_RAPPORT_SAMPLE_RATE 128000
#define CACHA_RAPPORT_SAMPLESPERSAMPLE 12800 // number of audio samples per high pred sample to send back

#define RAPPORT_CHANNELS 5 // number of channels recorded to include in the report

// *****************************************************************************
/* Application Data

  Summary:
    Holds application data

  Description:
    This structure holds the application's data.

  Remarks:
    Application strings and buffers are be defined outside this structure.
 */

typedef struct{
    APP_CNN_DETECTION_STATES state;
    int32_t* sig; // input signal
    float* meldspectro; //spectrogram input for the CNN
    void* startaddr; //used to store the current position of storage on DDR
}APP_CNN_DETECTION_DATA;


typedef struct{
    float predsC[CACHA_LENPRED]; //len of preds for 10sec signal
    short numDetectionsCachalot;
    float predsR[RORQUAL_LENPRED]; //len of preds for 60sec signal
    short numDetectionsRorqual;
    char fileName[50];      //Nom du fichier concerne
    int ToAs_cacha[NTOAS_MAX];
    unsigned char hydros_ToAs_cacha[NTOAS_MAX];
    short predPeaksR[RORQUAL_RAPPORT_NSAMPLESTOSEND]; //indices of predPeaks for rorqual
    short predPeaksC[CACHA_RAPPORT_NSAMPLESTOSEND]; //indices of predPeaks for cachalot
    int16_t samplesR[RORQUAL_RAPPORT_NSAMPLESTOSEND][RORQUAL_RAPPORT_SAMPLESPERSAMPLE][RAPPORT_CHANNELS]; // samples to send back for rorqual
    int16_t samplesC[CACHA_RAPPORT_NSAMPLESTOSEND][CACHA_RAPPORT_SAMPLESPERSAMPLE][RAPPORT_CHANNELS]; // samples to send back for cachalot
}RAPPORT;

typedef struct{
    short hydroid; //enum {cachalot : 0, rorqual 1}
    int timestamp; //?sec timestamp since start of recording
}TRAME_TOA;

// *****************************************************************************
// *****************************************************************************
// Section: Application Callback Routines
// *****************************************************************************
// *****************************************************************************
/* These routines are called by drivers when certain events occur.
*/

// *****************************************************************************
// *****************************************************************************
// Section: Application Initialization and State Machine Functions
// *****************************************************************************
// *****************************************************************************

/*******************************************************************************
  Function:
    void APP_CNN_DETECTION_Initialize ( void )

  Summary:
     MPLAB Harmony application initialization routine.

  Description:
    This function initializes the Harmony application.  It places the
    application in its initial state and prepares it to run so that its
    APP_CNN_DETECTION_Tasks function can be called.

  Precondition:
    All other system initialization routines should be called before calling
    this routine (in "SYS_Initialize").

  Parameters:
    None.

  Returns:
    None.

  Example:
    <code>
    APP_CNN_DETECTION_Initialize();
    </code>

  Remarks:
    This routine must be called from the SYS_Initialize function.
*/

void APP_CNN_DETECTION_Initialize ( void );


/*******************************************************************************
  Function:
    void APP_CNN_DETECTION_Tasks ( void )

  Summary:
    MPLAB Harmony Demo application tasks function

  Description:
    This routine is the Harmony Demo application's tasks function.  It
    defines the application's state machine and core logic.

  Precondition:
    The system and application initialization ("SYS_Initialize") should be
    called before calling this.

  Parameters:
    None.

  Returns:
    None.

  Example:
    <code>
    APP_CNN_DETECTION_Tasks();
    </code>

  Remarks:
    This routine must be called from SYS_Tasks() routine.
 */

void APP_CNN_DETECTION_Tasks( void );


void SendDataToGSM(uint8_t* ptr, uint32_t length);
int struct_to_bytelist(uint8_t* ptr, RAPPORT* data);
void getSamplesToSend(RAPPORT* rapport);

//DOM-IGNORE-BEGIN
#ifdef __cplusplus
}
#endif
//DOM-IGNORE-END

#endif /* _APP_CNN_DETECTION_H */

/*******************************************************************************
 End of File
 */

