/*******************************************************************************
  MPLAB Harmony Application Source File

  Company:
    Microchip Technology Inc.

  File Name:
    app_communication_task.c

  Summary:
    This file contains the source code for the MPLAB Harmony application.

  Description:
    This file contains the source code for the MPLAB Harmony application.  It
    implements the logic of the application's state machine and it may call
    API routines of other MPLAB Harmony modules in the system, such as drivers,
    system services, and middleware.  However, it does not call any of the
    system interfaces (such as the "Initialize" and "Tasks" functions) of any of
    the modules in the system or make any assumptions about when those functions
    are called.  That is the responsibility of the configuration-specific system
    files.
 *******************************************************************************/

// *****************************************************************************
// *****************************************************************************
// Section: Included Files
// *****************************************************************************
// *****************************************************************************

#include "app_communication_task.h"
#include "config/default/driver/usart/drv_usart.h"
#include "peripheral/gpio/plib_gpio.h"
#include "UTLN_Communication.h"
#include "FreeRTOS.h"
#include "event_groups.h"
#include "stream_buffer.h"
#include "HighBlue_Configuration.h"
#include "USTV_SystemTrace.h"
// *****************************************************************************
// *****************************************************************************
// Section: Global Data Definitions
// *****************************************************************************
// *****************************************************************************
//Variable utiles a l'envois d'un futur message
unsigned char nextMsgOutPayload[1024];
unsigned short nextMsgOutPayloadLength;
unsigned short nextMsgCommand;
bool nextMsgAvailable=false;
// *****************************************************************************
/* Application Data

  Summary:
    Holds application data

  Description:
    This structure holds the application's data.

  Remarks:
    This structure should be initialized by the APP_COMMUNICATION_TASK_Initialize function.

    Application strings and buffers are be defined outside this structure.
*/

APP_COMMUNICATION_TASK_DATA app_communication_taskData;
TaskHandle_t xTaskAppCommunicationHandle=NULL;
StreamBufferHandle_t xStreamBufferUart1Rx;
StreamBufferHandle_t xStreamBufferUart1Tx;
unsigned char rxBuff[128];


// *****************************************************************************
// *****************************************************************************
// Section: Application Callback Functions
// *****************************************************************************
// *****************************************************************************
//UART1 is used for transmission
static void APP_USART1BufferEventHandler(
    DRV_USART_BUFFER_EVENT bufferEvent,
    DRV_USART_BUFFER_HANDLE bufferHandle,
    uintptr_t context
)
{
    switch(bufferEvent)
    {
        case DRV_USART_BUFFER_EVENT_COMPLETE:
            if (bufferHandle == app_communication_taskData.writeBufferHandle)
            {
                // This means the USART write request corresponding to 
                // the appData.writeBufferHandle is complete.
            }
            
            if (bufferHandle == app_communication_taskData.readBufferHandle)
            {
                //Schedule a read operation
                DRV_USART_ReadBufferAdd(app_communication_taskData.usart1Handle,rxBuff,1,&app_communication_taskData.readBufferHandle);    
                
                
                // This means the USART read request corresponding to 
                // the appData.readBufferHandle is complete.
                size_t xBytesSent;
                BaseType_t xHigherPriorityTaskWoken = pdFALSE; /* Initialised to pdFALSE. */

                /* Attempt to send the string to the stream buffer. */
                xBytesSent = xStreamBufferSendFromISR( xStreamBufferUart1Rx,
                                                       ( void * ) rxBuff,
                                                       1,
                                                       &xHigherPriorityTaskWoken );

                if( xBytesSent != 1 )
                {
                    /* There was not enough free space in the stream buffer for the entire
                    string to be written, ut xBytesSent bytes were written. */
                }

                    
                            
                //LED_ORANGE_Toggle();
                
                /* If xHigherPriorityTaskWoken was set to pdTRUE inside
                xStreamBufferSendFromISR() then a task that has a priority above the
                priority of the currently executing task was unblocked and a context
                switch should be performed to ensure the ISR returns to the unblocked
                task.  In most FreeRTOS ports this is done by simply passing
                xHigherPriorityTaskWoken into taskYIELD_FROM_ISR(), which will test the
                variables value, and perform the context switch if necessary.  Check the
                documentation for the port in use for port specific instructions. */
                if( xHigherPriorityTaskWoken == pdTRUE )
                {
                     portYIELD();
                }
            }
            break;

        case DRV_USART_BUFFER_EVENT_ERROR:
           // app_communication_taskData.state = APP_STATE_ERROR;
            if (bufferHandle == app_communication_taskData.writeBufferHandle)
            {
                LED_ROUGE_Set();
            }
            
            if (bufferHandle == app_communication_taskData.readBufferHandle)
            {
                volatile static DRV_USART_ERROR error;
                error=DRV_USART_ErrorGet(app_communication_taskData.readBufferHandle);      //Getting the error cause clear the error
                //Schedule a read operation
                DRV_USART_ReadBufferAdd(app_communication_taskData.usart1Handle,rxBuff,1,&app_communication_taskData.readBufferHandle);
                
                #ifdef USE_SYSTEM_TRACE
                    //USTV_SystemTraceWriteLineToBuffer("===ERROR: USART_READ_BUFFER_ERROR");
                    switch(error)
                    {
                        case DRV_USART_ERROR_OVERRUN:
                            //USTV_SystemTraceWriteLineToBuffer("ERROR:-> DRV_USART_ERROR_OVERRUN"); 
                            LED_ROUGE_Toggle();
                            break;
                        case DRV_USART_ERROR_PARITY:
                            USTV_SystemTraceWriteLineToBuffer("ERROR:-> DRV_USART_ERROR_PARITY");
                            LED_ROUGE_Toggle();
                            break;
                        case DRV_USART_ERROR_FRAMING:
                           // USTV_SystemTraceWriteLineToBuffer("ERROR:-> DRV_USART_ERROR_FRAMING"); 
                            LED_ROUGE_Toggle();
                            break;
                        default:
                            break;
                    }
                #endif
            }

            break;

        default:
            break;
    }
}

// *****************************************************************************
// *****************************************************************************
// Section: Application Local Functions
// *****************************************************************************
// *****************************************************************************

void APP_COMMUNICATION_SetNextMessage(unsigned short command, unsigned short payloadLength, unsigned char payload[])
{
    nextMsgCommand=command;
    nextMsgOutPayloadLength=payloadLength;
    memcpy(nextMsgOutPayload,payload,payloadLength);
    nextMsgAvailable=true;
}


// *****************************************************************************
// *****************************************************************************
// Section: Application Initialization and State Machine Functions
// *****************************************************************************
// *****************************************************************************

/*******************************************************************************
  Function:
    void APP_COMMUNICATION_TASK_Initialize ( void )

  Remarks:
    See prototype in app_communication_task.h.
 */

void APP_COMMUNICATION_TASK_Initialize ( void )
{
    /* Place the App state machine in its initial state. */
    app_communication_taskData.state = APP_COMMUNICATION_TASK_STATE_INIT;

    //On creer un Stream Buffer de 1024o qui viendra receptionner les donnes recus sur le port Serie.
    //Il reveillera la tache communication lorsque le seuil de 10o sera atteint, ou q'un timeout sera depass
    xStreamBufferUart1Rx=xStreamBufferCreate( 1024, 1 );
    if( xStreamBufferUart1Rx == NULL )
    {
        /* There was not enough heap memory space available to create the
        stream buffer. */
    }
    else
    {
        /* The stream buffer was created successfully and can now be used. */
    }
    
    //On creer un Stream Buffer de 1024o qui viendra receptionner les donnes recus sur le port Serie.
    //Il reveillera la tache communication lorsque le seuil de 10o sera atteint, ou q'un timeout sera depass
    xStreamBufferUart1Tx=xStreamBufferCreate( 1024, 1 );
    if( xStreamBufferUart1Tx == NULL )
    {
        /* There was not enough heap memory space available to create the
        stream buffer. */
    }
    else
    {
        /* The stream buffer was created successfully and can now be used. */
    }
    
    app_communication_taskData.usart1Handle = DRV_USART_Open(DRV_USART_INDEX_0, DRV_IO_INTENT_READWRITE);
    if(app_communication_taskData.usart1Handle==DRV_HANDLE_INVALID)
    {

    }
    

    /* TODO: Initialize your application's state machine and other
     * parameters.
     */
}


/******************************************************************************
  Function:
    void APP_COMMUNICATION_TASK_Tasks ( void )

  Remarks:
    See prototype in app_communication_task.h.
 */

void APP_COMMUNICATION_TASK_Tasks ( void )
{

    /* Check the application's current state. */
    switch ( app_communication_taskData.state )
    {
        /* Application's initial state. */
        case APP_COMMUNICATION_TASK_STATE_INIT:
        {
            bool appInitialized = true;
            //On recupere l'handle de la tache communication
            xTaskAppCommunicationHandle=xTaskGetCurrentTaskHandle();
            //Open the USARTs drivers
          //  app_communication_taskData.usart1Handle = DRV_USART_Open(DRV_USART_INDEX_0, 0);

           
            // Register an event handler
            DRV_USART_BufferEventHandlerSet(app_communication_taskData.usart1Handle, APP_USART1BufferEventHandler, 0);      //Uart1
            
            //Schedule a read operation
            DRV_USART_ReadBufferAdd(app_communication_taskData.usart1Handle,rxBuff,1,&app_communication_taskData.readBufferHandle);
           
            if (appInitialized)
            {
                app_communication_taskData.state = APP_COMMUNICATION_TASK_STATE_SERVICE_TASKS;
            }
            break;
        }

        case APP_COMMUNICATION_TASK_STATE_SERVICE_TASKS:
        {
            uint8_t ucRxData[ 1024 ];
//            uint8_t ucTxData[ 1024 ];
            size_t xReceivedBytes;
//            size_t xSendBytes=0;
            const TickType_t xBlockTime = pdMS_TO_TICKS( 2 );

            /* Receive up to another sizeof( ucRxData ) bytes from the stream buffer.
            Wait in the Blocked state (so not using any CPU processing time) for a
            maximum of 2ms for the full sizeof( ucRxData ) number of bytes to be
            available. */
            xReceivedBytes = xStreamBufferReceive( xStreamBufferUart1Rx,
                                                   ( void * ) ucRxData,
                                                   sizeof( ucRxData ),
                                                   xBlockTime );

            if( xReceivedBytes > 0 )
            {
                int i;
                for(i=0;i<xReceivedBytes;i++)
                    Uart3DecodeMessage(ucRxData[i]);
            }
            else
            {

            }
            
//            /* Receive up to another sizeof( ucRxData ) bytes from the stream buffer.
//            Wait in the Blocked state (so not using any CPU processing time) for a
//            maximum of 2ms for the full sizeof( ucRxData ) number of bytes to be
//            available. */
//            xReceivedBytes = xStreamBufferReceive( xStreamBufferUart1Tx,
//                                                   ( void * ) ucTxData,
//                                                   sizeof( ucTxData ),
//                                                   xBlockTime );
//            
//            if( xSendBytes > 0 )
//            {
//                 SendMessageToUart1( xSendBytes, ucTxData);
//            }
//            else
//            {
//
//            }
            
            if(nextMsgAvailable)
            {
                nextMsgAvailable=0;
                MakeAndSendMessageWithUTLNProtocol(nextMsgCommand, nextMsgOutPayloadLength, nextMsgOutPayload);
            }
            break;
        }

        /* The default state should never be executed. */
        default:
        {
            /* TODO: Handle error in application's state machine. */
            break;
        }
    }
}


/*******************************************************************************
 End of File
 */
