/*******************************************************************************
  MPLAB Harmony Application Source File

  Company:
    Microchip Technology Inc.

  File Name:
    app_sd_tasks.c

  Summary:
    This file contains the source code for the MPLAB Harmony application.

  Description:
    This file contains the source code for the MPLAB Harmony application.  It
    implements the logic of the application's state machine and it may call
    API routines of other MPLAB Harmony modules in the system, such as drivers,
    system services, and middleware.  However, it does not call any of the
    system interfaces (such as the "Initialize" and "Tasks" functions) of any of
    the modules in the system or make any assumptions about when those functions
    are called.  That is the responsibility of the configuration-specific system
    files.
 *******************************************************************************/

// *****************************************************************************
// *****************************************************************************
// Section: Included Files
// *****************************************************************************
// *****************************************************************************
#include "app_sd_tasks.h"
#include "system/fs/sys_fs_media_manager.h"
#include "peripheral/gpio/plib_gpio.h"
#include "FreeRTOS.h"
#include "event_groups.h"
#include "app.h"
#include "HighBlue_Configuration.h"
#include "config/default/audio/encoder/audio_containers/include/wav_format_container.h"
#include "system/cache/sys_cache.h"
#include "app_usb.h"
#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include "Define.h"
#include "USTV_SystemTrace.h"
#include "UTLN_DDR_CircularBuffer.h"
#include "UTLN_Communication.h"
// *****************************************************************************
// *****************************************************************************
// Section: Global Data Definitions
// *****************************************************************************
// *****************************************************************************

// *****************************************************************************
/* Application Data

  Summary:
    Holds application data

  Description:
    This structure holds the application's data.

  Remarks:
    This structure should be initialized by the APP_SD_TASKS_Initialize function.

    Application strings and buffers are be defined outside this structure.
*/
//#define APP_MAKE_BUFFER_DMA_READY  __attribute__((coherent)) __attribute__((aligned(32)))
APP_SD_TASKS_DATA app_sd_tasksData;
extern APP_DATA appData;
extern APP_USB_DATA app_usbData;

//Buffer principaux utiliss en ping pong mode (SPI et USB transmissions)
//APP_MAKE_BUFFER_DMA_READY unsigned char drvAdcBufferA[PACKET_BUFFER_SIZE];
//APP_MAKE_BUFFER_DMA_READY unsigned char drvAdcBufferB[PACKET_BUFFER_SIZE];
extern TaskHandle_t xTaskAppHandle;
TaskHandle_t xTaskSDHandle=NULL;
// *****************************************************************************
// *****************************************************************************
// Section: Application Callback Functions
// *****************************************************************************
// *****************************************************************************

static int cnt=0;
void APP_SD_SYSFSEventHandler(SYS_FS_EVENT event,
                           void* eventData,
                           uintptr_t context)
{
    cnt++;
    switch(event)
    {
        case SYS_FS_EVENT_MOUNT:
        {
            if(strcmp((const char *)eventData, 
               SYS_FS_MEDIA_IDX0_MOUNT_NAME_VOLUME_IDX0) == 0)
            {
                //On notifie
                /* Set bit 8 in the notification value of the task referenced by xTask1Handle. */
                xTaskNotify( xTaskAppHandle, SD_INSERTED, eSetBits );
                app_sd_tasksData.sdCardPresent=true;
                #ifdef USE_SYSTEM_TRACE
                    USTV_SystemTraceWriteLineToBuffer("FS: SD Detected");
                #endif
                if(appData.recordParameters.saveMode==REC_SD_HDD)
                {
                    USTV_SetCurrentDrive(SYS_FS_MEDIA_IDX0_MOUNT_NAME_VOLUME_IDX0);
                    #ifdef USE_SYSTEM_TRACE
                        USTV_SystemTraceWriteLineToBuffer("FS: Current Drive set to SDCARD");
                    #endif
                }
                else if(appData.recordParameters.saveMode==REC_USB_HOST && app_usbData.deviceIsConnected)
                {
                    USTV_SetCurrentDrive(SYS_FS_MEDIA_IDX1_MOUNT_NAME_VOLUME_IDX0);
                    #ifdef USE_SYSTEM_TRACE
                        USTV_SystemTraceWriteLineToBuffer("FS: Current Drive set to USB MSD");
                    #endif
                }
                else
                {
                    USTV_SetCurrentDrive(SYS_FS_MEDIA_IDX0_MOUNT_NAME_VOLUME_IDX0);
                    #ifdef USE_SYSTEM_TRACE
                        USTV_SystemTraceWriteLineToBuffer("FS: Current Drive set to SDCARD");
                    #endif
                }
                LED_VERTE_Set();
            }
            else if(strcmp((const char *)eventData, 
               SYS_FS_MEDIA_IDX1_MOUNT_NAME_VOLUME_IDX0) == 0)
            {
                /* Set bit 8 in the notification value of the task referenced by xTask1Handle. */
                xTaskNotify( xTaskAppHandle, HDD_INSERTED, eSetBits );
                LED_VERTE_Set();
                app_usbData.deviceIsConnected=true;
                #ifdef USE_SYSTEM_TRACE
                    USTV_SystemTraceWriteLineToBuffer("FS: HDD Detected");
                #endif
                if(appData.recordParameters.saveMode==REC_USB_HOST)
                {
                    USTV_SetCurrentDrive(SYS_FS_MEDIA_IDX1_MOUNT_NAME_VOLUME_IDX0);
                    #ifdef USE_SYSTEM_TRACE
                        USTV_SystemTraceWriteLineToBuffer("FS: Current Drive set to USB MSD");
                    #endif
                }
                else if(appData.recordParameters.saveMode==REC_SD_HDD && app_sd_tasksData.sdCardPresent)
                {
                    USTV_SetCurrentDrive(SYS_FS_MEDIA_IDX0_MOUNT_NAME_VOLUME_IDX0);
                    #ifdef USE_SYSTEM_TRACE
                        USTV_SystemTraceWriteLineToBuffer("FS: Current Drive set to SDCARD");
                    #endif
                }
                else
                {
                    USTV_SetCurrentDrive(SYS_FS_MEDIA_IDX1_MOUNT_NAME_VOLUME_IDX0);
                    #ifdef USE_SYSTEM_TRACE
                        USTV_SystemTraceWriteLineToBuffer("FS: Current Drive set to USB MSD");
                    #endif
                }
            }
            
            break;
        }    
        case SYS_FS_EVENT_UNMOUNT:
        {
            if(strcmp((const char *)eventData,
               SYS_FS_MEDIA_IDX0_MOUNT_NAME_VOLUME_IDX0) == 0)
            {
                app_sd_tasksData.sdCardPresent=false;
                USTV_SetCurrentDrive(NULL);
                /* Set bit 8 in the notification value of the task referenced by xTask1Handle. */
                xTaskNotify( xTaskAppHandle, SD_OR_HDD_REMOVED, eSetBits );
                LED_VERTE_Clear();
            }
            else if(strcmp((const char *)eventData,
               SYS_FS_MEDIA_IDX1_MOUNT_NAME_VOLUME_IDX0) == 0)
            {
                app_usbData.deviceIsConnected=false;
                USTV_SetCurrentDrive(NULL);
                /* Set bit 8 in the notification value of the task referenced by xTask1Handle. */
                xTaskNotify( xTaskAppHandle, SD_OR_HDD_REMOVED, eSetBits );
                LED_VERTE_Clear();
            }
            break;
        }
        default:
            break;
    }
}

// *****************************************************************************
// *****************************************************************************
// Section: Application Local Functions
// *****************************************************************************
// *****************************************************************************

//<editor-fold defaultstate="collapsed" desc="Set Current Drive Func">
void USTV_SetCurrentDrive(char* drivePath)
{
    if(drivePath!=NULL)
    {
        app_sd_tasksData.currentDrive=drivePath;
    }
    else
    {
        app_sd_tasksData.currentDrive=NULL;
    }
}
//</editor-fold>
//<editor-fold defaultstate="collapsed" desc="Get Current Drive Func">
char* USTV_GetCurrentDrive(void)
{
    return app_sd_tasksData.currentDrive;
}
//</editor-fold>
//<editor-fold defaultstate="collapsed" desc="Set Current Drive Func">
bool USTV_IsCurrentDriveSet(void)
{
    return (app_sd_tasksData.currentDrive)?1:0;
}
//</editor-fold>

char filePath[64]={0};
char* USTV_GetFilePath(char* fileName)
{
//    static char filePath[64]={0};
    snprintf(filePath,64,"%s/%s",USTV_GetCurrentDrive(),fileName);
//    strncat(filePath, , 64);
//    strncat(filePath,"/",64);
//    strncat(filePath,fileName, 64);
    return filePath;
}

//<editor-fold defaultstate="collapsed" desc="Prepare WAV File Name">
char* USTV_PrepareWAVFileName(void)
{
    char tmp[50];
    static char tmp2[50];
    strcpy(tmp2,"/mnt/myDrive1/");
    
    tmp[0]=tmp[1]='0';
    sprintf(tmp, "%d", (appData.localTime.year+2000)); 
    //itoa(tmp,(appData.localTime.year+2000),10);
    tmp[4]=tmp[5]='0';
    sprintf(tmp+((appData.localTime.month>9)?4:5), "%d", (appData.localTime.month)); 
    //itoa(tmp+((appData.localTime.month>9)?4:5),appData.localTime.month,10);
    tmp[6]=tmp[7]='0';
    //itoa(tmp+((appData.localTime.day>9)?6:7),appData.localTime.day,10);
    tmp[8]='_';
    sprintf(tmp+9, "%d", appData.localTime.hour);
    //itoa(tmp+9,appData.localTime.hour,10);
    if(appData.localTime.hour<10)
    {
        tmp[9]=0x30;
        //itoa(tmp+10,appData.localTime.hour,10);
        sprintf(tmp+10, "%d", appData.localTime.hour);
    }
    else
        sprintf(tmp+9, "%d", appData.localTime.hour);
        //itoa(tmp+9,appData.localTime.hour,10);
    //itoa(tmp+11,appData.localTime.min,10);
    sprintf(tmp+11, "%d", appData.localTime.min);
    if(appData.localTime.min<10)
    {
        tmp[11]=0x30;
        sprintf(tmp+12, "%d", appData.localTime.min);
        //itoa(tmp+12,appData.localTime.min,10);
    }
    else
    {
        sprintf(tmp+11, "%d", appData.localTime.min);
        //itoa(tmp+11,appData.localTime.min,10);
    }
    if(appData.localTime.sec<10)
    {
        tmp[13]=0x30;
        //itoa(tmp+14,appData.localTime.sec,10);
        sprintf(tmp+14, "%d", appData.localTime.sec);
    }
    else
        //itoa(tmp+13,appData.localTime.sec,10);
        sprintf(tmp+13, "%d", appData.localTime.sec);
    strcpy(tmp+15,"UTC");
    tmp[18]='_';
    tmp[19]='V';
    tmp[20]=tmp[21]='0';
   // itoa(tmp+((HARDWARE_MAJOR_REV>9)?20:21),HARDWARE_MAJOR_REV,10);
    strcpy(tmp+22,"OS");
    sprintf(tmp+24, "%d", SOFTWARE_MAJOR_REV);
    sprintf(tmp+25, "%d", SOFTWARE_MINOR_REV);
    strcpy(tmp+26,".WAV");
    strcat(tmp2,tmp);
    Nop();
    Nop();
    return tmp2;

}
//</editor-fold>
//<editor-fold defaultstate="collapsed" desc="Prepare WAV File">
char* wavFileNameTest=0;
void USTV_PrepareWAVFile(void)
{
    if(app_sd_tasksData.sdCardPresent)
    {
        wavFileNameTest=USTV_PrepareWAVFileName();
        /* Try opening the file for append */
        app_sd_tasksData.fileHandle = SYS_FS_FileOpen((const char*)wavFileNameTest, (SYS_FS_FILE_OPEN_APPEND_PLUS));
        if(app_sd_tasksData.fileHandle == SYS_FS_HANDLE_INVALID)
        {
            /* Could not open the file. Error out*/
            //  appData.state = APP_STATE_ERROR;
            #ifdef USE_SYSTEM_TRACE
                USTV_SystemTraceWriteLine("Could not open .log file");
            #endif
        }
        else
        {
            appData.stats.filesCreated++;
            SYS_FS_FileSeek(app_sd_tasksData.fileHandle,WAV_HEADER_SIZE,SYS_FS_SEEK_SET);          //go to position of data
           
            
            //SYS_FS_FileClose(app_sd_tasksData.fileHandle);//To test avec RTOS
        }
    }
}
//</editor-fold>
//<editor-fold defaultstate="collapsed" desc="Write WAV Header Func">
void USTV_WavHeaderWriteFunc(unsigned int resolutionBits, unsigned char chanCount, unsigned int sampleRate, unsigned int encodedAudioSize)
{
    WAVHEADER hdr;
    StreamInfo info;
    info.bit_depth=resolutionBits;
    info.bps= resolutionBits*sampleRate;
    info.channel=chanCount;
    info.sample_rate=sampleRate;
    
    wav_riff_fill_header(&hdr, PCM,&info,encodedAudioSize);
    hdr.dataLen=16;
    /* Try writing to the file */
    if(SYS_FS_FileSeek(app_sd_tasksData.fileHandle,0,SYS_FS_SEEK_SET)==0)
    {
        if (SYS_FS_FileWrite( app_sd_tasksData.fileHandle, (const void *)&hdr, WAV_HEADER_SIZE ) == -1)
        {

            /* Write was not successful. Close the file
             * and error out.*/
            SYS_FS_FileClose(app_sd_tasksData.fileHandle);
            //appData.state = APP_STATE_ERROR;
            #ifdef USE_SYSTEM_TRACE
                USTV_SystemTraceWriteLine("Impossible d'ecrire dans le fichier .log\nAppState: APP_STATE_ERROR");
            #endif
        }
        else
        {
            /* We are done writing. */
            SYS_FS_FileWrite( app_sd_tasksData.fileHandle, (const void *)&hdr, 20 );        //on ajoute 20 octets afin d'etre multiple de 32

        }
    }
}
//</editor-fold>

//<editor-fold defaultstate="collapsed" desc="Prepare LOG File Name">
char* USTV_PrepareFileName(CURRENT_TIME* pTime, uint16_t fileNumber)
{
    #ifdef FILENAME_FORMAT1
    char tmp[50];
    static char tmp2[50];
    strcpy(tmp2,USTV_GetCurrentDrive());
    
    tmp[0]=tmp[1]='0';
    itoa(tmp,(pTime->year+2000),10);
    tmp[4]=tmp[5]='0';
    itoa(tmp+((pTime->month>9)?4:5),pTime->month,10);
    tmp[6]=tmp[7]='0';
    itoa(tmp+((pTime->day>9)?6:7),pTime->day,10);
    tmp[8]='_';
    itoa(tmp+9,pTime->hour,10);
    if(pTime->hour<10)
    {
        tmp[9]=0x30;
        itoa(tmp+10,pTime->hour,10);
    }
    else
        itoa(tmp+9,pTime->hour,10);
    itoa(tmp+11,pTime->min,10);
    if(pTime->min<10)
    {
        tmp[11]=0x30;
        itoa(tmp+12,pTime->min,10);
    }
    else
    {
        itoa(tmp+11,pTime->min,10);
    }
    if(pTime->sec<10)
    {
        tmp[13]=0x30;
        itoa(tmp+14,pTime->sec,10);
    }
    else
        itoa(tmp+13,pTime->sec,10);
    strcpy(tmp+15,"UTC");
    tmp[18]='_';
    tmp[19]='V';
    tmp[20]=tmp[21]='0';
   // itoa(tmp+((HARDWARE_MAJOR_REV>9)?20:21),HARDWARE_MAJOR_REV,10);
    strcpy(tmp+22,"OS");
    itoa(tmp+24,SOFTWARE_MAJOR_REV,10);
    itoa(tmp+25,SOFTWARE_MINOR_REV,10);
    strcpy(tmp+26,"_");
    itoa(tmp+27,appData.stats.filesCreated,10);
    strcpy(tmp+28,".log");
    strcat(tmp2,tmp);
    Nop();
    Nop();
    return tmp2;
#elif defined(FILENAME_FORMAT2)
    char tmp[25];
    static char tmp2[50];
    strcpy(tmp2,"/mnt/myDrive1/");
    
    tmp[0]=tmp[1]='0';
    itoa(tmp+((pTime->day>9)?0:1),pTime->day,10);
    tmp[2]='-';
    tmp[4]=tmp[3]='0';
    itoa(tmp+((pTime->month>9)?3:4),pTime->month,10);
    tmp[5]='-';
    itoa(tmp+6,(pTime->year+2000),10);
    tmp[10]='_';
    itoa(tmp+11,pTime->hour,10);
    if(pTime->hour<10)
    {
        tmp[11]=0x30;
        itoa(tmp+12,pTime->hour,10);
    }
    else
        itoa(tmp+11,pTime->hour,10);
    tmp[13]='-';
    itoa(tmp+14,pTime->min,10);
    if(pTime->min<10)
    {
        tmp[14]=0x30;
        itoa(tmp+15,pTime->min,10);
    }
    else
    {
        itoa(tmp+14,pTime->min,10);
    }
    tmp[16]='-';
    if(pTime->sec<10)
    {
        tmp[17]=0x30;
        itoa(tmp+18,pTime->sec,10);
    }
    else
        itoa(tmp+17,pTime->sec,10);
    strcpy(tmp+19,".log");
    strcat(tmp2,tmp);
    return tmp2;
#else
    static char tmp[50]={0};
    if(fileNumber>0)
    {
        snprintf(tmp,sizeof(tmp),"%.4d%.2d%.2d_%.2d%.2d%.2dUTC_V%d%d_%d.log",pTime->year+2000
                                                         ,pTime->month
                                                         ,pTime->day
                                                         ,pTime->hour
                                                         ,pTime->min
                                                         ,pTime->sec
                                                         ,SOFTWARE_MAJOR_REV
                                                         ,SOFTWARE_MINOR_REV
                                                         , fileNumber);
    }
    else
    {
        snprintf(tmp,sizeof(tmp),"%.4d%.2d%.2d_%.2d%.2d%.2dUTC_V%d%d.log",pTime->year+2000
                                                         ,pTime->month
                                                         ,pTime->day
                                                         ,pTime->hour
                                                         ,pTime->min
                                                         ,pTime->sec
                                                         ,SOFTWARE_MAJOR_REV
                                                         ,SOFTWARE_MINOR_REV);
    }
    return tmp;
#endif
}
//</editor-fold>
//<editor-fold defaultstate="collapsed" desc="Prepare LOG File">
void USTV_PrepareFile(CURRENT_TIME* pTime)
{
    if(app_sd_tasksData.sdCardPresent || app_usbData.deviceIsConnected)
    {
        appData.currentFileName=USTV_PrepareFileName(pTime, appData.stats.filesCreated);
        char path[65]={0};
        strncat(path,USTV_GetCurrentDrive(),64);
        strncat(path,"/",64);
        strncat(path,appData.currentFileName,64);

        /* Try opening the file for append */
        app_sd_tasksData.fileHandle = SYS_FS_FileOpen((const char*)appData.currentFileName, (SYS_FS_FILE_OPEN_APPEND_PLUS));
        if(app_sd_tasksData.fileHandle == SYS_FS_HANDLE_INVALID)
        {
            /* Could not open the file. Error out*/
            appData.status=APP_ERROR;
            #ifdef USE_SYSTEM_TRACE
                USTV_SystemTraceWriteLine("Impossible d'ouvrir le fichier .log\nAppState: APP_STATE_ERROR");
            #endif
        }
        else
        {
            if(appData.timeForFileName.day==0 && appData.timeForFileName.month==0 )
                appData.stats.filesCreated++;
//            USTV_LogHeaderWriteFunc();
        }
    }
//    else if(appData.USBMode==MODE_DEVICE && appData.deviceIsConfigured)
//    {
//        appData.recordParameters.dataSaveOption=SAVE_MODE_USB_DEVICE;
//    }
//    else
//    {
//        //Erreur on enregistre pas
//      //  LEDSetMode(LED_ROUGE, LED_ON);
//        return;
//    }
}
//</editor-fold>
//<editor-fold defaultstate="collapsed" desc="Write LOG Header Func">
void USTV_LogHeaderWriteFunc(SYS_FS_HANDLE fileHandle, 
                            unsigned int resolutionBits, 
                            unsigned char chanCount, 
                            unsigned int sampleRate, 
                            unsigned char periphCount, 
                            unsigned long startOfFileTimeStamp,
                            PERIPHERAL_CONFIGURATION config[])
{
    HighBlueHeader hdr;
    hdr.dmaBlockSize=PACKET_BUFFER_SIZE-ADDITIONNAL_DATA_SIZE;
    hdr.headerSize=HEADER_SIZE-4;                   //-4 a cause du champ headerSize
    hdr.numberOfChan=chanCount;
    hdr.resolutionBits=resolutionBits;
    hdr.samplingFrequency=sampleRate;
    hdr.sizeOfAdditionnalDataBuffer=ADDITIONNAL_DATA_SIZE;
    hdr.versionNumber=(SOFTWARE_MAJOR_REV<<8)|SOFTWARE_MINOR_REV;
    hdr.numberOfExternalPeripheral=periphCount;
    hdr.timeStampOfStart=startOfFileTimeStamp;
    int i;
    for(i=0;i<periphCount;i++)
    {
        hdr.periphConfig[i]=config[i];
    }
    
    
    /* Try writing to the file */
    if(SYS_FS_FileSeek(fileHandle,0,SYS_FS_SEEK_SET)==0)
    {
        if (SYS_FS_FileWrite( fileHandle, (const void *)&hdr, HEADER_SIZE ) == -1)
        {
            /* Write was not successful. Close the file
             * and error out.*/
            SYS_FS_FileClose(fileHandle);
            //appData.state = APP_STATE_ERROR;
            #ifdef USE_SYSTEM_TRACE
                USTV_SystemTraceWriteLine("Impossible d'ecrire dans le fichier .log\nAppState: APP_STATE_ERROR");
            #endif
        }
        else
        {
            /* We are done writing. */
        }
    }
}
//</editor-fold>
//<editor-fold defaultstate="collapsed" desc="Parse LOG File Header Func">
 uintptr_t USTV_ParseLogFileHeader(SYS_FS_HANDLE fileHandle, HighBlueHeader* hdr )
{
    if(fileHandle!=SYS_FS_HANDLE_INVALID)
    {
        //le fichier a bien ete ouvert correctement, on peut le lire        
        size_t bytes_read, bytes_toRead=0;

        //On commence par lire les 4 premiers octets du fichier (champ HeaderSize).
        char headerSizeBuf[4];
        bytes_read = SYS_FS_FileRead(fileHandle, headerSizeBuf, 4);
        if(bytes_read!=4)
            return (0);
        hdr->headerSize=BUILD_UINT32(headerSizeBuf[0],headerSizeBuf[1],headerSizeBuf[2],headerSizeBuf[3]);
        
        //On vient lire le header complet
        SYS_FS_FileSeek(fileHandle,0,SYS_FS_SEEK_SET);  //On se place au debut du fichier
        bytes_toRead=sizeof(HighBlueHeader);
        bytes_read = SYS_FS_FileRead(fileHandle, hdr,bytes_toRead );
        if(bytes_read!=sizeof(HighBlueHeader))
            return 0;
        else
            return 1;
    }
    else
        return 0;
}
//</editor-fold>

//<editor-fold defaultstate="collapsed" desc="Seek To First Data Block Func">
HighBlueHeader USTV_ParseHeaderAndSeekToFirstAudioDataBlock(SYS_FS_HANDLE fileHandle)
{
    HighBlueHeader hdr;
    //SYS_FS_FileSeek(fileHandle,0,SYS_FS_SEEK_SET);  //On se place au debut du fichier
    USTV_ParseLogFileHeader(fileHandle, &hdr);
    //On se decale au niveau du premier block de donnes audio
    SYS_FS_FileSeek(fileHandle,hdr.headerSize+4 + hdr.sizeOfAdditionnalDataBuffer,SYS_FS_SEEK_SET);  //On se place au debut des datas
    
    return hdr;
}
//</editor-fold>
//<editor-fold defaultstate="collapsed" desc="Seek To Next Data Block Func">
size_t USTV_SeekToNextDataBlock(SYS_FS_HANDLE fileHandle,uint32_t additionnalDataBlockSize )
{
    size_t offset=0;
    //On se decale de la taille d'un buffer de data additionnelles
    offset=SYS_FS_FileSeek(fileHandle,additionnalDataBlockSize,SYS_FS_SEEK_CUR);  //On se place au debut des datas
    return offset;
}
//</editor-fold>
//<editor-fold defaultstate="collapsed" desc="Get RAW Audio Data Block Func">
size_t USTV_GetRAWAudioDataBlock(SYS_FS_HANDLE fileHandle, unsigned char* buffer_ptr, uint32_t bufferSize)
{
    size_t bytes_read=0;
    //On vient lire le block complet a partir de la position courante
    bytes_read = SYS_FS_FileRead(fileHandle, buffer_ptr, bufferSize);
    return bytes_read;
}
//</editor-fold>

//<editor-fold defaultstate="collapsed" desc="Calculate File Position of N seconde of Audio Data Func">
uint32_t USTV_CalculateFilePositionOfNSecondOfData(HighBlueHeader hdr,uint32_t numberOfSecond)
{
    uint32_t sampleCountOfNSecondOfData=hdr.samplingFrequency*numberOfSecond;
    uint32_t numberOfBytesOfNSecondOfData=sampleCountOfNSecondOfData* hdr.numberOfChan * hdr.resolutionBits/8;
    uint32_t numberOfDMABlock=numberOfBytesOfNSecondOfData/(hdr.dmaBlockSize-hdr.sizeOfAdditionnalDataBuffer);  
    uint32_t position=hdr.headerSize + 4 + numberOfDMABlock*(hdr.dmaBlockSize+hdr.sizeOfAdditionnalDataBuffer);
    
    return position;
}

uint32_t USTV_CalculateFilePositionAtNSamples(HighBlueHeader hdr,uint32_t numberOfSamples)
{
    uint32_t numberOfBytesOfNSecondOfData= numberOfSamples* hdr.numberOfChan * hdr.resolutionBits/8;
    uint32_t numberOfDMABlock=numberOfBytesOfNSecondOfData/(hdr.dmaBlockSize-hdr.sizeOfAdditionnalDataBuffer);  
    uint32_t position=hdr.headerSize + 4 + numberOfDMABlock*(hdr.dmaBlockSize+hdr.sizeOfAdditionnalDataBuffer);
    
    return position;
}
//</editor-fold>

//<editor-fold defaultstate="collapsed" desc="FindStatFileAndGetCurrentNum">
unsigned int FindStatFileAndGetCurrentNum(void)
{
    SYS_FS_HANDLE file=SYS_FS_HANDLE_INVALID;;
    char path[50]={0};
    if(USTV_IsCurrentDriveSet())
    {
        strcat(path,USTV_GetCurrentDrive());
        strcat(path,"/info.log");
        file = SYS_FS_FileOpen(path,(SYS_FS_FILE_OPEN_READ));
    }

    if(file != SYS_FS_HANDLE_INVALID)
    {
        unsigned int bytes_read=0;
        char filecountBuf[5]={0};
        bytes_read = SYS_FS_FileRead(file, filecountBuf, 4);
        if(bytes_read!=4)
            return (0);
        SYS_FS_FileClose(file);
        return atoi(filecountBuf);
    }
    else
    {
        return 0;
    }
}
//</editor-fold>
//<editor-fold defaultstate="collapsed" desc="WriteCurrentFileNum">
unsigned int WriteCurrentFileNum(unsigned int num)
{
    SYS_FS_HANDLE file=SYS_FS_HANDLE_INVALID;;
    char path[50]={0};
    if(USTV_IsCurrentDriveSet())
    {
        strcat(path,USTV_GetCurrentDrive());
        strcat(path,"/info.log");
        file = SYS_FS_FileOpen(path,(SYS_FS_FILE_OPEN_WRITE));
    }

    if(file != SYS_FS_HANDLE_INVALID)
    {
        char buff[10];
        snprintf(buff,10,"%.4d",num);
        if (SYS_FS_FileWrite( file, (const void *) buff, 4 ) == -1)
        {
            /* Write was not successful. Close the file
             * and error out.*/
            SYS_FS_FileClose(file);
        }
        else
        {
            /* We are done writing. */
             SYS_FS_FileClose(file);
        }
    }
    else
    {
        return 0;
    }
    return 0;
}
//</editor-fold>
//<editor-fold defaultstate="collapsed" desc="Find File in Directory">
SYS_FS_HANDLE FindAndOpenFileInDirectory(char* srchStr, SYS_FS_FILE_OPEN_ATTRIBUTES fileAtt )
{
    SYS_FS_HANDLE dirHandle;
    SYS_FS_FSTAT stat;
    char longFileName[300];

    dirHandle = SYS_FS_DirOpen("/mnt/myDrive/");

    if(dirHandle != SYS_FS_HANDLE_INVALID)
    {
        // Directory open is successful
        // If long file name is used, the following elements of the "stat"
        // structure needs to be initialized with address of proper buffer.
        stat.lfname = longFileName;
        stat.lfsize = 300;

        if(SYS_FS_DirSearch(dirHandle, srchStr, SYS_FS_ATTR_ARC, &stat) == SYS_FS_RES_FAILURE)
        {
            // Specified file not found
            return SYS_FS_HANDLE_INVALID;
        }
        else
        {
            // File found. Read the complete file name from "stat.lfname" and
            // other file parameters from the "stat" structure
            return SYS_FS_FileOpen(stat.lfname,fileAtt);
        }
    }
    else
    {
        return SYS_FS_HANDLE_INVALID;
    }
}
//</editor-fold>

//<editor-fold defaultstate="collapsed" desc="Add Data To Additionnal Buffer Func">
extern APP_MAKE_BUFFER_DMA_READY unsigned char packetConstructionBuffer[]; //6 canaux avec DMA de taille max + 1000 octets au dbut 
unsigned char currentFilingBuffer=BUFFER_A;
unsigned int currentIndexInBufferA=0;
unsigned int currentIndexInBufferB=0;
void USTV_AddDataInAdditionnalBuffer(unsigned char* data, unsigned int dataCount)
{
    #ifdef USE_DDR_BUFFER_POOL
        if((currentIndexInBufferA+dataCount)<ADDITIONNAL_DATA_SIZE-UTLN_FRAME_SIZE)
        {
            //On copie le message dans les datas additionnelles de la DDR
            memcpy((void*)(packetConstructionBuffer+currentIndexInBufferA+UTLN_FRAME_SIZE),data, dataCount);
            currentIndexInBufferA+=dataCount;
        }
        else
        {
            //On n'ajoute pas le message, on le discard
            //LED_ORANGE_Toggle();
        }
    #else
    if(currentFilingBuffer==BUFFER_B)
    {
        if((currentIndexInBufferB+dataCount)<ADDITIONNAL_DATA_SIZE)
        {
            memcpy((drvAdcBufferB+currentIndexInBufferB),data, dataCount);
            currentIndexInBufferB+=dataCount;
        }
    }
    else
    {
        //On es en train de remplir le bufferA
        if((currentIndexInBufferA+dataCount)<ADDITIONNAL_DATA_SIZE)
        {
            memcpy((drvAdcBufferA+currentIndexInBufferA),data, dataCount);
            currentIndexInBufferA+=dataCount;
        }
    }
    #endif
}
void USTV_ResetAdditionnalDataIndexBufferA(void)
{
    currentIndexInBufferA=0;
}
void USTV_ResetAdditionnalDataIndexBufferB(void)
{
    currentIndexInBufferB=0;
}
void USTV_SetCurrentFillingAdditionnalBuffer(unsigned char selectedBuff)
{
    currentFilingBuffer=selectedBuff;
}
//</editor-fold>



// *****************************************************************************
// *****************************************************************************
// Section: Application Initialization and State Machine Functions
// *****************************************************************************
// *****************************************************************************

/*******************************************************************************
  Function:
    void APP_SD_TASKS_Initialize ( void )

  Remarks:
    See prototype in app_sd_tasks.h.
 */

void APP_SD_TASKS_Initialize ( void )
{
    /* Place the App state machine in its initial state. */
    app_sd_tasksData.state = APP_SD_TASKS_STATE_INIT;

    app_sd_tasksData.fileHandle=SYS_FS_HANDLE_INVALID;

    /* TODO: Initialize your application's state machine and other
     * parameters.
     */
}


/******************************************************************************
  Function:
    void APP_SD_TASKS_Tasks ( void )

  Remarks:
    See prototype in app_sd_tasks.h.
 */
BaseType_t xResult;
const TickType_t xMaxBlockTime = pdMS_TO_TICKS( 50 );
unsigned int lastWriteIndex;

extern volatile unsigned int DDR_CB_Tail;
extern volatile unsigned int DDR_CB_Head;

bool SdTaskInProgress = false;

void APP_SD_TASKS_Tasks ( void )
{
    /* Check the application's current state. */
    switch ( app_sd_tasksData.state )
    {
        /* Application's initial state. */
        case APP_SD_TASKS_STATE_INIT:
        {
            bool appInitialized = true;
            //On initialise le system de datalogging des etats system
            USTV_SystemTraceInit();
            
            //On enregistre un Handler au system de fichier (afin de detecter le montage des cartes SD)
            SYS_FS_EventHandlerSet(APP_SD_SYSFSEventHandler, (uintptr_t) NULL);
            
            xTaskSDHandle=xTaskGetCurrentTaskHandle();

            if (appInitialized)
            {
                app_sd_tasksData.state = APP_SD_TASKS_STATE_SERVICE_TASKS;
            }
            break;
        }

        case APP_SD_TASKS_STATE_SERVICE_TASKS:
        {
            uint32_t ulNotifiedValue=0;

            const TickType_t xTicksToWait = 5 / portTICK_PERIOD_MS;
            
            //ON attend l'arrive d'une notification en provenance des DMA opu d'un timout
            xResult = xTaskNotifyWait( pdFALSE,    /* Don't clear bits on entry. */
                           0xFFFFFFFF,        /* Clear all bits on exit. */
                           &ulNotifiedValue, /* Stores the notified value. */
                           xTicksToWait );
            
            if(!SdTaskInProgress)
            {
                SdTaskInProgress = true;
                
                //if( xResult == pdPASS ) //On a reu une notification d'un DMA, donc des donnes arrivent
                //{

                /* xEventGroupWaitBits() returned because just BUFFER_A_READY was set. */
                if(appData.recordParameters.saveMode == REC_SD_HDD)  //Si on travaille sur carte SD ou HDD
                {
                    //On verifie qu'un media est bien present
                    if((app_sd_tasksData.sdCardPresent || app_usbData.deviceIsConnected) && app_sd_tasksData.fileHandle!=SYS_FS_HANDLE_INVALID)
                    {
                        while(DDR_CB_Head!=DDR_CB_Tail) //Tant qu'il y a des datas dans le DDR en buffer circulaire
                        {       
                            //Tant qu'il y a des choses dans la DDR
                            //On les crit dans la SD
                            LED_VERTE_Toggle();
                            //On verifie que l'on ne depasse pas la taille max d'un fichier
                            int32_t fileLen=SYS_FS_FileTell(app_sd_tasksData.fileHandle) + PACKET_BUFFER_SIZE;       
                            if(fileLen >=appData.recordParameters.fileSizeLimitation)
                            {
                                //Si on a atteint ou dpass la taille de fichier maximale
                                #ifdef USE_WAV_FORMAT
                                    //Update WaveHeader
                                    USTV_WavHeaderWriteFunc(appData.recordParameters.resolution, appData.recordParameters.nbChannelsUsed,
                                                            appData.recordParameters.samplingFrequency, appData.stats.packetSuccessfullyWrittenToFS*PACKET_BUFFER_SIZE);
                                #endif
                                //On ferme le fichier courant
                                SYS_FS_FileClose(app_sd_tasksData.fileHandle);
                                //On re-ouvre un fichier 
                                #ifdef USE_WAV_FORMAT
                                    USTV_PrepareWAVFile(); 
                                    //Write WaveHeader
                                    USTV_WavHeaderWriteFunc(appData.recordParameters.resolution, appData.recordParameters.nbChannelsUsed,
                                        appData.recordParameters.samplingFrequency, appData.stats.packetSuccessfullyWrittenToFS*PACKET_BUFFER_SIZE);
                                #else
                                    USTV_PrepareFile(&appData.localTime);
                                    USTV_LogHeaderWriteFunc(app_sd_tasksData.fileHandle,appData.recordParameters.resolution, appData.recordParameters.nbChannelsUsed, appData.recordParameters.samplingFrequency, appData.numberOfExternalPeripheral,appData.currentStartOfFileTimeStamp, appData.peripheralConfig);
                                #endif
                                appData.stats.totalPacketSuccessfullyWrittenToFS+=appData.stats.packetSuccessfullyWrittenToFS;

                                //On ecrit les datas
                                if (SYS_FS_FileWrite( app_sd_tasksData.fileHandle,  (void*)DDRGetPointerFromBuffer(DDR_CB_Tail), PACKET_BUFFER_SIZE) == -1)
                                {
                                     //Write was not successful. Close the file
                                     // and error out.
                                    appData.stats.totalUSBWriteError++;
                                    SYS_FS_FileClose(app_sd_tasksData.fileHandle);
                                    //appData.state = APP_STATE_ERROR;
                                }
                                else
                                {
                                    //On a ecrit le dernier buffer, on clear le flag
                                    DDR_CB_Tail++;
                                    if(DDR_CB_Tail>=DDR_CIRCULAR_BUFFER_SIZE)
                                        DDR_CB_Tail=0;


                                    //();

                                    appData.stats.packetSuccessfullyWrittenToFS++;
                                }
                            }
                            else 
                            {
                                //Si on n'a pas atteint ou dpass la taille de fichier maximale : cas le plus courant
                                int res=0;
                                IO_0_Set();
                                res=SYS_FS_FileWrite( app_sd_tasksData.fileHandle, (void*) DDRGetPointerFromBuffer(DDR_CB_Tail), /*ADDITIONNAL_DATA_SIZE+SPI_DMA_BUFFER_SIZE*appData.recordParameters.nbChannelsUsed*/ 65536);
                                IO_0_Clear();
                                if (res == -1)
                                {
                                    /* Write was not successful. Close the file
                                     * and error out.*/
                                    SYS_FS_FileClose(app_sd_tasksData.fileHandle);
                                    appData.stats.totalUSBWriteError++;
                                    //appData.state = APP_STATE_ERROR;
                                }
                                else
                                {
                                    DDR_CB_Tail++;
                                    if(DDR_CB_Tail>=DDR_CIRCULAR_BUFFER_SIZE)
                                        DDR_CB_Tail=0;

                                    //USTV_ResetAdditionnalDataIndexBufferA();

                                    appData.stats.packetSuccessfullyWrittenToFS++;
                                }
                            }                               
                            //LED_VERTE_Clear();
                        }
                    }
                }
                else if(appData.recordParameters.saveMode == REC_USB_DEV)  //Si on est en mode device                    
                {
                    //On est en USB DEVICE
                    if(app_usbData.isConfigured) //Si l'USB est configur
                    {
                        while(DDR_CB_Head!=DDR_CB_Tail && !app_usbData.epDataWritePending) //Tant qu'il y a des datas dans le DDR en buffer circulaire
                        { 
                                /* Send the data to the host */
                                app_usbData.epDataWritePending = true;

                                USB_DEVICE_EndpointWrite ( app_usbData.deviceHandle, &app_usbData.writeTranferHandle,
                                        app_usbData.endpointTx, (void*)DDRGetPointerFromBuffer(DDR_CB_Tail),
                                        65536,
                                        USB_DEVICE_TRANSFER_FLAGS_MORE_DATA_PENDING);

                                    DDR_CB_Tail++;
                                    if(DDR_CB_Tail>=DDR_CIRCULAR_BUFFER_SIZE)
                                        DDR_CB_Tail=0;

                                    //USTV_ResetAdditionnalDataIndexBufferA();
                            
                        }
                    }
                }
                
                if(app_sd_tasksData.fileHandle==SYS_FS_HANDLE_INVALID)
                {
                    DDR_CB_Head=DDR_CB_Tail;
                }
                
                //Si la DDR est vide, qu'on est plus logging et qu'on est pass en flush
                if(DDR_CB_Head==DDR_CB_Tail && !appData.ads1602IsLogging && appData.state==APP_STATE_FLUSHING_DDR_TO_SD)
                {
                    if(!app_usbData.isConfigured) //Si pas d'USB
                    {
                        if(app_sd_tasksData.fileHandle != SYS_FS_HANDLE_INVALID) //Si un fichier est ouvert
                        {  
                            //On ferme le fichier aprs avoir updat les infos du header
                            #ifdef USE_WAV_FORMAT
                                //Update WaveHeader
                                USTV_WavHeaderWriteFunc(appData.recordParameters.resolution, appData.recordParameters.nbChannelsUsed,
                                                        appData.recordParameters.samplingFrequency, appData.stats.packetSuccessfullyWrittenToFS*131072);
                            #else
                                USTV_LogHeaderWriteFunc(app_sd_tasksData.fileHandle,appData.recordParameters.resolution, appData.recordParameters.nbChannelsUsed, appData.recordParameters.samplingFrequency, appData.numberOfExternalPeripheral,appData.currentStartOfFileTimeStamp, appData.peripheralConfig);
                            #endif
                            /* Close the file */
                            SYS_FS_FileClose(app_sd_tasksData.fileHandle);
                            app_sd_tasksData.fileHandle=SYS_FS_HANDLE_INVALID;
                        }
                    }
                    lastWriteIndex=0;
                    //On a termin l'ecriture des datas, on le notify a la tache APP
                    xTaskNotify( xTaskAppHandle, DDR_FLUSHED, eSetBits );
                }
//            }
                  
            #ifdef USE_SYSTEM_TRACE
                //Debug, datalog l'etat du system
                USTV_SystemTraceWriteBufferToFile();
            #endif
            
                SdTaskInProgress = false;
            }
            break;
        }

        /* TODO: implement your application state machine.*/


        /* The default state should never be executed. */
        default:
        {
            /* TODO: Handle error in application's state machine. */
            break;
        }
    }
}

/*******************************************************************************
 End of File
 */
