/*******************************************************************************
  MPLAB Harmony Application Header File

  Company:
    Microchip Technology Inc.

  File Name:
    app_sd_tasks.h

  Summary:
    This header file provides prototypes and definitions for the application.

  Description:
    This header file provides function prototypes and data type definitions for
    the application.  Some of these are required by the system (such as the
    "APP_SD_TASKS_Initialize" and "APP_SD_TASKS_Tasks" prototypes) and some of them are only used
    internally by the application (such as the "APP_SD_TASKS_STATES" definition).  Both
    are defined here for convenience.
*******************************************************************************/

#ifndef _APP_SD_TASKS_H
#define _APP_SD_TASKS_H

// *****************************************************************************
// *****************************************************************************
// Section: Included Files
// *****************************************************************************
// *****************************************************************************

#include <stdint.h>
#include <stdbool.h>
#include <stddef.h>
#include <stdlib.h>
#include "configuration.h"
#include "config/default/system/fs/sys_fs.h"
#include "HighBlue_Header.h"
#include "app.h"
// DOM-IGNORE-BEGIN
#ifdef __cplusplus  // Provide C++ Compatibility

extern "C" {

#endif
// DOM-IGNORE-END
#define BUFFER_A 0
#define BUFFER_B 1
    
//Events
#define BUFFER_A_READY 0x01
#define BUFFER_B_READY    0x02
#define SYS_TRACE_MESSAGE    (1u<<2)    
    
// *****************************************************************************
// *****************************************************************************
// Section: Type Definitions
// *****************************************************************************
// *****************************************************************************

// *****************************************************************************
/* Application states

  Summary:
    Application states enumeration

  Description:
    This enumeration defines the valid application states.  These states
    determine the behavior of the application at various times.
*/

typedef enum
{
    /* Application's state machine's initial state. */
    APP_SD_TASKS_STATE_INIT=0,
    APP_SD_TASKS_STATE_SERVICE_TASKS,
    /* TODO: Define states used by the application state machine. */

} APP_SD_TASKS_STATES;


// *****************************************************************************
/* Application Data

  Summary:
    Holds application data

  Description:
    This structure holds the application's data.

  Remarks:
    Application strings and buffers are be defined outside this structure.
 */

typedef struct
{
    /* The application's current state */
    APP_SD_TASKS_STATES state;

    /* TODO: Define any additional data used by the application. */
    SYS_FS_HANDLE      fileHandle;
    
    bool sdCardPresent;
    
    char* currentDrive;
    
} APP_SD_TASKS_DATA;

// *****************************************************************************
// *****************************************************************************
// Section: Application Callback Routines
// *****************************************************************************
// *****************************************************************************
/* These routines are called by drivers when certain events occur.
*/

// *****************************************************************************
// *****************************************************************************
// Section: Application Initialization and State Machine Functions
// *****************************************************************************
// *****************************************************************************

/*******************************************************************************
  Function:
    void APP_SD_TASKS_Initialize ( void )

  Summary:
     MPLAB Harmony application initialization routine.

  Description:
    This function initializes the Harmony application.  It places the
    application in its initial state and prepares it to run so that its
    APP_SD_TASKS_Tasks function can be called.

  Precondition:
    All other system initialization routines should be called before calling
    this routine (in "SYS_Initialize").

  Parameters:
    None.

  Returns:
    None.

  Example:
    <code>
    APP_SD_TASKS_Initialize();
    </code>

  Remarks:
    This routine must be called from the SYS_Initialize function.
*/

void APP_SD_TASKS_Initialize ( void );


/*******************************************************************************
  Function:
    void APP_SD_TASKS_Tasks ( void )

  Summary:
    MPLAB Harmony Demo application tasks function

  Description:
    This routine is the Harmony Demo application's tasks function.  It
    defines the application's state machine and core logic.

  Precondition:
    The system and application initialization ("SYS_Initialize") should be
    called before calling this.

  Parameters:
    None.

  Returns:
    None.

  Example:
    <code>
    APP_SD_TASKS_Tasks();
    </code>

  Remarks:
    This routine must be called from SYS_Tasks() routine.
 */

void APP_SD_TASKS_Tasks( void );
bool USTV_IsCurrentDriveSet(void);
void USTV_SetCurrentDrive(char* drivePath);
char* USTV_GetCurrentDrive(void);
char* USTV_GetFilePath(char* fileName);
void USTV_PrepareFile(CURRENT_TIME* pTime);
void USTV_PrepareWAVFile(void);
void USTV_WavHeaderWriteFunc(unsigned int resolutionBits, unsigned char chanCount, unsigned int sampleRate, unsigned int encodedAudioSize);
uintptr_t USTV_ParseLogFileHeader(SYS_FS_HANDLE fileHandle, HighBlueHeader* hdr );
HighBlueHeader USTV_ParseHeaderAndSeekToFirstAudioDataBlock(SYS_FS_HANDLE fileHandle);
size_t USTV_SeekToNextDataBlock(SYS_FS_HANDLE fileHandle,uint32_t additionnalDataBlockSize );
size_t USTV_GetRAWAudioDataBlock(SYS_FS_HANDLE fileHandle, unsigned char* buffer_ptr, uint32_t bufferSize);
uint32_t USTV_CalculateFilePositionOfNSecondOfData(HighBlueHeader hdr,uint32_t numberOfSecond);
uint32_t USTV_CalculateFilePositionAtNSamples(HighBlueHeader hdr,uint32_t numberOfSamples);
void USTV_LogHeaderWriteFunc(SYS_FS_HANDLE fileHandle, unsigned int resolutionBits, unsigned char chanCount, unsigned int sampleRate, unsigned char periphCount,unsigned long startOfFileTimeStamp, PERIPHERAL_CONFIGURATION config[]);
void USTV_AddDataInAdditionnalBuffer(unsigned char* data, unsigned int dataCount);
void USTV_ResetAdditionnalDataIndexBufferA(void);
void USTV_ResetAdditionnalDataIndexBufferB(void);
void USTV_SetCurrentFillingAdditionnalBuffer(unsigned char selectedBuff);

unsigned int FindStatFileAndGetCurrentNum(void);
unsigned int WriteCurrentFileNum(unsigned int num);
#endif /* _APP_SD_TASKS_H */

//DOM-IGNORE-BEGIN
#ifdef __cplusplus
}
#endif
//DOM-IGNORE-END

/*******************************************************************************
 End of File
 */

