/*******************************************************************************
  MPLAB Harmony Application Header File

  Company:
    Microchip Technology Inc.

  File Name:
    app_usb.h

  Summary:
    This header file provides prototypes and definitions for the application.

  Description:
    This header file provides function prototypes and data type definitions for
    the application.  Some of these are required by the system (such as the
    "APP_USB_Initialize" and "APP_USB_Tasks" prototypes) and some of them are only used
    internally by the application (such as the "APP_USB_STATES" definition).  Both
    are defined here for convenience.
*******************************************************************************/

#ifndef _APP_USB_H
#define _APP_USB_H

// *****************************************************************************
// *****************************************************************************
// Section: Included Files
// *****************************************************************************
// *****************************************************************************

#include <stdint.h>
#include <stdbool.h>
#include <stddef.h>
#include <stdlib.h>
#include "configuration.h"
#include "definitions.h"

// DOM-IGNORE-BEGIN
#ifdef __cplusplus  // Provide C++ Compatibility

extern "C" {

#endif
// DOM-IGNORE-END
    
#define APP_HOST  0x02
#define APP_DEVICE  0x03
#define APP_NONE  0x01

    
#define APP_USB_SWITCHROLE_DEVICE_EVENT 0x01
#define APP_USB_SWITCHROLE_HOST_EVENT 0x02
// *****************************************************************************
// *****************************************************************************
// Section: Type Definitions
// *****************************************************************************
// *****************************************************************************

// *****************************************************************************
/* Application states

  Summary:
    Application states enumeration

  Description:
    This enumeration defines the valid application states.  These states
    determine the behavior of the application at various times.
*/

typedef enum
{
    /* Application's state machine's initial state. */
    APP_USB_STATE_INIT=0,
    /* State where application changes the role */
    APP_STATE_SELECT_USB_ROLE,

	/* Application waits for configuration in this state */
    APP_STATE_WAIT_FOR_CONFIGURATION,
    
    /* Application waits for USB BUS to be enabled in this state */        
    APP_STATE_WAIT_FOR_BUS_ENABLE_COMPLETE,
    
    /* Application waits for USB BUS to be disabled in this state */
    APP_STATE_WAIT_FOR_BUS_DISABLE_COMPLETE,
            
    /* Application waits for attach cable*/
    APP_STATE_WAIT_FOR_POWER_DETECT,
    
    //Attente d'une connection de peripherique (HDD)
    APP_STATE_WAIT_FOR_DEVICE_ATTACH,
            
    //peripherique (HDD) connecte
    APP_STATE_DEVICE_CONNECTED,
            
            APP_STATE_IDLE,
            APP_STATE_RUNNING
} APP_USB_STATES;


// *****************************************************************************
/* Application Data

  Summary:
    Holds application data

  Description:
    This structure holds the application's data.

  Remarks:
    Application strings and buffers are be defined outside this structure.
 */

typedef struct
{
    /* The application's current state */
    APP_USB_STATES state;

    /* device layer handle returned by device layer open function */
    USB_DEVICE_HANDLE  deviceHandle;
    
    /* Is device connected to USB Host */
	bool deviceIsConnected;

    /* Is device configured */
    bool isConfigured;
    
    /* power detected */
    bool powerDetected;
    
    /* Flag to trigger USB stack role switch */
    bool roleSwitch;
    
    /* Determines the currently selected USB role */
    uint8_t currentRole;
    
    
        /* Tracks the alternate setting */
    uint8_t altSetting;
        /* ep data sent */
    bool epDataWritePending;

    /* ep data received */
    bool epDataReadPending;

    /* Transfer handle */
    USB_DEVICE_TRANSFER_HANDLE writeTranferHandle;

    /* Transfer handle */
    USB_DEVICE_TRANSFER_HANDLE readTranferHandle;

    /* The transmit endpoint address */
    USB_ENDPOINT_ADDRESS endpointTx;

    /* The receive endpoint address */
    USB_ENDPOINT_ADDRESS endpointRx;

} APP_USB_DATA;

// *****************************************************************************
// *****************************************************************************
// Section: Application Callback Routines
// *****************************************************************************
// *****************************************************************************
/* These routines are called by drivers when certain events occur.
*/

// *****************************************************************************
// *****************************************************************************
// Section: Application Initialization and State Machine Functions
// *****************************************************************************
// *****************************************************************************

void USB_HOST_EN_PowerEnable(void);
void USB_HOST_EN_PowerDisable(void);
/*******************************************************************************
  Function:
    void APP_USB_Initialize ( void )

  Summary:
     MPLAB Harmony application initialization routine.

  Description:
    This function initializes the Harmony application.  It places the
    application in its initial state and prepares it to run so that its
    APP_USB_Tasks function can be called.

  Precondition:
    All other system initialization routines should be called before calling
    this routine (in "SYS_Initialize").

  Parameters:
    None.

  Returns:
    None.

  Example:
    <code>
    APP_USB_Initialize();
    </code>

  Remarks:
    This routine must be called from the SYS_Initialize function.
*/

void APP_USB_Initialize ( void );


/*******************************************************************************
  Function:
    void APP_USB_Tasks ( void )

  Summary:
    MPLAB Harmony Demo application tasks function

  Description:
    This routine is the Harmony Demo application's tasks function.  It
    defines the application's state machine and core logic.

  Precondition:
    The system and application initialization ("SYS_Initialize") should be
    called before calling this.

  Parameters:
    None.

  Returns:
    None.

  Example:
    <code>
    APP_USB_Tasks();
    </code>

  Remarks:
    This routine must be called from SYS_Tasks() routine.
 */

void APP_USB_Tasks( void );
void ProcessUSBMessage( unsigned short int command, unsigned short int length, unsigned char payload[]);
void USBDecodeMessage(unsigned char* usbPayload, unsigned int usbPayloadLength);
void MakeAndSendUSBMessageWithUTLNProtocol(unsigned short command, unsigned int payloadLength, unsigned char* payload);
void MakeAndSendUSBMessageWithUTLNProtocol_direct(unsigned short command, unsigned int payloadLength, unsigned char* payload);
void USBWriteToTxBuffer(unsigned char value);
bool USBIsDataReadyInTxBuffer(void);
void USBWriteFromTxBuffer(void);
unsigned int USBGetNbOfValuesInTxBuffer(void);
unsigned int USBGetRemainingSpaceInTxBuffer(void);

//DOM-IGNORE-BEGIN
#ifdef __cplusplus
}
#endif
//DOM-IGNORE-END

#endif /* _APP_USB_H */

/*******************************************************************************
 End of File
 */

