/*******************************************************************************
  MPLAB Harmony Application Source File

  Company:
    Microchip Technology Inc.

  File Name:
    app_user_input.c

  Summary:
    This file contains the source code for the MPLAB Harmony application.

  Description:
    This file contains the source code for the MPLAB Harmony application.  It
    implements the logic of the application's state machine and it may call
    API routines of other MPLAB Harmony modules in the system, such as drivers,
    system services, and middleware.  However, it does not call any of the
    system interfaces (such as the "Initialize" and "Tasks" functions) of any of
    the modules in the system or make any assumptions about when those functions
    are called.  That is the responsibility of the configuration-specific system
    files.
 *******************************************************************************/

// *****************************************************************************
// *****************************************************************************
// Section: Included Files
// *****************************************************************************
// *****************************************************************************

#include "app_user_input.h"
#include "peripheral/gpio/plib_gpio.h"
#include "FreeRTOS.h"
#include "event_groups.h"
#include "USTV_SystemTrace.h"
#include "UTLN_Communication.h"

// *****************************************************************************
// *****************************************************************************
// Section: Global Data Definitions
// *****************************************************************************
// *****************************************************************************

// *****************************************************************************
/* Application Data

  Summary:
    Holds application data

  Description:
    This structure holds the application's data.

  Remarks:
    This structure should be initialized by the APP_USER_INPUT_Initialize function.

    Application strings and buffers are be defined outside this structure.
*/

APP_USER_INPUT_DATA app_user_inputData;
EventGroupHandle_t xCreatedEventGroupUserInput;
TaskHandle_t xTaskButtonHandle=NULL;
extern TaskHandle_t xTaskAppHandle;
extern TaskHandle_t xTaskCNNDetectionHandle;
extern TaskHandle_t xTaskUSBHandle;
// *****************************************************************************
// *****************************************************************************
// Section: Application Callback Functions
// *****************************************************************************
// *****************************************************************************
bool sw1Pushed=false;
static void SW1_User_Handler(GPIO_PIN pin, uintptr_t context)
{
    BaseType_t xHigherPriorityTaskWoken;
    /* xHigherPriorityTaskWoken must be initialised to pdFALSE.  If calling
    xTaskNotifyFromISR() unblocks the handling task, and the priority of
    the handling task is higher than the priority of the currently running task,
    then xHigherPriorityTaskWoken will automatically get set to pdTRUE. */
    xHigherPriorityTaskWoken = pdFALSE;
    
    if(SW1_Get() == 1)
    {
        sw1Pushed=true;

        /* Notify the task that the transmission is complete by setting the TX_BIT
        in the task's notification value. */
        xTaskNotifyFromISR( xTaskButtonHandle,
                       SW1_PUSHED,
                       eSetBits,
                       &xHigherPriorityTaskWoken );


    }
    else
    {
        /* Notify the task that the transmission is complete by setting the TX_BIT
        in the task's notification value. */
        xTaskNotifyFromISR( xTaskButtonHandle,
                       SW1_RELEASED,
                       eSetBits,
                       &xHigherPriorityTaskWoken );
    }
    
    /* Force a scheduler call on exit */
    if( xHigherPriorityTaskWoken == pdTRUE )
    {
         portYIELD();
    }
}

static void SW2_User_Handler(GPIO_PIN pin, uintptr_t context)
{
    BaseType_t xHigherPriorityTaskWoken;
    /* xHigherPriorityTaskWoken must be initialised to pdFALSE.  If calling
    xTaskNotifyFromISR() unblocks the handling task, and the priority of
    the handling task is higher than the priority of the currently running task,
    then xHigherPriorityTaskWoken will automatically get set to pdTRUE. */
    xHigherPriorityTaskWoken = pdFALSE;
    
    if(SW2_Get() == 1)
    {

        /* Notify the task that the transmission is complete by setting the TX_BIT
        in the task's notification value. */
        xTaskNotifyFromISR( xTaskButtonHandle,
                       SW2_PUSHED,
                       eSetBits,
                       &xHigherPriorityTaskWoken );
    }
    else
    {
        /* Notify the task that the transmission is complete by setting the TX_BIT
        in the task's notification value. */
        xTaskNotifyFromISR( xTaskButtonHandle,
                       SW2_RELEASED,
                       eSetBits,
                       &xHigherPriorityTaskWoken );
    }
    
    /* Force a scheduler call on exit */
    if( xHigherPriorityTaskWoken == pdTRUE )
    {
         portYIELD();
    }
}
static void SW3_User_Handler(GPIO_PIN pin, uintptr_t context)
{
    BaseType_t xHigherPriorityTaskWoken;
    /* xHigherPriorityTaskWoken must be initialised to pdFALSE.  If calling
    xTaskNotifyFromISR() unblocks the handling task, and the priority of
    the handling task is higher than the priority of the currently running task,
    then xHigherPriorityTaskWoken will automatically get set to pdTRUE. */
    xHigherPriorityTaskWoken = pdFALSE;
    
    if(SW3_Get() == 1)
    {

        /* Notify the task that the transmission is complete by setting the TX_BIT
        in the task's notification value. */
        xTaskNotifyFromISR( xTaskButtonHandle,
                       SW3_PUSHED,
                       eSetBits,
                       &xHigherPriorityTaskWoken );
    }
    else
    {
        /* Notify the task that the transmission is complete by setting the TX_BIT
        in the task's notification value. */
        xTaskNotifyFromISR( xTaskButtonHandle,
                       SW3_RELEASED,
                       eSetBits,
                       &xHigherPriorityTaskWoken );
    }
    
    /* Force a scheduler call on exit */
    if( xHigherPriorityTaskWoken == pdTRUE )
    {
         portYIELD();
    }
}
static void USB_OVER_CURRENT_User_Handler(GPIO_PIN pin, uintptr_t context)
{
    BaseType_t xHigherPriorityTaskWoken;
    /* xHigherPriorityTaskWoken must be initialised to pdFALSE.  If calling
    xTaskNotifyFromISR() unblocks the handling task, and the priority of
    the handling task is higher than the priority of the currently running task,
    then xHigherPriorityTaskWoken will automatically get set to pdTRUE. */
    xHigherPriorityTaskWoken = pdFALSE;
    
    if(USB_OVER_CURRENT_Get() == 0)
    {

        /* Notify the task that the transmission is complete by setting the TX_BIT
        in the task's notification value. */
        xTaskNotifyFromISR( xTaskButtonHandle,
                       USB_OVER_CURRENT_PUSHED,
                       eSetBits,
                       &xHigherPriorityTaskWoken );
    }
    else
    {
        /* Notify the task that the transmission is complete by setting the TX_BIT
        in the task's notification value. */
        xTaskNotifyFromISR( xTaskButtonHandle,
                       USB_OVER_CURRENT_RELEASED,
                       eSetBits,
                       &xHigherPriorityTaskWoken );
    }
    
    /* Force a scheduler call on exit */
    if( xHigherPriorityTaskWoken == pdTRUE )
    {
         portYIELD();
    }
}
// *****************************************************************************
// *****************************************************************************
// Section: Application Local Functions
// *****************************************************************************
// *****************************************************************************


/* TODO:  Add any necessary local functions.
*/


// *****************************************************************************
// *****************************************************************************
// Section: Application Initialization and State Machine Functions
// *****************************************************************************
// *****************************************************************************

/*******************************************************************************
  Function:
    void APP_USER_INPUT_Initialize ( void )

  Remarks:
    See prototype in app_user_input.h.
 */

void APP_USER_INPUT_Initialize ( void )
{
    /* Place the App state machine in its initial state. */
    app_user_inputData.state = APP_USER_INPUT_STATE_INIT;



    /* TODO: Initialize your application's state machine and other
     * parameters.
     */
}


/******************************************************************************
  Function:
    void APP_USER_INPUT_Tasks ( void )

  Remarks:
    See prototype in app_user_input.h.
 */
unsigned char sw1Task=0;;
void APP_USER_INPUT_Tasks ( void )
{

    /* Check the application's current state. */
    switch ( app_user_inputData.state )
    {
        /* Application's initial state. */
        case APP_USER_INPUT_STATE_INIT:
        {
            bool appInitialized = true;

            GPIO_PinInterruptCallbackRegister(SW1_PIN, SW1_User_Handler, 0);
            GPIO_PinInterruptEnable(SW1_PIN);
            GPIO_PinInterruptCallbackRegister(SW2_PIN, SW2_User_Handler, 0);
            GPIO_PinInterruptEnable(SW2_PIN);
            GPIO_PinInterruptCallbackRegister(SW3_PIN, SW3_User_Handler, 0);
            GPIO_PinInterruptEnable(SW3_PIN);
            //USB HOST Over current detection
            GPIO_PinInterruptCallbackRegister(USB_OVER_CURRENT_PIN, USB_OVER_CURRENT_User_Handler, 0);
            GPIO_PinInterruptEnable(USB_OVER_CURRENT_PIN);
            xTaskButtonHandle=xTaskGetCurrentTaskHandle();
            if (appInitialized)
            {
                app_user_inputData.state = APP_USER_INPUT_STATE_SERVICE_TASKS;
            }
            break;
        }

        case APP_USER_INPUT_STATE_SERVICE_TASKS:
        {
            //On attend une notification du bouton (call from interrupt)
            BaseType_t xResult;
            uint32_t ulNotifiedValue=0;

            switch(sw1Task)
            {
                case 0://Attente appuis
                    /* Wait to be notified of an interrupt. */
                    xResult = xTaskNotifyWait( pdFALSE,    /* Don't clear bits on entry. */
                       0xffffffff,        /* Clear all bits on exit. */
                       &ulNotifiedValue, /* Stores the notified value. */
                       0xFFFFFFFF );               //Timout 100ms
                    if( xResult == pdPASS )
                    {
                       /* A notification was received.  See which bits were set. */
                       if( ( ulNotifiedValue & SW1_PUSHED ) != 0 )
                       {
                           sw1Task=1;
                       }

                       if( ( ulNotifiedValue & SW2_PUSHED ) != 0 )
                       {
                           sw1Task=1;
                       }

                       if( ( ulNotifiedValue & SW3_PUSHED ) != 0 )
                       {
                           sw1Task=1;
                       }
                       if( ( ulNotifiedValue & USB_OVER_CURRENT_PUSHED ) != 0 )
                       {
                            #ifdef USE_SYSTEM_TRACE
                                USTV_SystemTraceWriteLine("ERROR:USB_OVER_CURRENT_DETECTED");
                            #endif
                       }
                    }
                    else
                    {
                       /* Did not receive a notification within the expected time. (Timout)*/ 
                    }
                    break;
                case 1:
                    vTaskDelay( 100 );
                    sw1Task=2;
                    break;
                case 2:
                         /* Wait to be notified of an interrupt. */
                        xResult = xTaskNotifyWait( pdFALSE,    /* Don't clear bits on entry. */
                           0xffffffff,        /* Clear all bits on exit. */
                           &ulNotifiedValue, /* Stores the notified value. */
                           0xFFFFFFFF );               //Timout 100ms
                        if( xResult == pdPASS )
                        {
                           /* A notification was received.  See which bits were set. */
                           if( ( ulNotifiedValue & SW1_RELEASED ) != 0 )
                           {
                               sw1Task=0;
//                               /* Set bit 8 in the notification value of the task referenced by xTask1Handle. */
//                               xTaskNotify( xTaskAppHandle, SW1_PUSHED, eSetBits );
                               unsigned char payload[1];
                               payload[0]= 1;
                               MakeAndSendMessageWithUTLNProtocol(SEND_BUTTON_CLICK, 1, payload);
                               vTaskDelay( 300 );
                           }   

                           if( ( ulNotifiedValue & SW2_RELEASED ) != 0 )
                           {
                               sw1Task=0;
                               /* Set bit 8 in the notification value of the task referenced by xTask1Handle. */
                               xTaskNotify( xTaskUSBHandle, SW2_PUSHED, eSetBits );
                               vTaskDelay( 300 );
                           }         
                           if( ( ulNotifiedValue & SW3_RELEASED ) != 0 )
                           {
                               sw1Task=0;
                               /* Set bit 8 in the notification value of the task referenced by xTask1Handle. */
                               xTaskNotify(xTaskCNNDetectionHandle , SW3_PUSHED, eSetBits );
                               vTaskDelay( 300 );
                           }         
                        }
                        else
                        {
                           /* Did not receive a notification within the expected time. (Timout)*/ 
                        }
                    break;
            }
            break;
        }



        /* The default state should never be executed. */
        default:
        {
            /* TODO: Handle error in application's state machine. */
            break;
        }
    }
}


/*******************************************************************************
 End of File
 */
