#ifndef _CNN_H    /* Guard against multiple inclusion */
#define _CNN_H
#include "app_cnn_detection.h"

#define MAX_KERNEL 11
#define NCONV 3
#define MAX_FEAT 128


typedef struct FrontBN FrontBN_t;
struct FrontBN{
    int nfeat;
	float bn_weight[MAX_FEAT]; // (outfeat)
	float bn_bias[MAX_FEAT]; // (outfeat)
	float bn_runningmean[MAX_FEAT]; // (outfeat)
	float bn_runningvar[MAX_FEAT]; // (outfeat)
};

// /!\ the forward takes into account the kernel sizes etc but not the prediction length and the predPeaks sample extraction !

typedef struct Conv Conv_t;
struct Conv{
	int in_feat;
	int out_feat;
	int kernel;
	int stride;
	float depthwise_weights[MAX_FEAT][MAX_KERNEL]; // (infeat, kernel)
	float depthwise_bias[MAX_FEAT]; // (infeat)
	float pointwise_weight[MAX_FEAT][MAX_FEAT]; // (outfeat, infeat)
	float pointwise_bias[MAX_FEAT]; // (oufeat)
	float bn_weight[MAX_FEAT]; // (outfeat)
	float bn_bias[MAX_FEAT]; // (outfeat)
	float bn_runningmean[MAX_FEAT]; // (outfeat)
	float bn_runningvar[MAX_FEAT]; // (outfeat)
};

int run_CNN(APP_CNN_DETECTION_DATA* app_cnn_detectionData, short lenspec, short melfeat, float* preds);

void read_line(char* line, SYS_FS_HANDLE file, float* table, int size);

void jumpLines(SYS_FS_HANDLE file, int n);

int load_CNN(Conv_t* model, FrontBN_t* frontbn, void* ddr);

void forward(float* spectro, Conv_t* model, FrontBN_t* frontbn, float* ddr, int lenspec, short melfeat, float* preds);
#endif